package centroServlet;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

import javax.servlet.http.HttpSession;

import m05bClasses.m05bConexion;
import m05bClasses.m05bConstantes;
import m05bClasses.m05bFileLog;

/**
 * Inserte aqu la descripcin del tipo.
 * Fecha de creacin: (15/10/03)
 */
public class m05bGrabarCentroServlet extends javax.servlet.http.HttpServlet {m05bFileLog miLog = new m05bFileLog();
/**
 * Process incoming HTTP POST requests 
 * 
 * @param request Object that encapsulates the request to the servlet 
 * @param response Object that encapsulates the response from the servlet
 */
public void doPost(javax.servlet.http.HttpServletRequest request, javax.servlet.http.HttpServletResponse response) throws javax.servlet.ServletException, java.io.IOException {

	performTask(request, response);

}
/**
 * Returns the servlet info string.
 */
public String getServletInfo() {

	return super.getServletInfo();

}
/**
 * Initializes the servlet.
 */
public void init() {
	// insert code to initialize the servlet here

}
/**
 * Process incoming requests for information
 * 
 * @param request Object that encapsulates the request to the servlet 
 * @param response Object that encapsulates the response from the servlet
 */
public void performTask(javax.servlet.http.HttpServletRequest request, javax.servlet.http.HttpServletResponse response) {

       String sCodigo, sDescripcion,sDescripcionEu;
	   String sql = "", accion;
	   java.sql.Connection conn=null;
	   PreparedStatement pstmt = null;
	   ResultSet rs = null;
	   boolean finalizado = false;  
       try

	{

		HttpSession session = request.getSession(true);

        sCodigo = request.getParameter("Codigo").toUpperCase();
        //System.out.println("m05b - Grabar Centros: CODIGO: " + sCodigo);
        sDescripcion=request.getParameter("Descripcion").toUpperCase();
        sDescripcionEu=request.getParameter("DescripcionEu").toUpperCase();
        accion=request.getParameter("Accion");
        
		try{
			m05bConexion miConex = new m05bConexion();
			conn = miConex.getConnection();
			if (accion.equals(m05bConstantes.ACC_ACTUALIZAR))  {
				pstmt = conn.prepareStatement(
					"update	M0505T00 " + 
					"set	DESCRIP_05 = ? , EDESCRIP_05 =? " + 
					"where	COD_CTRO_05 = ?");
				pstmt.setString(1, sDescripcion);
				pstmt.setString(2, sDescripcionEu);
				pstmt.setString(3, sCodigo);
			}
			else if (accion.equals(m05bConstantes.ACC_INSERTAR))  {
			// Chequear si ya existe un centro con ese codigo
			   sql = "select 1  from M0505T00 where COD_CTRO_05 = '" + sCodigo + "'";
		       pstmt = conn.prepareStatement(sql);
			   rs = pstmt.executeQuery();
			   if (rs.next() == true){ 		
       	    			response.sendRedirect("m05bCentrosJsp.jsp?Codigo=" + sCodigo + "&Mensaje=" + m05bConstantes.MSG_EXISTE);
       	    			finalizado = true;
			   } 
			   else {
					pstmt = conn.prepareStatement(
						"insert into	M0505T00 " + 
						"(COD_CTRO_05, DESCRIP_05,EDESCRIP_05)" + 
						"VALUES " + 
						"(?,?,?)"); 
					pstmt.setString(1, sCodigo);
					pstmt.setString(2, sDescripcion);
					pstmt.setString(3, sDescripcionEu);
				}
			}
			else   {
				pstmt = conn.prepareStatement(
					"delete from	M0505T00 " + 
					" where COD_CTRO_05 = ? "); 
				pstmt.setString(1, sCodigo);
			}
			if(!finalizado){
				pstmt.executeUpdate();
				response.sendRedirect("m05bRelCentrosJsp.jsp");
			}
		} 	catch (Exception SQLException) {
				miLog.addTraza(SQLException);
				response.sendRedirect("m05bError.jsp");
		}	finally{
				if (rs != null)
					rs.close();
				if (pstmt != null)
					pstmt.close();
				if (conn != null)
					conn.close();
		}
	}
	catch(Throwable theException)
	{
		// uncomment the following line when unexpected exceptions
		// are occuring to aid in debugging the problem.
		miLog.addTraza(theException);
		try {
			response.sendRedirect("m05bError.jsp");
		} catch (IOException e) {
			// TODO Auto-generated catch block
			m05bFileLog miLog = new m05bFileLog();
			miLog.addTraza(e);
		}
	}
}
}
