package cargoServlet;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import javax.servlet.http.HttpSession;

import m05bBD.m05bCargo;
import m05bClasses.m05bConexion;
import m05bClasses.m05bConstantes;
import m05bClasses.m05bFileLog;

/**
 * Inserte aqu la descripcin del tipo.
 * Fecha de creacin: (14/11/03)
 */
public class m05bGrabarCargoServlet extends javax.servlet.http.HttpServlet {m05bFileLog miLog = new m05bFileLog();
/**
 * Process incoming HTTP POST requests 
 * 
 * @param request Object that encapsulates the request to the servlet 
 * @param response Object that encapsulates the response from the servlet
 */
public void doPost(javax.servlet.http.HttpServletRequest request, javax.servlet.http.HttpServletResponse response) throws javax.servlet.ServletException, java.io.IOException {

	performTask(request, response);

}
/**
 * Returns the servlet info string.
 */
public String getServletInfo() {

	return super.getServletInfo();

}
/**
 * Initializes the servlet.
 */
public void init() {
	// insert code to initialize the servlet here

}
/**
 * Process incoming requests for information
 * 
 * @param request Object that encapsulates the request to the servlet 
 * @param response Object that encapsulates the response from the servlet
 */
public void performTask(javax.servlet.http.HttpServletRequest request, javax.servlet.http.HttpServletResponse response) {

       String sCodigo;
       String sDescripcion;
       String sEdescripcion;
       String accion;
       String sql = "";
	   java.sql.Connection conn=null;
	   PreparedStatement pstmt = null;
	   ResultSet rs = null;
	   boolean finalizado = false;
       try

	{
		HttpSession session = request.getSession(true);

        m05bCargo cargo = (m05bCargo)session.getAttribute("m05bCargo");
		sCodigo = request.getParameter("Codigo");
		cargo.setCar_codigo(sCodigo);
		sDescripcion=request.getParameter("Descripcion").toUpperCase();
		cargo.setCar_descripcion(sDescripcion);
		sEdescripcion=request.getParameter("Edescripcion").toUpperCase();
		cargo.setCar_edescripcion(sEdescripcion);
		accion=request.getParameter("Accion");
		
		try{
			m05bConexion miConex = new m05bConexion();
			conn = miConex.getConnection();
			if (accion.equals(m05bConstantes.ACC_ACTUALIZAR))  {
				pstmt = conn.prepareStatement(
					"update	M0504T00 " + 
					"set	DESCRIP_04 = ? " + 
					" ,		EDESCRIP_04 = ? " + 
					"where	COD_CARG_04 = ?");
				pstmt.setString(1, sDescripcion);
				pstmt.setString(2, sEdescripcion);
				pstmt.setString(3, sCodigo);
			}
			else if (accion.equals(m05bConstantes.ACC_INSERTAR))  {
			// Chequear si ya existe un cargo con ese codigo
			   sql = "select 1  from M0504T00 where COD_CARG_04 = '" + sCodigo + "'";
		       pstmt = conn.prepareStatement(sql);
			   rs = pstmt.executeQuery();
			   if (rs.next() == true){ 		
       	    			response.sendRedirect("m05bCargosJsp.jsp?Codigo=" + sCodigo + "&Mensaje=" + m05bConstantes.MSG_EXISTE);
       	    			finalizado = true;
			   } 
			   else {
					pstmt = conn.prepareStatement(
						"insert into	M0504T00 " + 
						"(COD_CARG_04, DESCRIP_04, EDESCRIP_04) " + 
						" values " + 
						"(? ,?, ? )" );
					pstmt.setString(1, sCodigo);
					pstmt.setString(2, sDescripcion);
					pstmt.setString(3, sEdescripcion);
				}
			}
			else   {
				pstmt = conn.prepareStatement(
					"delete from 	M0504T00 " + 
					" where COD_CARG_04 =  ? " );
				pstmt.setString(1, sCodigo);
			}
			if(!finalizado){
				pstmt.executeUpdate();
				response.sendRedirect("m05bRelCargosJsp.jsp");
				//response.sendRedirect("m05bCargosJsp.jsp?Codigo="+ sCodigo + "&Mensaje=true");
			}
		} 	catch (SQLException ex) {
				if (ex.getErrorCode() == m05bConstantes.ERR_INTEGRIDAD)
					response.sendRedirect("m05bCargosJsp.jsp?Codigo=" + sCodigo + "&Mensaje=" + m05bConstantes.MSG_INTEGRIDAD);
				else
					response.sendRedirect("m05bError.jsp");
				miLog.addTraza(ex);
		}	finally{
				if (rs != null)
					rs.close();
				if (pstmt != null)
					pstmt.close();
				if (conn != null)
					conn.close();
		}

	}
	catch(Throwable theException)
	{
		// uncomment the following line when unexpected exceptions
		// are occuring to aid in debugging the problem.
		miLog.addTraza(theException);
		try {
			response.sendRedirect("m05bError.jsp");
		} catch (IOException e) {
			// TODO Auto-generated catch block
			m05bFileLog miLog = new m05bFileLog();
			miLog.addTraza(e);
		}
	}
}
}
