package avisoServlet;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

import javax.servlet.http.HttpSession;

import m05bBD.m05bAviso;
import m05bClasses.m05bConexion;
import m05bClasses.m05bConstantes;
import m05bClasses.m05bFileLog;

/**
 * Inserte aqu la descripcin del tipo.
 * Fecha de creacin: (14/11/03)
 */
public class m05bGrabarAvisoServlet extends javax.servlet.http.HttpServlet {m05bFileLog miLog = new m05bFileLog();
/**
 * Process incoming HTTP POST requests 
 * 
 * @param request Object that encapsulates the request to the servlet 
 * @param response Object that encapsulates the response from the servlet
 */
public void doPost(javax.servlet.http.HttpServletRequest request, javax.servlet.http.HttpServletResponse response) throws javax.servlet.ServletException, java.io.IOException {

	performTask(request, response);

}
/**
 * Returns the servlet info string.
 */
public String getServletInfo() {

	return super.getServletInfo();

}
/**
 * Initializes the servlet.
 */
public void init() {
	// insert code to initialize the servlet here

}
/**
 * Process incoming requests for information
 * 
 * @param request Object that encapsulates the request to the servlet 
 * @param response Object that encapsulates the response from the servlet
 */
public void performTask(javax.servlet.http.HttpServletRequest request, javax.servlet.http.HttpServletResponse response) {

       String sMatricula, sTexto,sTextoEusk, sVehiculo, sAsignacion, sOT;
       String sql="", sAccion;
       boolean finalizado = false;
       try 	{
			java.sql.Connection conn = null;
			PreparedStatement pstmt = null;
			ResultSet rs = null;
			
			m05bFileLog miLog = new m05bFileLog();
			
			HttpSession session = request.getSession(true);
			String persona = (String) session.getAttribute("persona");

			m05bAviso aviso = (m05bAviso)session.getAttribute("m05bAviso");
			sMatricula = request.getParameter("Matricula").toUpperCase();
			miLog.addTraza(persona, "Grabar Aviso", "Matricula: " + sMatricula, m05bConstantes.LOG_NIVEL_BAJO);
			aviso.setAvi_matricula(sMatricula);
			sTexto=request.getParameter("Texto").toUpperCase();
			miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "Texto: " + sTexto, m05bConstantes.LOG_NIVEL_BAJO);
			aviso.setAvi_texto(sTexto);
			/*iker: Euskera*/
			sTextoEusk=request.getParameter("TextoEusk").toUpperCase();
			miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "TextoEuks: " + sTextoEusk, m05bConstantes.LOG_NIVEL_BAJO);
			aviso.setAvi_textoEusk(sTextoEusk);
			sVehiculo=request.getParameter("Vehiculo")==null?"N":"S";
			miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "Vehiculo: " + sVehiculo, m05bConstantes.LOG_NIVEL_BAJO);
			aviso.setAvi_vehiculo(sVehiculo);
			sAsignacion=request.getParameter("Asignacion")==null?"N":"S";
			miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "Asignacion: " + sAsignacion, m05bConstantes.LOG_NIVEL_BAJO);
			aviso.setAvi_asignacion(sAsignacion);
			sOT=request.getParameter("OT")==null?"N":"S";
			miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "OT: " + sOT, m05bConstantes.LOG_NIVEL_BAJO);
			aviso.setAvi_ot(sOT);
			
			try{
				m05bConexion miConex = new m05bConexion();
				conn = miConex.getConnection();	
				sAccion = request.getParameter("Accion");
				if (sAccion.equals(m05bConstantes.ACC_ACTUALIZAR))  {
					sql="update	" + m05bConstantes.TAB_AVISOS  + 
						" set	" + m05bConstantes.COL_02_TEXTO  + " = '" + sTexto + "'" + 
						" ,	E" + m05bConstantes.COL_02_TEXTO  + " = '" + sTextoEusk + "'" + 
						" ,	"+ m05bConstantes.COL_02_VEHICULO  + " = '" + sVehiculo + "'" + 
						" ,	" + m05bConstantes.COL_02_ASIGNACION  + " = '" + sAsignacion + "'" + 
						" ,	" + m05bConstantes.COL_02_OT  + " = '" + sOT + "'" + 
						" where	" + m05bConstantes.COL_02_MATRICULA + " = '" + sMatricula + "'" ;
					miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "SQL: " + sql,m05bConstantes.LOG_NIVEL_BAJO);
					pstmt = conn.prepareStatement(sql);
				} else if (sAccion.equals(m05bConstantes.ACC_ELIMINAR))  {
					pstmt = conn.prepareStatement(
						"delete from	" + m05bConstantes.TAB_AVISOS  + 
						" where	" + m05bConstantes.COL_02_MATRICULA + "= ?");
					pstmt.setString(1, sMatricula);
				} else {  
				  // Chequear si ya existe un aviso para esa matrcula
				   sql = "select 1  from " + m05bConstantes.TAB_AVISOS + " where " + m05bConstantes.COL_02_MATRICULA + " = '" + sMatricula + "'";
			       pstmt = conn.prepareStatement(sql);
				   rs = pstmt.executeQuery();
				   if (rs.next() == true){ 		
	       	    			response.sendRedirect("m05bAvisosJsp.jsp?Matricula=" + sMatricula + "&Mensaje=" + m05bConstantes.MSG_EXISTE);
	       	    			finalizado = true;
				   } else {
						pstmt = conn.prepareStatement(
							"insert into	" + m05bConstantes.TAB_AVISOS  + 
							"(" + m05bConstantes.COL_02_MATRICULA + ", " + m05bConstantes.COL_02_TEXTO + 
							", " + m05bConstantes.COL_02_VEHICULO + ", " + m05bConstantes.COL_02_ASIGNACION + 
							", " + m05bConstantes.COL_02_OT + 
							", E" + m05bConstantes.COL_02_TEXTO + ")" + 
							" VALUES (?, ?, ?, ?, ?,?)");
						pstmt.setString(1, sMatricula);
						pstmt.setString(2, sTexto);
						pstmt.setString(3, sVehiculo);
						pstmt.setString(4, sAsignacion);
						pstmt.setString(5, sOT);
						pstmt.setString(6, sTextoEusk);
					}
				}
				if(!finalizado){
					pstmt.executeUpdate();
					response.sendRedirect("m05bRelAvisosJsp.jsp");
				}
			} catch (Exception SQLException) {
				miLog.addTraza(SQLException);
				response.sendRedirect("m05bError.jsp");
			}
			finally{
				if (rs != null)
					rs.close();
				if (pstmt != null)
					pstmt.close();
				if (conn != null)
					conn.close();
			}
	} catch(Throwable theException) {
		// uncomment the following line when unexpected exceptions
		// are occuring to aid in debugging the problem.
		miLog.addTraza(theException);
		try {
			response.sendRedirect("m05bError.jsp");
		} catch (IOException e) {
			m05bFileLog miLog = new m05bFileLog();
			miLog.addTraza(e);
		}
	}
}
}