package asignacionServlet;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import java.util.ResourceBundle;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import m05bClasses.m05bComun;
import m05bClasses.m05bConexion;
import m05bClasses.m05bConstantes;
import m05bClasses.m05bConstantesInformes;
import m05bClasses.m05bFileLog;
import m05bClasses.m05bInformes;

public class m05bImpAsignacionUsuarioServlet extends
		javax.servlet.http.HttpServlet {
	java.sql.Connection conn = null;

	String sLinea;
	File foFileDir;
	File tmpFoFile;
	FileOutputStream tmpFoFileStream;

	m05bComun miComun = new m05bComun();
	m05bFileLog miLog = new m05bFileLog();
	m05bInformes miInforme = new m05bInformes();
	m05bConexion miConex = new m05bConexion();

	String sMatricula = "", sFecDesde = "", sFecHasta = "", sSituacion = "",
			sDni = "";
	String sDesDpto = "", sCodDpto = "", sNombre = "", sSituacionDesc = "",
			sSituacionD = "";
	String persona = "";
	String sFinalizadaP = "";

	public static final String FO_REQUEST_PARAM = "fo";

	public void doPost(javax.servlet.http.HttpServletRequest request,
			javax.servlet.http.HttpServletResponse response)
			throws javax.servlet.ServletException, java.io.IOException {
		try {
			doGet(request, response);
		} catch (Exception e) {
			miLog.addTraza(e);
		}
	}

	public void doGet(HttpServletRequest request, HttpServletResponse response)
			throws ServletException {
		performTask(request, response);

	}

	// if(log == null)
	// {
	// Hierarchy hierarchy = Hierarchy.getDefaultHierarchy();
	// log = hierarchy.getLoggerFor("fop");
	// log.setPriority(Priority.WARN);
	// }

	private void fncImprimirComienzoPagina(ResourceBundle res)
			throws java.io.IOException, javax.naming.NamingException {
		sLinea = "<fo:page-sequence master-reference=\"general\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
		// REGION BEFORE
		sLinea = "		<fo:static-content flow-name=\"xsl-region-before\" >\n";
		tmpFoFileStream.write(sLinea.getBytes());
		// -------------- CABECERA DEL LISTADO --------------
		// Cabecera 1
		sLinea = "      <fo:block text-align=\"end\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      </fo:block>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      <fo:block font-weight=\"bold\" padding-top=\"10pt\">\n "
				+ res.getString("infAsigUsuario.titulo")+ "</fo:block>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		if (!(sFecDesde.equals(""))) {
			sLinea = "      <fo:block font-weight=\"bold\" font-size=\"8pt\" padding-top=\"5pt\">\n<![CDATA[ "
					+ res.getString("infAsigUsuario.texto1")
					+ sFecDesde
					+ res.getString("infAsigUsuario.texto2")
					+ sFecHasta
					+ "]]></fo:block>\n";
			tmpFoFileStream.write(sLinea.getBytes());
		}
		if (!(sSituacion.equals(""))) {
			sLinea = "      <fo:block font-weight=\"bold\" font-size=\"8pt\" padding-top=\"5pt\">\n<![CDATA[ "
					+ res.getString("infAsigUsuario.texto3") + sSituacionDesc + "]]></fo:block>\n";
			tmpFoFileStream.write(sLinea.getBytes());
		}
		sLinea = "      <fo:block font-weight=\"bold\" font-size=\"8pt\" padding-top=\"5pt\">\n <![CDATA["
				+ res.getString("infAsigUsuario.texto4")
				+ sCodDpto
				+ " "
				+ sDesDpto
				+ "]]></fo:block>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      <fo:block font-weight=\"bold\" font-size=\"8pt\" padding-top=\"5pt\">\n<![CDATA[ "
				+ res.getString("infAsigUsuario.texto5") + sDni + " " + sNombre + "]]></fo:block>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		if (sFinalizadaP.equals("1")) {
			sLinea = "      <fo:block font-weight=\"bold\" padding-top=\"5pt\" font-size=\"8pt\" >\n "
					+ res.getString("infAsigUsuario.texto6")+" </fo:block>\n";
			tmpFoFileStream.write(sLinea.getBytes());
		} else if (sFinalizadaP.equals("2")) {
			sLinea = "      <fo:block font-weight=\"bold\" padding-top=\"5pt\" font-size=\"8pt\" >\n "
					+ res.getString("infAsigUsuario.texto7")+" </fo:block>\n";
			tmpFoFileStream.write(sLinea.getBytes());
		}

		sLinea = " 		</fo:static-content>\n";
		tmpFoFileStream.write(sLinea.getBytes());

		// PIE DE PAGINA
		miInforme.fncGenerarPiePagina(tmpFoFileStream,
				m05bConstantesInformes.DIR_VERTICAL);

		// BODY
		sLinea = "	<fo:flow flow-name=\"xsl-region-body\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
		// -------------- DETALLE DEL LISTADO --------------
		sLinea = "        <fo:table table-layout=\"fixed\" width=\"160mm\" space-after.optimum=\"12pt\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-column column-width=\"20mm\"/>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-column column-width=\"15mm\"/>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-column column-width=\"15mm\"/>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-column column-width=\"40mm\"/>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-column column-width=\"40mm\"/>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-column column-width=\"15mm\"/>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-column column-width=\"15mm\"/>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-body font-family=\"Helvetica\" font-size=\"8pt\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-row>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		// Matricula
		sLinea = "	    <fo:table-cell padding-top=\"2mm\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      <fo:block font-weight=\"bold\"  text-align=\"center\">\n "+ res.getString("infAsigUsuario.col1")+"</fo:block>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    </fo:table-cell>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		// Desde
		sLinea = "	    <fo:table-cell padding-top=\"2mm\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      <fo:block font-weight=\"bold\" text-align=\"center\">\n  "+ res.getString("infAsigUsuario.col2")
				+ "</fo:block>";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    </fo:table-cell>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		// Hasta
		sLinea = "	    <fo:table-cell padding-top=\"2mm\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      <fo:block font-weight=\"bold\"  text-align=\"center\">\n  "+ res.getString("infAsigUsuario.col3")+"</fo:block>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    </fo:table-cell>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		// Marca
		sLinea = "	    <fo:table-cell padding-top=\"2mm\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      <fo:block font-weight=\"bold\"  text-align=\"center\">\n  "+ res.getString("infAsigUsuario.col4")+"</fo:block>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    </fo:table-cell>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		// Modelo
		sLinea = "	    <fo:table-cell padding-top=\"2mm\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      <fo:block font-weight=\"bold\"  text-align=\"center\">\n  "+ res.getString("infAsigUsuario.col5")+"</fo:block>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    </fo:table-cell>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		// Finalizada
		sLinea = "	    <fo:table-cell padding-top=\"2mm\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      <fo:block font-weight=\"bold\"  text-align=\"center\">\n  "+ res.getString("infAsigUsuario.col6")+"</fo:block>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    </fo:table-cell>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		// N.Asig.
		sLinea = "	    <fo:table-cell padding-top=\"2mm\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      <fo:block font-weight=\"bold\"  text-align=\"center\">\n  "+ res.getString("infAsigUsuario.col7")+"</fo:block>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    </fo:table-cell>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    </fo:table-row>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-row >\n";
		tmpFoFileStream.write(sLinea.getBytes());
	}

	private void imprimirTotal(int intCont, boolean bolGeneral,
			ResourceBundle res) throws java.io.IOException,
			javax.naming.NamingException {
		sLinea = "	    <fo:table-row>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		// vacas
		for (int i = 0; i < 4; i++) {
			sLinea = "	    <fo:table-cell>\n<fo:block>\n</fo:block>\n</fo:table-cell>\n";
			tmpFoFileStream.write(sLinea.getBytes());
		}
		// Contador
		sLinea = "	    <fo:table-cell>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		if (bolGeneral)
			sLinea = "      <fo:block font-weight=\"bold\" text-align=\"right\"  padding-top=\"26pt\">\n "
					+ res.getString("infAsigDat.texto6")
					+ intCont
					+ "</fo:block>\n";
		else
			sLinea = "      <fo:block font-weight=\"bold\" text-align=\"right\"  padding-top=\"26pt\">\n "
					+ res.getString("infAsigDat.texto7")
					+ intCont
					+ "</fo:block>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    </fo:table-cell>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    </fo:table-row>\n";
		tmpFoFileStream.write(sLinea.getBytes());

	}

	public void performTask(javax.servlet.http.HttpServletRequest request,
			javax.servlet.http.HttpServletResponse response)
			throws ServletException {
		PreparedStatement pstmt = null;
		ResultSet rs = null;

		try {
			HttpSession session = request.getSession(true);
			/* Iker. idioma */
			Locale idiomaLocal = (Locale) session.getAttribute("Local");
			String idiomaSes = ((idiomaLocal.getLanguage() == null) ? "es"
					: idiomaLocal.getLanguage());

			String formatoFecha="dd/MM/yyyy";
			ResourceBundle res = (ResourceBundle) session
					.getAttribute("resTit");
			if (!idiomaSes.equals("es")) {
		
				formatoFecha = "yyyy/MM/dd";
			}
			persona = (String) session.getAttribute("persona");
			conn = miConex.getConnection();

			// Obtencin de informacin de BD
			// Vehculo
			// Recogemos la situacion
			sSituacion = request.getParameter("Situacion");
			if ((sSituacion == null) || (sSituacion.equals(""))) {
				sSituacion = "";
			} else {
				sSituacion = miComun.ListaCaracteres(sSituacion);
			}
			// Recogemos Fecha Hasta:
			sFecHasta = request.getParameter("FecHasta");
			if (sFecHasta == null) {
				sFecHasta = "";
			}
			// Recogemos Fecha Desde:
			sFecDesde = request.getParameter("FecDesde");
			if (sFecDesde == null) {
				sFecDesde = "";
			}
			// Recogemos Dni:
			sDni = request.getParameter("Dni");
			if (sDni == null) {
				sDni = "";
			}
			// Recogemos Finalizada
			sFinalizadaP = request.getParameter("Finalizada");
			if ((sFinalizadaP == null) || (sFinalizadaP.equals(""))) {
				sFinalizadaP = "";
			}

			if (!(sSituacion.equals(""))) {
				String sSentenciaSituacion = " SELECT "
						+ m05bConstantes.COL_99_DESCRIPCION + " FROM "
						+ m05bConstantes.TAB_DESCRIPCIONES + "  S " + " WHERE "
						+ m05bConstantes.COL_99_CODDESC + " in (" + sSituacion
						+ ") AND " + m05bConstantes.COL_99_CODTABLA + "='"
						+ m05bConstantes.DESC_SITUACIONES + "'";
				pstmt = conn.prepareStatement(sSentenciaSituacion);
				rs = pstmt.executeQuery();
				while (rs.next()) {
					sSituacionD = rs.getString(1);
					if (!(sSituacionDesc.equals(""))) {
						sSituacionDesc = sSituacionDesc + "," + sSituacionD;
					} else {
						sSituacionDesc = sSituacionD;
					}
				}
				if (rs != null)
					rs.close();
				if (pstmt != null)
					pstmt.close();
			}

			sDesDpto = "";
			sCodDpto = "";
			sNombre = "";

			String sUsuario = "", sFechaHasta = "", sFechaDesde = "", sAsignacion = "";
			String sMarca = "", sModelo = "", sMatricula = "", sDesDptoAnt = "", sCodDptoAnt = "", sDniAnt = "", sFinalizada = "";
			String sSentenciaPersonal = "";

			String sSentencia = " SELECT " + m05bConstantes.COL_01_CODASIG
					+ "," + m05bConstantes.COL_01_MATRICULA + ","
					+ m05bConstantes.COL_01_DNI + ","
					+ m05bConstantes.COL_01_FECHA + ",TO_CHAR("
					+ m05bConstantes.COL_01_FDESDE + ",'" + formatoFecha + "')"
					+ ",TO_CHAR(" + m05bConstantes.COL_01_FDESDE
					+ ",'hh24:mi:ss')" + ",TO_CHAR("
					+ m05bConstantes.COL_01_FHASTA + ",'" + formatoFecha + "')"
					+ ",TO_CHAR(" + m05bConstantes.COL_01_FHASTA
					+ ",'hh24:mi:ss')," + m05bConstantes.COL_01_FDEVOL + ","
					+ " DECODE (TO_CHAR(" + m05bConstantes.COL_01_FDEVOL + ",'"
					+ formatoFecha + "'),'',TO_CHAR("
					+ m05bConstantes.COL_01_FHASTA + ",'" + formatoFecha
					+ "'),TO_CHAR(" + m05bConstantes.COL_01_FDEVOL + ",'"
					+ formatoFecha + "'))," + " DECODE (TO_CHAR("
					+ m05bConstantes.COL_01_FDEVOL
					+ ",'hh24:mi:ss'),'',TO_CHAR("
					+ m05bConstantes.COL_01_FHASTA + ",'hh24:mi:ss'),TO_CHAR("
					+ m05bConstantes.COL_01_FDEVOL + ",'hh24:mi:ss')),"
					+ " TO_CHAR(" + m05bConstantes.COL_01_FDEVOL
					+ ",'hh24:mi:ss')," + m05bConstantes.COL_01_KMSALIDA + ","
					+ m05bConstantes.COL_01_KMLLEGADA + ","
					+ m05bConstantes.COL_01_KMRECORRIDO + ","
					+ m05bConstantes.COL_01_FINALIZA + ","
					+ m05bConstantes.COL_01_ORDEN + ","
					+ m05bConstantes.COL_01_OBSERV + ","
					+ m05bConstantes.COL_01_IMPRESO + ","
					+ m05bConstantes.COL_01_FIMPRESO + ","
					+ m05bConstantes.COL_01_FDECRETO + ","
					+ m05bConstantes.COL_01_FENTREGA + ","
					+ m05bConstantes.COL_01_DECRETO + ","
					+ m05bConstantes.COL_01_ENTREGA + ","
					+ m05bConstantes.COL_21_NOMBRE + ","
					+ m05bConstantes.COL_34_SITUACION + ","
					+ m05bConstantes.COL_01_DESDPTO + ","
					+ m05bConstantes.COL_01_CODDPTO + ","
					+ m05bConstantes.COL_99_DESCRIPCION + ","
					+ m05bConstantes.COL_17_DESCRIP + " FROM "
					+ m05bConstantes.TAB_ASIGNACION + ","
					+ m05bConstantes.TAB_PERSONAL + ","
					+ m05bConstantes.TAB_MODELOS + ","
					+ m05bConstantes.TAB_DESCRIPCIONES + "  M,"
					+ m05bConstantes.TAB_VEHICULOS + " WHERE "
					+ m05bConstantes.COL_01_MATRICULA + "="
					+ m05bConstantes.COL_34_MATRICULA + "(+) AND "
					+ m05bConstantes.COL_34_MODELO + "="
					+ m05bConstantes.COL_17_CODMOD + " AND M."
					+ m05bConstantes.COL_99_CODTABLA + "="
					+ m05bConstantes.DESC_MARCAS + " AND "
					+ m05bConstantes.COL_34_MARCA + "= M."
					+ m05bConstantes.COL_99_CODDESC + " AND "
					+ m05bConstantes.COL_01_DNI + "="
					+ m05bConstantes.COL_21_DNI + "(+)";

			if (!(sSituacion.equals(""))) {
				sSentencia = sSentencia + " AND "
						+ m05bConstantes.COL_34_SITUACION + " in ("
						+ sSituacion + ")";
			}
			if (!(sDni.equals(""))) {
				sSentencia = sSentencia + " AND " + m05bConstantes.COL_01_DNI
						+ " = '" + sDni + "'";
			}
			if (sFinalizadaP.equals("1")) {
				sSentencia = sSentencia + " AND "
						+ m05bConstantes.COL_01_FINALIZA + " = 'S'";
			} else if (sFinalizadaP.equals("2")) {
				sSentencia = sSentencia + " AND "
						+ m05bConstantes.COL_01_FINALIZA + " = 'N'";
			}
			if (!(sFecDesde.equals(""))) {
				String sFecHasta2 = miComun.formatearFecha2(sFecHasta);
				String sFecDesde2 = miComun.formatearFecha2(sFecDesde);

				sSentencia = sSentencia + " AND (( TO_CHAR("
						+ m05bConstantes.COL_01_FDESDE + ",'YYYY/mm/dd')<='"
						+ sFecHasta2 + "')" + " AND   (("
						+ m05bConstantes.COL_01_FDEVOL + " Is Null )"
						+ " OR    ( TO_CHAR(" + m05bConstantes.COL_01_FHASTA
						+ ",'YYYY/mm/dd')>='" + sFecDesde2 + "')))";
			}
			// ORDER
			sSentencia = sSentencia + " ORDER BY "
					+ m05bConstantes.COL_01_CODDPTO + ","
					+ m05bConstantes.COL_01_CODASIG + " DESC ";

			miLog.addTraza(persona, "ImpAsignacionUsuario Servlet", "SQL: "
					+ sSentencia, m05bConstantes.LOG_NIVEL_BAJO);

			pstmt = conn.prepareStatement(sSentencia);
			rs = pstmt.executeQuery();

			tmpFoFileStream = miInforme.fncAbrirFicheroTemporal();
			miLog.addTraza(m05bConstantes.LOG_NO_USER,
					m05bConstantes.LOG_NO_SRC,
					"Despues de abrir fichero temporal",
					m05bConstantes.LOG_NIVEL_BAJO);
			sLinea = "<?xml version=\"1.0\" encoding=\"windows-1252\"?>\n";
			tmpFoFileStream.write(sLinea.getBytes());

			sLinea = "<fo:root xmlns:fo=\"http://www.w3.org/1999/XSL/Format\">\n";
			tmpFoFileStream.write(sLinea.getBytes());
			// LAYOUT DEL LISTADO
			sLinea = "<fo:layout-master-set>\n";
			tmpFoFileStream.write(sLinea.getBytes());
			sLinea = "	<fo:simple-page-master master-name=\"general\"  page-height=\"29.5cm\" page-width=\"21cm\" margin-top=\"2cm\" margin-bottom=\"2cm\" margin-left=\"2.5cm\" margin-right=\"2.5cm\">\n";
			tmpFoFileStream.write(sLinea.getBytes());
			sLinea = "		<fo:region-before extent=\"3.5cm\"/>\n";
			tmpFoFileStream.write(sLinea.getBytes());
			sLinea = "		<fo:region-body  margin-top=\"3.2cm\" margin-bottom=\"1.5cm\" />\n";
			tmpFoFileStream.write(sLinea.getBytes());
			sLinea = "		<fo:region-after  extent=\"1cm\"/>\n";
			tmpFoFileStream.write(sLinea.getBytes());
			sLinea = "		<fo:region-start extent=\"0cm\"/>\n";
			tmpFoFileStream.write(sLinea.getBytes());
			sLinea = "		<fo:region-end extent=\"0cm\"/>\n";
			tmpFoFileStream.write(sLinea.getBytes());

			sLinea = "	</fo:simple-page-master>\n";
			tmpFoFileStream.write(sLinea.getBytes());

			sLinea = "</fo:layout-master-set>\n";
			tmpFoFileStream.write(sLinea.getBytes());
			// PAGE-SEQUENCE DEL LISTADO

			int cont = 0;
			// Agurtzane Mar12: contador en listados
			int intCont = 0, intContParcial = 0;
			// Fin Agurtzane Mar12: contador en listados
			while (rs.next()) {
				// Agurtzane Mar12: contador en listados
				intCont++;
				intContParcial++;
				// Fin Agurtzane Mar12: contador en listados
				sDesDpto = rs.getString(27) == null ? "" : rs.getString(27);
				sCodDpto = rs.getString(28) == null ? "" : rs.getString(28);
				sMatricula = rs.getString(2) == null ? "" : rs.getString(2);
				sFechaDesde = rs.getString(5) == null ? "" : rs.getString(5);
				sFechaHasta = rs.getString(10) == null ? "" : rs.getString(10);
				sDni = rs.getString(3) == null ? "" : rs.getString(3);
				sMarca = rs.getString(29) == null ? "" : rs.getString(29);
				sModelo = rs.getString(30) == null ? "" : rs.getString(30);
				sNombre = rs.getString(25) == null ? "" : rs.getString(25);
				sAsignacion = rs.getString(1) == null ? "" : rs.getString(1);
				sFinalizada = rs.getString(16) == null ? "" : rs.getString(16);
				if (((!(sCodDpto.equals(sCodDptoAnt))))
						|| ((!(sDni.equals(sDniAnt)))) || (cont == 40)) {
					if (sCodDptoAnt != "") {
						imprimirTotal(intContParcial, false, res);// Agurtzane
																	// Mar12:
																	// contador
																	// en
																	// listados

						// miLog.addTraza(m05bConstantes.LOG_NO_USER,
						// m05bConstantes.LOG_NO_SRC, "Fin pagina",
						// m05bConstantes.LOG_NIVEL_BAJO);
						miInforme.fncImprimirFinPagina(tmpFoFileStream);
					}
					// miLog.addTraza(m05bConstantes.LOG_NO_USER,
					// m05bConstantes.LOG_NO_SRC, "Comienzo pagina",
					// m05bConstantes.LOG_NIVEL_BAJO);
					fncImprimirComienzoPagina(res);
					cont = 0;
					intContParcial = 0;// Agurtzane Mar12: contador en listados
				} else {
					cont = cont + 1;
					sLinea = "	    <fo:table-row >\n";
					tmpFoFileStream.write(sLinea.getBytes());
				}
				sCodDptoAnt = sCodDpto;
				sDniAnt = sDni;
				// Matricula
				sLinea = "	    <fo:table-cell border-width=\"0.1mm\" border-style=\"solid\">\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "      <fo:block  text-align=\"center\">\n <![CDATA["
						+ sMatricula + "]]></fo:block>";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "	    </fo:table-cell>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				// Marca
				sLinea = "	    <fo:table-cell border-width=\"0.1mm\" border-style=\"solid\">\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "      <fo:block  text-align=\"center\">\n <![CDATA["
						+ sFechaDesde + "]]></fo:block>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "	    </fo:table-cell>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				// Modelo
				sLinea = "	    <fo:table-cell border-width=\"0.1mm\" border-style=\"solid\">\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "      <fo:block  text-align=\"center\">\n<![CDATA["
						+ sFechaHasta + "]]></fo:block>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "	    </fo:table-cell>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				// F.Matricula
				sLinea = "	    <fo:table-cell border-width=\"0.1mm\" border-style=\"solid\">\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "      <fo:block  text-align=\"center\">\n<![CDATA[" + sMarca
						+ "]]></fo:block>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "	    </fo:table-cell>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				// Km
				sLinea = "	    <fo:table-cell border-width=\"0.1mm\" border-style=\"solid\">\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "      <fo:block  text-align=\"center\">\n<![CDATA[" + sModelo
						+ "]]></fo:block>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "	    </fo:table-cell>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				// situacion
				sLinea = "	    <fo:table-cell border-width=\"0.1mm\" border-style=\"solid\">\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "      <fo:block  text-align=\"center\">\n<![CDATA["
						+ sFinalizada + "]]></fo:block>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "	    </fo:table-cell>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				// Centro
				sLinea = "	    <fo:table-cell border-width=\"0.1mm\" border-style=\"solid\">\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "      <fo:block  text-align=\"center\">\n<![CDATA["
						+ sAsignacion + "]]></fo:block>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "	    </fo:table-cell>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "	    </fo:table-row>\n";
				tmpFoFileStream.write(sLinea.getBytes());
			}
			// Agurtzane Mar12: contador en listados
			intContParcial++;
			imprimirTotal(intContParcial, false, res);
			// Es siempre por usuario imprimirTotal(intCont, true);
			// Fin Agurtzane Mar12: contador en listados
			miInforme.fncImprimirFinPagina(tmpFoFileStream);
			rs.close();
			sLinea = "</fo:root>\n";
			tmpFoFileStream.write(sLinea.getBytes());

			tmpFoFileStream.close();
			miLog.addTraza(persona, "ImpAsignacionUsuario Servlet",
					"Antes generar PDF desde FO", m05bConstantes.LOG_NIVEL_BAJO);
			miInforme.generarPDFdesdeFO(response);
			miLog.addTraza(persona, "ImpAsignacionUsuario Servlet",
					"Despues generar PDF desde FO",
					m05bConstantes.LOG_NIVEL_BAJO);

		} catch (Exception ex) {
			try {
				response.sendRedirect("m05bError.jsp");
			} catch (IOException e) {
				// TODO Auto-generated catch block
				miLog.addTraza(e);
			}
		} finally {
			try {
				if (rs != null)
					rs.close();
				if (pstmt != null)
					pstmt.close();
				if (conn != null)
					conn.close();
			} catch (SQLException e2) {
				try {
					response.sendRedirect("m05bError.jsp");
				} catch (IOException e) {
					// TODO Auto-generated catch block
					miLog.addTraza(e);
				}
			}
		}
	}

}