package asignacionServlet;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;

import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.naming.InitialContext;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import m05bAsignacionEJB.m05Asignacion;
import m05bAsignacionEJB.m05AsignacionHome;
import m05bAsignacionEJB.m05AsignacionPK;
import m05bBD.m05bAsignacion;
import m05bBD.m05bCargo;
import m05bBD.m05bPersonal;
import m05bBD.m05bSolicitudReserva;
import m05bCargoEJB.m05Cargo;
import m05bCargoEJB.m05CargoHome;
import m05bCargoEJB.m05CargoPK;
import m05bClasses.m05bCampos;
import m05bClasses.m05bComun;
import m05bClasses.m05bConexion;
import m05bClasses.m05bConstantes;
import m05bClasses.m05bDescrip;
import m05bClasses.m05bFileLog;
import m05bClasses.m05bGenerarClave;
import m05bClasses.m05bUtils;
import m05bClasses.m05bDokusi.m05bDokusiService;
import m05bClasses.m05bDokusi.models.T65BDocumentID;
import m05bClasses.m05bDokusi.parsers.T65BHDCustomParser;
import m05bClasses.m05bFirma.m05bFirmaInfoBean;
import m05bClasses.m05bFirma.m05bPlatea;
import m05bLdap.SecurityHelpperException;
import m05bLdap.SecurityHelpperXLNets;
import m05bLdap.m05bPersonaXLNET;
import m05bPersonalEJB.m05Personal;
import m05bPersonalEJB.m05PersonalHome;
import m05bPersonalEJB.m05PersonalPK;
import m05bSolicitudReservaEJB.m05SolicitudReserva;
import m05bSolicitudReservaEJB.m05SolicitudReservaHome;
import m05bSolicitudReservaEJB.m05SolicitudReservaPK;
import weblogic.utils.encoders.BASE64Decoder;

/**
 * Inserte aqu la descripcion del tipo.
 * Fecha de creacin: (15/03/04)
 */
public class m05bGrabarAsignacionServlet extends javax.servlet.http.HttpServlet {m05bFileLog miLog = new m05bFileLog();
	
	public final String XML_VAL_NOEXISTE = "NOEXISTE";
	
/**
 * Process incoming HTTP POST requests
 *
 * @param request Object that encapsulates the request to the servlet
 * @param response Object that encapsulates the response from the servlet
 */
public void doPost(javax.servlet.http.HttpServletRequest request, javax.servlet.http.HttpServletResponse response) throws javax.servlet.ServletException, java.io.IOException {

	performTask(request, response);

}
/**
 * Returns the servlet info string.
 */
public String getServletInfo() {

	return super.getServletInfo();

}
/**
 * Initializes the servlet.
 */
public void init() {
	// insert code to initialize the servlet here

}
/**
 * Process incoming requests for information
 *
 * @param request Object that encapsulates the request to the servlet
 * @param response Object that encapsulates the response from the servlet
 */
public void performTask(javax.servlet.http.HttpServletRequest request, javax.servlet.http.HttpServletResponse response) {

	   m05bPersonaXLNET personaXLNET = null;

	   String strMensajeRetorno = "";

       m05bFileLog miLog = new m05bFileLog();
       m05bCampos campos = new m05bCampos();
       m05bComun comun =  new m05bComun();
       String sCodigo,sMatricula, sDni, sDepartamento, sKmsalida, sKmllegada, sKmrecorridos="";
       String sComentarios, sPermanente, sFinalizada, sRango, sCargo, sOrden, sCodDpto;
       String sFecSol, sFecDes, sFecHas, sFecDev, sHorDes, sHorHas, sHorDev;
       String sImpreso="N", sDecreto="N", sEntrega="";
       String accion="";
       String accionFirma="";
  	   java.sql.Connection conn = null;
	   PreparedStatement pstmt = null;

	   HttpSession session = request.getSession(true);
	   String campoTexto="C";
		
		String formatoFecha="dd/MM/yyyy";
		String formatoFechaHora = "dd/MM/yyyy HH24:mi";
		Locale idiomaLocal = (Locale)session.getAttribute("Local");
   		String idiomaSes = ((idiomaLocal.getLanguage()==null)?"es":idiomaLocal.getLanguage());	
  			
  		if (!idiomaSes.equals("es")) {
			formatoFecha = "yyyy/MM/dd";
			formatoFechaHora = "yyyy/MM/dd HH24:mi";
			campoTexto="E";
		}
	
	   String persona = (String) session.getAttribute("persona");
	   String personaCodigo = (String) session.getAttribute("personaCodigo");
	   miLog.addTraza(persona, "Grabar Asignaciones Servlet", "INICIO", m05bConstantes.LOG_NIVEL_BAJO);

       accion=request.getParameter("Accion");
       accionFirma=request.getParameter("AccionFirma");
       sCodigo = new String(request.getParameter("Codigo"));
       sMatricula=request.getParameter("Matricula").toUpperCase();

       sCodDpto=request.getParameter("CodDpto").toUpperCase();
       sCodDpto=campos.getCodDpto(sCodDpto);
       sCodDpto=sCodDpto.trim();

       sDni=request.getParameter("Dni");

       sKmsalida=request.getParameter("Kmsalida");
       sKmrecorridos=request.getParameter("Kmrecorridos");
       if ( (sKmsalida.equals("")) || (sKmsalida == null) ) {

       	   sKmsalida="0";
           sKmrecorridos="0";
       } else
           sKmsalida=comun.ImportesABasedatos(sKmsalida);
       
       sKmllegada=request.getParameter("Kmllegada");
       if ( (sKmllegada.equals("")) || (sKmllegada == null ) )
       	   sKmllegada="0";
       else
           sKmllegada=comun.ImportesABasedatos(sKmllegada);

       if ( (sKmrecorridos == null) || (sKmrecorridos.equals("")) )
       	   sKmrecorridos="0";
       else
           sKmrecorridos=comun.ImportesABasedatos(sKmrecorridos);

       sDepartamento=request.getParameter("DescDpto");
       sDepartamento=sDepartamento.trim();

       sComentarios=request.getParameter("Comentarios").toUpperCase();

       sRango=request.getParameter("RangPer");
       sCargo=request.getParameter("CodCargo");
       sPermanente=request.getParameter("AsigPermanenteVar");
  	   miLog.addTraza(persona, "Grabar Asignaciones Servlet", "AsigPermanente:"+sPermanente, m05bConstantes.LOG_NIVEL_BAJO);

       if ((sPermanente==null)|| (sPermanente.equals("")) ) {
            sPermanente="N";
       }

	   if (accion.equals(m05bConstantes.ACC_REVOCAR)) {
	   	   	sFinalizada="S";
       		sFecDev=request.getParameter("FDevolucion");
       		sHorDev=request.getParameter("HoraDevol");
	   } else {
	       	sFinalizada=request.getParameter("Finalizada");
	        if (sFinalizada==null)
	            sFinalizada="N";
       		sFecDev=request.getParameter("FDevolucion");
       		sHorDev=request.getParameter("HoraDevol");
	        if (sFecDev!=null && !sFecDev.equals("")) {
	         	sFecDev=comun.FechaBD(sFecDev,sHorDev,campoTexto);
	        }
	        else {
	            sFecDev="";
	        }
	   }

       sFecSol=request.getParameter("FSolicitud");
       sFecDes= request.getParameter("Desde");
       sHorDes=request.getParameter("HoraDesde");

       sFecHas=request.getParameter("Hasta");
       sHorHas=request.getParameter("HoraHasta");
       sOrden=request.getParameter("Rango");
       
       sEntrega=request.getParameter("Entregado");
       if (sEntrega == null || !sEntrega.equals("S")) {
    	   sEntrega = "N";
       }

       try {
    	   m05bAsignacion asignacion = (m05bAsignacion)session.getAttribute("m05bAsignacion");
    	   //sFecSol=sFecSol.substring(sFecSol.lastIndexOf("/")+1,sFecSol.length())+sFecSol.substring(sFecSol.indexOf("/")+1,sFecSol.lastIndexOf("/"))+sFecSol.substring(0,sFecSol.indexOf("/"));

    	   sFecSol=comun.FechaBD(sFecSol,"00:00",campoTexto);

    	   sFecDes=comun.FechaBD(sFecDes,sHorDes,campoTexto);
    	   sFecHas=comun.FechaBD(sFecHas,sHorHas,campoTexto);
    	   miLog.addTraza(persona, "Grabar Asignaciones Servlet", "Fecha Hasta: " + sFecHas, m05bConstantes.LOG_NIVEL_BAJO);

    	   asignacion.setAsi_codigo(sCodigo);
    	   asignacion.setAsi_matricula(sMatricula);
    	   asignacion.setAsi_coddpto(sCodDpto);

    	   asignacion.setAsi_dni(sDni);
    	   asignacion.setAsi_kmsalida(sKmsalida);
    	   asignacion.setAsi_kmllegada(sKmllegada);

    	   asignacion.setAsi_kmrecorridos(sKmrecorridos);
    	   asignacion.setAsi_coddpto(sDepartamento);
    	   asignacion.setAsi_observaciones(sComentarios);
    	   miLog.addTraza(persona, "Grabar Asignaciones Servlet", "Comentarios: " + sComentarios, m05bConstantes.LOG_NIVEL_BAJO);

    	   asignacion.setAsi_codrango(sRango);
    	   asignacion.setAsi_codcargo(sCargo);
    	   asignacion.setAsi_permanente(sPermanente);

    	   asignacion.setAsi_finalizada(sFinalizada);
    	   asignacion.setAsi_fsolicitud(sFecSol);
    	   asignacion.setAsi_fdesde(sFecDes);
    	   miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "Fecha Hasta-1: " + sFecHas, m05bConstantes.LOG_NIVEL_BAJO);

    	   asignacion.setAsi_fhasta(sFecHas);
    	   miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "Fecha Hasta-2: " + sFecHas, m05bConstantes.LOG_NIVEL_BAJO);
        
    	   if (!sFecDev.equals(""))
    		   asignacion.setAsi_fdevolucion(sFecDev);
    	   asignacion.setAsi_orden(sOrden);
    	   session.setAttribute("m05bAsignacion", asignacion);

    	   asignacion.setAsi_entrega(sEntrega);

    	   if (accion.equals(m05bConstantes.ACC_INSERTAR)) {
    		   asignacion.setAsi_impreso(sImpreso);
    		   asignacion.setAsi_decreto(sDecreto);
    	   }

    	   try {
    		   m05bConexion miConex = new m05bConexion();
    		   conn = miConex.getConnection();
    		   conn.setAutoCommit(false);

    		   //20141002 - INIGO
    		   String sDniSinLetra = sDni;
               if (sDni.length() > 0) {
            	   if (!Character.isDigit(sDni.charAt(sDni.length() - 1))) {
            		   sDniSinLetra = sDniSinLetra.substring(0, sDni.length() - 1);
            	   }
               }

               boolean existeDni = false;
               boolean existeDniLike = false;
               String sDniLike = sDni;
               String sqlExiste = "select 1 from M0521T00 where DNI_21 = '" + sDni + "'";
        	   miLog.addTraza(m05bConstantes.LOG_NO_USER,m05bConstantes.LOG_NO_SRC," : Primero miramos si existe la persona... sqlExiste=" + sqlExiste, m05bConstantes.LOG_NIVEL_BAJO);
        	   PreparedStatement pstmtExiste = conn.prepareStatement(sqlExiste);
        	   if (pstmtExiste.executeQuery().next()) {
        		   existeDni = true;
        	   } else {
        		   sqlExiste = "select DNI_21 from M0521T00 where DNI_21 LIKE '" + sDniSinLetra + "%'";
        		   miLog.addTraza(m05bConstantes.LOG_NO_USER,m05bConstantes.LOG_NO_SRC," : Primero miramos si existe la persona... sqlExiste(LIKE)=" + sqlExiste, m05bConstantes.LOG_NIVEL_BAJO);
        		   pstmtExiste = conn.prepareStatement(sqlExiste);
        		   if (pstmtExiste.executeQuery().next()) {
        			   existeDniLike = true;
        			   sDniLike = pstmtExiste.getResultSet().getString("DNI_21");
        		   }
        	   }
        	   pstmtExiste.close();

        	   String sDniAGuardar = sDni;
        	   if (!existeDni && existeDniLike) {
        		   sDniAGuardar = sDniLike;
        	   }

        	   if (!existeDni && !existeDniLike) {
        		   sDniAGuardar = m05bUtils.dniConLetra(sDniAGuardar);
        	   }

        	   sDniAGuardar = sDniAGuardar.toUpperCase();

        	   asignacion.setAsi_dni(sDniAGuardar);
    		   //

    		   String sql="";
    		   if (accion.equals(m05bConstantes.ACC_ACTUALIZAR)) {
    			   if (!sFecDev.equals(""))
    				   sFinalizada="S";
    			   else
    				   sFinalizada="N";
    			   sql="update	" + m05bConstantes.TAB_ASIGNACION + " set " + m05bConstantes.COL_01_OBSERV + " = ? " ;
    			   if (sKmsalida!="0") {
    				   sql=sql+" ,	   " + m05bConstantes.COL_01_KMSALIDA + " = " + sKmsalida ;
    			   }

    			   sql=sql+" ,	   " + m05bConstantes.COL_01_KMLLEGADA + " = " + sKmllegada +
    			   		" ,	   " + m05bConstantes.COL_01_KMRECORRIDO + " = " + sKmrecorridos +
			   			" ,	   " + m05bConstantes.COL_01_ASIG + " = '" + sPermanente + "'" +
			   			" ,	   " + m05bConstantes.COL_01_FINALIZA + " = '" + sFinalizada + "'" +
			   			" ,	   " + m05bConstantes.COL_01_ENTREGA + " = '" + sEntrega + "'" +
			   			" ,	   " + m05bConstantes.COL_01_DNI + " = '" + sDniAGuardar + "'" +
			   			" ,	   " + m05bConstantes.COL_01_MATRICULA + " ='" + sMatricula + "'" +
			   			" ,	   " + m05bConstantes.COL_01_CODRANGO + " = '" + sRango + "'" +
			   			" ,	   " + m05bConstantes.COL_01_CODDPTO + " = '" + sCodDpto + "'" +
			   			" ,	   " + m05bConstantes.COL_01_DESDPTO + " = '" + sDepartamento + "'" +
			   			" ,	   " + m05bConstantes.COL_01_CODCARGO + " = '" + sCargo + "'" +
			   			" ,	   " + m05bConstantes.COL_01_FECHA + "  = TO_DATE ('" + sFecSol + "','YYYYMMDDHH24MISS') " +
			   			" ,	   " + m05bConstantes.COL_01_FDESDE + " = TO_DATE ('" + sFecDes + "','YYYYMMDDHH24MISS') " +
			   			" ,	   " + m05bConstantes.COL_01_FHASTA + " = TO_DATE ('" + sFecHas + "','YYYYMMDDHH24MISS') " +
			   			" ,    " + m05bConstantes.COL_01_ORDEN + " = '" + sOrden + "'";
    			   if (!sFecDev.equals("")) {
    				   sql=sql+" ,	   "+ m05bConstantes.COL_01_FDEVOL +" = TO_DATE ('"+ sFecDev + "','YYYYMMDDHH24MISS') ";
    			   } else {
    				   sql=sql+" ,	   "+ m05bConstantes.COL_01_FDEVOL +" =''";
    			   }
    			   sql=sql+" where	COD_ASIG_01 = '" + sCodigo + "'";
    			   miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "SQL UPDATE: " + sql, m05bConstantes.LOG_NIVEL_BAJO);
    			   pstmt = conn.prepareStatement(sql);
    			   pstmt.setString(1, sComentarios);
    			   pstmt.executeUpdate();
    			   if (sFinalizada == "S") {
    				   // Actualizar los km y la fecha actuales del vehiculo
    				   sql="update	" + m05bConstantes.TAB_VEHICULOS +
									" set " + m05bConstantes.COL_34_KMACTUALES + " = " + sKmllegada + 
									" ,  " + m05bConstantes.COL_34_FKMACT + "= TO_DATE ('" + sFecDev + "','YYYYMMDDHH24MISS') " +
									" where " + m05bConstantes.COL_34_MATRICULA + " = '" + sMatricula + "' AND TO_CHAR("+
			                        m05bConstantes.COL_34_FKMACT+",'YYYY/mm/dd')<=TO_CHAR(TO_DATE('"+ sFecDev+"','YYYYMMDDHH24MISS'),'yyyy/mm/dd') AND  "+m05bConstantes.COL_34_KMACTUALES +
				                    "<='"+sKmllegada+"'";
    				   miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "SQL KM ACTUALES: " + sql, m05bConstantes.LOG_NIVEL_BAJO);
    				   pstmt = conn.prepareStatement(sql);
    				   pstmt.executeUpdate();
    			   } else {
    				   sql="update	" + m05bConstantes.TAB_VEHICULOS +
    				   " set " + m05bConstantes.COL_34_KMACTUALES + " = " + sKmsalida +
    				   " ,  " + m05bConstantes.COL_34_FKMACT + "= TO_DATE ('" + sFecDes + "','YYYYMMDDHH24MISS') " +
    				   " where " + m05bConstantes.COL_34_MATRICULA + " = '" + sMatricula + "' AND TO_CHAR("+
    				   m05bConstantes.COL_34_FKMACT+",'YYYY/mm/dd')<=TO_CHAR(TO_DATE('"+ request.getParameter("Desde")+"','dd/mm/yyyy'),'yyyy/mm/dd') AND "+  m05bConstantes.COL_34_KMACTUALES +
    				   "<='"+sKmsalida+"'";
    				   miLog.addTraza(m05bConstantes.LOG_NO_USER,m05bConstantes.LOG_NO_SRC,"SQL: " + sql, m05bConstantes.LOG_NIVEL_BAJO);
    				   pstmt = conn.prepareStatement(sql);
    				   pstmt.executeUpdate();
    			   }

    		   } // FIN IF accion.equals(m05bConstantes.ACC_ACTUALIZAR)
    		   else if (accion.equals(m05bConstantes.ACC_REVOCAR)) {

    			   if (sFecDev.equals("")) {
    				   sFecDev="sysdate";
    			   }

    			   //sKmllegada=request.getParameter("KmAct");
    			   sql="update	"+m05bConstantes.TAB_ASIGNACION+
    			   		" set "+m05bConstantes.COL_01_FINALIZA+" = '" + sFinalizada + "'" +
    			   		" ,	   "+ m05bConstantes.COL_01_KMLLEGADA + " =  " + sKmllegada +
    			   		" ,	   "+ m05bConstantes.COL_01_KMRECORRIDO + " =  " + sKmrecorridos +
    			   		" ,	   "+ m05bConstantes.COL_01_FDEVOL +" = " + sFecDev;
    			   sql=sql+" where	COD_ASIG_01 = "+sCodigo;
    			   pstmt = conn.prepareStatement(sql);
    			   pstmt.executeUpdate();
    			   // Actualizar los km y la fecha actuales del vehiculo
    			   sql="update	" + m05bConstantes.TAB_VEHICULOS +
    			   		" set " + m05bConstantes.COL_34_KMACTUALES + " = " + sKmllegada +
    			   		" ,  " + m05bConstantes.COL_34_FKMACT + "= sysdate " +
    			   		" where " + m05bConstantes.COL_34_MATRICULA + " = '" + sMatricula + "' AND TO_CHAR("+
    			   		m05bConstantes.COL_34_FKMACT+",'YYYY/mm/dd')<=TO_CHAR(sysdate,'yyyy/mm/dd') AND  "+m05bConstantes.COL_34_KMACTUALES +
    			   		"<='"+sKmllegada+"'";

    			   pstmt = conn.prepareStatement(sql);
    			   pstmt.executeUpdate();
    		   }
    		   else if (accion.equals(m05bConstantes.ACC_INSERTAR)) {

					sql="insert into " +m05bConstantes.TAB_ASIGNACION+
						" ("+m05bConstantes.COL_01_CODASIG+","+m05bConstantes.COL_01_MATRICULA+"," +
						m05bConstantes.COL_01_DNI+","+m05bConstantes.COL_01_KMSALIDA+","+
						m05bConstantes.COL_01_KMLLEGADA+","+m05bConstantes.COL_01_KMRECORRIDO+","+
						m05bConstantes.COL_01_ASIG+","+m05bConstantes.COL_01_FINALIZA+","+
						m05bConstantes.COL_01_OBSERV+","+m05bConstantes.COL_01_CODRANGO+","+
						m05bConstantes.COL_01_CODDPTO+","+m05bConstantes.COL_01_DESDPTO+","+
						m05bConstantes.COL_01_CODCARGO+","+m05bConstantes.COL_01_FECHA+","+
						m05bConstantes.COL_01_FDESDE+","+m05bConstantes.COL_01_FHASTA+","+
						m05bConstantes.COL_01_ORDEN+","+m05bConstantes.COL_01_IMPRESO+","+m05bConstantes.COL_01_DECRETO+","+
						m05bConstantes.COL_01_ENTREGA;
					if (!sFecDev.equals(""))
						sql=sql+","+m05bConstantes.COL_01_FDEVOL+") values ";
					else
						sql=sql+") values ";
					sql=sql+"(? ,?, UPPER(?), ?, ?, ? , ? ,? , ? , ? , ?, ?, ?, TO_DATE(?,'YYYYMMDDHH24MISS'), TO_DATE(?,'YYYYMMDDHH24MISS'), TO_DATE(?,'YYYYMMDDHH24MISS'), ?, ?, ?, ?";
					if (sFecDev.equals(""))
						sql=sql+")";
					else
						sql=sql+", TO_DATE(?,'YYYYMMDDHH24MISS'))";

					miLog.addTraza(persona, "Grabar Asignaciones Servlet", "sql:"+sql, m05bConstantes.LOG_NIVEL_BAJO);

					pstmt = conn.prepareStatement(sql);
					miLog.addTraza(persona, "Grabar Asignaciones Servlet", "codigo:"+sCodigo, m05bConstantes.LOG_NIVEL_BAJO);
					miLog.addTraza(persona, "Grabar Asignaciones Servlet", "sMatricula:"+sMatricula, m05bConstantes.LOG_NIVEL_BAJO);
					miLog.addTraza(persona, "Grabar Asignaciones Servlet", "sDni:"+sDni, m05bConstantes.LOG_NIVEL_BAJO);
					miLog.addTraza(persona, "Grabar Asignaciones Servlet", "sDniAGuardar:"+sDniAGuardar, m05bConstantes.LOG_NIVEL_BAJO);
					miLog.addTraza(persona, "Grabar Asignaciones Servlet", "sKmsalida:"+sKmsalida, m05bConstantes.LOG_NIVEL_BAJO);
					miLog.addTraza(persona, "Grabar Asignaciones Servlet", "sKmllegada:"+sKmllegada, m05bConstantes.LOG_NIVEL_BAJO);
					miLog.addTraza(persona, "Grabar Asignaciones Servlet", "sKmrecorridos:"+sKmrecorridos, m05bConstantes.LOG_NIVEL_BAJO);
					miLog.addTraza(persona, "Grabar Asignaciones Servlet", "sPermanente:"+sPermanente, m05bConstantes.LOG_NIVEL_BAJO);
					miLog.addTraza(persona, "Grabar Asignaciones Servlet", "sFinalizada:"+sFinalizada, m05bConstantes.LOG_NIVEL_BAJO);
					miLog.addTraza(persona, "Grabar Asignaciones Servlet", "sComentarios:"+sComentarios, m05bConstantes.LOG_NIVEL_BAJO);
					miLog.addTraza(persona, "Grabar Asignaciones Servlet", "sRango:"+sRango, m05bConstantes.LOG_NIVEL_BAJO);
					miLog.addTraza(persona, "Grabar Asignaciones Servlet", "sCodDpto:"+sCodDpto, m05bConstantes.LOG_NIVEL_BAJO);
					miLog.addTraza(persona, "Grabar Asignaciones Servlet", "sDepartamento:"+sDepartamento, m05bConstantes.LOG_NIVEL_BAJO);
					miLog.addTraza(persona, "Grabar Asignaciones Servlet", "sCargo:"+sCargo, m05bConstantes.LOG_NIVEL_BAJO);
					miLog.addTraza(persona, "Grabar Asignaciones Servlet", "sFecSol:"+sFecSol, m05bConstantes.LOG_NIVEL_BAJO);
					miLog.addTraza(persona, "Grabar Asignaciones Servlet", "sFecDes:"+sFecDes, m05bConstantes.LOG_NIVEL_BAJO);
					miLog.addTraza(persona, "Grabar Asignaciones Servlet", "sFecHas:"+sFecHas, m05bConstantes.LOG_NIVEL_BAJO);
					miLog.addTraza(persona, "Grabar Asignaciones Servlet", "sOrden:"+sOrden, m05bConstantes.LOG_NIVEL_BAJO);
					miLog.addTraza(persona, "Grabar Asignaciones Servlet", "sImpreso:"+sImpreso, m05bConstantes.LOG_NIVEL_BAJO);
					miLog.addTraza(persona, "Grabar Asignaciones Servlet", "sDecreto:"+sDecreto, m05bConstantes.LOG_NIVEL_BAJO);
					miLog.addTraza(persona, "Grabar Asignaciones Servlet", "sEntrega:"+sEntrega, m05bConstantes.LOG_NIVEL_BAJO);
					miLog.addTraza(persona, "Grabar Asignaciones Servlet", "sFecDev:"+sFecDev, m05bConstantes.LOG_NIVEL_BAJO);

					pstmt.setString(1, sCodigo);
					pstmt.setString(2, sMatricula);
					pstmt.setString(3, sDniAGuardar);
					pstmt.setString(4, sKmsalida);
					pstmt.setString(5, sKmllegada);
					pstmt.setString(6, sKmrecorridos);
					pstmt.setString(7, sPermanente);
					pstmt.setString(8, sFinalizada);
					pstmt.setString(9, sComentarios);
					pstmt.setString(10,sRango);
					pstmt.setString(11,sCodDpto);
					pstmt.setString(12,sDepartamento);
					pstmt.setString(13,sCargo);
					pstmt.setString(14,sFecSol);
					pstmt.setString(15,sFecDes);
					pstmt.setString(16,sFecHas);
					pstmt.setString(17,sOrden);
					pstmt.setString(18,sImpreso);
					pstmt.setString(19,sDecreto);
					pstmt.setString(20,sEntrega);
					if (!sFecDev.equals(""))
						pstmt.setString(21,sFecDev);
					pstmt.executeUpdate();
					
					sql="update	" + m05bConstantes.TAB_VEHICULOS +
						" set " + m05bConstantes.COL_34_KMACTUALES + " = " + sKmsalida +
						" ,  " + m05bConstantes.COL_34_FKMACT + "= TO_DATE ('" + sFecDes + "','YYYYMMDDHH24MISS') " +
						" where " + m05bConstantes.COL_34_MATRICULA + " = '" + sMatricula + "' AND TO_CHAR("+
						m05bConstantes.COL_34_FKMACT+",'YYYY/mm/dd')<=TO_CHAR(TO_DATE('"+ request.getParameter("Desde")+"','dd/mm/yyyy'),'yyyy/mm/dd') AND "+  m05bConstantes.COL_34_KMACTUALES +
						"<='"+sKmsalida+"'";

					miLog.addTraza(m05bConstantes.LOG_NO_USER,m05bConstantes.LOG_NO_SRC,"SQL: " + sql, m05bConstantes.LOG_NIVEL_BAJO);
					pstmt = conn.prepareStatement(sql);
					pstmt.executeUpdate();

					/*20110921 Iigo Solicitud Reserva INI*/
					String sIdSolicitud = request.getParameter("IdSolicitud");
					if (sIdSolicitud != null && !sIdSolicitud.equals("")) {
						
						//Obtenemos la solicitud de reserva
						m05SolicitudReservaPK primaryKey = new m05SolicitudReservaPK();
						primaryKey.idSolicitud = new Integer(sIdSolicitud);
						InitialContext ctx2 = new InitialContext();
						m05SolicitudReservaHome solicitudReservaEBHome = (m05SolicitudReservaHome) ctx2.lookup("m05SolicitudReserva");
						m05SolicitudReserva solicitudReservaEB = solicitudReservaEBHome.findByPrimaryKey(primaryKey);
						m05bSolicitudReserva solicitudReserva = solicitudReservaEB.getSolicitudReserva();
						
						if (solicitudReserva.getCodAsignacion()==null || solicitudReserva.getCodAsignacion().intValue()<=0) {

							//Actualizamos la tabla de la solicitud con el cdigo de la asignacin
							sql = "UPDATE M05100T00"
								+ " SET COD_ASIGNACION_100 = " + sCodigo
								+ " WHERE ID_SOLICITUD_100 = " + Integer.parseInt(sIdSolicitud);
							pstmt = conn.prepareStatement(sql);
							pstmt.executeUpdate();

						   	if (personaXLNET == null) {
						   		personaXLNET = this.obtenerUsuarioXlNets(personaCodigo, request);
						   	}

							// Cambiamos a BAJA los estados que estn PENDIENTES DE ENTREGA
						   	sql = "update m05102s01 set SITUACION_102=? "
						   		+ "where ID_SOLICITUD_102=? AND ESTADO_102=? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, m05bConstantes.SITUACION_BAJA); // ORIGEN_102
							pstmt.setLong(2, Integer.parseInt(sIdSolicitud)); // ID_SOLICITUD_102
							pstmt.setString(3, m05bConstantes.ACEPTADASINENTREGAR); // ESTADO_102
							miLog.addTraza(persona, "m05bGrabarAsignacionServlet", "SQL: " + sql, m05bConstantes.LOG_NIVEL_BAJO);
							pstmt.executeUpdate();
							//

							//Cambiamos el estado de la solicitud a PENDIENTE DE ENTREGA
							sql = "insert into m05102s01 (ID_SOLICITUD_102,COD_VALIDADOR_102,FECHA_VALIDACION_102,"
								+ " ESTADO_102,MOTIVO_102,OBSERVACIONES_102,COD_DESTINO_102,DESTINO_OTROS_102,"
								+ " MAIL_ENVIADO_102,DNI_102,NOMBRE_APELLIDOS_102,ORIGEN_102,SITUACION_102,"
								+ " VALIDACION_POSTERIOR_102)"
								+ " values (?,?,sysdate,?,?,null,null,null,'0',?,?,?,?,'0')";
							pstmt = conn.prepareStatement(sql);
							pstmt.setLong(1, Long.parseLong(sIdSolicitud)); // ID_SOLICITUD_102
							pstmt.setString(2, personaXLNET.getCodigo()); // COD_VALIDADOR_102
							pstmt.setString(3, m05bConstantes.ACEPTADASINENTREGAR); // ESTADO_102
							pstmt.setString(4, null); // MOTIVO_102
							pstmt.setString(5, personaXLNET.getDni()); // DNI_102
							pstmt.setString(6, personaXLNET.getNombre() + " " + personaXLNET.getApellidos()); // NOMBRE_APELLIDOS_102
							pstmt.setString(7, m05bConstantes.ORIGENPARQUEMOVIL); // ORIGEN_102
							pstmt.setString(8, m05bConstantes.SITUACION_ALTA); // ORIGEN_102
							miLog.addTraza(persona, "m05bGrabarAsignacionServlet", "SQL: " + sql, m05bConstantes.LOG_NIVEL_BAJO);
							pstmt.executeUpdate();
							//

							//Desbloqueamos la solicitud de reserva (en caso de que estuviera bloqueada)
							boolean solicitudBloqueada = request.getParameter("SolicitudBloqueada")==null?false:(request.getParameter("SolicitudBloqueada").equals("1"));
							miLog.addTraza(persona, "m05bGrabarAsignacionServlet", "solicitudBloqueada=" + solicitudBloqueada, m05bConstantes.LOG_NIVEL_BAJO);
							//if (solicitudBloqueada) {
							//	sql = "update m05100s01 set BLOQUEO_100 = 0 WHERE ID_SOLICITUD_100 = ? AND NVL(BLOQUEO_100,0)=1";
							//	pstmt = conn.prepareStatement(sql.toString());
							//	pstmt.setLong(1, Long.parseLong(sIdSolicitud));
							//	int desbloqueo = pstmt.executeUpdate();
							//	miLog.addTraza(persona, "m05bGrabarAsignacionServlet", "SQL: " + sql + " - " + desbloqueo + " fila(s) afectada(s)", m05bConstantes.LOG_NIVEL_BAJO);
							//}
							//

							//Aadimos o actualizamos el usuario de la solicitud en la tabla personal de la aplicacin (m0521t00)
							//Primero miramos si existe la persona
							solicitudReserva.getUsuario().setDni(sDniAGuardar);

							if (existeDni || existeDniLike) {
								//LO ACTUALIZAMOS
								miLog.addTraza(m05bConstantes.LOG_NO_USER,m05bConstantes.LOG_NO_SRC,"ACTUALIZAMOS LA PERSONA INI: ", m05bConstantes.LOG_NIVEL_BAJO);
								
								String sCodDptoPersonaAnt = "";
								sql = "select CODDPTO_21 as CODDPTO_21 from M0521T00 where DNI_21 = '" + sDniAGuardar + "'";
								pstmt = conn.prepareStatement(sql);
								ResultSet rsDptoPersona = pstmt.executeQuery();
								if (rsDptoPersona.next()) {
									sCodDptoPersonaAnt = rsDptoPersona.getString("CODDPTO_21");
								}
								if (!sCodDptoPersonaAnt.equals(sCodDpto)) {
									//Inserta el registro historico si ha cambiado el departamento
									miLog.addTraza(m05bConstantes.LOG_NO_USER,m05bConstantes.LOG_NO_SRC,"El departamento ha cambiado, se inserta en histrico. sCodDptoPersonaAnt=" + sCodDptoPersonaAnt + " - sCodDpto=" + sCodDpto, m05bConstantes.LOG_NIVEL_BAJO);
									m05bGenerarClave miIdHist = new m05bGenerarClave();
									String sIDHist = "" + miIdHist.getNextId(m05bConstantes.TAB_HIST_PERSONAL, m05bConstantes.COL_12_ID);
									sql = "insert into	M0512T00 " + 
											"(COD_PERH_12,CODRANGO_P_12,NOMBRE_12,DIREC_12,TELEF_12,DNI_12,CODCARGO_12,CODDPTO_12,FCAMBIO_12,ACT_GIP_12,CODPROVINCIA_12,CODMUNICIPIO_12,CODPOSTAL_12)" + 
											" select " + sIDHist + ",CODRANG_P_21,"+
											//Agurtzane Feb12: guardar maysculas
											//"NOMBRE_21,"+
											"UPPER(NOMBRE_21),"+
											//Fin Agurtzane Feb12: guardar maysculas
											"DIREC_21,TELEF_21,DNI_21,CODCARGO_21,CODDPTO_21, sysdate, ACT_GIP_21,CODPROVINCIA_21,CODMUNICIPIO_21,CODPOSTAL_21" +
											" from M0521T00 where DNI_21 = '" + sDniAGuardar + "'";
									pstmt = conn.prepareStatement(sql);
									miLog.addTraza(m05bConstantes.LOG_NO_USER,m05bConstantes.LOG_NO_SRC,"INSERTAMOS LA PERSONA EN EL HISTRICO SQL: " + sql, m05bConstantes.LOG_NIVEL_BAJO);
									pstmt.executeUpdate();
								} else {
									miLog.addTraza(m05bConstantes.LOG_NO_USER,m05bConstantes.LOG_NO_SRC,"El departamento NO ha cambiado.", m05bConstantes.LOG_NIVEL_BAJO);
								}
								//Actualiza el registro actual de la tabla Personal
								String sCargoPersona=request.getParameter("Cargo");
								String sRangoPersona=request.getParameter("Rang");
								sql = "update M0521T00 " +
										"set NOMBRE_21 = ?" +
										", DIREC_21 = ?" +
										", TELEF_21 = ?" +
										", CODCARGO_21 = ?" +
										", CODRANG_P_21 = ?" +
										", CODDPTO_21 = ?" +
										", CODPROVINCIA_21 = ?" +
										", CODMUNICIPIO_21 = ?" +
										", CODPOSTAL_21 = ?" +
										"where DNI_21 = ?";
								pstmt = conn.prepareStatement(sql);
								//Agurtzane Feb12: guardar maysculas
								//pstmt.setString(1,  solicitudReserva.getUsuario().getNombre_apellidos()); // NOMBRE_21
								pstmt.setString(1,  solicitudReserva.getUsuario().getNombre_apellidos().toUpperCase()); // NOMBRE_21
								//Fin Agurtzane Feb12: guardar maysculas
								pstmt.setString(2,  solicitudReserva.getUsuario().getDomicilio()); // DIREC_21
								pstmt.setString(3,  solicitudReserva.getUsuario().getTelefono()); // TELEF_21
								pstmt.setString(4,  sCargoPersona); // CODCARGO_21
								pstmt.setString(5,  sRangoPersona); // CODRANG_P_21
								pstmt.setString(6,  sCodDpto); // CODDPTO_21
								pstmt.setString(7,  solicitudReserva.getUsuario().getProvincia().getCodigo()); // CODPROVINCIA_21
								pstmt.setString(8,  solicitudReserva.getUsuario().getMunicipio().getCodigo()); // CODMUNICIPIO_21
								pstmt.setString(9,  solicitudReserva.getUsuario().getCodPostal()); // CODPOSTAL_21
								pstmt.setString(10, sDniAGuardar); // DNI_21

								miLog.addTraza(m05bConstantes.LOG_NO_USER,m05bConstantes.LOG_NO_SRC,"ACTUALIZAMOS LA PERSONA SQL: " + sql, m05bConstantes.LOG_NIVEL_BAJO);
								pstmt.executeUpdate();

							} else {
								//LO CREAMOS
								sql = "insert into	M0521T00 " +
									  "(DNI_21, NOMBRE_21, DIREC_21,TELEF_21,CODCARGO_21,CODRANG_P_21,CODDPTO_21,ACT_GIP_21,TIPO_PER_21,CODPROVINCIA_21,CODMUNICIPIO_21,CODPOSTAL_21) " + 
									  " values (?,?,?,?,?,?,?,?,?,?,?,?)";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, sDniAGuardar);
//								Agurtzane Feb12: guardar maysculas
								//pstmt.setString(2, solicitudReserva.getUsuario().getNombre_apellidos());
								pstmt.setString(2, solicitudReserva.getUsuario().getNombre_apellidos().toUpperCase());
//								Fin Agurtzane Feb12: guardar maysculas
								pstmt.setString(3, solicitudReserva.getUsuario().getDomicilio());
								pstmt.setString(4, solicitudReserva.getUsuario().getTelefono());
								String sCargoPersona=request.getParameter("Cargo");
								pstmt.setString(5, sCargoPersona);
								String sRangoPersona=request.getParameter("Rang");
								pstmt.setString(6, sRangoPersona);
								//Hay que coger a partir del cdigo de departamento de XLNETs el departamento de la tabla m0506t00
								pstmt.setString(7, sCodDpto);
								pstmt.setString(8, "N");
								pstmt.setString(9, "N");
								pstmt.setString(10, solicitudReserva.getUsuario().getProvincia().getCodigo());
								pstmt.setString(11, solicitudReserva.getUsuario().getMunicipio().getCodigo());
								pstmt.setString(12, solicitudReserva.getUsuario().getCodPostal());

								miLog.addTraza(m05bConstantes.LOG_NO_USER,m05bConstantes.LOG_NO_SRC,"INSERTAMOS UNA NUEVA PERSONA SQL: " + sql, m05bConstantes.LOG_NIVEL_BAJO);

								miLog.addTraza(m05bConstantes.LOG_NO_USER,m05bConstantes.LOG_NO_SRC,"sDniAGuardar: " + sDniAGuardar, m05bConstantes.LOG_NIVEL_BAJO);
								miLog.addTraza(m05bConstantes.LOG_NO_USER,m05bConstantes.LOG_NO_SRC,"getNombre_apellidos: " + solicitudReserva.getUsuario().getNombre_apellidos(), m05bConstantes.LOG_NIVEL_BAJO);
								miLog.addTraza(m05bConstantes.LOG_NO_USER,m05bConstantes.LOG_NO_SRC,"getDomicilio: " + solicitudReserva.getUsuario().getDomicilio(), m05bConstantes.LOG_NIVEL_BAJO);
								miLog.addTraza(m05bConstantes.LOG_NO_USER,m05bConstantes.LOG_NO_SRC,"getTelefono: " + solicitudReserva.getUsuario().getTelefono(), m05bConstantes.LOG_NIVEL_BAJO);
								miLog.addTraza(m05bConstantes.LOG_NO_USER,m05bConstantes.LOG_NO_SRC,"sCargoPersona: " + sCargoPersona, m05bConstantes.LOG_NIVEL_BAJO);
								miLog.addTraza(m05bConstantes.LOG_NO_USER,m05bConstantes.LOG_NO_SRC,"sRangoPersona: " + sRangoPersona, m05bConstantes.LOG_NIVEL_BAJO);
								miLog.addTraza(m05bConstantes.LOG_NO_USER,m05bConstantes.LOG_NO_SRC,"getCodDepartamento: " + solicitudReserva.getUsuario().getCodDepartamento(), m05bConstantes.LOG_NIVEL_BAJO);
								miLog.addTraza(m05bConstantes.LOG_NO_USER,m05bConstantes.LOG_NO_SRC,"getProvincia().getCodigo(): " + solicitudReserva.getUsuario().getProvincia().getCodigo(), m05bConstantes.LOG_NIVEL_BAJO);
								miLog.addTraza(m05bConstantes.LOG_NO_USER,m05bConstantes.LOG_NO_SRC,"getMunicipio().getCodigo(): " + solicitudReserva.getUsuario().getMunicipio().getCodigo(), m05bConstantes.LOG_NIVEL_BAJO);
								miLog.addTraza(m05bConstantes.LOG_NO_USER,m05bConstantes.LOG_NO_SRC,"getCodPostal(): " + solicitudReserva.getUsuario().getCodPostal(), m05bConstantes.LOG_NIVEL_BAJO);

								pstmt.executeUpdate();
							}
							
							//Si todo ha ido bien
							//mandamos un mail al solicitante de la solicitud
							try {
								//Tenemos que coger el color marca y modelo del coche
							    String vehiculo [] = new String [5];
				    			vehiculo = new m05bDescrip().getPropVehiculo(sMatricula);
							    String modelo = vehiculo[0];
							    String color = vehiculo[1];
							    String marca = vehiculo[2];

							
								String mailSolicitante = this.obtenerMailXlnets(solicitudReserva.getUsuario().getCodSolicitante(), request);
								this.enviarMail(mailSolicitante,
											    sFecDes,
												sFecHas,
												sComentarios,
												sMatricula,
												color,
												marca,
												modelo,
												idiomaSes);
							} catch (Exception e) {
								miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, " ERROR AL ENVIAR MAIL ASIGNACIN " + e, m05bConstantes.LOG_NIVEL_BAJO);
							}
						}
					}
					/*20110921 Iigo Solicitud Reserva FIN*/
					else {
						//20140925 - INIGO
						//No hay solicitud de reserva.
						//Comprobamos si existe el dni con o sin letra en la tabla 21
						if (existeDni || existeDniLike) {
							//YA EXISTE
						} else {
							//LO CREAMOS
							sql = "insert into	M0521T00 " +
								  "(DNI_21, NOMBRE_21, DIREC_21,TELEF_21,CODCARGO_21,CODRANG_P_21,CODDPTO_21,ACT_GIP_21,TIPO_PER_21,CODPROVINCIA_21,CODMUNICIPIO_21,CODPOSTAL_21) " +
								  " values (?,?,?,?,?,?,?,?,?,?,?,?)";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, sDniAGuardar);
							pstmt.setString(2, request.getParameter("Nombre").toUpperCase());
							pstmt.setString(3, null);
							pstmt.setString(4, null);
							pstmt.setString(5, sCargo);
							pstmt.setString(6, request.getParameter("Rango"));
							pstmt.setString(7, sCodDpto);
							pstmt.setString(8, "N");
							pstmt.setString(9, "N");
							pstmt.setString(10, null);
							pstmt.setString(11, null);
							pstmt.setString(12, null);

							pstmt.executeUpdate();
						}
					}

    		   } else if (accion.equals(m05bConstantes.ACC_FIRMARENTREGA) //FIRMA ENTREGA
    				      || accion.equals(m05bConstantes.ACC_FIRMARDEVOLUCION)) { //FIRMA DEVOLUCIN

    			   String firma = request.getParameter("strFirma");
    			   String firmaCompleta = "";
    			   String ficheroPdfEncoded = request.getParameter("pdfFicheroEntDev");
    			   byte[] decodedPdf = this.decodeBase64(ficheroPdfEncoded);

    			   if (personaXLNET == null) {
    				   personaXLNET = this.obtenerUsuarioXlNets(personaCodigo, request);
    			   }
    			   SecurityHelpperXLNets sh = new SecurityHelpperXLNets();
    			   sh.setHttpRequest(request);
    			   String strTokenAplicacion = sh.getTokenAplicacion();

    			   /*COMPROBAMOS QUE LA FIRMA SIMPLE SEA CORRECTA EN EL SERVICIO HORIZONTAL DE FIRMA*/
    			   boolean firmaCorrecta = m05bPlatea.fncVerificarFirmaBase64(strTokenAplicacion, firma, ficheroPdfEncoded);
    			   miLog.addTraza(persona, m05bConstantes.LOG_NO_SRC, "firmaCorrecta="+firmaCorrecta, m05bConstantes.LOG_NIVEL_BAJO);
    			   /**/

    			   m05bFirmaInfoBean datosFirmante = null;
    			   if (firmaCorrecta) {
    				   /*COMPLETAMOS LA FIRMA (FIRMA COMPLETA) A TRAVS DEL SERVICIO HORIZONTAL DE FIRMA*/
    				   firmaCompleta = m05bPlatea.fncObtenerFirmaCompletaBase64(strTokenAplicacion, firma);
    				   String datosFirmaCompleta = m05bPlatea.fncObtenerDatosFirmaCompleta(strTokenAplicacion, decodedPdf, firmaCompleta);
    				   datosFirmante = this.obtenerInformacionFirmaCompleta(datosFirmaCompleta);
    				   /**/
    			   }

    			   String GuardarEnBD = request.getParameter("GuardarEnBD");

    			   if (!(firmaCorrecta && firmaCompleta != null && firmaCompleta.length() > 0)) {
    				   strMensajeRetorno = m05bConstantes.MSG_ERRORENFIRMA;
    			   } else {
    				   
    				   /*GUARDAMOS EL DOCUMENTO Y LA FIRMA COMPLETA EN DOKUSI*/
    				   miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "INSERTAMOS EL DOCUMENTO EN DOKUSI...", m05bConstantes.LOG_NIVEL_BAJO);
    				   String retDocumentoId = m05bDokusiService.getm05bDokusiService()
    				   					.almacenarDocumento(ficheroPdfEncoded,
    				   										"DocumentoDeEntregaDevolucion",
    				   										datosFirmante.getDniFirmante(),
    				   										datosFirmante.getNombreFirmante());

    				   T65BDocumentID docId = T65BHDCustomParser.parseToT65BDocumentID(retDocumentoId);

    				   String strDocId = docId.getId();
    				   String strDocVer = docId.getVersion();
    				   //miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "FIRMA COMPLETAAAAAAAAAAAAAAAA...="+firmaCompleta, m05bConstantes.LOG_NIVEL_BAJO);
    				   
    				   String retFirma = m05bDokusiService.getm05bDokusiService()
	   									.adjuntarFirma(firmaCompleta,
	   												   retDocumentoId,
	   												   strDocVer,
	   												   datosFirmante.getDniFirmante(),
	   												   datosFirmante.getNombreFirmante());

    				   miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "INSERTAMOS EL DOCUMENTO EN DOKUSI... retDocumentoId=" + retDocumentoId, m05bConstantes.LOG_NIVEL_BAJO);
    				   miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "INSERTAMOS EL DOCUMENTO EN DOKUSI... retFirma=" + retFirma, m05bConstantes.LOG_NIVEL_BAJO);
    				   if (retFirma.equals("-1")) {
    					   miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "INSERTAMOS EL DOCUMENTO EN DOKUSI... ERROR!!!", m05bConstantes.LOG_NIVEL_BAJO);
    					   strMensajeRetorno = m05bConstantes.MSG_ERRORENFIRMA;
    				   } else {
    					   miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "INSERTAMOS EL DOCUMENTO EN DOKUSI... INSERTADO", m05bConstantes.LOG_NIVEL_BAJO);

	    				   String tipoFirma = "";
	    				   String tipoFirmaPM = "";
	    				   if (accion.equals(m05bConstantes.ACC_FIRMARENTREGA)) {
	    					   tipoFirma = m05bConstantes.FIRMAENTREGA;
	    					   tipoFirmaPM = m05bConstantes.FIRMAENTREGA_PM;
	    					   miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "FIRMAR LA ENTREGA...", m05bConstantes.LOG_NIVEL_BAJO);
	    				   } else {
	    					   tipoFirma = m05bConstantes.FIRMADEVOLUCION;
	    					   tipoFirmaPM = m05bConstantes.FIRMADEVOLUCION_PM;
	    					   miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "FIRMAR LA DEVOLUCIN", m05bConstantes.LOG_NIVEL_BAJO);
	    				   }
		    			   //Al firmar la entrega introduciremos dos filas en la tabla de FIRMAS
		    			   sql = "insert into M05103T00 " +
		    			   			"(COD_ASIGNACION_103, TIPO_FIRMA_103, FECHA_FIRMA_103, " +
		    			   			"COD_FIRMANTE_103, DNI_103, NOMBRE_APELLIDOS_103, DOCUMENTO_103, FIRMA_103, OID_DOKUSI_103, VERSION_DOKUSI_103) " +
					   				"values " +
					   				"(" + asignacion.getAsi_codigo() + ", '" + tipoFirma + "', sysdate, " +
					   				"null, ?, ?, ?, ?, ?, ?)";
		
		    			   /*java.sql.Blob
		    			   oracle.sql.BLOB newBlob = null;
		    			   oracle.sql.BLOB newBlob2 = null;
		    			   if (GuardarEnBD != null && GuardarEnBD.equals("1")) {
		    				   newBlob = oracle.sql.BLOB.createTemporary(conn, false, oracle.sql.BLOB.DURATION_SESSION);
		    				   newBlob.putBytes(1, decodedPdf);

		    				   newBlob2 = oracle.sql.BLOB.createTemporary(conn, false, oracle.sql.BLOB.DURATION_SESSION);
		    				   newBlob2.putBytes(1, firmaCompleta.getBytes());
		    			   }*/

		    			   pstmt = conn.prepareStatement(sql);
		    			   pstmt.setString(1, datosFirmante.getDniFirmante());
		    			   pstmt.setString(2, datosFirmante.getNombreFirmante());
		    			   pstmt.setBinaryStream(3, new ByteArrayInputStream(decodedPdf));
		    			   pstmt.setBinaryStream(4, new ByteArrayInputStream(firmaCompleta.getBytes()));
		    			   pstmt.setString(5, strDocId);
		    			   pstmt.setString(6, strDocVer);

		    			   if (accion.equals(m05bConstantes.ACC_FIRMARENTREGA)) {
	    					   miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "INSERTAMOS LA FIRMA ENTREGA SQL: " + sql, m05bConstantes.LOG_NIVEL_BAJO);
	    				   } else {
	    					   miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "INSERTAMOS LA FIRMA DEVOLUCIN SQL: " + sql, m05bConstantes.LOG_NIVEL_BAJO);
	    				   }

		    			   pstmt.executeUpdate();

		    			   sql = "insert into M05103T00 " +
		    			   			"(COD_ASIGNACION_103, TIPO_FIRMA_103, FECHA_FIRMA_103, " +
		    			   			"COD_FIRMANTE_103, DNI_103, NOMBRE_APELLIDOS_103, DOCUMENTO_103, FIRMA_103, OID_DOKUSI_103) " +
		    			   			"values " +
		    			   			"(" + asignacion.getAsi_codigo() + ", '" + tipoFirmaPM + "', sysdate, " +
		    			   			"'" + personaCodigo + "', '" + personaXLNET.getDni() + "', '" + personaXLNET.getNombre() + " " + personaXLNET.getApellidos() + "', null, null, null)";
		    			   pstmt = conn.prepareStatement(sql);
		    			   
	    				   if (accion.equals(m05bConstantes.ACC_FIRMARENTREGA)) {
	    					   miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "INSERTAMOS LA FIRMA ENTREGA SQL: " + sql, m05bConstantes.LOG_NIVEL_BAJO);
	    				   } else {
	    					   miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "INSERTAMOS LA FIRMA DEVOLUCIN SQL: " + sql, m05bConstantes.LOG_NIVEL_BAJO);
	    				   }
	    				   
		    			   pstmt.executeUpdate();

		    			   /*20120202 CAMBIO PARA QUE ACTUALICE LA SOLICITUD SIN NECESIDAD DE REALIZAR FIRMAS*/

		    			   if (accion.equals(m05bConstantes.ACC_FIRMARENTREGA)) {
	    				   //Actualizamos la asignacin a entregada
		    				   sql = "update " + m05bConstantes.TAB_ASIGNACION
									+ " SET " + m05bConstantes.COL_01_ENTREGA + " = ? "
									+ " WHERE " + m05bConstantes.COL_01_CODASIG + " = ?";
			    			   pstmt = conn.prepareStatement(sql);
			    			   pstmt.setString(1, "S"); // ENTREGA_01
			    			   pstmt.setLong(2, Long.parseLong(sCodigo));    // COD_ASIG_01
			    			   miLog.addTraza(persona, "m05bGrabarAsignacionServlet", "SQL: " + sql, m05bConstantes.LOG_NIVEL_BAJO);
			    			   pstmt.executeUpdate();
		    			   }
		    			   //
    				   }
    			   }

    		   } else if (accion.equals(m05bConstantes.ACC_ELIMINAR)) { //Otra ACCION
    			   miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "VAMOS A ELIMINAR LA ASIGNACIN: " + sCodigo, m05bConstantes.LOG_NIVEL_BAJO);
    			   
    			   pstmt = conn.prepareStatement("update m05100t00 set COD_ASIGNACION_100 = null where COD_ASIGNACION_100 = " + sCodigo);
				   pstmt.executeUpdate();
				   miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "ASIGNACIN ELIMINADA paso 1 de 2 - SQL: " + sql, m05bConstantes.LOG_NIVEL_BAJO);
				   
    			   pstmt = conn.prepareStatement(
    					   "delete from  " + m05bConstantes.TAB_ASIGNACION +
    					   " where  " + m05bConstantes.COL_01_CODASIG + " = " + sCodigo);
				   pstmt.executeUpdate();
				   miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "ASIGNACIN ELIMINADA paso 2 de 2 - SQL: " + sql, m05bConstantes.LOG_NIVEL_BAJO);

				   conn.commit();

    			   response.sendRedirect("m05bAsignacionesJsp.jsp?Codigo=NUEVO&Mensaje=" + m05bConstantes.MSG_ELIMINAROK);

    			   return;
    		   }

/*INI*/
    		   sql = "select ID_SOLICITUD_100, "
    			     + "ESTADO_102, "
    			   	 + "NVL(" + m05bConstantes.COL_01_ENTREGA + ", 'N') as " + m05bConstantes.COL_01_ENTREGA + ", "
    			   	 + "NVL(" + m05bConstantes.COL_01_FINALIZA + ", 'N') as " + m05bConstantes.COL_01_FINALIZA + " "
    			   	 + "from ASIGNAR_SOLICITUDES, " + m05bConstantes.TAB_ASIGNACION + " "
    			   	 + "WHERE COD_ASIGNACION_100 = COD_ASIG_01 "
    			   	 + "AND COD_ASIGNACION_100 = " + asignacion.getAsi_codigo();

    		   pstmt = conn.prepareStatement(sql);
			   miLog.addTraza(persona, "m05bGrabarAsignacionServlet", "SQL: " + sql, m05bConstantes.LOG_NIVEL_BAJO);
			   ResultSet rsSol = pstmt.executeQuery();
			   if (rsSol.next()) {

				   // EXISTE SOLICITUD
				   String sIdSolicitud = rsSol.getString("ID_SOLICITUD_100");
				   String sEstado = rsSol.getString("ESTADO_102");
				   String sAsignacionEntregada = rsSol.getString(m05bConstantes.COL_01_ENTREGA);
				   String sAsignacionFinalizada = rsSol.getString(m05bConstantes.COL_01_FINALIZA);

				   if (sAsignacionEntregada.equals("S")
					   && sAsignacionFinalizada.equals("N")
					   && sEstado.equals(m05bConstantes.ACEPTADASINENTREGAR)) {

					   //Si la asignacin est entregada y no finalizada
		    		   //y el estado de la solicitud es AceptadaSinEntregar
		    		   //Actualizamos el estado de la solicitud a ASD
					   if (personaXLNET == null) {
	    				   personaXLNET = this.obtenerUsuarioXlNets(personaCodigo, request);
	    			   }

					   //ACTUALIZAMOS EL ESTADO DE LA SOLICITUD A ASD
	    			   sql = "insert into m05102s01 (ID_SOLICITUD_102,COD_VALIDADOR_102,FECHA_VALIDACION_102,"
							+ " ESTADO_102,MOTIVO_102,OBSERVACIONES_102,COD_DESTINO_102,DESTINO_OTROS_102,"
							+ " MAIL_ENVIADO_102,DNI_102,NOMBRE_APELLIDOS_102,ORIGEN_102,SITUACION_102,"
							+ " VALIDACION_POSTERIOR_102)"
							+ " values (?,?,SYSDATE + 1/86400,?,?,null,null,null,'0',?,?,?,?,'0')";
	    			   pstmt = conn.prepareStatement(sql);
	    			   pstmt.setLong(1, Long.parseLong(sIdSolicitud)); // ID_SOLICITUD_102
	    			   pstmt.setString(2, personaXLNET.getCodigo()); // COD_VALIDADOR_102
	    			   pstmt.setString(3, m05bConstantes.ACEPTADASINDEVOLVER); // ESTADO_102
	    			   pstmt.setString(4, null); // MOTIVO_102
	    			   pstmt.setString(5, personaXLNET.getDni()); // DNI_102
	    			   pstmt.setString(6, personaXLNET.getNombre() + " " + personaXLNET.getApellidos()); // NOMBRE_APELLIDOS_102
	    			   pstmt.setString(7, m05bConstantes.ORIGENPARQUEMOVIL); // ORIGEN_102
	    			   pstmt.setString(8, m05bConstantes.SITUACION_ALTA); // ORIGEN_102
	    			   miLog.addTraza(persona, "m05bGrabarAsignacionServlet", "SQL: " + sql, m05bConstantes.LOG_NIVEL_BAJO);

	    			   pstmt.executeUpdate();

				   } else if (sAsignacionEntregada.equals("S")
					   && sAsignacionFinalizada.equals("S")
					   && sEstado.equals(m05bConstantes.ACEPTADASINDEVOLVER)) {
					   //Si la asignacin est entregada y finalizada
		    		   //y el estado de la solicitud es AceptadaSinDevolver
		    		   //Actualizamos el estado de la solicitud a FIN
					   if (personaXLNET == null) {
	    				   personaXLNET = this.obtenerUsuarioXlNets(personaCodigo, request);
	    			   }

					   //ACTUALIZAMOS EL ESTADO DE LA SOLICITUD A FIN
	    			   sql = "insert into m05102s01 (ID_SOLICITUD_102,COD_VALIDADOR_102,FECHA_VALIDACION_102,"
							+ " ESTADO_102,MOTIVO_102,OBSERVACIONES_102,COD_DESTINO_102,DESTINO_OTROS_102,"
							+ " MAIL_ENVIADO_102,DNI_102,NOMBRE_APELLIDOS_102,ORIGEN_102,SITUACION_102,"
							+ " VALIDACION_POSTERIOR_102)"
							+ " values (?,?,SYSDATE + 1/86400,?,?,null,null,null,'0',?,?,?,?,'0')";
	    			   pstmt = conn.prepareStatement(sql);
	    			   pstmt.setLong(1, Long.parseLong(sIdSolicitud)); // ID_SOLICITUD_102
	    			   pstmt.setString(2, personaXLNET.getCodigo()); // COD_VALIDADOR_102
					   pstmt.setString(3, m05bConstantes.FINALIZADA); // ESTADO_102
	    			   pstmt.setString(4, null); // MOTIVO_102
	    			   pstmt.setString(5, personaXLNET.getDni()); // DNI_102
	    			   pstmt.setString(6, personaXLNET.getNombre() + " " + personaXLNET.getApellidos()); // NOMBRE_APELLIDOS_102
	    			   pstmt.setString(7, m05bConstantes.ORIGENPARQUEMOVIL); // ORIGEN_102
	    			   pstmt.setString(8, m05bConstantes.SITUACION_ALTA); // ORIGEN_102
	    			   miLog.addTraza(persona, "m05bGrabarAsignacionServlet", "SQL: " + sql, m05bConstantes.LOG_NIVEL_BAJO);

	    			   pstmt.executeUpdate();
				   }
				   
				   //Agurtzane Mar12: finalizar solicitud, asignacin finalizada
				   else if (sAsignacionEntregada.equals("N")
						   && sAsignacionFinalizada.equals("S")
						   && sEstado.equals(m05bConstantes.ACEPTADASINENTREGAR)) {
						   //Si la asignacin est finalizada, pero no se marc el check de entregada
			    		   //y el estado de la solicitud es AceptadaSinEntregar
			    		   //Actualizamos el estado de la solicitud a FIN
						   if (personaXLNET == null) {
		    				   personaXLNET = this.obtenerUsuarioXlNets(personaCodigo, request);
		    			   }
						   //Actualizamos la asignacin a entregada
	    				   sql = "update " + m05bConstantes.TAB_ASIGNACION
							+ " SET " + m05bConstantes.COL_01_ENTREGA + " = ? "
							+ " WHERE " + m05bConstantes.COL_01_CODASIG + " = ?";
		    			   pstmt = conn.prepareStatement(sql);
		    			   pstmt.setString(1, "S"); // ENTREGA_01
		    			   pstmt.setLong(2, Long.parseLong(sCodigo));    // COD_ASIG_01
		    			   miLog.addTraza(persona, "m05bGrabarAsignacionServlet", "SQL asig entregada: " + sql, m05bConstantes.LOG_NIVEL_BAJO);
		    			   pstmt.executeUpdate();
						   //ACTUALIZAMOS EL ESTADO DE LA SOLICITUD A ASD 
		    			   sql = "insert into m05102s01 (ID_SOLICITUD_102,COD_VALIDADOR_102,FECHA_VALIDACION_102,"
								+ " ESTADO_102,MOTIVO_102,OBSERVACIONES_102,COD_DESTINO_102,DESTINO_OTROS_102,"
								+ " MAIL_ENVIADO_102,DNI_102,NOMBRE_APELLIDOS_102,ORIGEN_102,SITUACION_102,"
								+ " VALIDACION_POSTERIOR_102)"
								+ " values (?,?,SYSDATE,?,?,null,null,null,'0',?,?,?,?,'0')";
		    			   pstmt = conn.prepareStatement(sql);
		    			   pstmt.setLong(1, Long.parseLong(sIdSolicitud)); // ID_SOLICITUD_102
		    			   pstmt.setString(2, personaXLNET.getCodigo()); // COD_VALIDADOR_102
						   pstmt.setString(3, m05bConstantes.ACEPTADASINDEVOLVER); // ESTADO_102
		    			   pstmt.setString(4, null); // MOTIVO_102
		    			   pstmt.setString(5, personaXLNET.getDni()); // DNI_102
		    			   pstmt.setString(6, personaXLNET.getNombre() + " " + personaXLNET.getApellidos()); // NOMBRE_APELLIDOS_102
		    			   pstmt.setString(7, m05bConstantes.ORIGENPARQUEMOVIL); // ORIGEN_102
		    			   pstmt.setString(8, m05bConstantes.SITUACION_ALTA); // ORIGEN_102
		    			   miLog.addTraza(persona, "m05bGrabarAsignacionServlet", "SQL Sol entregada: " + sql, m05bConstantes.LOG_NIVEL_BAJO);

		    			   pstmt.executeUpdate();
						   //ACTUALIZAMOS EL ESTADO DE LA SOLICITUD A FIN
		    			   sql = "insert into m05102s01 (ID_SOLICITUD_102,COD_VALIDADOR_102,FECHA_VALIDACION_102,"
								+ " ESTADO_102,MOTIVO_102,OBSERVACIONES_102,COD_DESTINO_102,DESTINO_OTROS_102,"
								+ " MAIL_ENVIADO_102,DNI_102,NOMBRE_APELLIDOS_102,ORIGEN_102,SITUACION_102,"
								+ " VALIDACION_POSTERIOR_102)"
								+ " values (?,?,SYSDATE + 1/86400,?,?,null,null,null,'0',?,?,?,?,'0')";
		    			   pstmt = conn.prepareStatement(sql);
		    			   pstmt.setLong(1, Long.parseLong(sIdSolicitud)); // ID_SOLICITUD_102
		    			   pstmt.setString(2, personaXLNET.getCodigo()); // COD_VALIDADOR_102
						   pstmt.setString(3, m05bConstantes.FINALIZADA); // ESTADO_102
		    			   pstmt.setString(4, null); // MOTIVO_102
		    			   pstmt.setString(5, personaXLNET.getDni()); // DNI_102
		    			   pstmt.setString(6, personaXLNET.getNombre() + " " + personaXLNET.getApellidos()); // NOMBRE_APELLIDOS_102
		    			   pstmt.setString(7, m05bConstantes.ORIGENPARQUEMOVIL); // ORIGEN_102
		    			   pstmt.setString(8, m05bConstantes.SITUACION_ALTA); // ORIGEN_102
		    			   miLog.addTraza(persona, "m05bGrabarAsignacionServlet", "SQL Sol Fin: " + sql, m05bConstantes.LOG_NIVEL_BAJO);

		    			   pstmt.executeUpdate();
					   }
				   //Fin Agurtzane Mar12: finalizar solicitud, asignacin finalizada
			   }
			   //
/*FIN*/

    		   //Si todo ha ido bien se actualizan los cambios en la BD
    		   conn.commit();

    		   String sURL;
    		   m05AsignacionPK primaryKey = new m05AsignacionPK();
    		   primaryKey.asi_codigo = sCodigo;

    		   InitialContext ctx2 = new InitialContext();
    		   m05AsignacionHome asignacionEBHome = (m05AsignacionHome) ctx2.lookup("m05Asignacion");

    		   m05Asignacion asignacionEB = asignacionEBHome.findByPrimaryKey(primaryKey);
    		   m05bAsignacion asigna = asignacionEB.getAsignacion();

    		   session.setAttribute("m05bAsignacion", asigna);

    		   /*ACCION_FIRMA*/
    		   if (accionFirma != null) {
	    		   if (accionFirma.equals(m05bConstantes.ACC_GUARDAREINICIARFIRMARENTREGA)
	    			   || accionFirma.equals(m05bConstantes.ACC_GUARDAREINICIARFIRMARDEVOLUCION)) {
	    			   //Obtenemos el fichero de firma
	    			   m05PersonalPK personalPrimaryKey = new m05PersonalPK();
	    			   personalPrimaryKey.per_dni = asigna.getAsi_dni();
	    			   m05PersonalHome personalEBHome = (m05PersonalHome)ctx2.lookup("m05Personal");
	    			   m05Personal personalEB = personalEBHome.findByPrimaryKey(personalPrimaryKey);
	    			   m05bPersonal personal = personalEB.getPersonal();
	    			   m05bCargo cargo = null;
	    			   if (personal.getPer_cod_car() != null) {
		    			   m05CargoPK cargoPrimaryKey = new m05CargoPK();
		    			   cargoPrimaryKey.car_codigo = personal.getPer_cod_car();
		    			   m05CargoHome cargoEBHome = (m05CargoHome)ctx2.lookup("m05Cargo");
		    			   m05Cargo cargoEB = cargoEBHome.findByPrimaryKey(cargoPrimaryKey);
		    			   cargo = cargoEB.getCargo();
	    			   }

	    			   String fechaDev = null;
	    			   String horaDev = null;
	    			   if (asigna.getAsi_fdevolucion() != null && !asigna.getAsi_fdevolucion().equals("")) {
		    			   String fechaHoraDev = comun.formatearFechaHora2(asigna.getAsi_fdevolucion());
		    			   fechaDev = fechaHoraDev.split(" ")[0];
		    			   horaDev = fechaHoraDev.split(" ")[1];
	    			   }

	   		   	 	   session.setAttribute("PDFTipoPer", personal.getPer_tipoper());
				   	   session.setAttribute("PDFNombre", personal.getPer_nombre());
				   	   if (cargo != null) {
					   	   session.setAttribute("PDFCodCargo", asigna.getAsi_codcargo());
					   	   session.setAttribute("PDFCargo", cargo.getCar_descripcion());
				   	   }
				   	   session.setAttribute("PDFDpto", asigna.getAsi_descdpto());
				   	   session.setAttribute("PDFCodDpto", asigna.getAsi_coddpto());
				   	   session.setAttribute("PDFFSolicitud", comun.formatearFecha(asigna.getAsi_fsolicitud()));
				   	   session.setAttribute("PDFMotivo", asigna.getAsi_observaciones());
				   	   session.setAttribute("PDFKmSalida", asigna.getAsi_kmsalida());
				   	   session.setAttribute("PDFKmLLegada", asigna.getAsi_kmllegada());
				   	   if (fechaDev != null) {
				   		   session.setAttribute("PDFFDevolucion", fechaDev);
				   	   }
				   	   if (horaDev != null) {
				   		   session.setAttribute("PDFHDevolucion", horaDev);
				   	   }

	    			   sURL = response.encodeRedirectURL("m05bImpEntDevServlet"
	    					   					+ "?Matricula=" + sMatricula
						       					+ "&Codigo=" + sCodigo
						       					+ "&Accion=" + accion
						       					+ "&AccionFirma=" + accionFirma
						       					+ "&ObtenerFichero=1");
	    			   RequestDispatcher rd = request.getRequestDispatcher(sURL);
	    			   rd.forward(request, response);
	
	    			   return;
	    		   }
    		   }
    		   /**/

    		   if (accion.equals(m05bConstantes.ACC_REVOCAR)) {
    			   //sURL = response.encodeRedirectURL("m05bImpRevocarServlet?Matricula=" + sMatricula);
    			   sURL = response.encodeRedirectURL("m05bAsigPDFRevocarJsp.jsp?Matricula=" + sMatricula + "&Acta=false");
    			   //response.sendRedirect("m05bImpRevocarServlet?Matricula=" + sMatricula);
    			   RequestDispatcher rd;
    			   rd = request.getRequestDispatcher(sURL);
    			   try {
    				   rd.forward(request, response);
    			   } catch (ServletException e) {
    			   }
    		   } else {
    			   if (strMensajeRetorno == null || strMensajeRetorno.equals("")) {
    				   sURL = response.encodeRedirectURL("m05bAsignacionesJsp.jsp?Codigo=" + sCodigo +  "&Mensaje=" + m05bConstantes.MSG_OK);
    			   } else {
    				   sURL = response.encodeRedirectURL("m05bAsignacionesJsp.jsp?Codigo=" + sCodigo +  "&Mensaje=" + strMensajeRetorno);
    			   }
    			   RequestDispatcher rd = request.getRequestDispatcher(sURL);
    			   rd.forward(request, response);
    		   }

    	   } catch (Exception ex) {
    		   conn.rollback();  // Ha habido problemas, se deshacen todos los cambios
    		   miLog.addTraza(persona, "Grabar Asignaciones Servlet", "CATCH EXCEPTION-1: " + ex, m05bConstantes.LOG_NIVEL_BAJO);
    	
    			
    			miLog.addTraza(ex);
    		   response.sendRedirect("m05bError.jsp");
    	   } finally {
    		   miLog.addTraza(persona, "Grabar Asignaciones Servlet", "FINALLY", m05bConstantes.LOG_NIVEL_BAJO);
    		   if (pstmt != null)
    			   pstmt.close();
    		   if (conn != null)
    			   conn.close();
    	   }

       } catch(Throwable theException) {
    	   // uncomment the following line when unexpected exceptions
    	   // are occuring to aid in debugging the problem.
    	   miLog.addTraza(persona, "Grabar Asignaciones Servlet", "CATCH EXCEPTION-2: " + theException, m05bConstantes.LOG_NIVEL_BAJO);
    	   miLog.addTraza(theException);
    	   try {
    		   response.sendRedirect("m05bError.jsp");
    	   } catch (IOException e) {
    		   miLog.addTraza(e);
    	   }
       }
	}

	private m05bPersonaXLNET obtenerUsuarioXlNets(String usuario, javax.servlet.http.HttpServletRequest request)
	{
		SecurityHelpperXLNets sh;
		ArrayList listaD = null;
		sh = new SecurityHelpperXLNets();
		try {
			sh.setHttpRequest(request);
			listaD = sh.getPersonasXLNETs(usuario, "", "", "");
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			m05bFileLog miLog = new m05bFileLog();
			miLog.addTraza(e);
		}
		if (listaD != null && listaD.size() > 0)
		{
			return (m05bPersonaXLNET)listaD.get(0);
		}
	
		return null;
	}

	
	public byte[] decodeBase64(String strPdf) {

    	BASE64Decoder decoder = new BASE64Decoder();

    	try {
    		return decoder.decodeBuffer(strPdf);
    	} catch (Exception e) {
    		return null;
    	}
    }

	public m05bFirmaInfoBean obtenerInformacionFirmaCompleta(String strXMLInfoFirma) throws Exception {
		m05bFileLog miLog = new m05bFileLog();

		miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "Entramos en fncObtenerInformacionFirmaCompleta", m05bConstantes.LOG_NIVEL_BAJO);

		m05bFirmaInfoBean datos = new m05bFirmaInfoBean();

		miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "XML info firma: " + strXMLInfoFirma, m05bConstantes.LOG_NIVEL_BAJO);

		if (strXMLInfoFirma!=null && !strXMLInfoFirma.equals("") ) {

			//Primero comprueba si es valida
			String nsvalid = this.fncParsearXml(strXMLInfoFirma, "ns:valid");
			miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "Valor de ns:valid -> " + nsvalid, m05bConstantes.LOG_NIVEL_BAJO);
			if ("true".equals(nsvalid)) {
				miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "La firma si es valida", m05bConstantes.LOG_NIVEL_BAJO);
				datos.setFirmaValida(Boolean.TRUE);
			} else {
				miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "La firma no es valida", m05bConstantes.LOG_NIVEL_BAJO);
				datos.setFirmaValida(Boolean.FALSE);
			}

			//Extraer el ns:certificateSubject
			String subject = this.fncParsearXml(strXMLInfoFirma, "ns:certificateSubject");
			if (subject!=null && !subject.equals(XML_VAL_NOEXISTE)) {
				//Dni
				String valor = this.fncParsearXmlGeneric(subject, "serialNumber");
				if (valor!=null && !valor.equals(XML_VAL_NOEXISTE)) {
					datos.setDniFirmante(valor);
				}
				//Nombre
				valor = this.fncParsearXmlGeneric(subject, "CN");
				if (valor!=null && !valor.equals(XML_VAL_NOEXISTE)) {
					datos.setNombreFirmante(valor);
				}
				//Extrae el ns:signatureDate, que es directamente la fecha de firma
				String fecha = this.fncParsearXml(strXMLInfoFirma, "ns:signatureDate");
				if (fecha!=null && !fecha.equals(XML_VAL_NOEXISTE)) {
					datos.setFechaFirma(fecha);
				}
			}
		} else {
			miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "Error. XML con info de firma esta vacio", m05bConstantes.LOG_NIVEL_BAJO);
			datos = null;
		}
		if (datos!=null){
			miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, " - firmaValida: " + datos.getFirmaValida(), m05bConstantes.LOG_NIVEL_BAJO);
			miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, " - dniFirmante: " + datos.getDniFirmante(), m05bConstantes.LOG_NIVEL_BAJO);
			miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, " - nombreFirmante: " + datos.getNombreFirmante(), m05bConstantes.LOG_NIVEL_BAJO);
			miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, " - fechaFirma: " + datos.getFechaFirma(), m05bConstantes.LOG_NIVEL_BAJO);
		}
		return datos;
	}
	
	 /**
     * Parsea un documento XML
     * @param xml String que contiene el XML
     * @param s String
     * @return String Documento XML parseado
     * @throws Exception
     */
	public String fncParsearXml(String xml, String s)throws Exception {
    	int i=xml.indexOf("<"+s+">");
    	if (i==-1)
    		return XML_VAL_NOEXISTE;
        String salida=xml.substring(i+s.length()+2,xml.indexOf("</"+s+">"));
        return salida;
    }//Fin fncParsearXml
	
	/**
     * Parsea un documento XML
     * @param xml String que contiene el XML
     * @param s String
     * @return String Documento XML parseado
     * @throws Exception
     */
	public String fncParsearXmlGeneric(String xml, String s)throws Exception {
		//p43bClsLog.info("fncParsearXmlGeneric xml->"+xml+". s->"+s);
		String salida=null;
    	int i=xml.indexOf(s+"=");
    	if (i==-1)
    		return XML_VAL_NOEXISTE;
    	i=i+s.length()+1;
    	//Buscamos el siguiente '='
    	int j=xml.indexOf("=", i);
    	//Si no existe otro = posteriormente estamos en el ultimo campo
    	//p43bClsLog.info("fncParsearXmlGeneric i->"+i+". j->"+j);
    	if ( j==-1){
    		//Buscamos la etiqueta </subject>
    		salida=xml.substring(i,xml.length());
    	} else {
    		//Buscamos el caracter ',' anterior
    		String xmlTemporal=xml.substring(i,j);
    		//p43bClsLog.info("fncParsearXmlGeneric xmlTemporal->"+xmlTemporal);
    		int posFinal=xmlTemporal.lastIndexOf(',',xmlTemporal.length());
    		//p43bClsLog.info("fncParsearXmlGeneric posFinal->"+posFinal);
    		salida=xmlTemporal.substring(0, posFinal); 
    	}
    	//p43bClsLog.info("fncParsearXmlGeneric campo->"+s+". salida->"+salida);
        return salida;        
    }//Fin fncParsearXmlGeneric


	private String obtenerMailXlnets(String usuario, HttpServletRequest request)
	{
		String mail = "";
		SecurityHelpperXLNets sh;
		ArrayList listaD = null;
		sh = new SecurityHelpperXLNets();
		try {
			sh.setHttpRequest(request);
			listaD = sh.getPersonasXLNETs(usuario, "", "", "");
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			m05bFileLog miLog = new m05bFileLog();
			miLog.addTraza(e);
		}
		if (listaD != null && listaD.size() > 0)
		{
			mail = ((m05bPersonaXLNET)listaD.get(0)).getEMail();
		}

		return mail;
	}

	private String enviarMail(String destinatario,
							  String sFecDes,
							  String sFecHas,
							  String sComentarios,
							  String sMatricula,
							  String sColor,
							  String sMarca,
							  String sModelo,
							  String idioma) throws Exception
	{
		String to = "";

		// Acceder a los Diccionarios
		Locale lCas = new Locale("ES");
		Locale lEus = new Locale("EU");
		ResourceBundle resCas = ResourceBundle.getBundle("html.datos.etiquetas", lCas);
		ResourceBundle resEus = ResourceBundle.getBundle("html.datos.etiquetas", lEus);

		m05bFileLog miLog = new m05bFileLog();

		try
		{
			m05bComun miComun = new m05bComun();
			String remitente = miComun.leerPropiedad("user.mail.remitente");

    		if (remitente == null || remitente == "")
    		{
    			String retorno = "";

    			if (idioma.equals("ES"))
    			{
    				retorno = resEus.getString("general.email.error")
    						+ "\n" + resEus.getString("general.email.noExisteEmisor");
    			}
    			else
    			{
    				retorno = resCas.getString("general.email.error")
    						+ "\n" + resCas.getString("general.email.noExisteEmisor");
    			}

    			return retorno;
    		}
    		else
    		{
    			String host = miComun.leerPropiedad("servidor.smtp");

    			miLog.addTraza("EnviarMail", "GrabarAsignacionServlet", "ENVIAR MAIL ASIGNACIN host:" + host, m05bConstantes.LOG_NIVEL_BAJO);

    			to = destinatario;

    			String from = remitente;

    			miLog.addTraza("EnviarMail", "GrabarAsignacionServlet", "ENVIAR MAIL ASIGNACIN from:" + remitente + " to:" + to, m05bConstantes.LOG_NIVEL_BAJO);

	            Properties props = System.getProperties();
	            props.put("mail.smtp.host", host);

	            // Esta lnea indica que vamos a autenticarnos en el servidor SMTP
	            //props.put("mail.smtp.auth", "true");
	            props.put("mail.smtp.auth", "false");

	            // Obtener una sesin con las propiedades anteriormente definidas
	            // Authenticator auth = new MiAutenticador();
	            // Session sesion = Session.getDefaultInstance(props, auth);
	            Session sesion = Session.getInstance(props);

	            String asunto = "";
            	asunto = resCas.getString("asignacion.email.asunto") + " / " + resEus.getString("asignacion.email.asunto");

	    	    StringBuffer contenido = new StringBuffer();
	    	    contenido.append("<p>"+resCas.getString("asignacion.email.titulo")+"</p>");
	    	    contenido.append("<p>"+resCas.getString("asignacion.email.texto")+"</p>");
	    	    contenido.append("<p>");
				contenido.append(resCas.getString("asignacion.email.textoenlace"));
				contenido.append(" ");
				contenido.append("<a href='" + miComun.leerPropiedad("solicitudes.url.gestion") + "'>");
				contenido.append(resCas.getString("asignacion.email.enlace"));
				contenido.append("</a>");
				contenido.append("</p>");
				contenido.append("<p>"+resCas.getString("asignacion.email.despedida")+"</p>");
	    	    contenido.append("_________________________________________________________________________________________");
	    	    contenido.append("<br>"+"<br>");
	    	    contenido.append("<p>"+resEus.getString("asignacion.email.titulo")+"</p>");
	    	    contenido.append("<p>"+resEus.getString("asignacion.email.texto")+"</p>");
	    	    contenido.append("<p>");
				contenido.append(resEus.getString("asignacion.email.textoenlace"));
				contenido.append(" ");
				contenido.append("<a href='" + miComun.leerPropiedad("solicitudes.url.gestion") + "'>");
				contenido.append(resEus.getString("asignacion.email.enlace"));
				contenido.append("</a>");
				contenido.append("</p>");
	    	    contenido.append("<p>"+resEus.getString("asignacion.email.despedida")+"</p>");
	    	    String strTextoSolicitud = "";
	    	    strTextoSolicitud += "<b>" + resCas.getString("etDatosAsignacion") + " / " + resEus.getString("etDatosAsignacion") + "</b>";
	    	    strTextoSolicitud += "<br>";
	    	    strTextoSolicitud += resCas.getString("etFechaDesde") + " / " + resEus.getString("etFechaDesde") + ": ";

	    	    sFecDes = sFecDes.substring(0,4)+"-"+ sFecDes.substring(4,6)+"-"+ sFecDes.substring(6,8)
	    	    			+ " " + sFecDes.substring(8,10) + ":" + sFecDes.substring(10,12) + ":00";
	    	    sFecHas = sFecHas.substring(0,4)+"-"+ sFecHas.substring(4,6)+"-"+ sFecHas.substring(6,8)
    						+ " " + sFecHas.substring(8,10) + ":" +  sFecHas.substring(10,12) + ":00";

	    	    strTextoSolicitud += miComun.formatearFechaHora2(sFecDes);
	    	    strTextoSolicitud += "<br>";
	    	    strTextoSolicitud += resCas.getString("etFechaHasta") + " / " + resEus.getString("etFechaHasta") + ": ";
	    	    strTextoSolicitud += miComun.formatearFechaHora2(sFecHas);
	    	    strTextoSolicitud += "<br>";
	    	    strTextoSolicitud += resCas.getString("etMotivoSolicitud") + " / " + resEus.getString("etMotivoSolicitud") + ": ";
	    	    strTextoSolicitud += "<br>";
	    	    strTextoSolicitud += sComentarios.replaceAll("\n", "<br>");
	    	    strTextoSolicitud += "<br>";
	    	    strTextoSolicitud += resCas.getString("etMatricula") + " / " + resEus.getString("etMatricula") + ": ";
	    	    strTextoSolicitud += sMatricula;
	    	    strTextoSolicitud += "<br>";
	    	    strTextoSolicitud += resCas.getString("etColor") + " / " + resEus.getString("etColor") + ": ";
	    	    strTextoSolicitud += sColor;
	    	    strTextoSolicitud += "<br>";
	    	    strTextoSolicitud += resCas.getString("etMarca") + " / " + resEus.getString("etMarca") + ": ";
	    	    strTextoSolicitud += sMarca;
	    	    strTextoSolicitud += "<br>";
	    	    strTextoSolicitud += resCas.getString("etModelo") + " / " + resEus.getString("etModelo") + ": ";
	    	    strTextoSolicitud += sModelo;
	    	    strTextoSolicitud += "<br>";

	    	    contenido.append("<p>"+strTextoSolicitud+"</p>");

	    	    // create a message
		        MimeMessage msg = new MimeMessage(sesion);
		        msg.setFrom(new InternetAddress(from));
		        msg.addRecipient(Message.RecipientType.TO, new InternetAddress(to));

	    	    // create and fill the first message part
	    	    MimeBodyPart mbp1 = new MimeBodyPart();
	    	    mbp1.setText(contenido.toString());
	    	    mbp1.setHeader("Content-Type", "text/html");

	    	    // create the Multipart and add its parts to it
	    	    Multipart mp = new MimeMultipart();
	    	    mp.addBodyPart(mbp1);

	    	    // add the Multipart to the message
	    	    msg.setContent(mp);
	    	    msg.setSubject(asunto);
	    	    // set the Date: header
	    	    msg.setSentDate(new Date());

	    	    // send the message
	    	    Transport.send(msg);

	    	    miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "ENVIAR MAIL ASIGNACIN = OK", m05bConstantes.LOG_NIVEL_BAJO);
	    	    
	    	    return "";
    		}
		}
		catch (Exception ex)
		{
			miLog.addTraza("EnviarMail", "GrabarAsignacionServlet", "ENVIAR MAIL ASIGNACIN to:" + to + " " + ex.getMessage(), m05bConstantes.LOG_NIVEL_BAJO);
			String retorno = "";
			if (idioma.equals("ES"))
			{
				retorno = resEus.getString("general.email.error")
						+ "\n" + resEus.getString("general.email.noExisteEmisor");
			}
			else
			{
				retorno = resCas.getString("general.email.error")
						+ "\n" + resCas.getString("general.email.noExisteEmisor");
			}

			retorno += " " + to;
			return retorno;
		}
	}
}