package amortizacionesServlet;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import m05bClasses.m05bCampos;
import m05bClasses.m05bComun;
import m05bClasses.m05bConexion;
import m05bClasses.m05bConstantes;
import m05bClasses.m05bFileLog;
import m05bClasses.m05bGenerarClave;


/**
 * Inserte aqu la descripcin del tipo.
 * Fecha de creacin: (01/09/05)
 */
public class m05bCargarAmortizacionesServlet extends javax.servlet.http.HttpServlet {m05bFileLog miLog = new m05bFileLog();
/**
 * Process incoming HTTP POST requests
 *
 * @param request Object that encapsulates the request to the servlet
 * @param response Object that encapsulates the response from the servlet
 */    
	private static final int REDONDEO  = 	BigDecimal.ROUND_HALF_UP;
	private static final int DECIMALES = 	2;
	java.sql.Connection conn=null;

public void doPost(javax.servlet.http.HttpServletRequest request, javax.servlet.http.HttpServletResponse response) throws javax.servlet.ServletException, java.io.IOException {

	performTask(request, response);

}

/**
 * Returns the servlet info string.
 */
public String getServletInfo() {

	return super.getServletInfo();

}

/**
 * Initializes the servlet.
 */
public void init() {
	// insert code to initialize the servlet here
		
}

private double obtenerImporteAmortizacionAcumulada(String matricula, String hasta) throws java.lang.Exception
{
	try
	{
		double amortizacionAcumulada = 0;
		String sqlAmortiz = "";
		PreparedStatement pstmtA = null;
		ResultSet rsA = null;
		
		sqlAmortiz = " select " + m05bConstantes.COL_39_AMORTIZA + "," + m05bConstantes.COL_39_FECHA;
		sqlAmortiz += " from " + m05bConstantes.TAB_AMORTIZACION;
		sqlAmortiz += " where ";
		sqlAmortiz += m05bConstantes.COL_39_FECHA + " IN (SELECT max(" + m05bConstantes.COL_39_FECHA;
		sqlAmortiz += ") FROM " + m05bConstantes.TAB_AMORTIZACION + " WHERE 1 = 1";
		if (hasta.length() > 0)
			sqlAmortiz += " and " + m05bConstantes.COL_39_FECHA + " <= (to_date(" + hasta + ", 'yyyymmdd')+1)";
		sqlAmortiz += " and " + m05bConstantes.COL_39_MATRICULA + "= '" + matricula + "')";
		sqlAmortiz += " and " + m05bConstantes.COL_39_MATRICULA + "= '" + matricula + "'";
		
		pstmtA = conn.prepareStatement(sqlAmortiz);
		rsA = pstmtA.executeQuery();
		if (rsA.next())
			amortizacionAcumulada = rsA.getDouble(1);
		else
			amortizacionAcumulada = 0;

		if (rsA != null)
			rsA.close();
		if (pstmtA != null)
			pstmtA.close();
		
		return amortizacionAcumulada;
	}
	catch (Exception ex1)
	{m05bFileLog miLog = new m05bFileLog();
		miLog.addTraza(ex1);
		throw new Exception(ex1);
	}
}

/**
 * Process incoming requests for information
 *
 * @param request Object that encapsulates the request to the servlet
 * @param response Object that encapsulates the response from the servlet
 */
public void performTask(javax.servlet.http.HttpServletRequest request, javax.servlet.http.HttpServletResponse response) {

	   m05bFileLog miLog = new m05bFileLog();
	   String sql="", sqlInsert="",sqlInsert2="";
       String ejercicio, matricula="", matricAnt="", precio="", fecha="", vida="";
       String ejerAlta="", fmatric="", fUltAmort="", rango="", sImpUltAmort="",sTipo="",sImpAmortAcum="";
       String fHastaMatric="";
       String sFechaMax="",sImpInicial="",sVidaUtil="";
	   PreparedStatement pstmt = null, pstmtInsert = null,pstmt_40 = null,pstmt_40bis=null;
	   ResultSet rs = null;
	   ResultSet rs_40 = null;
	   ResultSet rs_40bis = null;
	   int codigo=0;
	   double amortAcum=0.0, diasAmort=0.0, dImpAmortizacion=0.0, dImporteInicial=0.0, dquedaamortiz=0.0,dPrecioCompra=0.0;
	   BigDecimal aux1, aux2, amortDiaria, dias, amortizacion, amortizAcum,diasVidaUtil,bdImporteInicial,bdquedaamortiz,bdPrecioCompra;
	   amortizacion = new BigDecimal(0);
	   amortizAcum = new BigDecimal(0);
	   bdquedaamortiz = new BigDecimal(0);
	   amortDiaria = new BigDecimal(0);
	   diasVidaUtil= new BigDecimal(0);
	   bdImporteInicial= new BigDecimal(0);
	   bdPrecioCompra= new BigDecimal(0);
	   
	   boolean bGrabar = true;
	   boolean amortizacionPorFinVidaUtil = false;
	   double importePendienteAmortizar = 0.0;
       StringBuffer sqlV= new StringBuffer();
       StringBuffer sqlT= new StringBuffer();
       StringBuffer sqlTImp= new StringBuffer();       

       try  {
    	    // Conexin
			try {
				m05bConexion miConex = new m05bConexion();
				conn = miConex.getConnection();
				conn.setAutoCommit(false);  // Al final si todo ha ido bien se hace commit
	   		} catch (Exception SQLException) {
				try {
		  			conn.rollback();  // Ha habido problemas, se deshacen todos los cambios
		  		} catch (SQLException e2){
		  			System.err.println("Exception: OutletMaintenanceS.service: " + e2);
		  		}
		  		
		  		miLog.addTraza(SQLException);
			} 
			
		    try{
		    	m05bComun miComun = new m05bComun();
		    	m05bCampos miCampo = new m05bCampos();
		        ejercicio = request.getParameter("Ejercicio");
				//System.out.println("m05b - Cargar Amortizaciones Servlet: EJERCICIO: " + ejercicio);
		        
		        // Comprobar que no se haya ejecutado el proceso para ese ejercicio
		        
   				m05bGenerarClave miCodigo = new m05bGenerarClave();
				String aux="to_number(" + m05bConstantes.COL_39_CODIGO + ")";
   				codigo = miCodigo.getNextId(m05bConstantes.TAB_AMORTIZACION,aux);
		        
		   	    // Seleccionar los vehiculos a tratar
   				sqlV=sqlV.append(" select	").append( m05bConstantes.COL_34_MATRICULA);
   				sqlV=sqlV.append(", " + m05bConstantes.COL_34_VIDAUTIL );
   				sqlV=sqlV.append(", " ).append( m05bConstantes.COL_34_PRECIO ).append( ", TO_CHAR(" );
   				sqlV=sqlV.append( m05bConstantes.COL_34_FMATRIC ).append( ",'YYYY') " );
   				sqlV=sqlV.append(", " ).append( m05bConstantes.COL_34_RANGO );
   				sqlV=sqlV.append(", TO_CHAR(" ).append( m05bConstantes.COL_34_FMATRIC ).append( ",'YYYYMMDD') " );
   				sqlV=sqlV.append(", TO_CHAR(" ).append( m05bConstantes.COL_39_FECHA ).append( ",'YYYYMMDD') " );
   				sqlV=sqlV.append(", ").append( m05bConstantes.COL_39_IMPORTE );
   				sqlV=sqlV.append(", DECODE(" ).append( m05bConstantes.COL_39_FECHA ).append( ",NULL,'A','B')");
   				sqlV=sqlV.append(", DECODE(" ).append( m05bConstantes.COL_39_FECHA ).append( ",NULL,0,");
   				sqlV=sqlV.append( m05bConstantes.COL_39_AMORTIZA).append(")");
   				sqlV=sqlV.append(" from " ).append( m05bConstantes.TAB_VEHICULOS  ).append( ", " );
   				sqlV=sqlV.append( m05bConstantes.TAB_AMORTIZACION  );
   				sqlV=sqlV.append(" where " ).append(  m05bConstantes.COL_39_MATRICULA ).append( "(+) = " );
   				sqlV=sqlV.append( m05bConstantes.COL_34_MATRICULA );
   				sqlV=sqlV.append(" and  ((" ).append(  m05bConstantes.COL_39_FECHA ).append( " is NULL) OR ((" );
   				sqlV=sqlV.append(  m05bConstantes.COL_39_FECHA ).append( " = (SELECT MAX( " ).append(m05bConstantes.COL_39_FECHA );
   				sqlV=sqlV.append(") from " ).append( m05bConstantes.TAB_AMORTIZACION ).append(" WHERE " );
   				sqlV=sqlV.append(m05bConstantes.COL_39_MATRICULA ).append( " = ").append(m05bConstantes.COL_34_MATRICULA );
   				sqlV=sqlV.append(")) and " ).append(  m05bConstantes.COL_39_FECHA ).append( " < TO_DATE('" );
   				sqlV=sqlV.append( ejercicio ).append( "1231','YYYYMMDD'))) and " );
   				sqlV=sqlV.append(  m05bConstantes.COL_34_REGADQUIS ).append( " = '" );
   				sqlV=sqlV.append( m05bConstantes.VEH_REG_COMPRA ).append( "' " );
   				sqlV=sqlV.append(" and " ).append(  m05bConstantes.COL_34_FMATRIC ).append( " < TO_DATE('" );
   				sqlV=sqlV.append( ejercicio ).append( "1231','YYYYMMDD') " );
   				sqlV=sqlV.append(" and (" ).append(  m05bConstantes.COL_34_SITUACION ).append( " IN ('" );
   				sqlV=sqlV.append( m05bConstantes.VEH_ALTA ).append( "', '" );
   				sqlV=sqlV.append( m05bConstantes.VEH_PENDIENTE ).append( "', '" );
   				sqlV=sqlV.append( m05bConstantes.VEH_OTRO ).append( "') " );
   				sqlV=sqlV.append( ") " );
   				
   				//sqlV=sqlV.append(" and " + m05bConstantes.COL_34_MATRICULA + "in ('0377 BTT') ");
   				
   				
   				//sqlV=sqlV.append(" and " ).append( m05bConstantes.COL_34_MATRICULA );
   				//sqlV=sqlV.append( " not in (select " ).append( m05bConstantes.COL_39_MATRICULA ).append( " from " );
   				//sqlV=sqlV.append( m05bConstantes.TAB_AMORTIZACION ).append( " where " );
   				//sqlV=sqlV.append( m05bConstantes.COL_39_FECHA ).append( "=TO_DATE('");
   				//sqlV=sqlV.append( ejercicio ).append( "1231','YYYYMMDD')) " );
				sqlV=sqlV.append(" order by " ).append(  m05bConstantes.COL_34_MATRICULA ).append( ", " );
				sqlV=sqlV.append( m05bConstantes.COL_39_FECHA ).append( " DESC");
				

			    //miLog.addTraza("BEGO" , "Cargar Amortizaciones:  " , "sqlV: " + sqlV,m05bConstantes.LOG_NIVEL_BAJO);   				
   				

		        //System.out.println("m05b - Cargar Amortizaciones: SQL: " + sql );
            	pstmt = conn.prepareStatement(sqlV.toString() );
	        	rs = pstmt.executeQuery();
		   		while (rs.next()) {
		   				bGrabar = true;
			   			matricula=rs.getString(1);
			   			amortizacionPorFinVidaUtil = false;

			   			if (!(matricula.equals(matricAnt))) {
								//System.out.println("\n******   m05b - Cargar Amortizaciones Servlet: MATRICULA: " + matricula);
								vida = rs.getString(2);
				   				precio = rs.getString(3);
				   				bdPrecioCompra=new BigDecimal(precio);
				   				dPrecioCompra=Double.valueOf(precio).doubleValue();
								ejerAlta = rs.getString(4);
								rango = rs.getString(5);
								fmatric = rs.getString(6);
								fHastaMatric = "" + (Integer.parseInt(fmatric.substring(0,4)) + Integer.parseInt(vida))
				    		   	  				+ fmatric.substring(4,6)
			    		   	  					+ fmatric.substring(6,8);
								
								//El fin de vida til del vehculo finaliza en el presente ejercicio
								if (fHastaMatric.compareTo(ejercicio + "0101")>0
									&& fHastaMatric.compareTo(ejercicio + "1231")<0)
								{
									//El fin de vida til del vehculo finaliza en el presente ejercicio
									//miLog.addTraza("BEGO" , "Cargar Amortizaciones: FIN DE VIDA TIL ", " matrcula = " + matricula, m05bConstantes.LOG_NIVEL_BAJO);
					            	
									//Obtenemos el importe amortizado del vehculo
									//y tenemos que amortizar todo el importe pendiente
									double importeAmortizado = this.obtenerImporteAmortizacionAcumulada(matricula, ejercicio + "1231");
									importePendienteAmortizar = 0.0;
									importePendienteAmortizar = Double.parseDouble(precio) - importeAmortizado;
									
									amortizacionPorFinVidaUtil = true;
									bGrabar = (importePendienteAmortizar > 0);
								}
								else
								{
									fUltAmort = rs.getString(7)==null?"":rs.getString(7);
									sImpUltAmort = rs.getString(8)==null?"0":rs.getString(8);
									sImpAmortAcum = rs.getString(10)==null?"0":rs.getString(10);
									sTipo=rs.getString(9);
									sqlT=sqlT.delete(0, sqlT.length());
					   				sqlT=sqlT.append(" SELECT ").append( m05bConstantes.COL_39_MATRICULA);
					   				sqlT=sqlT.append(", TO_CHAR(MAX(" ).append( m05bConstantes.COL_40_FHASTA ).append("),'YYYYMMDD')");
					   				sqlT=sqlT.append(" from " ).append( m05bConstantes.TAB_TRANSFERENCIAS ).append( ", " );
					   				sqlT=sqlT.append( m05bConstantes.TAB_AMORTIZACION  );
					   				sqlT=sqlT.append(" where " ).append(  m05bConstantes.COL_39_MATRICULA ).append( " = " );
					   				sqlT=sqlT.append( m05bConstantes.COL_40_MATRICULA );
					   				sqlT=sqlT.append("(+) and " ).append(  m05bConstantes.COL_40_FHASTA ).append( "(+) < " );
					   				sqlT=sqlT.append( m05bConstantes.COL_39_FECHA ).append( " AND " );
					   				sqlT=sqlT.append( m05bConstantes.COL_39_FECHA ).append( " < TO_DATE('" );
					   				sqlT=sqlT.append( ejercicio ).append( "1231','YYYYMMDD') " );
					   				sqlT=sqlT.append(" and " ).append(  m05bConstantes.COL_39_MATRICULA ).append(" = '").append( matricula ).append("'");
					   				sqlT=sqlT.append( " GROUP BY  " ).append(  m05bConstantes.COL_39_MATRICULA );
	
								    //miLog.addTraza("BEGO" , "Cargar Amortizaciones:  " , "sqlT: " + sqlT,m05bConstantes.LOG_NIVEL_BAJO);
					   				
								    pstmt_40 = conn.prepareStatement(sqlT.toString() );
						        	rs_40 = pstmt_40.executeQuery();
						        	sFechaMax = null;
						        	if (rs_40.next()) {
							        	sFechaMax=rs_40.getString(2);
						        	}
									if (rs_40 != null)
										rs_40.close();
									if (pstmt_40 != null)
										pstmt_40.close();	
									diasVidaUtil=new BigDecimal(vida);
					        		diasVidaUtil=diasVidaUtil.multiply(new BigDecimal(365));
									amortAcum = Double.valueOf(sImpAmortAcum).doubleValue();
									
						        	if ((sFechaMax == null)||(sFechaMax.equals("")))
						        	{
						        		bdImporteInicial=new BigDecimal(precio);
						        		dImporteInicial=Double.valueOf(precio).doubleValue();
						        		
										// Obtener amortizacion acumulada
						        	}else{
						        		sqlTImp=sqlTImp.delete(0, sqlTImp.length());
						   				sqlTImp=sqlTImp.append(" SELECT ").append( m05bConstantes.COL_40_IMPORTE);
						   				sqlTImp=sqlTImp.append(" from " ).append( m05bConstantes.TAB_TRANSFERENCIAS );
						   				sqlTImp=sqlTImp.append(" where " ).append(  m05bConstantes.COL_40_MATRICULA ).append( " = '" );
						   				sqlTImp=sqlTImp.append( matricula );
						   				sqlTImp=sqlTImp.append("' and " ).append(  m05bConstantes.COL_40_FHASTA ).append( " = TO_DATE(" );
						   				sqlTImp=sqlTImp.append(sFechaMax).append(",'YYYYMMDD')");	
					   					//miLog.addTraza("BEGO" , "Cargar Amortizaciones:  " , "sqlTImp: " + sqlTImp,m05bConstantes.LOG_NIVEL_BAJO);					   				
						            	pstmt_40bis = conn.prepareStatement(sqlTImp.toString() );
							        	rs_40bis = pstmt_40bis.executeQuery();
							        	if (rs_40bis.next()) {
							        		bdImporteInicial=new BigDecimal(rs_40bis.getString(1));
							        		dImporteInicial=Double.valueOf(rs_40bis.getString(1)).doubleValue();
							        		diasVidaUtil=diasVidaUtil.subtract(new BigDecimal(miComun.getDiasEntreFechas( fmatric,sFechaMax)));
											if (rs_40bis != null)
												rs_40bis.close();
											if (pstmt_40bis != null)
												pstmt_40bis.close();						        		
							        	}
						        	}
						        	  amortDiaria=bdImporteInicial.divide(diasVidaUtil, DECIMALES, REDONDEO);
						        	if (sTipo.equals("A")){
						        		diasAmort = miComun.getDiasEntreFechas(fmatric, ejercicio + "1231");
						        	} else {
										// Se ha amortizado una parte
								    	diasAmort = miComun.getDiasEntreFechas(fUltAmort, ejercicio + "1231");
									}
						        	
									//System.out.println("m05b - Cargar Amortizaciones: AMORT DIARIA: " +  amortDiaria);
	
									// Si el alta se ha producido dentro del ejercicio a amortizar
	
						        	amortizacion=new BigDecimal(diasAmort).multiply(amortDiaria);
						        	dImpAmortizacion=amortizacion.doubleValue();
						        	amortizAcum=new BigDecimal(amortAcum);
						        	//bdquedaamortiz=bdImporteInicial.subtract(amortizAcum);
						        	dquedaamortiz=dPrecioCompra-amortAcum;
						        	bdquedaamortiz=new BigDecimal(dquedaamortiz);
	
		                            if ((dImpAmortizacion <= dquedaamortiz) && (dImpAmortizacion > 0.0) && (dquedaamortiz > 0.0)) {
		                            	bGrabar=true;
		                            }else if ((dImpAmortizacion > 0.0) && (dquedaamortiz > 0.0)){
		                            	 bGrabar=true;
		                            	 amortizacion=new BigDecimal(dquedaamortiz);
		                            }else{
		                            	bGrabar=false;
										//sqlInsert2="insert into	 "  + m05bConstantes.TAB_AMORTIZACION +
										//" (" + m05bConstantes.COL_39_CODIGO + "," + m05bConstantes.COL_39_MATRICULA +
										//"," + m05bConstantes.COL_39_IMPORTE + "," + m05bConstantes.COL_39_FECHA + 
										//"," + m05bConstantes.COL_39_RANGO + "," + m05bConstantes.COL_39_AMORTIZA + ") " +
										//" values " +
										//"( " + codigo + ", '" + matricula + "', " + amortizacion + 
										//", TO_DATE('" + ejercicio + "1231','YYYYMMDD'), '" + rango + "', " + amortizAcum + " )";
									    //miLog.addTraza("BEGO" , "Cargar Amortizaciones:  " , "sqlInsert2: " + sqlInsert2,m05bConstantes.LOG_NIVEL_BAJO);
		                            }
								}
								
								
								if (bGrabar) {
									if (amortizacionPorFinVidaUtil)
									{
						   				//Inserta en la table de amortizaciones
										sqlInsert="insert into "  + m05bConstantes.TAB_AMORTIZACION +
													" (" + m05bConstantes.COL_39_CODIGO + "," + m05bConstantes.COL_39_MATRICULA +
													"," + m05bConstantes.COL_39_IMPORTE + "," + m05bConstantes.COL_39_FECHA + 
													"," + m05bConstantes.COL_39_RANGO + "," + m05bConstantes.COL_39_AMORTIZA + ") " +
													" values " +
													"( " + codigo + ", '" + matricula + "', " + importePendienteAmortizar + 
													", TO_DATE('" + fHastaMatric + "','YYYYMMDD'), '" + rango + "', " + precio + " )";
									     
										//miLog.addTraza("BEGO" , "Cargar Amortizaciones:  " , "INIRO POR FECHA HASTA MATRIC FIN VIDA TIL sqlInsert: " + sqlInsert,m05bConstantes.LOG_NIVEL_BAJO);
									}
									else
									{
										amortizAcum = new BigDecimal(amortAcum);
										amortizAcum = amortizAcum.add(amortizacion);
						   				//Inserta en la table de amortizaciones
										sqlInsert="insert into "  + m05bConstantes.TAB_AMORTIZACION +
													" (" + m05bConstantes.COL_39_CODIGO + "," + m05bConstantes.COL_39_MATRICULA +
													"," + m05bConstantes.COL_39_IMPORTE + "," + m05bConstantes.COL_39_FECHA + 
													"," + m05bConstantes.COL_39_RANGO + "," + m05bConstantes.COL_39_AMORTIZA + ") " +
													" values " +
													"( " + codigo + ", '" + matricula + "', " + amortizacion + 
													", TO_DATE('" + ejercicio + "1231','YYYYMMDD'), '" + rango + "', " + amortizAcum + " )";
										 //miLog.addTraza("BEGO" , "Cargar Amortizaciones:  " , "sqlInsert: " + sqlInsert,m05bConstantes.LOG_NIVEL_BAJO);
									}
									
									pstmtInsert = conn.prepareStatement(sqlInsert);
					   				pstmtInsert.execute();
					   				++codigo;
									if (pstmtInsert != null)
										pstmtInsert.close();
									
					   			} // Fin if bGrabar
			   			}  // Fin if matricula != matricAnt
			   			matricAnt=matricula;
		   	   	}  // Fin while
				//Si todo ha ido bien se actualizan los cambios en la BD
				    conn.commit();
					response.sendRedirect("m05bAmortizacionesJsp.jsp?Mensaje=" + m05bConstantes.MSG_OK );
			} catch (SQLException ex1) {
				try {
		  			conn.rollback();  // Ha habido problemas, se deshacen todos los cambios
		  		} catch (SQLException ex2){
		  			System.err.println("m05b - Servlet Carga Amortizaciones EXCEPTION-1: OutletMaintenanceS.service: " + ex2);
		  			response.sendRedirect("m05bError.jsp");
		  		}
				if (ex1.getErrorCode() == m05bConstantes.ERR_INTEGRIDAD)  {
//					  	System.err.println("m05b - Servlet Carga Amortizaciones EXCEPTION-2: OutletMaintenanceS.service: " + ex1);
						response.sendRedirect("m05bAmortizacionesJsp.jsp?Mensaje=" + m05bConstantes.MSG_INTEGRIDAD);
			  	}else{
			  			response.sendRedirect("m05bError.jsp");
			  	}
				miLog.addTraza(ex1);
			} 	finally{
					  	System.err.println("m05b - Servlet Carga Amortizaciones ENTRA AL FINALLY");
						if (rs_40bis != null)
							rs_40bis.close();
						if (pstmt_40bis != null)
							pstmt_40bis.close();	
						if (rs_40 != null)
							rs_40.close();
						if (pstmt_40 != null)
							pstmt_40.close();							
					    if (rs != null)
						    rs.close();
					    if (pstmtInsert != null)
						    pstmtInsert.close();
					    if (pstmt != null)
						    pstmt.close();
					    if (conn != null)
						    conn.close();
					  	System.err.println("m05b - Servlet Carga Amortizaciones SALE DEL FINALLY");
			}  
	} catch(Throwable theException)	{
		// uncomment the following line when unexpected exceptions
		// are occuring to aid in debugging the problem.
		miLog.addTraza(theException);
		try {
			response.sendRedirect("m05bError.jsp");
		} catch (IOException e) {
			// TODO Auto-generated catch block
			miLog.addTraza(e);
		}
	}  // Fin try 
}  // Fin funcion performTask
} // Fin clase m05bCargarAmortizacionesServlet