package m05bOrganismoEJB;

import javax.ejb.CreateException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;

import m05bBD.m05bOrganismo;


/**
 * This class is the Bean Implementation for the Entity EJB <tt>M05OrganismoEB</tt>.
 *
 * @see     m05.exe.Organismo
 * @see     m05.exe.M05OrganismoEB
 * @see     m05.exe.M05OrganismoEBPK
 * @see     m05.exe.M05OrganismoEBHome
 * @author <a href="mailto:paco.gomez@terra.com">Paco Gomez</a>.
 *         Professional J2EE Programming with BEA WebLogic Server, 
 *         by Gomez & Zadrozny, Copyright &#169; 2000. 
 */
abstract public class m05OrganismoBean implements EntityBean {
  
  private EntityContext ctx;



  /** 
   * This is the primary key.
   * It is the clave, which is the primary key 
   * in table <tt>m0502t00</tt>.
   */
  
  /**
   * Returns the Organismo information of this E-EJB.
   */    
  public m05bOrganismo getOrganismo(){
    m05bOrganismo organismo = new m05bOrganismo();
    
    organismo.setOrg_codigo(getOrg_codigo());
    organismo.setOrg_descripcion(getOrg_descripcion());
    organismo.setOrg_edescripcion(getOrg_edescripcion());
    
    return organismo;	
  }    

  /**
   * Sets the Organismo information of this E-EJB.
   * @exception P2GException 
   *              If the given Organismo <tt>avi_codigo</tt> field 
   *              does not match the primary key that is in the E-EJB.
   */   
  public void setOrganismo(m05bOrganismo organismo)
    throws Exception{
   
    //the primary key is never modified!!
    if (getOrg_codigo() != organismo.getOrg_codigo())
      throw new CreateException ("Cannot modify a different organismo");
      
    setOrg_descripcion(organismo.getOrg_descripcion());
    setOrg_edescripcion(organismo.getOrg_edescripcion());
   
  }   	
  
  abstract public String getOrg_codigo();
  abstract public void setOrg_codigo(String n);
  
  abstract public String getOrg_descripcion();
  abstract public void setOrg_descripcion(String n);

  abstract public String getOrg_edescripcion();
  abstract public void setOrg_edescripcion(String n);


  public void ejbActivate() {
  }

  public void ejbPassivate() {
  }

  public void setEntityContext(EntityContext ctx) {
    this.ctx = ctx;
  }

  public void unsetEntityContext() {
    this.ctx = null;
  }

  public void ejbLoad() {
  }
  
  public void ejbStore() {
  }

  public void ejbRemove()
    throws RemoveException
  {
  }

  /**
   * This function initializes the Organismo 
   * information of this E-EJB.
   * It assigns a new primary key to the Organismo.
   */ 
  public m05OrganismoPK ejbCreate(m05bOrganismo organismo) 
    throws CreateException
  {
    try {
      setOrg_codigo(getOrg_codigo());
    } catch (Exception e) {
      throw new CreateException (e.getMessage());
    }    
    setOrg_descripcion(organismo.getOrg_descripcion());
    setOrg_edescripcion(organismo.getOrg_descripcion());
    return null;      	
  }

  public void ejbPostCreate(m05bOrganismo organismo) 
  {
  }

 
}
