package m05bModeloEJB;

import javax.ejb.CreateException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;

import m05bBD.m05bModelo;

/**
 * This class is the Bean Implementation for the Entity EJB <tt>M05ModeloEB</tt>.
 *
 * @see     m05.exe.Modelo
 * @see     m05.exe.M05ModeloEB
 * @see     m05.exe.M05ModeloEBPK
 * @see     m05.exe.M05ModeloEBHome
 * @author <a href="mailto:paco.gomez@terra.com">Paco Gomez</a>.
 *         Professional J2EE Programming with BEA WebLogic Server, 
 *         by Gomez & Zadrozny, Copyright &#169; 2000. 
 */
abstract public class m05ModeloBean implements EntityBean {
  
  private EntityContext ctx;

 

  /** 
   * This is the primary key.
   * It is the clave, which is the primary key 
   * in table <tt>m0517t00</tt>.
   */
 /* public String mod_codigo          = "";
  
  public String mod_marca        	= "";
  public String mod_descripcion     = "";*/
  
  /**
   * Returns the Modelo information of this E-EJB.
   */    
  public m05bModelo getModelo(){
    m05bModelo modelo = new m05bModelo();
    
    modelo.setMod_codigo(getMod_codigo());
    modelo.setMod_marca(getMod_marca());
    modelo.setMod_descripcion(getMod_descripcion());

    
    return modelo;	
  }    

  /**
   * Sets the Modelo information of this E-EJB.
   * @exception P2GException 
   *              If the given Modelo <tt>mod_codigo</tt> field 
   *              does not match the primary key that is in the E-EJB.
   */   
  public void setModelo(m05bModelo modelo)
    throws Exception{
   
    //the primary key is never modified!!
    if (getMod_codigo() != modelo.getMod_codigo())
      throw new CreateException ("Cannot modify a different modelo");
      
    setMod_marca(modelo.getMod_marca());
    setMod_descripcion(modelo.getMod_descripcion());
    
  }   	

  abstract public String getMod_codigo();
  abstract public void setMod_codigo(String n);
  
  abstract public String getMod_marca();
  abstract public void setMod_marca(String n);

  abstract public String getMod_descripcion();
  abstract public void setMod_descripcion(String n);

  public void ejbActivate() {
  }

  public void ejbPassivate() {
  }

  public void setEntityContext(EntityContext ctx) {
    this.ctx = ctx;
  }

  public void unsetEntityContext() {
    this.ctx = null;
  }

  public void ejbLoad() {
  }
  
  public void ejbStore() {
  }

  public void ejbRemove()
    throws RemoveException
  {
  }

  /**
   * This function initializes the Modelo 
   * information of this E-EJB.
   * It assigns a new primary key to the Modelo.
   * @see #getNewOrderNum()
   */ 
  public m05ModeloPK ejbCreate(m05bModelo modelo) 
    throws CreateException
  {
    try {
      setMod_codigo(getMod_codigo());
    } catch (Exception e) {
      throw new CreateException (e.getMessage());
    }    
    setMod_marca(modelo.getMod_marca());
    setMod_descripcion(modelo.getMod_descripcion());
    return null;      	
  }

  public void ejbPostCreate(m05bModelo modelo) 
  {
  }

 
}
