package m05bGruposEJB;

import javax.ejb.CreateException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;

import m05bBD.m05bGrupos;


/**
 * This class is the Bean Implementation for the Entity EJB <tt>M05GruposEB</tt>.
 *
 * @see     m05.exe.Grupos
 * @see     m05.exe.M05GruposEB
 * @see     m05.exe.M05GruposEBPK
 * @see     m05.exe.M05GruposEBHome
 */
abstract public class m05GruposBean implements EntityBean {

  private EntityContext ctx;


  /**
   * This is the primary key.
   * It is the clave, which is the primary key
   * in table <tt>m0536t00</tt>.
   */

  /**
   * Returns the Grupos information of this E-EJB.
   */
  public m05bGrupos getGrupos(){
    m05bGrupos grupos = new m05bGrupos();

    grupos.setGru_codigo(getGru_codigo());
    grupos.setGru_nombre(getGru_nombre());
    grupos.setGru_rango(getGru_rango());

    grupos.setGru_nombreEu(getGru_nombreEu());

    return grupos;
  }

  /**
   * Sets the Grupo information of this E-EJB.
   * @exception P2GException
   *              If the given Grupo <tt>gru_codigo</tt> field
   *              does not match the primary key that is in the E-EJB.
   */
  public void setGrupos(m05bGrupos grupos)
    throws Exception{

    //the primary key is never modified!!
    if (getGru_codigo() != grupos.getGru_codigo())
      throw new CreateException ("Cannot modify a different grupo");

    setGru_nombre(grupos.getGru_nombre());
    setGru_nombreEu(grupos.getGru_nombreEu());
  }

  abstract public String getGru_codigo();
  abstract public void setGru_codigo(String n);

  abstract public String getGru_nombre();
  abstract public void setGru_nombre(String n);
  abstract public String getGru_nombreEu();
  abstract public void setGru_nombreEu(String n);
  abstract public String getGru_rango();
  abstract public void setGru_rango(String n);

  public void ejbActivate() {
  }

  public void ejbPassivate() {
  }

  public void setEntityContext(EntityContext ctx) {
    this.ctx = ctx;
  }

  public void unsetEntityContext() {
    this.ctx = null;
  }

  public void ejbLoad() {
  }

  public void ejbStore() {
  }

  public void ejbRemove()
    throws RemoveException
  {
  }

  /**
   * This function initializes the Empleado
   * information of this E-EJB.
   * It assigns a new primary key to the Grupos.
   */
  public m05GruposPK ejbCreate(m05bGrupos grupos)
    throws CreateException
  {
    try {
      setGru_codigo(getGru_codigo());
    } catch (Exception e) {
      throw new CreateException (e.getMessage());
    }
    setGru_nombre(grupos.getGru_nombre());
    setGru_rango(grupos.getGru_rango());    
    return null;
  }

  public void ejbPostCreate(m05bGrupos grupos)
  {
  }
}
