package m05bFestivoEJB;

import javax.ejb.CreateException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;

import m05bBD.m05bFestivo;


/**
 * This class is the Bean Implementation for the Entity EJB <tt>M05FestivoEB</tt>.
 *
 * @see     m05.exe.Festivo
 * @see     m05.exe.M05FestivoEB
 * @see     m05.exe.M05FestivoEBPK
 * @see     m05.exe.M05FestivoEBHome
 * @author <a href="mailto:paco.gomez@terra.com">Paco Gomez</a>.
 *         Professional J2EE Programming with BEA WebLogic Server, 
 *         by Gomez & Zadrozny, Copyright &#169; 2000. 
 */
abstract public class m05FestivoBean implements EntityBean {
  
  private EntityContext ctx;

 

  /** 
   * This is the primary key.
   * It is the clave, which is the primary key 
   * in table <tt>m0508t00</tt>.
   */
  /*public String fes_codigo   = "0";
  public String fes_fecha     = "";*/
  
  /**
   * Returns the Festivo information of this E-EJB.
   */    
  public m05bFestivo getFestivo(){
    m05bFestivo festivo = new m05bFestivo();
    
    festivo.setFes_codigo(getFes_codigo());
    festivo.setFes_fecha(getFes_fecha());
    festivo.setFes_descrip(getFes_descrip());
    festivo.setFes_edescrip(getFes_edescrip());
    
    return festivo;	
  }    

  /**
   * Sets the Festivo information of this E-EJB.
   * @exception P2GException 
   *              If the given Festivo <tt>fes_codigo</tt> field 
   *              does not match the primary key that is in the E-EJB.
   */   
  public void setFestivo(m05bFestivo festivo)
    throws Exception{
   
    //the primary key is never modified!!
    if (getFes_codigo() != festivo.getFes_codigo())
      throw new CreateException ("Cannot modify a different festivo");
      
    setFes_fecha(festivo.getFes_fecha());
    
  }   	
  
  abstract public String getFes_codigo();
  abstract public void setFes_codigo(String n);

  abstract public String getFes_fecha();
  abstract public void setFes_fecha(String n);

  abstract public String getFes_descrip();
  abstract public void setFes_descrip (String n);
  abstract public String getFes_edescrip();
  abstract public void setFes_edescrip (String n);
  public void ejbActivate() {
  }

  public void ejbPassivate() {
  }

  public void setEntityContext(EntityContext ctx) {
    this.ctx = ctx;
  }

  public void unsetEntityContext() {
    this.ctx = null;
  }

  public void ejbLoad() {
  }
  
  public void ejbStore() {
  }

  public void ejbRemove()
    throws RemoveException
  {
  }

  /**
   * This function initializes the Festivo 
   * information of this E-EJB.
   * It assigns a new primary key to the Festivo.
   */ 
  public m05FestivoPK ejbCreate(m05bFestivo festivo) 
    throws CreateException
  {
    try {
      setFes_codigo(getFes_codigo());
    } catch (Exception e) {
      throw new CreateException (e.getMessage());
    }    
    setFes_fecha(festivo.getFes_fecha());
    setFes_descrip(festivo.getFes_descrip ());
    setFes_edescrip(festivo.getFes_edescrip ());
    return null;      	
  }

  public void ejbPostCreate(m05bFestivo festivo) 
  {
  }

 
}