package m05bEmpleadoEJB;

import javax.ejb.CreateException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;

import m05bBD.m05bEmpleado;


/**
 * This class is the Bean Implementation for the Entity EJB <tt>M05EmpleadoEB</tt>.
 *
 * @see     m05.exe.Empleado
 * @see     m05.exe.M05EmpleadoEB
 * @see     m05.exe.M05EmpleadoEBPK
 * @see     m05.exe.M05EmpleadoEBHome
 * @author <a href="mailto:paco.gomez@terra.com">Paco Gomez</a>.
 *         Professional J2EE Programming with BEA WebLogic Server, 
 *         by Gomez & Zadrozny, Copyright &#169; 2000. 
 */
abstract public class m05EmpleadoBean implements EntityBean {
  
  private EntityContext ctx;

  

  /** 
   * This is the primary key.
   * It is the clave, which is the primary key 
   * in table <tt>m0502t00</tt>.
   */
  
  /**
   * Returns the Empleado information of this E-EJB.
   */    
  public m05bEmpleado getEmpleado(){
    m05bEmpleado empleado = new m05bEmpleado();
    
    empleado.setEmp_codigo(getEmp_codigo());
    empleado.setEmp_nombre(getEmp_nombre());
    empleado.setEmp_precio(getEmp_precio());
    empleado.setEmp_alta(getEmp_alta());


    
    return empleado;	
  }    

  /**
   * Sets the Empleado information of this E-EJB.
   * @exception P2GException 
   *              If the given Empleado <tt>emp_codigo</tt> field 
   *              does not match the primary key that is in the E-EJB.
   */   
  public void setEmpleado(m05bEmpleado empleado)
    throws Exception{
   
    //the primary key is never modified!!
    if (getEmp_codigo() != empleado.getEmp_codigo())
      throw new CreateException ("Cannot modify a different empleado");
      
    setEmp_nombre(empleado.getEmp_nombre());
    
  }   	
  
  abstract public String getEmp_codigo();
  abstract public void setEmp_codigo(String n);
  
  abstract public String getEmp_nombre();
  abstract public void setEmp_nombre(String n);
  
  abstract public double getEmp_precio();
  abstract public void setEmp_precio(double n);

  abstract public String getEmp_alta();
  abstract public void setEmp_alta(String n);
  
  public void ejbActivate() {
  }

  public void ejbPassivate() {
  }

  public void setEntityContext(EntityContext ctx) {
    this.ctx = ctx;
  }

  public void unsetEntityContext() {
    this.ctx = null;
  }

  public void ejbLoad() {
  }
  
  public void ejbStore() {
  }

  public void ejbRemove()
    throws RemoveException
  {
  }

  /**
   * This function initializes the Empleado 
   * information of this E-EJB.
   * It assigns a new primary key to the Empleado.
   */ 
  public m05EmpleadoPK ejbCreate(m05bEmpleado empleado) 
    throws CreateException
  {
    try {
      setEmp_codigo(getEmp_codigo());
    } catch (Exception e) {
      throw new CreateException (e.getMessage());
    }    
    setEmp_nombre(empleado.getEmp_nombre());
    return null;      	
  }

  public void ejbPostCreate(m05bEmpleado empleado) 
  {
  }

 
}
