package n05bModelosVistas;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import m05bClasses.m05bConstantesInformes;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class m05bVehiculoV extends m05bPaginacion implements m05bImprimible{
	public static final int [] ORDENEXCELALTAS={0,1,2,3,7,8,5,10};
	public static final int [] ORDENEXCELBAJAS={0,1,2,3,7,9,5,6};
	public static final int [] ORDENCOCHES={0,1,2,3,7,8,11,5,4};
	public static final int [] ORDENLISTADO={0,1,2,3,7,8,5,4,11};
	private String departamento, matricula, marca, modelo, situacion,
			rangoVehiculo, motivoBaja;
	private Date fechaMatricula, fechaAlta, fechaBaja;
	private double precio;
	private int kmActuales;

	public int getKmActuales() {
		return kmActuales;
	}

	public void setKmActuales(int kmActuales) {
		this.kmActuales = kmActuales;
	}

	public String getDepartamento() {
		return departamento;
	}

	public Date getFechaAlta() {
		return fechaAlta;
	}

	public Date getFechaBaja() {
		return fechaBaja;
	}

	public Date getFechaMatricula() {
		return fechaMatricula;
	}

	public String getMarca() {
		return marca;
	}

	public String getMatricula() {
		return matricula;
	}

	public String getModelo() {
		return modelo;
	}

	public String getMotivoBaja() {
		return motivoBaja;
	}

	public double getPrecio() {
		return precio;
	}

	public String getRangoVehiculo() {
		return rangoVehiculo;
	}

	public String getSituacion() {
		return situacion;
	}

	public void setDepartamento(String departamento) {
		this.departamento = departamento;
	}

	public void setFechaAlta(Date fechaAlta) {
		this.fechaAlta = fechaAlta;
	}

	public void setFechaBaja(Date fechaBaja) {
		this.fechaBaja = fechaBaja;
	}

	public void setFechaMatricula(Date fechaMatricula) {
		this.fechaMatricula = fechaMatricula;
	}

	public void setMarca(String marca) {
		this.marca = marca;
	}

	public void setMatricula(String matricula) {
		this.matricula = matricula;
	}

	public void setModelo(String modelo) {
		this.modelo = modelo;
	}

	public void setMotivoBaja(String motivoBaja) {
		this.motivoBaja = motivoBaja;
	}

	public void setPrecio(double precio) {
		this.precio = precio;
	}

	public void setRangoVehiculo(String rangoVehiculo) {
		this.rangoVehiculo = rangoVehiculo;
	}

	public void setSituacion(String situacion) {
		this.situacion = situacion;
	}
	/**
	 * Devuelve un Element xml en el documento DOC que representa al vehculo actual
	 * @param doc
	 * @return
	 * @throws ParserConfigurationException
	 */
	public Element toXMl(Document doc,String idioma) throws ParserConfigurationException {
	
		String localeStr="dd/MM/yyyy";
		if(!idioma.equals(m05bConstantesInformes.CASTELLANO))
				 localeStr="yyyy/MM/dd";
		DateFormat df = new SimpleDateFormat(localeStr);
		Element rootElement = doc.createElement("vehiculo");
		Element departamento = doc.createElement("departamento");
		if (this.departamento != null) 
			departamento.appendChild(doc.createTextNode(this.departamento));
		else
			departamento.appendChild(doc.createTextNode(" "));
		rootElement.appendChild(departamento);
		Element matricula = doc.createElement("matricula");
		matricula.appendChild(doc.createTextNode(this.matricula));
		if (this.matricula != null) 
			rootElement.appendChild(matricula);
		else
			matricula.appendChild(doc.createTextNode(" "));
		Element marca = doc.createElement("marca");
		if (this.marca != null) 
			marca.appendChild(doc.createTextNode(this.marca));
		else
			marca.appendChild(doc.createTextNode(" "));
		rootElement.appendChild(marca);
		Element modelo = doc.createElement("modelo");
		if (this.modelo != null) 
			modelo.appendChild(doc.createTextNode(this.modelo));
		else
			modelo.appendChild(doc.createTextNode(" "));
		rootElement.appendChild(modelo);

		if (this.fechaMatricula != null) {
			Element fechaMatricula = doc.createElement("fechaMatricula");

			fechaMatricula.appendChild(doc.createTextNode(df
					.format(this.fechaMatricula)));
			rootElement.appendChild(fechaMatricula);
		}

		if (this.fechaAlta != null) {
			Element fechaAlta = doc.createElement("fechaAlta");
			fechaAlta
					.appendChild(doc.createTextNode(df.format(this.fechaAlta)));
			rootElement.appendChild(fechaAlta);
		}
		if (this.fechaBaja != null) {
			Element fechaBaja = doc.createElement("fechaBaja");
			fechaBaja
					.appendChild(doc.createTextNode(df.format(this.fechaBaja)));
			rootElement.appendChild(fechaBaja);
		}
		
		Element situacion = doc.createElement("situacion");
		if (this.situacion != null) {
			situacion.appendChild(doc.createTextNode(this.situacion));
		}
		else{
			situacion.appendChild(doc.createTextNode(" "));
		}
		rootElement.appendChild(situacion);
		
		
		Element rangoVehiculo = doc.createElement("rangoVehiculo");
		if (this.rangoVehiculo != null) {
			rangoVehiculo.appendChild(doc.createTextNode(this.rangoVehiculo+""));
		}
		else{
			rangoVehiculo.appendChild(doc.createTextNode(" "));
		}
		rootElement.appendChild(rangoVehiculo);

		Element precio = doc.createElement("precio");
		
			precio.appendChild(doc.createTextNode(this.precio+""));
		
		rootElement.appendChild(precio);

		Element motivoBaja = doc.createElement("motivoBaja");
		if (this.motivoBaja != null) {
			motivoBaja.appendChild(doc.createTextNode(this.motivoBaja));
		}
		else{
			motivoBaja.appendChild(doc.createTextNode(" "));
		}
		rootElement.appendChild(motivoBaja);
		
		Element km = doc.createElement("kmActuales");		
		km.appendChild(doc.createTextNode(this.kmActuales+""));	
		rootElement.appendChild(km);
		
		
		return rootElement;
	}

	@Override
	public Object get(int i) {
//		/*
//		 * private String departamento, matricula, marca, modelo, situacion,
//			rangoVehiculo, motivoBaja;
//	private Date fechaMatricula, fechaAlta, fechaBaja;
//	private double precio;
//		 * 
//		 * /
		switch(i){
		case 0:
			return departamento;
		case 1:
			return matricula;
		case 2:
			return marca;
		case 3:
			return modelo;
		case 4:
			return situacion;
		case 5:
			return rangoVehiculo;
		case 6:
			return motivoBaja;
		case 7:
			return fechaMatricula;
		case 8:
			return fechaAlta;
		case 9:
			return fechaBaja;
		case 10:
			return precio;
		case 11:
			return kmActuales;
		}
		return null;
	}
}
