package n05bModelosVistas;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.xml.parsers.ParserConfigurationException;

import m05bClasses.m05bConstantesInformes;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class m05bSancion  extends m05bPaginacion implements m05bImprimible {
	public static final int []ORDENBASE={0,1,2,3,4,5,6,7,8};
	private String rango;
	private String matricula;
	private String marca;
	private String modelo;
	private String sancion;
	private int anioDenuncia;
	private Date fechaSancion;
	private String expediente;
	private String dni;
	public String getRango() {
		return rango;
	}

	public void setRango(String rango) {
		this.rango = rango;
	}

	public String getMatricula() {
		return matricula;
	}

	public void setMatricula(String matricula) {
		this.matricula = matricula;
	}

	public String getMarca() {
		return marca;
	}

	public void setMarca(String marca) {
		this.marca = marca;
	}

	public String getModelo() {
		return modelo;
	}

	public void setModelo(String modelo) {
		this.modelo = modelo;
	}

	public String getSancion() {
		return sancion;
	}

	public void setSancion(String sancion) {
		this.sancion = sancion;
	}

	public int getAnioDenuncia() {
		return anioDenuncia;
	}

	public void setAnioDenuncia(int anioDenuncia) {
		this.anioDenuncia = anioDenuncia;
	}

	public Date getFechaSancion() {
		return fechaSancion;
	}

	public void setFechaSancion(Date fechaSancion) {
		this.fechaSancion = fechaSancion;
	}

	public String getExpediente() {
		return expediente;
	}

	public void setExpediente(String expediente) {
		this.expediente = expediente;
	}

	public String getDni() {
		return dni;
	}

	public void setDni(String dni) {
		this.dni = dni;
	}

	@Override
	public Object get(int i) {
		switch(i){
		case 0:	return rango;			
		case 1: return matricula;
		case 2: return marca;
		case 3: return modelo;
		case 4: return sancion;
		case 5: return anioDenuncia;
		case 6: return fechaSancion;
		case 7: return expediente;
		case 8: return dni;
	}
	return null;
	}

	@Override
	public Element toXMl(Document doc, String idioma)
			throws ParserConfigurationException {
		String localeStr="dd/MM/yyyy";
		if(!idioma.equals(m05bConstantesInformes.CASTELLANO))
				 localeStr="yyyy/MM/dd";
		DateFormat df = new SimpleDateFormat(localeStr);
		Element rootElement = doc.createElement("sancion");
		Element elemento = doc.createElement("rango");
		if (this.rango != null)
			elemento.appendChild(doc.createTextNode(this.rango));
		else
			elemento.appendChild(doc.createTextNode(" "));
		rootElement.appendChild(elemento);
		elemento = doc.createElement("matricula");
		if (this.matricula != null)
			elemento.appendChild(doc.createTextNode(this.matricula));
		else
			elemento.appendChild(doc.createTextNode(" "));
		rootElement.appendChild(elemento);
		
		elemento=doc.createElement("marca");
		if (this.marca != null)
			elemento.appendChild(doc.createTextNode(this.marca));
		else
			elemento.appendChild(doc.createTextNode(" "));
		rootElement.appendChild(elemento);
		
		elemento=doc.createElement("modelo");
		if (this.modelo != null)
			elemento.appendChild(doc.createTextNode(this.modelo));
		else
			elemento.appendChild(doc.createTextNode(" "));
		rootElement.appendChild(elemento);
		
		elemento=doc.createElement("sancion");
		if (this.sancion != null)
			elemento.appendChild(doc.createTextNode(this.sancion));
		else
			elemento.appendChild(doc.createTextNode(" "));
		rootElement.appendChild(elemento);
		elemento=doc.createElement("anioDenuncia");
		
			elemento.appendChild(doc.createTextNode(""+this.anioDenuncia));
		
		rootElement.appendChild(elemento);
		
		if (this.fechaSancion!= null) {
			elemento = doc.createElement("fechaSancion");

			elemento.appendChild(doc.createTextNode(df
					.format(this.fechaSancion)));
			rootElement.appendChild(elemento);
		}
		
		elemento = doc.createElement("expediente");
		if (this.expediente != null)
			elemento.appendChild(doc.createTextNode(this.expediente));
		else
			elemento.appendChild(doc.createTextNode(" "));
		rootElement.appendChild(elemento);
		
		elemento=doc.createElement("dni");
		if (this.dni != null)
			elemento.appendChild(doc.createTextNode(this.dni));
		else
			elemento.appendChild(doc.createTextNode(" "));
		rootElement.appendChild(elemento);
		return rootElement;
	}
	
}
