package n05bModelosVistas;

import java.text.DateFormat;
import java.text.SimpleDateFormat;

import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class m05bPersonaEstadisticas extends m05bPaginacion implements m05bImprimible {
	public static int [] ORDENINFORMEASIGNACIONPERSONAS={0,1,2,3,4,5,6};
	private String nombre;
	private String departamento;
	private int numeroMatriculas;
	private int numeroKilometros;
	private int totalDias;
	private double gasolina;
	private double peaje;
	public double getPeaje() {
		return peaje;
	}
	public void setPeaje(double peaje) {
		this.peaje = peaje;
	}
	public String getNombre() {
		return nombre;
	}
	public void setNombre(String nombre) {
		this.nombre = nombre;
	}
	public String getDepartamento() {
		return departamento;
	}
	public void setDepartamento(String departamento) {
		this.departamento = departamento;
	}
	public int getNumeroMatriculas() {
		return numeroMatriculas;
	}
	public void setNumeroMatriculas(int numeroMatriculas) {
		this.numeroMatriculas = numeroMatriculas;
	}
	public int getNumeroKilometros() {
		return numeroKilometros;
	}
	public double getGasolina() {
		return gasolina;
	}
	public void setGasolina(double gasolina) {
		this.gasolina = gasolina;
	}
	public void setNumeroKilometros(int numeroKilometros) {
		this.numeroKilometros = numeroKilometros;
	}
	public int getTotalDias() {
		return totalDias;
	}
	public void setTotalDias(int totalDias) {
		this.totalDias = totalDias;
	}
	
	/**
	 * Devuelve un Element xml en el documento DOC que representa a la persona estadstica
	 * @param doc
	 * @return
	 * @throws ParserConfigurationException
	 */
	public Element toXMl(Document doc,String idioma) throws ParserConfigurationException {
		
		Element rootElement = doc.createElement("personaEstadistica");
		Element departamento = doc.createElement("departamento");
		if (this.departamento != null) 
			departamento.appendChild(doc.createTextNode(this.departamento));
		else
			departamento.appendChild(doc.createTextNode(" "));
		rootElement.appendChild(departamento);
		
		Element nombre = doc.createElement("nombre");
		if (this.nombre != null) 
			nombre.appendChild(doc.createTextNode(this.nombre));
		else
			nombre.appendChild(doc.createTextNode(" "));
		rootElement.appendChild(nombre);
		
		Element numeroMatriculas = doc.createElement("numeroMatriculas");
		numeroMatriculas.appendChild(doc.createTextNode(this.numeroMatriculas+""));
		rootElement.appendChild(numeroMatriculas);
		
		Element numeroKilometros = doc.createElement("numeroKilometros");
		numeroKilometros.appendChild(doc.createTextNode(this.numeroKilometros+""));
		rootElement.appendChild(numeroKilometros);
		
		Element totalDias = doc.createElement("totalDias");
		totalDias.appendChild(doc.createTextNode(this.totalDias+""));
		rootElement.appendChild(totalDias);
		Element gasolina = doc.createElement("gasolina");
		gasolina.appendChild(doc.createTextNode(this.gasolina+""));
		rootElement.appendChild(gasolina);
		Element peaje = doc.createElement("peaje");
		peaje.appendChild(doc.createTextNode(this.peaje+""));
		rootElement.appendChild(peaje);
	return rootElement;
	}
	@Override
	public Object get(int i) {
		switch (i){
			case 0:
				return this.nombre;
			case 1:
				return this.departamento;
			case 2:
				return this.numeroMatriculas;
			case 3:
				return this.numeroKilometros;
			case 4:
				return this.totalDias;	
			case 5:
				return this.gasolina;	
			case 6:
				return this.peaje;	
		}
		return null;
	}
}
