package n05bModelosVistas;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.xml.parsers.ParserConfigurationException;

import m05bClasses.m05bConstantesInformes;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class m05bOrdenTrabajo extends m05bPaginacion implements m05bImprimible {
	public static final int [] ORDENDELAORDEN={8,0,6,7,4,9,1};
	public static final int [] ORDENDETALLES={0,6,7,2,10,3};
	public static final int [] ORDENFECHAS={0,6,7,1,5,8,4,9};
	public static final int [] ORDENFECHASAGRUP={4,0,11};
	public static final int [] ORDENFECHASRANGOAGRUP={4,0,5,11};
	private String matricula, taller, concepto, empleado, departamento, rango,descripcion;
	public String getDescripcion() {
		return descripcion;
	}

	public void setDescripcion(String descripcion) {
		this.descripcion = descripcion;
	}

	private Date fechaEntrada, fechaSalida;
	private int idOrden, cuenta;
	private double importe;

	@Override
	public Object get(int i) {
		// TODO Auto-generated method stub
		switch (i){
		case 0: return matricula;
		case 1: return taller;
		case 2: return concepto;
		case 3: return empleado;
		case 4: return departamento;
		case 5: return rango;
		case 6: return fechaEntrada;
		case 7: return fechaSalida;
		case 8: return ""+idOrden;
		case 9: return importe;	
		case 10:return descripcion;
		case 11:return cuenta;
		}
		return null;
	}

	public int getCuenta() {
		return cuenta;
	}

	public void setCuenta(int cuenta) {
		this.cuenta = cuenta;
	}

	@Override
	public Element toXMl(Document doc,String idioma) throws ParserConfigurationException {
		
		String localeStr="dd/MM/yyyy";
		if(!idioma.equals(m05bConstantesInformes.CASTELLANO))
				 localeStr="yyyy/MM/dd";
		DateFormat df = new SimpleDateFormat(localeStr);
		Element rootElement = doc.createElement("ordentrabajo");
		Element matricula = doc.createElement("matricula");
		if (this.matricula != null)
			matricula.appendChild(doc.createTextNode(this.matricula));
		else
			matricula.appendChild(doc.createTextNode(" "));
		rootElement.appendChild(matricula);

		Element taller = doc.createElement("taller");
		if (this.taller != null)
			taller.appendChild(doc.createTextNode(this.taller));
		else
			taller.appendChild(doc.createTextNode(" "));
		rootElement.appendChild(taller);
		
		Element concepto = doc.createElement("concepto");
		if (this.concepto != null)
			concepto.appendChild(doc.createTextNode(this.concepto));
		else
			concepto.appendChild(doc.createTextNode(" "));
		rootElement.appendChild(concepto);
		Element descripcion = doc.createElement("descripcion");
		if (this.descripcion != null)
			descripcion.appendChild(doc.createTextNode(this.descripcion));
		else
			descripcion.appendChild(doc.createTextNode(" "));
		rootElement.appendChild(descripcion);
		
		Element empleado = doc.createElement("empleado");
		if (this.empleado != null)
			empleado.appendChild(doc.createTextNode(this.empleado));
		else
			empleado.appendChild(doc.createTextNode(" "));
		rootElement.appendChild(empleado);
		
		
		Element departamento = doc.createElement("departamento");
		if (this.departamento != null)
			departamento.appendChild(doc.createTextNode(this.departamento));
		else
			departamento.appendChild(doc.createTextNode(" "));
		rootElement.appendChild(departamento);
		
		
		Element rango = doc.createElement("rango");
		if (this.rango != null)
			rango.appendChild(doc.createTextNode(this.rango));
		else
			rango.appendChild(doc.createTextNode(" "));
		rootElement.appendChild(rango);
		
		if (this.fechaEntrada != null) {
			Element fechaEntrada = doc.createElement("fechaEntrada");

			fechaEntrada.appendChild(doc.createTextNode(df
					.format(this.fechaEntrada)));
			rootElement.appendChild(fechaEntrada);
		}

		if (this.fechaSalida != null) {
			Element fechaSalida = doc.createElement("fechaSalida");
			fechaSalida.appendChild(doc.createTextNode(df
					.format(this.fechaSalida)));
			rootElement.appendChild(fechaSalida);
		}
		
		
		
		Element idorden = doc.createElement("idorden");
		idorden.appendChild(doc.createTextNode(this.idOrden + ""));
		rootElement.appendChild(idorden);
		Element cuenta = doc.createElement("cuenta");
		cuenta.appendChild(doc.createTextNode(this.cuenta + ""));
		rootElement.appendChild(cuenta);
		Element importe = doc.createElement("importe");
		importe.appendChild(doc.createTextNode(this.importe + ""));
		rootElement.appendChild(importe);
		return rootElement;
		
	}

	public String getMatricula() {
		return matricula;
	}

	public void setMatricula(String matricula) {
		this.matricula = matricula;
	}

	public String getTaller() {
		return taller;
	}

	public void setTaller(String taller) {
		this.taller = taller;
	}

	public String getConcepto() {
		return concepto;
	}

	public void setConcepto(String concepto) {
		this.concepto = concepto;
	}

	public String getEmpleado() {
		return empleado;
	}

	public void setEmpleado(String empleado) {
		this.empleado = empleado;
	}

	public String getDepartamento() {
		return departamento;
	}

	public void setDepartamento(String departamento) {
		this.departamento = departamento;
	}

	public String getRango() {
		return rango;
	}

	public void setRango(String rango) {
		this.rango = rango;
	}

	public Date getFechaEntrada() {
		return fechaEntrada;
	}

	public void setFechaEntrada(Date fechaEntrada) {
		this.fechaEntrada = fechaEntrada;
	}

	public Date getFechaSalida() {
		return fechaSalida;
	}

	public void setFechaSalida(Date fechaSalida) {
		this.fechaSalida = fechaSalida;
	}

	public int getIdOrden() {
		return idOrden;
	}

	public void setIdOrden(int idOrden) {
		this.idOrden = idOrden;
	}

	public double getImporte() {
		return importe;
	}

	public void setImporte(double importe) {
		this.importe = importe;
	}
}
