package n05bModelosVistas;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.xml.parsers.ParserConfigurationException;

import m05bClasses.m05bConstantesInformes;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class m05bKilometrajes extends m05bPaginacion implements m05bImprimible {

	public static final int []ORDENBASE={0,5,1,3,4,2};
	public static final int []ORDENKMRECORRIDOS={5,2};
	public static final int []ORDENVEHICULOSALTA={0,3,4,5,6,7,8};
	public static final int [] ORDENNUMERO={5,8};
	private String matricula,rango,situacion;
	public String getSituacion() {
		return situacion;
	}

	public void setSituacion(String situacion) {
		this.situacion = situacion;
	}

	public int getDiasDeAlta() {
		return diasDeAlta;
	}

	public void setDiasDeAlta(int diasDeAlta) {
		this.diasDeAlta = diasDeAlta;
	}

	public double getPorcentaje() {
		return porcentaje;
	}

	public void setPorcentaje(double porcentaje) {
		this.porcentaje = porcentaje;
	}

	private Date fecha,fechainiciorango,fechafinrango;
	public String getMatricula() {
		return matricula;
	}
	
	public void setMatricula(String matricula) {
		this.matricula = matricula;
	}

	public String getRango() {
		return rango;
	}

	public void setRango(String rango) {
		this.rango = rango;
	}

	public Date getFecha() {
		return fecha;
	}

	public void setFecha(Date fecha) {
		this.fecha = fecha;
	}

	public Date getFechainiciorango() {
		return fechainiciorango;
	}

	public void setFechainiciorango(Date fechainiorango) {
		this.fechainiciorango = fechainiorango;
	}

	public Date getFechafinrango() {
		return fechafinrango;
	}

	public void setFechafinrango(Date fechafinrango) {
		this.fechafinrango = fechafinrango;
	}

	public int getKilometros() {
		return kilometros;
	}

	public void setKilometros(int kilometros) {
		this.kilometros = kilometros;
	}

	private int kilometros,diasDeAlta;
	private double porcentaje;

	@Override
	public Object get(int i) {
		switch(i){
			case 0:	return matricula;			
			case 1: return fecha;
			case 2: return kilometros;
			case 3: return fechainiciorango;
			case 4: return fechafinrango;
			case 5: return rango;
			case 6: return situacion;
			case 7: return diasDeAlta;
			case 8: return porcentaje;
		}
		return null;
	}
	@Override
	public Element toXMl(Document doc,String idioma) throws ParserConfigurationException {
		// TODO Auto-generated method stub
		String localeStr="dd/MM/yyyy";
		if(!idioma.equals(m05bConstantesInformes.CASTELLANO))
				 localeStr="yyyy/MM/dd";
		DateFormat df = new SimpleDateFormat(localeStr);

		Element rootElement = doc.createElement("kilometraje");
		Element matricula = doc.createElement("matricula");
		if (this.matricula != null)
			matricula.appendChild(doc.createTextNode(this.matricula));
		else
			matricula.appendChild(doc.createTextNode(" "));
		rootElement.appendChild(matricula);
		Element rango = doc.createElement("rango");
		if (this.rango != null)
			rango.appendChild(doc.createTextNode(this.rango));
		else
			rango.appendChild(doc.createTextNode(" "));
		rootElement.appendChild(rango);
		Element situacion = doc.createElement("situacion");
		if (this.situacion != null)
			situacion.appendChild(doc.createTextNode(this.situacion));
		else
			situacion.appendChild(doc.createTextNode(" "));
		rootElement.appendChild(situacion);		
		if (this.fecha!= null) {
			Element fechaEntrada = doc.createElement("fecha");

			fechaEntrada.appendChild(doc.createTextNode(df
					.format(this.fecha)));
			rootElement.appendChild(fechaEntrada);
		}

		if (this.fechainiciorango != null) {
			Element fechainiciorango = doc.createElement("fechainiciorango");
			fechainiciorango.appendChild(doc.createTextNode(df
					.format(this.fechainiciorango)));
			rootElement.appendChild(fechainiciorango);
		}
		if (this.fechafinrango != null) {
			Element fechafinrango = doc.createElement("fechafinrango");
			fechafinrango.appendChild(doc.createTextNode(df
					.format(this.fechafinrango)));
			rootElement.appendChild(fechafinrango);
		}		
		Element kilometros = doc.createElement("kilometros");
		kilometros.appendChild(doc.createTextNode(this.kilometros + ""));
		rootElement.appendChild(kilometros);
		Element diasdealta = doc.createElement("diasdealta");
		diasdealta.appendChild(doc.createTextNode(this.diasDeAlta + ""));
		rootElement.appendChild(diasdealta);
		Element porcentaje = doc.createElement("porcentaje");
		porcentaje.appendChild(doc.createTextNode(this.porcentaje + ""));
		rootElement.appendChild(porcentaje);
		return rootElement;
		
	}

}
