/**
 * 
 */
package n05bModelosVistas;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.xml.parsers.ParserConfigurationException;

import m05bClasses.m05bConstantesInformes;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * @author iaizpurl
 *
 */
public class m05bCombustible extends m05bPaginacion implements m05bImprimible {
	public static int [] ORDENCOMBUSTIBLE={0,1,2,3,4,5,6};
	public static int [] ORDENRESUMEN={1,6};
	private String matricula,rangoVehiculo;
	private Date expr11,fechaGasto,fechaInicioRango,fechaFinRango;
	public String getMatricula() {
		return matricula;
	}

	public void setMatricula(String matricula) {
		this.matricula = matricula;
	}

	public String getRangoVehiculo() {
		return rangoVehiculo;
	}

	public void setRangoVehiculo(String rangoVehiculo) {
		this.rangoVehiculo = rangoVehiculo;
	}

	public Date getExpr11() {
		return expr11;
	}

	public void setExpr11(Date expr11) {
		this.expr11 = expr11;
	}

	public Date getFechaGasto() {
		return fechaGasto;
	}

	public void setFechaGasto(Date fechaGasto) {
		this.fechaGasto = fechaGasto;
	}

	public Date getFechaInicioRango() {
		return fechaInicioRango;
	}

	public void setFechaInicioRango(Date fechaInicioRango) {
		this.fechaInicioRango = fechaInicioRango;
	}

	public Date getFechaFinRango() {
		return fechaFinRango;
	}

	public void setFechaFinRango(Date fechaFinRango) {
		this.fechaFinRango = fechaFinRango;
	}

	public double getImporte() {
		return importe;
	}

	public void setImporte(double importe) {
		this.importe = importe;
	}

	private double importe;
	/* (non-Javadoc)
	 * @see n05bModelosVistas.m05bImprimible#get(int)
	 */
	@Override
	public Object get(int i) {
		switch(i){
			case 0: return matricula;
			case 1: return rangoVehiculo;
			case 2: return expr11;
			case 3: return fechaGasto;
			case 4: return fechaInicioRango;
			case 5: return fechaFinRango;
			case 6: return importe;
		
		}
		return null;
	}

	/* (non-Javadoc)
	 * @see n05bModelosVistas.m05bImprimible#toXMl(org.w3c.dom.Document)
	 */
	@Override
	public Element toXMl(Document doc,String idioma) throws ParserConfigurationException {
		String localeStr="dd/MM/yyyy";
		if(!idioma.equals(m05bConstantesInformes.CASTELLANO))
				 localeStr="yyyy/MM/dd";
		DateFormat df = new SimpleDateFormat(localeStr);

		Element rootElement = doc.createElement("combustible");
		Element matricula = doc.createElement("matricula");		
		if (this.matricula != null) 
			matricula.appendChild(doc.createTextNode(this.matricula));	
		else
			matricula.appendChild(doc.createTextNode(" "));
		rootElement.appendChild(matricula);
		
		Element rangoVehiculo = doc.createElement("rangoVehiculo");
		if (this.rangoVehiculo != null) {
			rangoVehiculo.appendChild(doc.createTextNode(this.rangoVehiculo+""));
		}
		else{
			rangoVehiculo.appendChild(doc.createTextNode(" "));
		}
		rootElement.appendChild(rangoVehiculo);		
		if (this.expr11 != null) {
			Element expr11 = doc.createElement("expr11");
			expr11.appendChild(doc.createTextNode(df.format(this.expr11)));
			rootElement.appendChild(expr11);
		}
		if (this.fechaGasto != null) {
			Element fechaGasto = doc.createElement("fechaGasto");
			fechaGasto.appendChild(doc.createTextNode(df.format(this.fechaGasto)));
			rootElement.appendChild(fechaGasto);
		}
		if (this.fechaInicioRango != null) {
			Element fechaInicioRango = doc.createElement("fechaInicioRango");
			fechaInicioRango.appendChild(doc.createTextNode(df.format(this.fechaInicioRango)));
			rootElement.appendChild(fechaInicioRango);
		}
//		if (this.fechaInicioRango != null) {
//			Element fechaInicioRango = doc.createElement("fechaInicioRango");
//			fechaInicioRango.appendChild(doc.createTextNode(df.format(this.fechaInicioRango)));
//			rootElement.appendChild(fechaInicioRango);
//		}
		if (this.fechaFinRango != null) {
			Element fechaFinRango = doc.createElement("fechaFinRango");
			fechaFinRango.appendChild(doc.createTextNode(df.format(this.fechaFinRango)));
			rootElement.appendChild(fechaFinRango);
		}
		Element importe = doc.createElement("importe");		
		importe.appendChild(doc.createTextNode(this.importe+""));	
		rootElement.appendChild(importe);
		return rootElement;
	}

}
