package n05bModelosVistas;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.xml.parsers.ParserConfigurationException;

import m05bClasses.m05bConstantesInformes;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class m05bAsignacion extends m05bVehiculoV implements m05bImprimible {
	public static int[] ORDENINFORMEASIGNACIONESVIVAS = { 19, 1, 18, 13, 15, 0 };
	public static int[] ORDENINFORMEASIGNACIONESPORVEH = { 0, 13, 18, 1, 8, 15,
			16, 17, 12, 14 };
	public static int[] ORDENINFORMEASIGNACIONESFECHAS = { 0, 18, 1, 15, 16,
			17, 12, 5, 14 };
	public static int[] ORDENCONDUCTORES = { 1, 2, 3, 7, 17, 0, 13, 5, 16, 4 };
	private String asigpermanente;
	private String cargo;
	private String codrangovehiculo;
	private Date fechaDecreto;
	private Date fechaDevolucion;
	private int kilometraje;
	private String nombre;
	private int id;

	public int getId() {
		return id;
	}

	private String idioma = m05bConstantesInformes.CASTELLANO;

	public m05bAsignacion() {

	}

	public m05bAsignacion(String idioma) {
		this.idioma = idioma;
	}

	public void setId(int id) {
		this.id = id;
	}

	public String getAsigpermanente() {
		if (idioma.equals(m05bConstantesInformes.CASTELLANO)) {
			if (asigpermanente.toUpperCase().startsWith("S"))
				return "S";
			else
				return "NO";
		} else {
			if (asigpermanente.toUpperCase().startsWith("S"))
				return "BAI";
			else
				return "EZ";
		}

	}

	public String getCargo() {
		return cargo;
	}

	public String getCodrangovehiculo() {
		return codrangovehiculo;
	}

	public Date getFechaDecreto() {
		return fechaDecreto;
	}

	public Date getFechaDevolucion() {
		return fechaDevolucion;
	}

	public int getKilometraje() {
		return kilometraje;
	}

	public String getNombre() {
		return nombre;
	}

	public void setAsigpermanente(String asigpermanente) {
		
		this.asigpermanente = asigpermanente;
	}

	public void setCargo(String cargo) {
		this.cargo = cargo;
	}

	public void setCodrangovehiculo(String codrangovehiculo) {
		this.codrangovehiculo = codrangovehiculo;
	}

	public void setFechaDecreto(Date fechaDecreto) {
		this.fechaDecreto = fechaDecreto;
	}

	public void setFechaDevolucion(Date fechaDevolucion) {
		this.fechaDevolucion = fechaDevolucion;
	}

	public void setKilometraje(int kilometraje) {
		this.kilometraje = kilometraje;
	}

	public void setNombre(String nombre) {
		this.nombre = nombre;
	}

	/**
	 * Devuelve el nodo Element XML con los valores de los elementos
	 */
	public Element toXMl(Document doc, String idioma)
			throws ParserConfigurationException {
		String localeStr = "dd/MM/yyyy";
		if (!idioma.equals(m05bConstantesInformes.CASTELLANO))
			localeStr = "yyyy/MM/dd";
		DateFormat df = new SimpleDateFormat(localeStr);

		Element rootElement = doc.createElement("asignacion");
		rootElement.appendChild(super.toXMl(doc, idioma));
		Element cargo = doc.createElement("cargo");
		if (this.cargo != null)
			cargo.appendChild(doc.createTextNode(this.cargo));
		else
			cargo.appendChild(doc.createTextNode(" "));
		rootElement.appendChild(cargo);

		Element nombre = doc.createElement("nombre");
		if (this.nombre != null)
			nombre.appendChild(doc.createTextNode(this.nombre));
		else
			nombre.appendChild(doc.createTextNode(" "));
		rootElement.appendChild(nombre);
		Element kilometraje = doc.createElement("kilometraje");

		kilometraje.appendChild(doc.createTextNode(this.kilometraje + ""));

		rootElement.appendChild(kilometraje);
		Element codrangovehiculo = doc.createElement("codrangovehiculo");
		if (this.codrangovehiculo != null)
			codrangovehiculo.appendChild(doc
					.createTextNode(this.codrangovehiculo + ""));
		else
			codrangovehiculo.appendChild(doc.createTextNode(" "));
		rootElement.appendChild(codrangovehiculo);
		Element asigpermanente = doc.createElement("asigpermanente");

		if (this.asigpermanente != null)
			asigpermanente.appendChild(doc.createTextNode(getAsigpermanente()
					+ ""));
		else
			asigpermanente.appendChild(doc.createTextNode(" "));
		rootElement.appendChild(asigpermanente);
		if (this.fechaDecreto != null) {
			Element fechaDecreto = doc.createElement("fechadecreto");

			fechaDecreto.appendChild(doc.createTextNode(df
					.format(this.fechaDecreto)));
			rootElement.appendChild(fechaDecreto);
		}

		if (this.fechaDevolucion != null) {
			Element fechaDevolucion = doc.createElement("fechaDevolucion");
			fechaDevolucion.appendChild(doc.createTextNode(df
					.format(this.fechaDevolucion)));
			rootElement.appendChild(fechaDevolucion);
		}

		Element id = doc.createElement("id");

		id.appendChild(doc.createTextNode(this.id + ""));
		rootElement.appendChild(id);
		return rootElement;
	}

	@Override
	public Object get(int i) {
		if (i < 11)
			return super.get(i);
		else
			switch (i) {
			case 12:
				return getAsigpermanente();
			case 13:
				return cargo;
			case 14:
				return codrangovehiculo;
			case 15:
				return fechaDecreto;
			case 16:
				return fechaDevolucion;
			case 17:
				return kilometraje;
			case 18:
				return nombre;
			case 19:
				return "" + id;

			}
		return null;
	}
}
