package n05bModelosVistas;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

import javax.xml.parsers.ParserConfigurationException;

import m05bClasses.m05bConstantesInformes;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class m05bAmortizacionBase extends m05bPaginacion implements m05bImprimible {
	public static final int [] ORDENAMORTIZACIONBASE={0,1,2,3,4,5,6,7,8,9,10,11};
	private String rango,matricula;
	private Date expr1,fechaInicioAmortizacion,fechaFinAmortizacion,fechaInicioDelRango,fechaFinDelRango;
	private double precio,valorAmortizacionDiaria,amortAcumTransf,amortizacionPeriodo;
	private int diasAmortizacion;
	public String getRango() {
		return rango;
	}
	public void setRango(String rango) {
		this.rango = rango;
	}
	public String getMatricula() {
		return matricula;
	}
	public void setMatricula(String matricula) {
		this.matricula = matricula;
	}
	public Date getExpr1() {
		return expr1;
	}
	public void setExpr1(Date expr1) {
		this.expr1 = expr1;
	}
	public Date getFechaInicioAmortizacion() {
		return fechaInicioAmortizacion;
	}
	public void setFechaInicioAmortizacion(Date fechaInicioAmortizacion) {
		this.fechaInicioAmortizacion = fechaInicioAmortizacion;
	}
	public Date getFechaFinAmortizacion() {
		return fechaFinAmortizacion;
	}
	public void setFechaFinAmortizacion(Date fechaFinAmortizacion) {
		this.fechaFinAmortizacion = fechaFinAmortizacion;
	}
	public Date getFechaInicioDelRango() {
		return fechaInicioDelRango;
	}
	public void setFechaInicioDelRango(Date fechaInicioDelRango) {
		this.fechaInicioDelRango = fechaInicioDelRango;
	}
	public Date getFechaFinDelRango() {
		return fechaFinDelRango;
	}
	public void setFechaFinDelRango(Date fechaFinDelRango) {
		this.fechaFinDelRango = fechaFinDelRango;
	}
	public double getPrecio() {
		return precio;
	}
	public void setPrecio(double precio) {
		this.precio = precio;
	}
	public double getValorAmortizacionDiaria() {
		return valorAmortizacionDiaria;
	}
	public void setValorAmortizacionDiaria(double valorAmortizacionDiaria) {
		this.valorAmortizacionDiaria = valorAmortizacionDiaria;
	}
	public double getAmortAcumTransf() {
		return amortAcumTransf;
	}
	public void setAmortAcumTransf(double amortAcumTransf) {
		this.amortAcumTransf = amortAcumTransf;
	}
	public double getAmortizacionPeriodo() {
		return amortizacionPeriodo;
	}
	public void setAmortizacionPeriodo(double amortizacionPeriodo) {
		this.amortizacionPeriodo = amortizacionPeriodo;
	}
	public int getDiasAmortizacion() {
		return diasAmortizacion;
	}
	public void setDiasAmortizacion(int diasAmortizacion) {
		this.diasAmortizacion = diasAmortizacion;
	}
	@Override
	public Object get(int i) {
		switch(i){
		case 0:
			
			return this.rango;
		case 1:
			return this.expr1;
		case 2:
			return this.matricula;
		case 3:
			return this.precio;
		case 4:
			return this.fechaInicioAmortizacion;
		case 5:
			return this.fechaFinAmortizacion;
		case 6:
			return this.fechaInicioDelRango;
		case 7:
			return this.fechaFinDelRango;
		case 8:
			return this.diasAmortizacion;
		case 9:
			return this.valorAmortizacionDiaria;
		case 10:
			return this.amortAcumTransf;
		case 11:
			return this.amortizacionPeriodo;
		}
		return null;
	}
	@Override
	public Element toXMl(Document doc,String idioma) throws ParserConfigurationException {
		String localeStr="dd/MM/yyyy";
		if(!idioma.equals(m05bConstantesInformes.CASTELLANO))
				 localeStr="yyyy/MM/dd";
		DateFormat df = new SimpleDateFormat(localeStr);

		Element rootElement = doc.createElement("amortizacion");
	
		Element rango = doc.createElement("rango");
		if (this.rango != null)
			rango.appendChild(doc.createTextNode(this.rango));
		else
			rango.appendChild(doc.createTextNode(" "));
		rootElement.appendChild(rango);

		
		if (this.expr1 != null) {
			Element expr1 = doc.createElement("expr1");
			expr1.appendChild(doc.createTextNode(df
					.format(this.expr1)));
			rootElement.appendChild(expr1);
		}		
		Element matricula = doc.createElement("matricula");
		if (this.matricula != null)
			matricula.appendChild(doc.createTextNode(this.matricula));
		else
			matricula.appendChild(doc.createTextNode(" "));
		rootElement.appendChild(matricula);
		
		Element precio = doc.createElement("precio");
		precio.appendChild(doc.createTextNode(this.precio+""));
		rootElement.appendChild(precio);
		
		
		if (this.fechaInicioAmortizacion != null) {
			Element fechaInicioAmortizacion = doc.createElement("fechaInicioAmortizacion");
			fechaInicioAmortizacion.appendChild(doc.createTextNode(df
					.format(this.fechaInicioAmortizacion)));
			rootElement.appendChild(fechaInicioAmortizacion);
		}		
		
		if (this.fechaFinAmortizacion != null) {
			Element fechaFinAmortizacion = doc.createElement("fechaFinAmortizacion");
			fechaFinAmortizacion.appendChild(doc.createTextNode(df
					.format(this.fechaFinAmortizacion)));
			rootElement.appendChild(fechaFinAmortizacion);
		}
		
		if (this.fechaInicioDelRango != null) {
			Element fechaInicioDelRango = doc.createElement("fechaInicioDelRango");
			fechaInicioDelRango.appendChild(doc.createTextNode(df
					.format(this.fechaInicioDelRango)));
			rootElement.appendChild(fechaInicioDelRango);
		}		
		
		if (this.fechaFinDelRango != null) {
			Element fechaFinDelRango = doc.createElement("fechaFinDelRango");
			fechaFinDelRango.appendChild(doc.createTextNode(df
					.format(this.fechaFinDelRango)));
			rootElement.appendChild(fechaFinDelRango);
		}
		
		Element diasAmortizacion = doc.createElement("diasAmortizacion");
		diasAmortizacion.appendChild(doc.createTextNode(this.diasAmortizacion+""));
		rootElement.appendChild(diasAmortizacion);
		
		Element valorAmortDiaria = doc.createElement("valorAmortizacionDiaria");
		valorAmortDiaria.appendChild(doc.createTextNode(this.valorAmortizacionDiaria+""));
		rootElement.appendChild(valorAmortDiaria);
		
		Element amortAcumTransf = doc.createElement("amortAcumTransf");
		amortAcumTransf.appendChild(doc.createTextNode(this.amortAcumTransf+""));
		rootElement.appendChild(amortAcumTransf);
		
		
		Element amortizacionPeriodo = doc.createElement("amortizacionPeriodo");
		amortizacionPeriodo.appendChild(doc.createTextNode(this.amortizacionPeriodo+""));
		rootElement.appendChild(amortizacionPeriodo);
		return rootElement;
	}

}
