package n05bModelosVistas;

import java.text.DateFormat;
import java.text.SimpleDateFormat;

import javax.xml.parsers.ParserConfigurationException;

import m05bClasses.m05bConstantesInformes;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class m05bAmortizacion implements m05bImprimible {
	public static final int [] ORDENAMORTIZACION={0,1};
	private String rango;
	private double valorAmortizacion;

	public String getRango() {
		return rango;
	}

	public void setRango(String rango) {
		this.rango = rango;
	}

	public double getValorAmortizacion() {
		return valorAmortizacion;
	}

	public void setValorAmortizacion(double valorAmortizacion) {
		this.valorAmortizacion = valorAmortizacion;
	}

	@Override
	public Object get(int i) {
		switch (i){
			case 0:
				return rango;
			case 1:
				return valorAmortizacion;
		}
		return null;
	}

	@Override
	public Element toXMl(Document doc,String idioma) throws ParserConfigurationException {
		String localeStr="dd/MM/yyyy";
		if(!idioma.equals(m05bConstantesInformes.CASTELLANO))
				 localeStr="yyyy/MM/dd";
		DateFormat df = new SimpleDateFormat(localeStr);

		Element rootElement = doc.createElement("amortizacion");
		Element rango = doc.createElement("rango");
		if (this.rango != null) 
			rango.appendChild(doc.createTextNode(this.rango));
		else
			rango.appendChild(doc.createTextNode(" "));
		rootElement.appendChild(rango);
		
		Element amortizacion = doc.createElement("valorAmortizacion");
		amortizacion.appendChild(doc.createTextNode(" "+this.valorAmortizacion));
		rootElement.appendChild(amortizacion);
		return rootElement;
	}

	
}
