package m05bServices;

import java.util.ArrayList;

import n05bModelosVistas.m05bOption;
import n05bModelosVistas.m05bVehiculoV;
import m05bDaos.m05bAsignacionesDao;
import m05bDaos.m05bVistaVehiculosDao;

public class m05bVistaVehiculosService{
	private static m05bVistaVehiculosService instance = null;
	//private static Logger log;
	public static m05bVistaVehiculosService getInstance() {
		if (instance == null) {
			synchronized (m05bVistaVehiculosService.class) {
				if (instance == null){
					instance = new m05bVistaVehiculosService();
		//  		    log= Logger.getLogger(instance.getClass());
	  		//	    PropertyConfigurator.configure( t64bGlobalContainer.LOGGERCONF);
				}
			}
		}

		return instance;
	}
	
	/**
	 *Ejecuta una una select sobre la vista vehiculos (M0534V00) 
	 * y devuelve una lista de vehiculos matriculados a partir del ao de entrada 
	 * @param anio
	 */
	public ArrayList<m05bVehiculoV> altasPorAnio(int anio, String [] listasituaciones,String idioma, int numPagina) {
		m05bVistaVehiculosDao dao= m05bVistaVehiculosDao.getInstance();
		return dao.altasPorAnio(anio,listasituaciones,idioma,numPagina);
	}
	/**
	 *Ejecuta una una select sobre la vista vehiculos (M0534V00) 
	 * y devuelve una lista de vehiculos matriculados a partir del ao de entrada 
	 * @param anio
	 */
	public ArrayList<m05bVehiculoV> bajasPorAnio(int anio, String [] listadepartamentos, String [] listarangos,String idioma, int numPagina) {
		m05bVistaVehiculosDao dao= m05bVistaVehiculosDao.getInstance();
		return dao.bajasPorAnio(anio,listadepartamentos,  listarangos,idioma,numPagina);
	}
	/**
	 *Ejecuta una una select sobre la vista vehiculos (M0534V00) 
	 * y devuelve una lista con todos los distintos aos
	 * 
	 */
	public ArrayList<m05bOption> getAniosAlta(){
		m05bVistaVehiculosDao dao= m05bVistaVehiculosDao.getInstance();
		return dao.getAniosAlta();
		
	}
	/**
	 *Ejecuta una una select sobre la vista vehiculos (M0534V00) 
	 * y devuelve una lista con todos los distintos aos
	 * 
	 */
	public ArrayList<m05bOption> getAniosBaja(){
		m05bVistaVehiculosDao dao= m05bVistaVehiculosDao.getInstance();
		return dao.getAniosBaja();
		
	}
	/**
	 *Ejecuta una una select sobre la vista vehiculos (M0534V00) 
	 * y devuelve una lista con todos los distintos aos de fecha de matriculacion
	 * 
	 */
	public ArrayList<m05bOption> getAniosMatriculacion(String idioma, int numPagina){
		m05bVistaVehiculosDao dao= m05bVistaVehiculosDao.getInstance();
		return dao.getAniosMatriculacion();
		
	}
	/**
	 *Ejecuta una una select sobre la vista vehiculos (M0534V00) 
	 * y devuelve una lista con todos los distintos situaciones
	 * 
	 */
	public ArrayList<m05bOption> getSituaciones(String idioma, int numPagina){
		m05bVistaVehiculosDao dao= m05bVistaVehiculosDao.getInstance();
		return dao.getSituaciones(idioma,numPagina);
		
	}
	/**
	 * Rangos
	 * @return
	 */
	public ArrayList<m05bOption> getRangos(String idioma, int numPagina){
		m05bVistaVehiculosDao dao= m05bVistaVehiculosDao.getInstance();
		return dao.getRangos(idioma,numPagina);
		
	}
	/**
	 * 
	 * @return
	 */
	public ArrayList<m05bOption> getDepartamentos(String idioma, int numPagina){
		m05bVistaVehiculosDao dao= m05bVistaVehiculosDao.getInstance();
		return dao.getDepartamentos(idioma,numPagina);
	}	
	/**
	 *Ejecuta una una select sobre la vista vehiculos (M0534V00) 
	 * y devuelve una lista con todos los distintos situaciones
	 * 
	 */
	public ArrayList<m05bOption> getSituaciones(String [] situaciones,String idioma, int numPagina){
		m05bVistaVehiculosDao dao= m05bVistaVehiculosDao.getInstance();
		return dao.getSituaciones(situaciones,idioma,numPagina);
		
	}
	/**
	 * Rangos
	 * @return
	 */
	public ArrayList<m05bOption> getRangos(String [] rangos,String idioma, int numPagina){
		m05bVistaVehiculosDao dao= m05bVistaVehiculosDao.getInstance();
		return dao.getRangos(rangos,idioma,numPagina);
		
	}
	/**
	 * 
	 * @return
	 */
	public ArrayList<m05bOption> getDepartamentos(String [] departamentos,String idioma, int numPagina){
		m05bVistaVehiculosDao dao= m05bVistaVehiculosDao.getInstance();
		return dao.getDepartamentos(departamentos,idioma,numPagina);
	}	
	/**
	 * 
	 * @param tipo
	 * @param situaciones
	 * @return
	 */
	public ArrayList<m05bVehiculoV> cocherPorTipo(String[]  rangos, String[] situaciones,String [] departamentos,String idioma, int numPagina){
		m05bVistaVehiculosDao dao= m05bVistaVehiculosDao.getInstance();
		return dao.cocherPorTipo(rangos,situaciones,departamentos,idioma,numPagina);
	}
	/**
	 * 
	 * @return
	 */
	public ArrayList<m05bOption> getMarcas(String idioma, int numPagina){
		m05bVistaVehiculosDao dao= m05bVistaVehiculosDao.getInstance();
		return dao.getMarcas();
	}
	/**
	 * Devuelve una  lista de marcas que tengan los codigos de marcas
	 * @param marcas
	 * @param idioma
	 * @param numPagina
	 * @return
	 */	
	public ArrayList<m05bOption> getMarcas(String [] marcas,String idioma, int numPagina){
		m05bVistaVehiculosDao dao= m05bVistaVehiculosDao.getInstance();
		return dao.getMarcas(marcas,idioma,numPagina);
	}
	public ArrayList<m05bOption> getModelos(String marcas,String idioma, int numPagina){
		m05bVistaVehiculosDao dao= m05bVistaVehiculosDao.getInstance();
		return dao.getModelos(marcas);
	}
	/**
		Devuelve el listado de vehiculos por situaciones
	 * 
	 * @param situaciones
	 */
	public ArrayList<m05bVehiculoV> listadoGeneral( String[] situaciones,String idioma, int numPagina) {
		return m05bVistaVehiculosDao.getInstance().listadoGeneral(situaciones,idioma,numPagina);
	}
	/**
	 * Devuelve un listado de modelos
	 * @param modelos
	 * @return
	 */
	public ArrayList<m05bOption> toArrayList(String [] modelos){
		return m05bVistaVehiculosDao.getInstance().getModelos(modelos);
	}
}
