package m05bServices;

import java.util.ArrayList;

import m05bDaos.m05bOrdenesTrabajoDao;
import n05bModelosVistas.m05bOrdenTrabajo;

public class m05bOrdenesTrabajoService {
	private static m05bOrdenesTrabajoService instance = null;
	//private static Logger log;
	public static m05bOrdenesTrabajoService getInstance() {
		if (instance == null) {
			synchronized (m05bOrdenesTrabajoService.class) {
				if (instance == null){
					instance = new m05bOrdenesTrabajoService();
		//  		    log= Logger.getLogger(instance.getClass());
	  		//	    PropertyConfigurator.configure( t64bGlobalContainer.LOGGERCONF);
				}
			}
		}

		return instance;
	}
	/**
	 * 
	 * @param fechaEntrada1
	 * @param fechaEntrada2
	 * @param fechaSalida1
	 * @param fechaSalida2
	 * @param tipoTaller
	 * @return
	 */
	public ArrayList<m05bOrdenTrabajo> ordenes(String fechaEntrada1,String fechaEntrada2,
			String fechaSalida1,String fechaSalida2,int tipoTaller,String idioma, int numPagina){
		return m05bOrdenesTrabajoDao.getInstance().ordenes(fechaEntrada1, fechaEntrada2, fechaSalida1, fechaSalida2, tipoTaller, idioma,numPagina);
		
	}
	
	/**
	 * Devuelve un array con las ordenes de trabajo detalladas para la fecha de entrada y la matrcula dada
	 * @param fechaEntrada
	 * @param matricula
	 * @return
	 */
	public ArrayList<m05bOrdenTrabajo> ordenesDetalle(String fechaEntrada,String matricula,String idioma, int numPagina){
		return m05bOrdenesTrabajoDao.getInstance().ordenesDetalle(fechaEntrada, matricula, idioma,numPagina);
	}
	/**
	 * Devuelve las ordendes de trabajo por fecha y tipotaller
	 * @param fechaEntrada
	 * @param matricula
	 * @param tipoTaller
	 * @return
	 */
	public ArrayList<m05bOrdenTrabajo> ordenesporFecha(String fechaEntrada,String fechaEntrada2, int tipoTaller,String idioma, int numPagina) {
		return m05bOrdenesTrabajoDao.getInstance().ordenesporFecha(fechaEntrada, fechaEntrada2, tipoTaller, idioma,numPagina);
	}
	/**
	 * Devuelve las ordendes de trabajo por fecha y tipotaller agrupadas por departamento y grupo
	 * @param fechaEntrada
	 * @param matricula
	 * @param tipoTaller
	 * @return
	 */
	public ArrayList<m05bOrdenTrabajo> ordenesporFechaAgrup(String fechaEntrada,String fechaEntrada2, int tipoTaller,String idioma, int numPagina) {
		return m05bOrdenesTrabajoDao.getInstance().ordenesporFechaAgrup(fechaEntrada, fechaEntrada2, tipoTaller, idioma,numPagina);
	
	}

	/**
	 * Devuelve las ordendes de trabajo por fecha y tipotaller agrupadas por departamento y matrcula
	 * @param fechaEntrada
	 * @param matricula
	 * @param tipoTaller
	 * @return
	 */
	public ArrayList<m05bOrdenTrabajo> ordenesAgrup(String fechaEntrada1,String fechaEntrada2,
			String fechaSalida1,String fechaSalida2,int tipoTaller,String idioma, int numPagina){
		return m05bOrdenesTrabajoDao.getInstance().ordenesAgrup(fechaEntrada1, fechaEntrada2, fechaSalida1, fechaSalida2, tipoTaller,idioma,numPagina);
	}
	
	 /**
	  * Devuelve las ordendes de trabajo por fecha y tipotaller aprupados por departamento , matricula y rango
	 * @param fechaEntrada
	 * @param matricula
	 * @param tipoTaller
	 * @return
	 */
	public ArrayList<m05bOrdenTrabajo> ordenesAgrupRango(String fechaEntrada1,String fechaEntrada2,
			String fechaSalida1,String fechaSalida2,int tipoTaller,String idioma, int numPagina){
		return m05bOrdenesTrabajoDao.getInstance().ordenesAgrupRango(fechaEntrada1, fechaEntrada2, fechaSalida1, fechaSalida2, tipoTaller, idioma,numPagina);
	}
}
