package m05bServices;

import java.util.ArrayList;
import m05bDaos.m05bMunicipiosDao;
import m05bDaos.m05bPaginator;
import n05bModelosVistas.m05bOption;
import n05bModelosVistas.m05bTasasMunicipio;

public class m05bMunicipiosService {

	private static m05bMunicipiosService instance = null;
	//private static Logger log;

	public static m05bMunicipiosService getInstance() {
		if (instance == null) {
			synchronized (m05bMunicipiosService.class) {
				if (instance == null) {
					instance = new m05bMunicipiosService();
					//log=Logger.getLogger(instance.getClass());
					//PropertyConfigurator.configure( t64bGlobalContainer.LOGGERCONF);
				}
			}
		}

		return instance;
	}

	/**
	 * Devuelve una lista de municipios
	 */
	public ArrayList<m05bOption> getMunicipio() {
		return m05bMunicipiosDao.getInstance().getMunicipio();
	}

	/**
	 * Devuleve las tasas que paga el municipio. Si municipio=-1 devuleve todas las tasas de todos los municipios
	 * @param municipio
	 * @return
	 */
	public ArrayList<m05bTasasMunicipio> getTasas(String municipio, String [] situaciones, String idioma, int numPagina) {
		return m05bMunicipiosDao.getInstance().getTasas(municipio, situaciones, idioma, numPagina);
	}
}