package m05bServices;

import java.util.ArrayList;

import n05bModelosVistas.m05bAmortizacion;
import n05bModelosVistas.m05bAmortizacionBase;
import n05bModelosVistas.m05bCombustible;
import n05bModelosVistas.m05bKilometrajes;
import m05bDaos.m05bCTKDao;

public class m05bCTKService {
	private static m05bCTKService instance = null;

	// private static Logger log;
	public static m05bCTKService getInstance() {
		if (instance == null) {
			synchronized (m05bCTKService.class) {
				if (instance == null) {
					instance = new m05bCTKService();
					// log= Logger.getLogger(instance.getClass());
					// PropertyConfigurator.configure(
					// t64bGlobalContainer.LOGGERCONF);
				}
			}
		}

		return instance;
	}
	
	/**
	 * devuelve un array con los rangos de los vehculos y las amortizaciones
	 * @param fechaInicio
	 * @param fechaFin
	 * @return
	 */
	public ArrayList<m05bAmortizacion> amortizacion(String fechaInicio, String fechaFin,String idioma, int numPagina){
		return m05bCTKDao.getInstance().amortizacion(fechaInicio, fechaFin,idioma,numPagina);
	}
	/**
	 * devuelve un array de amortizaciones base
	 * @param fechaInicio
	 * @param fechaFin
	 * @return
	 */
	public ArrayList<m05bAmortizacionBase> amortizacionBase(String fechaInicio, String fechaFin,String idioma, int numPagina) {
		return m05bCTKDao.getInstance().amortizacionBase(fechaInicio, fechaFin,idioma,numPagina);
	}
	
	/**
	 * Devuelve una lista de m05Combustible, representando al gasto
	 * @param fechainicio
	 * @param fechafin
	 * @return
	 */
	public  ArrayList<m05bCombustible> combustibleGastos(String fechainicio, String fechafin,String idioma, int numPagina){
	
		return m05bCTKDao.getInstance().combustibleGastos(fechainicio,fechafin,idioma,numPagina);
	
	}
	/**
	 * Devuelve una lista de m05Combustible, representando al combustible de bancos
	 * @param fechainicio
	 * @param fechafin
	 * @return
	 */
	public  ArrayList<m05bCombustible> combustibleBanco(String fechainicio, String fechafin,String idioma, int numPagina){
		return m05bCTKDao.getInstance().combustibleBanco(fechainicio,fechafin,idioma,numPagina);
	
	}
	/**
	 * Devuelve una lista de m05Combustible, con la lista de combustible total
	 * @param fechainicio
	 * @param fechafin
	 * @return
	 */
	public  ArrayList<m05bCombustible> combustibleTotal(String fechainicio, String fechafin,String idioma, int numPagina){
		return m05bCTKDao.getInstance().combustibleTotal(fechainicio,fechafin,idioma,numPagina);
	
	}
	/**
	 * Devuelve una lista de m05Combustible, para obtener el resumen
	 * @param fechainicio
	 * @param fechafin
	 * @return
	 */
	public  ArrayList<m05bCombustible> combustible(String fechainicio, String fechafin,String idioma, int numPagina){
		return m05bCTKDao.getInstance().combustible(fechainicio,fechafin,idioma,numPagina);
	
	}
	/**
	 * Rellena tabla
	 */
	public void callRellenar(){
		 m05bCTKDao.getInstance().callRellenar();
	}
	/**
	 * Rellena la tabla temporal de kilometrajes para el usuario username entre los valores fechainit,fechafin
	 * @param username
	 * @param fechainit
	 * @param fechafin
	 */
	public void callRellenarKilometrajes(String username,String fechainit,String fechafin,String idioma, int numPagina) {
		 m05bCTKDao.getInstance().callRellenarKilometrajes(username, fechainit, fechafin);
	}
	
	/**
	 * Devuelve una lista de kilometrajes resumen
	 * 	 * @param usuario
	 * @return
	 */
	public ArrayList<m05bKilometrajes> kilometrosRecorrido(String usuario,String idioma, int numPagina) {
		return m05bCTKDao.getInstance().kilometrosRecorrido(usuario,idioma,numPagina);
	}
	
	/**
	 * Devuelve una lista de kilometrajes
	 * @param fechainit
	 * @param fechafin
	 * @return
	 */
	public ArrayList<m05bKilometrajes> kilometrajesBase(String fechainit, String fechafin,String idioma, int numPagina) {
		return m05bCTKDao.getInstance().kilometrajesBase(fechainit, fechafin,idioma,numPagina);
	}
	
	/**
	 * @param fechaInicio
	 * @param fechaFin
	 * @return
	 */
	public  ArrayList<m05bKilometrajes>  getVehiculosAltaEntreFechas(String fechaInicio, String fechaFin,String idioma, int numPagina){
		return m05bCTKDao.getInstance().getVehiculosAltaEntreFechas(fechaInicio, fechaFin,idioma,numPagina);
	}
	/**
	 * @param fechaInicio
	 * @param fechaFin
	 * @return
	 */
	public  ArrayList<m05bKilometrajes>  getMediaVehiculos(String fechaInicio, String fechaFin,String idioma, int numPagina){
		return m05bCTKDao.getInstance().getMediaVehiculos(fechaInicio, fechaFin,idioma,numPagina);
	}
	/**
	 * Devuleve el resultado de CTk vehiculos
	 * @param fecha1
	 * @return
	 */
	public ArrayList<m05bKilometrajes> numeroVehiculos(String fecha1,String idioma, int numPagina){
		return m05bCTKDao.getInstance().numeroVehiculos(fecha1,idioma,numPagina);
	}
}
