package m05bServices;

import java.util.ArrayList;

import m05bDaos.m05bAsignacionesDao;
import n05bModelosVistas.m05bAsignacion;
import n05bModelosVistas.m05bOption;
import n05bModelosVistas.m05bPersonaEstadisticas;
import n05bModelosVistas.m05bVehiculoV;

public class m05bAsignacionesService{
	private static m05bAsignacionesService instance = null;
	//private static Logger log;
	public static m05bAsignacionesService getInstance() {
		if (instance == null) {
			synchronized (m05bAsignacionesService.class) {
				if (instance == null){
					instance = new m05bAsignacionesService();
		//  		    log= Logger.getLogger(instance.getClass());
	  		//	    PropertyConfigurator.configure( t64bGlobalContainer.LOGGERCONF);
				}
			}
		}

		return instance;
	}
	
	
	/**
	 * 
	 * @return 
	 */
	public ArrayList<m05bAsignacion> asignacionesPorTipo(String  [] tipos,String fechaAsigDesde,String fechaAsigHasta, String fechaDevolucionDesde,String fechaDevolucionHasta,String fechaDecretoDesde,String fechaDecretoHasta,String [] cargos,String [] departamentos,String idioma, int numPagina) {
 
		m05bAsignacionesDao dao= m05bAsignacionesDao.getInstance();
		return dao.asignacionesPorTipo(tipos,fechaAsigDesde,fechaAsigHasta, fechaDevolucionDesde, fechaDevolucionHasta, fechaDecretoDesde, fechaDecretoHasta,cargos,departamentos,idioma,numPagina);
	}	
	/**
	 * 
	 * @return
	 */
	public ArrayList<m05bAsignacion> asignacionesPorFecha( String fechaDesde,String fechaHasta, String [] rangos,String idioma, int numPagina) {
		m05bAsignacionesDao dao= m05bAsignacionesDao.getInstance();
		return dao.asignacionesPorFecha(fechaDesde, fechaHasta, rangos,idioma,numPagina);
	}	
	
	/**
	 * Devuelve una lista de los cargos disponibles
	 * 
	 */
	public ArrayList<m05bOption> getCargos(String idioma, int numPagina){
		m05bAsignacionesDao dao= m05bAsignacionesDao.getInstance();
		return dao.getCargos(idioma);
	}
	/**
	 * Devuelve una lista de los cargos disponibles
	 * 
	 */
	public ArrayList<m05bOption> getCargos(String [] cargos,String idioma, int numPagina){
		m05bAsignacionesDao dao= m05bAsignacionesDao.getInstance();
		return dao.getCargos(cargos,idioma);
	}
	/**
	 * Devuelve una lista de los Rangos disponibles
	 * 
	 */
	public ArrayList<m05bOption> getRangos(String idioma, int numPagina){
		m05bAsignacionesDao dao= m05bAsignacionesDao.getInstance();
		return dao.getRangos(idioma);
	}
	/**
	 * Devuelve una lista de los Rangos disponibles
	 * 
	 */
	public ArrayList<m05bOption> getRangos(String [] rangos,String idioma, int numPagina){
		m05bAsignacionesDao dao= m05bAsignacionesDao.getInstance();
		return dao.getRangos(rangos,idioma);
	}
	/**
	 * Ejecuta una una select sobre las vista personas y asignaciones y devuelve una
	 * lista de personas estadisticas (numero de kilometros, coches y das
	 *  
	 * @param anio
	 * @param situaciones
	 */
	public ArrayList<m05bPersonaEstadisticas> asignacionesPorPersonas(String anio,String idioma, int numPagina) {
		m05bAsignacionesDao dao= m05bAsignacionesDao.getInstance();
		return dao.asignacionesPorPersonas(anio,idioma,numPagina);
	}
	
	/**
	 * Ejecuta una una select sobre las vistas personal y asignaciones y
	 * devuelve las asignaciones sin finalizar
	 *  
	 * @param anio
	 * @param situaciones
	 */
	public ArrayList<m05bAsignacion> asignacionesVivas(String [] departamentos,String idioma, int numPagina){
		m05bAsignacionesDao dao= m05bAsignacionesDao.getInstance();
		return dao.asignacionesVivas(departamentos,idioma,numPagina);
	}
	/**
	 * Ejecuta una selec en las vistas vehiculos, personal y asignaciones segun los parametros de entrada
	 * @param marcas
	 * @param modelos
	 * @param rangos
	 * @param situaciones
	 * @param fechaDevolucion
	 * @return
	 */
	public ArrayList<m05bAsignacion> asignacionesAConductores(String []marcas,String [] modelos,String []rangos,String [] situaciones,int fechaDevolucion,String idioma, int numPagina) {
		m05bAsignacionesDao dao= m05bAsignacionesDao.getInstance();
		return dao.asignacionesAConductores(marcas, modelos, rangos, situaciones, fechaDevolucion,idioma,numPagina);
	}
}
