package m05bLdap;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;

import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import m05bClasses.m05bFileLog;

import org.w3c.dom.Document;
import org.w3c.dom.Node;

public final class m05bXLNetsPrintWritter {      

    public m05bXLNetsPrintWritter() {    
    }

    public static void print (Document documento, Object streamSalida) {
        StreamResult result = null;

        try {
            // Tiki tiki
            TransformerFactory transformerFactory = TransformerFactory.newInstance ();
            Transformer transformer = transformerFactory.newTransformer ();

            transformer.setOutputProperty(OutputKeys.METHOD,"xml");
            transformer.setOutputProperty(OutputKeys.ENCODING,"UTF-8");
            transformer.setOutputProperty(OutputKeys.VERSION,"1.0");

            DOMSource source = new DOMSource (documento);
            if (streamSalida instanceof PrintStream) {
                result = new StreamResult ((PrintStream)streamSalida);
            } else if (streamSalida instanceof PrintWriter) {
                result = new StreamResult ((PrintWriter)streamSalida);
            }
            transformer.transform (source, result);
            return;
        } catch (Exception e) {
        	m05bFileLog miLog = new m05bFileLog();
        	miLog.addTraza(e);	
            return;
        }         
    }          
   


   
    public static String print (Node documento) {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance ();
            Transformer transformer = transformerFactory.newTransformer ();

            transformer.setOutputProperty(OutputKeys.METHOD,"xml");
            transformer.setOutputProperty(OutputKeys.ENCODING,"UTF-8");
            transformer.setOutputProperty(OutputKeys.VERSION,"1.0");

            DOMSource source = new DOMSource (documento);    
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            StreamResult result = new StreamResult (stream); 

            transformer.transform (source, result);
            return (stream.toString ());
        } catch (Exception e) {
        	m05bFileLog miLog = new m05bFileLog();
        	miLog.addTraza(e);	
            return ("Error al Imprimir el Documento como String");
        }         
    }
 }