package m05bIdioma;
/*
 * Creacion: 07/07/2005
 */

import java.util.Locale;
import java.util.ResourceBundle;

import m05bClasses.m05bConstantes;
import m05bClasses.m05bConstantesInformes;
import m05bClasses.m05bConstantesPaginas;
import m05bClasses.m05bFileLog;
/**
 *  Esta clase representa una configuracin especfica para una regin.
 */
public class m05bCResources {
	
    private ResourceBundle cRecursos = null;
	private Locale locale =null;
	private Locale currentLocale = null;
	private Locale[] supportedLocales ={new Locale("",m05bConstantesInformes.CASTELLANO),new Locale("eu","EU")};
	private String idioma = "";
	
	m05bFileLog miLog = new m05bFileLog();
	
    //HttpSession session = request.getSession(true);
  	//private Locale locale = (Locale) (session.getAttribute("IdiomaActual"));
    //private Locale locale = Locale.getDefault();
    
	private String cresName = m05bConstantesPaginas.PATH_ETIQUETAS_C;
	//private String cresCMName = m05bConstantesPaginas.PATH_CMIGAS_C;
	//private String cresTitName = m05bConstantesPaginas.PATH_TITULOS_C;

	
    private String descIdioma;
  
    /**
     *  Construye un nueva configuracin de regin.
     */
    public m05bCResources() {
    }
  
    /**
     *  Construye un nueva configuracin de regin con una configuracin loc
     *  @param  loc     configuracion local
     */
    public m05bCResources(Locale loc) {
    	locale = loc;
    }

    /**
     *  Construye un nueva configuracin de regin con una configuracin loc
     *  y un fichero de configuracin resName
     *  @param  loc     configuracion local.
     *  @param  resName fichero de configuracin.
     */
    public m05bCResources(Locale loc, String resName) {
  	    locale = loc;
    	cresName = resName;
    }          
    
    /**
     *  Obtiene una etiqueta astrClave de la configuracin regional.
     *  @param  String  tipo de fichero de configuracin.
     *  @param  String  valor de la caracterstica buscada.
     */
    public String get(String astrTipo, String astrClave) {
	    String lstrValor = "";
	    try {    
	    	if (astrTipo.equals("E")) {
				cresName=m05bConstantesPaginas.PATH_ETIQUETAS_C;
	    	} else if (astrTipo.equals("CM")) {
				cresName=m05bConstantesPaginas.PATH_CMIGAS_C;
	    	} else if (astrTipo.equals("T")) {
				cresName=m05bConstantesPaginas.PATH_TITULOS_C;
	    	}
            miLog.addTraza("persona","CResources","GET TIPO: "  + astrTipo, m05bConstantes.LOG_NIVEL_BAJO);
            miLog.addTraza("persona","CResources","GET FICHERO: "  + cresName, m05bConstantes.LOG_NIVEL_BAJO);
	  	    //loadResources(cresName);
            miLog.addTraza("persona","CResources","DESPUES LOAD: "  + cresName, m05bConstantes.LOG_NIVEL_BAJO);
	  	    lstrValor = cRecursos.getString (astrClave);
            miLog.addTraza("persona","CResources","DESPUES GET STRING: "  + astrClave, m05bConstantes.LOG_NIVEL_BAJO);
	  	    
	    } catch (Exception e) {
               	miLog.addTraza("persona","CResources","GET ETIQ - REFERENCIA ERRONEA EN FICHERO DE CONFIGURACION: "  + e, m05bConstantes.LOG_NIVEL_BAJO);
        }
	    
	  return lstrValor;
    }
    
    
    /**
     *  Obtiene un camino de migas astrClave de la configuracin regional.
     *  @param  String  valor de la caracterstica buscada.
     */
  /*  public String getCM(String astrClave) {
	    String lstrValor = "";
	    try {    
	  	    loadResources(cresCMName);
            miLog.addTraza("persona","CResources","GET CM - PROPERTIES: "  + cresCMName, m05bConstantes.LOG_NIVEL_BAJO);
	  	    lstrValor = cRecursos.getString (astrClave);
	    } catch (Exception e) {
            miLog.addTraza("persona","CResources","GET CM - REFERENCIA ERRONEA EN FICHERO DE CONFIGURACION: " + e, m05bConstantes.LOG_NIVEL_BAJO);
        }
	    
	  return lstrValor;
    }*/
    
    
    /**
     *  Obtiene un ttulo astrClave de la configuracin regional.
     *  @param  String  valor de la caracterstica buscada.
     */
 /*   public String getTit(String astrClave) {
	    String lstrValor = "";
	    try {    
	  	    loadResources(cresTitName);
            miLog.addTraza("persona","CResources","GET TIT - PROPERTIES: " + cresTitName, m05bConstantes.LOG_NIVEL_BAJO);
	  	    lstrValor = cRecursos.getString (astrClave);
	    } catch (Exception e) {
            	miLog.addTraza("persona","CResources","GET TIT - REFERENCIA ERRONEA EN FICHERO DE CONFIGURACION: " + e, m05bConstantes.LOG_NIVEL_BAJO);
        }
	    
	  return lstrValor;
    }*/
    
    
    /**
     *  Carga una configuracin de regin a partir de los parmetros definidos
     *  de regin y fichero de configuracin.
     */
    private void loadResources(String tipo) {
            	miLog.addTraza("persona","CResources","LOAD RESOURCES - TIPO: " + tipo, m05bConstantes.LOG_NIVEL_BAJO);
	
	//	idioma = (String)session.getAttribute("IdiomaActual");

//		if (idioma.equals("ES")) { 
			currentLocale = supportedLocales[0];
	/*	} 
		else (idioma.equals("EU")) {
			currentLocale = supportedLocales[1];
		}*/
            	
            	miLog.addTraza("persona","CResources","LOAD RESOURCES - currentLocale: " + currentLocale, m05bConstantes.LOG_NIVEL_BAJO);
  	    if (cRecursos == null)  {
            	miLog.addTraza("persona","CResources","LOAD RESOURCES - cRecursos antes " , m05bConstantes.LOG_NIVEL_BAJO);
  		    cRecursos = ResourceBundle.getBundle(tipo,currentLocale);
            	miLog.addTraza("persona","CResources","LOAD RESOURCES - cRecursos despues " , m05bConstantes.LOG_NIVEL_BAJO);
  		    
  	    } else {
            	miLog.addTraza("persona","CResources","LOAD RESOURCES - cRecursos NO NULO: " + cRecursos, m05bConstantes.LOG_NIVEL_BAJO);
  	    }
    }
    
    public void setIdiomaActual(String idioma) { 
        descIdioma = idioma;
    }  
    
    public String getIdiomaActual() {
        return descIdioma;
    }            
    
  /*  public void main(String args[]) {
       	miLog.addTraza("persona","CResources","MAIN" + cRecursos, m05bConstantes.LOG_NIVEL_BAJO);
		m05bCResources res = new m05bCResources(new Locale("ES",""));
	}*/
}