package m05bDaos;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.apache.log4j.Logger;

import m05bClasses.m05bConexion;
import m05bClasses.m05bConstantesInformes;
import n05bModelosVistas.m05bAsignacion;
import n05bModelosVistas.m05bOption;
import n05bModelosVistas.m05bVehiculoV;

/**
 * 
 * @author iaizpurl
 * 
 */
public class m05bVistaVehiculosDao extends m05bPaginator {
	public static final int B1 = 0;
	public static final int B2 = 1;
	public static final int C = 2;
	public static final int CA = 3;
	public static final int CB = 4;
	public static final int CV = 5;
	public static final int D1 = 6;
	public static final int D2 = 7;

	private static m05bVistaVehiculosDao instance = null;

	private static Logger logger;

	public static m05bVistaVehiculosDao getInstance() {
		if (instance == null) {
			synchronized (m05bVistaVehiculosDao.class) {
				if (instance == null) {
					instance = new m05bVistaVehiculosDao();
					logger = Logger.getLogger(instance.getClass());
					// PropertyConfigurator.configure(
					// t64bGlobalContainer.LOGGERCONF);
				}
			}
		}

		return instance;
	}

	private void imprimirError(Exception e) {
		StackTraceElement[] stackTraceElements = Thread.currentThread()
				.getStackTrace();
		for (StackTraceElement stackTrace : stackTraceElements) {
			logger.error(stackTrace.getClassName() + "  "
					+ stackTrace.getMethodName() + " "
					+ stackTrace.getLineNumber());
		}
	}

	/**
	 * Crea la select bsica para vehiculos
	 * 
	 * @return
	 */
	private StringBuffer getMainSQL(String idioma) {
		String formatoFecha="";
		String campoTexto="";
		String campoTexto2="";
		if(idioma.equals(m05bConstantesInformes.CASTELLANO)){
			formatoFecha="dd/MM/yyyy";
		}
		else{
			formatoFecha="yyyy/MM/dd";
			campoTexto="E";
			campoTexto2="E_";
		}
		
		StringBuffer strsql = new StringBuffer();
		strsql.append("SELECT MATRIC_34 AS MATRICULA ,");
		strsql.append(" B.DESCRIP_99   AS MARCA ,");
		strsql.append(" DESCRIP_17     AS MODELO ,");
		strsql.append(" NVL(A.");
		strsql.append(campoTexto);
		strsql.append("DESCRIP_99 ,A.DESCRIP_99 )  ");
		strsql.append("AS RANGOVEHICULO ,");
		strsql.append(" RANGO_34       AS CODRANGO,");
		strsql.append("FALTA_34   AS FECHA_ALTA ,");
		strsql.append(" FMATRIC_34 AS FECHA_MATRICULA ,");
		strsql.append(" FBAJA_34   AS FECHA_BAJA ,");
		strsql.append(" OBSERV_34      AS NOTAS ,");
		strsql.append(" D.DESCRIP_99   AS SITUACION ,");
		strsql.append(" SITUACION_34   AS CODSITUACION,NVL(");
		strsql.append(campoTexto2);
		strsql.append("DESCRIP_06 ,DESCRIP_06 )    AS DEPARTAMENTO ,");
		strsql.append(" codDpto_34     AS CODDPTO,");
		strsql.append(" PRECIO_34     AS PRECIO_EUROS,");
		strsql.append(" MOTIVBAJA_34  AS MOTIVO_BAJA ");
		strsql.append(" FROM M0534S00_VEHICULOS,M0506T00,");
		strsql.append(" M0517S00_MODELOS,");
		strsql.append(" M0599S00_DESCRIPCIONES D,");
		// strsql.append(" M0599S00_DESCRIPCIONES C,");
		strsql.append(" M0599S00_DESCRIPCIONES B,");
		strsql.append(" M0599S00_DESCRIPCIONES A");
		strsql.append(" WHERE codDpto_34=cod_dpto_06 and RANGO_34     =A.COD_DESC_99");
		strsql.append(" AND A.COD_TAB_99   =11");
		strsql.append(" AND MARCA_34       =B.COD_DESC_99");
		strsql.append(" AND B.COD_TAB_99   =7");
		// strsql.append(" AND COLOR_34       =C.COD_DESC_99(+)");
		// strsql.append(" AND C.COD_TAB_99(+)=1");
		strsql.append(" AND COD_MOD_17     =COD_MOD_34");
		strsql.append(" AND SITUACION_34   =D.COD_DESC_99");
		strsql.append(" AND D.COD_TAB_99   =9 ");
		return strsql;

	}

	private StringBuffer getCochesMainSQL() {
		StringBuffer strsql = new StringBuffer();
		strsql.append("SELECT DEPARTAMENTO,  MATRICULA,  MARCA,  FECHA_MATRICULA,  RANGOVEHICULO,  FECHA_ALTA,  MODELO,  SITUACION,  KM_ACTUALES FROM M0534V00");
		return strsql;

	}
	/**
	 * Crea la para obtener los vehculos por situacion, rango y departamento
	 * @param situaciones
	 * @param rangos
	 * @param departamentos
	 * @return
	 */
	private StringBuffer getSqlVehiculosTipo(String[] situaciones,
			String[] rangos, String[] departamentos,String idioma) {
		StringBuffer strsql = new StringBuffer();
		String formatoFecha="";
		String campoTexto="";
		String campoTexto2="";
		if(idioma.equals(m05bConstantesInformes.CASTELLANO)){
			formatoFecha="dd/MM/yyyy";
		}
		else{
			formatoFecha="yyyy/MM/dd";
			campoTexto="E";
			campoTexto2="E_";
		}
		
		strsql.append("SELECT matric_34 AS matricula,  B.DESCRIP_99    AS MARCA ,");
		strsql.append("    DESCRIP_17      AS MODELO ,");
		strsql.append("    NVL(A.");
		strsql.append(campoTexto);
		strsql.append("DESCRIP_99,A.DESCRIP_99)    AS RANGOVEHICULO ,");
		strsql.append("    fmatric_34      AS fecha_matricula,");
		strsql.append("    FALTA_34        AS FECHA_ALTA, NVL(");
		strsql.append(campoTexto2);
		strsql.append("DESCRIP_06 ,DESCRIP_06)    AS DEPARTAMENTO ,");
		strsql.append("    CODDPTO_34      AS CODDEPARTAMENTO ,");
		strsql.append("    SITUACION_34    AS codSituacion,");
		strsql.append("    NVL(D.");
		strsql.append(campoTexto);
		strsql.append("DESCRIP_99,D.DESCRIP_99)   AS SITUACION ,");
		strsql.append("    KM_ACT_34      AS KM_ACTUALES");
		strsql.append("  FROM M0534T00,M0506T00,");
		strsql.append("    M0517T00,");
		strsql.append("    M0599T00 D,");
		strsql.append("    M0599T00 B,");
		strsql.append("    M0599T00 A");
		strsql.append("  WHERE codDpto_34=cod_dpto_06 and RANGO_34   =A.COD_DESC_99");
		strsql.append("  AND A.COD_TAB_99 =11");
		strsql.append("  AND MARCA_34     =B.COD_DESC_99");
		strsql.append("  AND B.COD_TAB_99 =7");
		strsql.append("  AND SITUACION_34   =D.COD_DESC_99");
		strsql.append("  AND D.COD_TAB_99 =9");
		strsql.append("  AND COD_MOD_17   =COD_MOD_34 ");
		strsql.append(stringArrayToSqlIn("SITUACION_34", "AND", situaciones));
		strsql.append(stringArrayToSqlIn("RANGO_34", "AND", rangos));
		strsql.append(stringArrayToSqlIn("CODDPTO_34", "AND", departamentos));
		strsql.append(" ORDER BY DEPARTAMENTO,MATRICULA");
		return strsql;

	}

	/**
	 * Devuelve la where con la SQL de coches por tipo
	 * 
	 * @param tipo
	 * @return
	 */
	private StringBuffer getCochesSQLWhere(String[] tipos, String[] situaciones) {
		StringBuffer strsql = new StringBuffer();
		int tipo;
		strsql.append(" WHERE 1=1 ");
		if (tipos != null) {
			strsql.append(" AND (");
			for (int i = 0; i < tipos.length; i++) {
				tipo = Integer.parseInt(tipos[i]);
				if (i != 0)
					strsql.append(" OR ");
				strsql.append(" RANGOVEHICULO ");
				switch (tipo) {
				case m05bVistaVehiculosDao.B1:
					strsql.append("LIKE 'VICE%'");
					break;
				case m05bVistaVehiculosDao.B2:
					strsql.append("LIKE 'DIREC%'");
					break;
				case m05bVistaVehiculosDao.C:
					strsql.append("='DISPOSICIN - RGANOS ADMINISTRATIVOS'");
					break;
				case m05bVistaVehiculosDao.CA:
					strsql.append("='DISPOSICION ALTA REPRESENTACIN'");
					break;
				case m05bVistaVehiculosDao.CB:
					strsql.append("='DISPOSICION-DIRECTORES'");
					break;
				case m05bVistaVehiculosDao.CV:
					strsql.append("='DISPOSICION-VICECONSEJEROS'");
					break;
				case m05bVistaVehiculosDao.D1:
					strsql.append("='PERMANENTES - RGANOS ADMINISTRATIVOS'");
					break;
				case m05bVistaVehiculosDao.D2:
					strsql.append("='VEH. ESPECIALES'");
					break;
				}
			}
			strsql.append(" ) ");
		}
		strsql.append(stringArrayToSqlIn("SITUACION", "AND", situaciones));
		return strsql;
	}

	/**
	 * SQL de listado general
	 * 
	 * @param situaciones
	 * @return
	 */
	private StringBuffer getListadoGeneral(String[] situaciones) {
		StringBuffer strsql = new StringBuffer();
		strsql.append("SELECT DEPARTAMENTO, MATRICULA,  MARCA,  FECHA_MATRICULA, RANGOVEHICULO, FECHA_ALTA, MODELO, SITUACION, KM_ACTUALES");
		strsql.append(" FROM M0534V00 ");
		if (situaciones != null) {
			strsql.append(" WHERE");
			strsql.append(stringArrayToSqlIn("SITUACION", "", situaciones));
		}
		strsql.append(" ORDER BY DEPARTAMENTO, FECHA_MATRICULA ");
		return strsql;
	}

	// select distinct Marca_17 as marca_id, count(descrip_99) as num,
	// descrip_99 as marca
	// from (M0517T00 inner join M0599T00 on
	// M0517T00.MARCA_17=M0599T00.COD_DESC_99 ) inner join M0534S00_VEHICULOS on
	// COD_MOD_17 =COD_MOD_34
	// where M0599T00.COD_TAB_99 =7 group by Marca_17, descrip_99
	// order by num desc,marca;
	//
	// select distinct
	// descrip_17 as modelo,
	// m0517t00.cod_mod_17 as modelo_id,
	// Marca_17 as marca_id,
	// count(descrip_17) as num
	// from (M0517T00 inner join M0599T00 on
	// M0517T00.MARCA_17=M0599T00.COD_DESC_99 ) inner join M0534S00_VEHICULOS on
	// COD_MOD_17 =COD_MOD_34
	// where M0599T00.COD_TAB_99 =7
	// and MARCA_17 in (32,10)
	// group by descrip_17, m0517t00.cod_mod_17, Marca_17
	// order by marca_id,num desc, modelo;
	/**
	 * Crea parte de la where para filtrar el cambio nombre si est en array
	 * 
	 * @param nombre
	 * @param bool
	 * @param array
	 * @return
	 */
	private StringBuffer stringArrayToSqlIn(String nombre, String bool,
			String[] array) {
		StringBuffer strsql = new StringBuffer();
		if (array != null) {
			strsql.append(bool);
			strsql.append(" ");
			strsql.append(nombre);
			strsql.append(" in('");
			boolean first = true;
			for (String element : array) {
				if (!first)
					strsql.append(",'");

				strsql.append(element + "'");
				first = false;

			}
			strsql.append(")");

		}
		return strsql;

	}

	/**
	 * Ejecuta una una select sobre la vista vehiculos (M0534V00) y devuelve una
	 * lista de vehiculos dados de alta a partir del ao de entrada y con las
	 * situaciones de entrada
	 * 
	 * @param anio
	 * @param situaciones
	 */
	public ArrayList<m05bVehiculoV> altasPorAnio(int anio,
			String[] situaciones, String idioma, int numPagina) {

		ArrayList<m05bVehiculoV> resultado = null;
		PreparedStatement stmt = null;
		ResultSet rs = null;
		StringBuffer strsql = new StringBuffer();
		Connection m_Connection = null;
		try {

			String fecha = "" + anio;
			// String fecha2 = "31/12/" + anio;
			// strsql.append("SELECT DEPARTAMENTO, MATRICULA, MARCA, MODELO, FECHA_MATRICULA,FECHA_ALTA,SITUACION,RANGOVEHICULO ");
			// strsql.append(" FROM M0534V00");

			strsql.append(getMainSQL(idioma));
			strsql.append(" AND to_char(FALTA_34, 'YYYY') =?");
			// strsql.append(" AND FALTA_34<=to_date(?,'dd/MM/yyyy')");
			strsql.append(stringArrayToSqlIn("SITUACION_34", "AND", situaciones));
			strsql.append(" ORDER BY DEPARTAMENTO, FECHA_MATRICULA");
			// ////System.out.println(strsql.toString());

			resultado = new ArrayList<m05bVehiculoV>();
			m05bVehiculoV current;
			// Prueba de paginacin
			if (numPagina == m05bPaginator.INITPAGE) {
				int cuenta = 0;

				cuenta = contarRegistros(strsql, anio);
				current = new m05bVehiculoV();
				current.setKmActuales((int) Math.ceil((double) cuenta
						/ m05bPaginator.PAGESIZE));
				resultado.add(current);
				numPagina = 1;
			}
			if (numPagina != m05bPaginator.NO) {

				strsql = paginar(strsql, numPagina);
			}

			m05bConexion miConex = new m05bConexion();
			m_Connection = miConex.getConnection();
			stmt = m_Connection.prepareStatement(strsql.toString());
			stmt.setString(1, fecha);
			// stmt.setString(2, fecha2);
			logger.info("Ejecutando sql" + strsql.toString());
			rs = stmt.executeQuery();

			while (rs.next()) {
				current = new m05bVehiculoV();
				current.setDepartamento(rs.getString("DEPARTAMENTO"));
				current.setMatricula(rs.getString("MATRICULA"));
				current.setMarca(rs.getString("MARCA"));
				current.setModelo(rs.getString("MODELO"));
				current.setFechaMatricula(rs.getDate("FECHA_MATRICULA"));
				current.setFechaAlta(rs.getDate("FECHA_ALTA"));
				current.setSituacion(rs.getString("SITUACION"));
				current.setRangoVehiculo(rs.getString("RANGOVEHICULO"));
				current.setPrecio(rs.getDouble("PRECIO_EUROS"));
				resultado.add(current);
			}

			stmt.close();
		} catch (Exception e) {
			
			imprimirError(e);
			logger.info("Cerrando conexin");
		} finally {
			try {
				logger.info("Cerrando conexin");
				m_Connection.close();
				logger.info("Conexin cerrada");
			} catch (Exception e) {
				imprimirError(e);
			}
		}
		return resultado;
	}

	/**
	 * Ejecuta una una select sobre la vista vehiculos (M0534V00) y devuelve una
	 * lista de vehiculos dados de alta a partir del ao de entrada y con las
	 * situaciones de entrada
	 * 
	 * @param anio
	 * @param situaciones
	 */
	public ArrayList<m05bVehiculoV> listadoGeneral(String[] situaciones,
			String idioma, int numPagina) {

		ArrayList<m05bVehiculoV> resultado = null;
		PreparedStatement stmt = null;
		ResultSet rs = null;
		StringBuffer strsql = new StringBuffer();
		Connection m_Connection = null;
		try {

			// strsql.append("SELECT DEPARTAMENTO, MATRICULA, MARCA, MODELO, FECHA_MATRICULA,FECHA_ALTA,SITUACION,RANGOVEHICULO ");
			// strsql.append(" FROM M0534V00");

			strsql.append(getListadoGeneral(situaciones));

			m05bVehiculoV current;
			resultado = new ArrayList<m05bVehiculoV>();
			// Prueba de paginacin
			if (numPagina == m05bPaginator.INITPAGE) {
				int cuenta = 0;

				cuenta = contarRegistros(strsql);
				current = new m05bVehiculoV();
				current.setKmActuales((int) Math.ceil((double) cuenta
						/ m05bPaginator.PAGESIZE));
				resultado.add(current);
				numPagina = 1;
			}
			if (numPagina != m05bPaginator.NO) {

				strsql = paginar(strsql, numPagina);
			}
			// System.out.println(strsql.toString());
			m05bConexion miConex = new m05bConexion();
			m_Connection = miConex.getConnection();
			stmt = m_Connection.prepareStatement(strsql.toString());

			logger.info("Ejecutando sql" + strsql.toString());
			rs = stmt.executeQuery();

			while (rs.next()) {
				current = new m05bVehiculoV();
				current.setDepartamento(rs.getString("DEPARTAMENTO"));
				current.setMatricula(rs.getString("MATRICULA"));
				current.setMarca(rs.getString("MARCA"));
				current.setModelo(rs.getString("MODELO"));
				current.setFechaMatricula(rs.getDate("FECHA_MATRICULA"));
				current.setFechaAlta(rs.getDate("FECHA_ALTA"));
				current.setSituacion(rs.getString("SITUACION"));
				current.setRangoVehiculo(rs.getString("RANGOVEHICULO"));
				current.setKmActuales(rs.getInt("KM_ACTUALES"));
				resultado.add(current);
			}

			stmt.close();
		} catch (Exception e) {
			imprimirError(e);
			logger.info("Cerrando conexin");
		} finally {
			try {
				logger.info("Cerrando conexin");
				m_Connection.close();
				logger.info("Conexin cerrada");
			} catch (Exception e) {
				imprimirError(e);

			}
		}
		return resultado;
	}

	/**
	 * Ejecuta una una select sobre la vista vehiculos (M0534V00) y devuelve una
	 * lista de vehiculos dados de alta a partir del ao de entrada y con las
	 * situaciones de entrada
	 * 
	 * @param anio
	 * @param situaciones
	 */
	public ArrayList<m05bVehiculoV> cocherPorTipo(String[] rangos,
			String[] situaciones, String[] departamentos, String idioma,
			int numPagina) {

		ArrayList<m05bVehiculoV> resultado = null;
		PreparedStatement stmt = null;
		ResultSet rs = null;
		StringBuffer strsql = new StringBuffer();
		Connection m_Connection = null;
		try {
			m05bVehiculoV current;
			resultado = new ArrayList<m05bVehiculoV>();
			strsql = getSqlVehiculosTipo(situaciones, rangos, departamentos,idioma);
			if (numPagina == m05bPaginator.INITPAGE) {
				int cuenta = 0;
				cuenta = contarRegistros(strsql);
				current = new m05bVehiculoV();
				current.setNumeroPaginas((int) Math.ceil((double) cuenta
						/ m05bPaginator.PAGESIZE));
				current.setNumeroRegistros(cuenta);
				resultado.add(current);
				numPagina = 1;
			}
			if (numPagina != m05bPaginator.NO) {

				strsql = paginar(strsql, numPagina);
			}

			// ////System.out.println(strsql.toString());
			m05bConexion miConex = new m05bConexion();
			m_Connection = miConex.getConnection();
			stmt = m_Connection.prepareStatement(strsql.toString());
			logger.info("Ejecutando sql" + strsql.toString());
			rs = stmt.executeQuery();

			while (rs.next()) {
				current = new m05bVehiculoV();
				current.setDepartamento(rs.getString("DEPARTAMENTO"));
				current.setMatricula(rs.getString("MATRICULA"));
				current.setMarca(rs.getString("MARCA"));
				current.setModelo(rs.getString("MODELO"));
				current.setFechaMatricula(rs.getDate("FECHA_MATRICULA"));
				current.setFechaAlta(rs.getDate("FECHA_ALTA"));
				current.setSituacion(rs.getString("SITUACION"));
				current.setRangoVehiculo(rs.getString("RANGOVEHICULO"));
				current.setKmActuales(rs.getInt("KM_ACTUALES"));
				resultado.add(current);
			}
			stmt.close();
		} catch (Exception e) {
			
			imprimirError(e);
			logger.info("Cerrando conexin");
		} finally {
			try {
				logger.info("Cerrando conexin");
				m_Connection.close();
				logger.info("Conexin cerrada");
			} catch (Exception e) {
				imprimirError(e);

			}
		}
		return resultado;
	}

	/**
	 * Ejecuta una una select sobre la vista vehiculos (M0534V00) y devuelve una
	 * lista de vehiculos dados de alta a partir del ao de entrada y con las
	 * situaciones de entrada
	 * 
	 * @param anio
	 * @param situaciones
	 */
	public ArrayList<m05bVehiculoV> bajasPorAnio(int anio,
			String[] listadepartamentos, String[] listarangos, String idioma,
			int numPagina) {

		ArrayList<m05bVehiculoV> resultado = null;
		PreparedStatement stmt = null;
		ResultSet rs = null;
		StringBuffer strsql = new StringBuffer();
		Connection m_Connection = null;
		try {

			String fecha = "" + anio;
			// String fecha2 = "31/12/" + anio;
			// strsql.append("SELECT DEPARTAMENTO, MATRICULA, MARCA, MODELO, FECHA_MATRICULA,FECHA_ALTA,SITUACION,RANGOVEHICULO ");
			// strsql.append(" FROM M0534V00");

			strsql.append(getMainSQL(idioma));
			strsql.append(" AND to_char(FBAJA_34, 'YYYY') =?");
			// strsql.append(" AND FBAJA_34<=to_date(?,'dd/MM/yyyy')");
			strsql.append(stringArrayToSqlIn("codDpto_34", "AND",
					listadepartamentos));
			strsql.append(stringArrayToSqlIn("RANGO_34", "AND", listarangos));
			strsql.append(" ORDER BY DEPARTAMENTO, FECHA_MATRICULA");
			// ////System.out.println(strsql.toString());
			m05bConexion miConex = new m05bConexion();
			m_Connection = miConex.getConnection();
			stmt = m_Connection.prepareStatement(strsql.toString());
			stmt.setString(1, fecha);
			// stmt.setString(2, fecha2);
			logger.info("Ejecutando sql" + strsql.toString());
			rs = stmt.executeQuery();
			m05bVehiculoV current;
			resultado = new ArrayList<m05bVehiculoV>();
			while (rs.next()) {
				current = new m05bVehiculoV();
				current.setDepartamento(rs.getString("DEPARTAMENTO"));
				current.setMatricula(rs.getString("MATRICULA"));
				current.setMarca(rs.getString("MARCA"));
				current.setModelo(rs.getString("MODELO"));
				current.setFechaMatricula(rs.getDate("FECHA_MATRICULA"));
				current.setFechaBaja(rs.getDate("FECHA_BAJA"));
				current.setSituacion(rs.getString("SITUACION"));
				current.setRangoVehiculo(rs.getString("RANGOVEHICULO"));
				current.setMotivoBaja(rs.getString("MOTIVO_BAJA"));
				resultado.add(current);
			}

			stmt.close();
		} catch (Exception e) {
			imprimirError(e);
			logger.info("Cerrando conexin");
		} finally {
			try {
				logger.info("Cerrando conexin");
				m_Connection.close();
				logger.info("Conexin cerrada");
			} catch (Exception e) {
				imprimirError(e);

			}
		}
		return resultado;
	}

	/**
	 * Ejecuta una una select sobre la vista vehiculos (M0534V00) y devuelve una
	 * lista con todos los distintos aos de fecha de alta
	 * 
	 */
	public ArrayList<m05bOption> getAniosAlta() {
		return getOptions("select distinct extract(year from FECHA_ALTA) as val , extract(year from FECHA_ALTA) as text  from M0534V00 order by val desc");
	}

	/**
	 * Ejecuta una una select sobre la vista vehiculos (M0534V00) y devuelve una
	 * lista con todos los distintos aos de fecha de baja
	 * 
	 */
	public ArrayList<m05bOption> getAniosBaja() {
		return getOptions("select distinct extract(year from FECHA_BAJA) as val , extract(year from FECHA_BAJA) as text  from M0534V00 where fecha_baja is not null order by val desc");
	}

	/**
	 * Ejecuta una una select sobre la vista vehiculos (M0534V00) y devuelve una
	 * lista con todos los distintos aos de fecha de matriculacion
	 * 
	 */
	public ArrayList<m05bOption> getAniosMatriculacion() {
		return getOptions("select distinct extract(year from FECHA_MATRICULA) as val , extract(year from FECHA_MATRICULA) as text  from M0534V00 order by val desc");
	}

	/**
	 * Ejecuta una una select sobre la vista vehiculos (M0534V00) y devuelve una
	 * lista con todos los distintos aos
	 * 
	 */
	public ArrayList<m05bOption> getSituaciones(String idioma, int numPagina) {
		StringBuffer strsql= new StringBuffer("select distinct SITUACION_34 as val,  NVL(");
		if(!idioma.equals(m05bConstantesInformes.CASTELLANO))
			strsql.append("E");
		strsql.append("DESCRIP_99,DESCRIP_99) as text from M0534S00_VEHICULOS inner join M0599T00 on  M0534S00_VEHICULOS.SITUACION_34=M0599T00.COD_DESC_99 where COD_TAB_99=9 order by ");
	
		strsql.append(" text");
		return getOptions(strsql.toString());
	}
	/**
	 * Devuelve una lista de situaciones por los parametros 
	 * @param situaciones
	 * @param idioma
	 * @param numPagina
	 * @return
	 */
	public ArrayList<m05bOption> getSituaciones(String  [] situaciones,String idioma, int numPagina) {
		StringBuffer strsql= new StringBuffer("select distinct SITUACION_34 as val, NVL( ");
		if(!idioma.equals(m05bConstantesInformes.CASTELLANO))
			strsql.append("E");
		strsql.append("DESCRIP_99 ,DESCRIP_99)as text from M0534S00_VEHICULOS inner join M0599T00 on  M0534S00_VEHICULOS.SITUACION_34=M0599T00.COD_DESC_99 where COD_TAB_99=9 ");
		strsql.append(stringArrayToSqlIn("SITUACION_34", "AND", situaciones));
		strsql.append(" order by ");
	
		strsql.append(" text");		
		return getOptions(strsql.toString());
	}
	/**
	 * Devuelve una lista de los rangos disponibles
	 * 
	 */
	public ArrayList<m05bOption> getRangos(String idioma, int numPagina) {
		StringBuffer strsql=new StringBuffer ("select distinct RANGO_34  as val, RANGO_34 || ' - ' || NVL(");
		if(!idioma.equals(m05bConstantesInformes.CASTELLANO))
			strsql.append("E");
		strsql.append("DESCRIP_99,DESCRIP_99) as text from M0534S00_VEHICULOS inner join M0599T00 on  M0534S00_VEHICULOS.RANGO_34=M0599T00.COD_DESC_99 where COD_TAB_99=11 order by RANGO_34");
		return getOptions(strsql.toString());
	}
	/**
	 * Devuelve una lista de rangos segn los parametros de entrada
	 * @param rangos
	 * @param idioma
	 * @param numPagina
	 * @return
	 */
	public ArrayList<m05bOption> getRangos(String[] rangos,String idioma, int numPagina) {
		StringBuffer strsql= new StringBuffer("select distinct RANGO_34  as val, RANGO_34 || ' - ' || NVL(");
		if(!idioma.equals(m05bConstantesInformes.CASTELLANO))
			strsql.append("E");
		strsql.append("DESCRIP_99,DESCRIP_99) as text from M0534S00_VEHICULOS inner join M0599T00 on  M0534S00_VEHICULOS.RANGO_34=M0599T00.COD_DESC_99 where COD_TAB_99=11");
		strsql.append(stringArrayToSqlIn("RANGO_34", "AND", rangos));
		strsql.append(" order by RANGO_34");		
		return getOptions(strsql.toString());
	}
	/**
	 * Devuelve una lista de los rangos disponibles
	 * 
	 */
	public ArrayList<m05bOption> getDepartamentos(String idioma, int numPagina) {
		StringBuffer strsql= new StringBuffer(" select distinct NVL(");
		if(!idioma.equals(m05bConstantesInformes.CASTELLANO))
			strsql.append("E_");
		strsql.append("DESCRIP_06,DESCRIP_06) as text, coddpto_34 as val  FROM M0534T00 inner join m0506t00 on coddpto_34=cod_dpto_06");
		return getOptions(strsql.toString());
	}
	/**
	 * Devuelve una lista de departamentos segn que tengan los codigos de entrada
	 * @param departamentos
	 * @param idioma
	 * @param numPagina
	 * @return
	 */
	public ArrayList<m05bOption> getDepartamentos(String [] departamentos,String idioma, int numPagina) {
		StringBuffer strsql= new StringBuffer(" select distinct NVL(");
		if(!idioma.equals(m05bConstantesInformes.CASTELLANO))
			strsql.append("E_");
		strsql.append("DESCRIP_06,DESCRIP_06) as text, coddpto_34 as val  FROM M0534T00 inner join m0506t00 on coddpto_34=cod_dpto_06 ");
		strsql.append(stringArrayToSqlIn("coddpto_34", "AND", departamentos));
		strsql.append(" order by ");
	
		strsql.append(" text");		
		return getOptions(strsql.toString());
	}
	/**
	 * Devuelve la lista de marcas
	 * 
	 * @return
	 */
	public ArrayList<m05bOption> getMarcas() {
		StringBuffer strsql = new StringBuffer();
		strsql.append("select distinct Marca_17 as val, count(descrip_99) as num,");
		strsql.append(" descrip_99 as text");
		strsql.append(" from (M0517T00 inner join M0599T00 on M0517T00.MARCA_17=M0599T00.COD_DESC_99 ) inner join M0534S00_VEHICULOS on COD_MOD_17     =COD_MOD_34");
		strsql.append(" where M0599T00.COD_TAB_99   =7 group by Marca_17, descrip_99");
		strsql.append("		order by num desc,text");
		// //System.out.println(strsql.toString());
		return getOptions(strsql.toString());
	}
	/**
	 * Devuelve una  lista de marcas que tengan los codigos de marcas
	 * @param marcas
	 * @param idioma
	 * @param numPagina
	 * @return
	 */
	public ArrayList<m05bOption> getMarcas(String [] marcas,String idioma, int numPagina){
		StringBuffer strsql = new StringBuffer();
		strsql.append("select distinct COD_DESC_99 as val, ");
		strsql.append(" descrip_99 as text");
		strsql.append(" from  M0599T00 ");
		strsql.append(" where M0599T00.COD_TAB_99   =7 ");
		strsql.append(stringArrayToSqlIn("COD_DESC_99", "AND", marcas));
		strsql.append("		group by COD_DESC_99, descrip_99");
	//	System.out.println(strsql.toString());
		return getOptions(strsql.toString());
		}
	public ArrayList<m05bOption> getModelos(String marcas) {
		StringBuffer strsql = new StringBuffer();
		strsql.append("select distinct   descrip_17 as text, descrip_17 as val,      m0517t00.cod_mod_17 as modelo_id,    Marca_17 as marca_id,");
		strsql.append(" count(descrip_17) as num ");
		strsql.append(" from (M0517T00 inner join M0599T00 on M0517T00.MARCA_17=M0599T00.COD_DESC_99 ) inner join M0534S00_VEHICULOS on COD_MOD_17     =COD_MOD_34");
		strsql.append(" where M0599T00.COD_TAB_99   =7 ");
		strsql.append(" and MARCA_17 in (");
		strsql.append(marcas);
		strsql.append(") group by descrip_17, m0517t00.cod_mod_17, Marca_17");
		strsql.append(" order by  num desc, text");
		// //System.out.println(strsql.toString());
		return getOptions(strsql.toString());
	}
	public ArrayList<m05bOption> getModelos(String [] modelos) {
		ArrayList<m05bOption> sal= new ArrayList<m05bOption>();
		m05bOption opt;
		for(String next: modelos){
			opt=new m05bOption();
			opt.setText(next);
			opt.setValue(next);
			sal.add(opt);
		}
		return sal;
	}
	/**
	 * Ejecuta una una select sobre la vista vehiculos (M0534V00) y devuelve una
	 * lista con todos los distintos aos
	 * 
	 */
	private ArrayList<m05bOption> getOptions(String sql) {

		ArrayList<m05bOption> resultado = null;
		PreparedStatement stmt = null;
		ResultSet rs = null;
		StringBuffer strsql = new StringBuffer();
		Connection m_Connection = null;
		try {

			strsql.append(sql);

			m05bConexion miConex = new m05bConexion();
			m_Connection = miConex.getConnection();
			stmt = m_Connection.prepareStatement(strsql.toString());

			logger.info("Ejecutando sql" + strsql.toString());
			rs = stmt.executeQuery();

			resultado = new ArrayList<m05bOption>();
			m05bOption current;
			while (rs.next()) {
				current = new m05bOption();
				current.setText(rs.getString("text"));
				current.setValue(rs.getString("val"));
				resultado.add(current);
			}

			stmt.close();
		} catch (Exception e) {
			imprimirError(e);
			logger.info("Cerrando conexin");
		} finally {
			try {
				logger.info("Cerrando conexin");
				m_Connection.close();
				logger.info("Conexin cerrada");
			} catch (Exception e) {
				imprimirError(e);

			}
		}
		return resultado;
	}

}
