package m05bDaos;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import m05bClasses.m05bConexion;
import n05bModelosVistas.m05bSancion;
import org.apache.log4j.Logger;

public class m05bSancionesDao extends m05bPaginator {

	private static m05bSancionesDao instance = null;
	private static Logger logger;

	public static m05bSancionesDao getInstance() {
		if (instance == null) {
			synchronized (m05bSancionesDao.class) {
				if (instance == null) {
					instance = new m05bSancionesDao();
					logger = Logger.getLogger(instance.getClass());
				}
			}
		}
		return instance;
	}

	private void imprimirError(Exception e) {
		StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
		for (StackTraceElement stackTrace : stackTraceElements) {
			logger.error(stackTrace.getClassName() + "  "
					+ stackTrace.getMethodName() + " "
					+ stackTrace.getLineNumber());
		}
	}

	/**
	 * Devuelve el listado de sanciones
	 */
	public ArrayList<m05bSancion> getSanciones(int numPagina, String identificado, int anio, String[] rangos) {
		ArrayList<m05bSancion> resultado = null;
		PreparedStatement stmt = null;
		ResultSet rs = null;
		StringBuffer strsql = new StringBuffer();
		Connection m_Connection = null;
		try {
			strsql.append("select rango_34 RANGO, matric_34 MATRICULA, M.DESCRIP_99  MARCA, DESCRIP_17  MODELO, S.DESCRIP_99 SANCION, TO_CHAR(FDENUNCIA_45, 'YYYY') ANO_DENUNCIA, FSANCION_45 FECHA_SANCION, NEXP_SANCION_45 EXPEDIENTE,DNI_45 DNI");
			strsql.append(" from m0545s00_sanciones, m0534s00_Vehiculos, M0599S00_DESCRIPCIONES S,  M0599S00_DESCRIPCIONES M,M0517S00_MODELOS");
			strsql.append(" where m0534s00_vehiculos.matric_34 = m0545s00_sanciones.matric_45");
			strsql.append(" AND S.COD_TAB_99 = 17 AND TIPO_45 = S.COD_DESC_99");
			strsql.append(" AND M.COD_TAB_99 = 7 AND MARCA_34 = M.COD_DESC_99");
			strsql.append(" AND COD_MOD_34 = COD_MOD_17");

			if (anio > 0) {
				strsql.append(" AND TO_CHAR(FDENUNCIA_45, 'YYYY') = '" + anio + "'");
			}
			if (identificado != null && !identificado.equals("")) {
				if (identificado.equals("0")) {
					strsql.append(" AND DNI_45 IS NULL");
				} else {
					strsql.append(" AND DNI_45 IS NOT NULL");
				}
			}
			if (rangos != null && rangos.length > 0) {
				strsql.append(stringArrayToSqlIn("RANGO_34", " AND", rangos));
			}

			strsql.append(" ORDER BY 1,4");

			logger.info("Ejecutando sql" + strsql.toString());

			m05bSancion current;
			resultado = new ArrayList<m05bSancion>();
			if (numPagina == m05bPaginator.INITPAGE) {
				int cuenta = 0;
				cuenta = contarRegistros(strsql);
				current = new m05bSancion();
				current.setNumeroPaginas((int) Math.ceil((double) cuenta / m05bPaginator.PAGESIZE));
				current.setNumeroRegistros(cuenta);
				resultado.add(current);
				numPagina = 1;
			}
			if (numPagina != m05bPaginator.NO) {
				strsql = paginar(strsql, numPagina);
			}
			m05bConexion miConex = new m05bConexion();
			m_Connection = miConex.getConnection();
			stmt = m_Connection.prepareStatement(strsql.toString());
			rs = stmt.executeQuery();
			while (rs.next()) {
				current= new m05bSancion();
				current.setRango(rs.getString("rango"));
				current.setMatricula(rs.getString("matricula"));
				current.setMarca(rs.getString("marca"));
				current.setModelo(rs.getString("modelo"));
				current.setSancion(rs.getString("sancion"));
				current.setAnioDenuncia(rs.getInt("ANO_DENUNCIA"));
				current.setExpediente(rs.getString("expediente"));
				current.setDni(rs.getString("DNI"));
				current.setFechaSancion(rs.getDate("FECHA_SANCION"));
				resultado.add(current);
			}

			stmt.close();
		} catch (Exception e) {
			imprimirError(e);
			logger.info("Cerrando conexin");
		} finally {
			try {
				logger.info("Cerrando conexin");
				m_Connection.close();
				logger.info("Conexin cerrada");
			} catch (Exception e) {
				imprimirError(e);
			}
		}
		return resultado;
	}

	/**
	 * Crea parte de la where para filtrar el cambio nombre si est en array
	 *
	 * @param nombre
	 * @param bool
	 * @param array
	 * @return
	 */
	private StringBuffer stringArrayToSqlIn(String nombre, String bool, String[] array) {
		StringBuffer strsql = new StringBuffer();
		if (array != null) {
			strsql.append(bool);
			strsql.append(" ");
			strsql.append(nombre);
			strsql.append(" in ('");
			boolean first = true;
			for (String element : array) {
				if (!first)
					strsql.append(",'");

				strsql.append(element + "'");
				first = false;
			}
			strsql.append(") ");
		}
		return strsql;
	}
}