package m05bDaos;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;

import org.apache.log4j.Logger;

import m05bClasses.m05bConexion;
import m05bClasses.m05bConstantesInformes;
import n05bModelosVistas.m05bKilometrajes;
import n05bModelosVistas.m05bOrdenTrabajo;
import n05bModelosVistas.m05bVehiculoV;

public class m05bOrdenesTrabajoDao extends m05bPaginator{
	private static m05bOrdenesTrabajoDao instance = null;

	public static final int TALLERINTERNO = 1;
	public static final int TALLEREXTERNO = 2;
	private static Logger logger;

	public static m05bOrdenesTrabajoDao getInstance() {
		if (instance == null) {
			synchronized (m05bOrdenesTrabajoDao.class) {
				if (instance == null) {
					instance = new m05bOrdenesTrabajoDao();
					logger = Logger.getLogger(instance.getClass());
					// PropertyConfigurator.configure(
					// t64bGlobalContainer.LOGGERCONF);
				}
			}
		}

		return instance;
	}
	private void imprimirError(Exception e) {
		StackTraceElement[] stackTraceElements = Thread.currentThread()
				.getStackTrace();
		for (StackTraceElement stackTrace : stackTraceElements) {
			logger.error(stackTrace.getClassName() + "  "
					+ stackTrace.getMethodName() + " "
					+ stackTrace.getLineNumber());
		}
	}
	/**
	 * Devuelve las sql de ordenes de trabajo detalle
	 * 
	 * @param matricula
	 * @param fechaEntrada
	 * @return
	 */
	private StringBuffer getOrdenesDetalleSql(String fechaEntrada,
			String matricula,String idioma) {
		StringBuffer strsql = new StringBuffer();
		String formatoFecha="dd/MM/yyyy";
String campoTexto="";
		if(!idioma.equals(m05bConstantesInformes.CASTELLANO)){
			formatoFecha="yyyy/MM/dd";
			campoTexto="E";
		}
		strsql.append("SELECT M0520V00.MATRICULA, M0520V00.FECHA_ENTRADA, M0520V00.FECHA_SALIDA, M0520V00.DESCRIPCION, NVL(M0519V00.");
		strsql.append(campoTexto);
		strsql.append("CONCEPTO,M0519V00.CONCEPTO) as CONCEPTO,EMPLEADO");
		strsql.append(" FROM M0520V00 INNER JOIN M0519V00 ON M0520V00.ID_ORDEN = M0519V00.ID_ORDEN");
		strsql.append(" WHERE ");
		if (matricula.length() > 0) {
			strsql.append(" M0520V00.MATRICULA='");
			strsql.append(matricula);
			strsql.append("' ");
			strsql.append(" AND ");
		}
		strsql.append(" M0520V00.FECHA_ENTRADA>to_date('");
		strsql.append(fechaEntrada);
		strsql.append("','");
			strsql.append(formatoFecha);
			strsql.append("')");
		strsql.append(" ORDER BY M0520V00.FECHA_ENTRADA DESC");
		return strsql;
	}

	/**
	 * Devuelve la SQL de ordenes por fechas
	 * 
	 * @param fechaEntrada1
	 * @param fechaEntrada2
	 * @param tipoTaller
	 * @return
	 */
	private StringBuffer getOrdenesPorFechasSql(String fechaEntrada1,
			String fechaEntrada2, int tipoTaller,String idioma) {
		StringBuffer strsql = new StringBuffer();
		String formatoFecha="dd/MM/yyyy";

		if(!idioma.equals(m05bConstantesInformes.CASTELLANO)){
			formatoFecha="yyyy/MM/dd";
		
		}
		strsql.append(" SELECT ot.matric_20 as matricula,");
		strsql.append("  ot.fentrada_20 as fecha_entrada,");
		strsql.append("  ot.fsalida_20 as fecha_salida,");
		strsql.append("   T.DESCRIP_30 as taller,");
		strsql.append("  D.DESCRIP_99 as RANGOVEHICULO,");
		strsql.append("  ot.cod_otra_20 as ID_ORDEN,");
		strsql.append("  V.DESDPTO_34 as DEPARTAMENTO,  ");
		strsql.append(" ot.imp_fact_20 as IMPORTE_FACT_EUROS");
		strsql.append(" FROM  M0520S00_ORDEN_TRABAJO OT inner join M0530S00_TALLERES T on  T.COD_TAL_30 = OT.CODTALLER_20 ");
		strsql.append(" inner join  M0534S00_VEHICULOS V on  V.MATRIC_34 = OT.MATRIC_20 ");
		strsql.append(" inner join  m0599s00_descripciones D on  V.RANGO_34= D.COD_DESC_99");		
		strsql.append(" WHERE (OT.FENTRADA_20 >=to_date('");
		strsql.append(fechaEntrada1);
		strsql.append("','");
			strsql.append(formatoFecha);
			strsql.append("') And OT.FENTRADA_20 <=to_date('");
		strsql.append(fechaEntrada2);
		strsql.append("','");
			strsql.append(formatoFecha);
			strsql.append("')) AND    D.COD_TAB_99=11");
		if (tipoTaller == m05bOrdenesTrabajoDao.TALLERINTERNO) {
			strsql.append(" AND  CODTALLER_20  = '0034' ");
		} else if (tipoTaller == m05bOrdenesTrabajoDao.TALLEREXTERNO) {
			strsql.append(" AND  CODTALLER_20  != '0034' ");
		}
		strsql.append(" ORDER BY ot.fentrada_20,ot.matric_20");
		return strsql;
	}

	/**
	 * Devuelve la sql de ordenes por fecha, que agrupa los resultados por
	 * departamento y matricula
	 * 
	 * @param fechaEntrada1
	 * @param fechaEntrada2
	 * @param tipoTaller
	 * @return
	 */
	private StringBuffer getOrdenesPorFechasAgrupSql(String fechaEntrada1,
			String fechaEntrada2, int tipoTaller,String idioma) {
		StringBuffer strsql = new StringBuffer();
		String formatoFecha="dd/MM/yyyy";

		if(!idioma.equals(m05bConstantesInformes.CASTELLANO)){
			formatoFecha="yyyy/MM/dd";
		
		}
		strsql.append(" SELECT  V.DESDPTO_34 as DEPARTAMENTO,  ");
		strsql.append(" OT.MATRIC_20 as MATRICULA, ");
		strsql.append("  COUNT(OT.MATRIC_20) AS cuenta");
		strsql.append(" FROM M0520S00_ORDEN_TRABAJO OT  inner join M0534S00_VEHICULOS V on V.MATRIC_34 = OT.MATRIC_20 ");
		strsql.append(" WHERE (OT.FENTRADA_20 >=to_date('");
		strsql.append(fechaEntrada1);
		strsql.append("','");
			strsql.append(formatoFecha);
			strsql.append("') And  OT.FENTRADA_20 <=to_date('");
		strsql.append(fechaEntrada2);
		strsql.append("','");
			strsql.append(formatoFecha);
			strsql.append("')) ");
		if (tipoTaller == m05bOrdenesTrabajoDao.TALLERINTERNO) {
			strsql.append(" AND  CODTALLER_20  = '0034'");
		} else if (tipoTaller == m05bOrdenesTrabajoDao.TALLEREXTERNO) {
			strsql.append(" AND  CODTALLER_20  != '0034'");
		}
		strsql.append(" group by  V.DESDPTO_34, OT.MATRIC_20");
		strsql.append(" ORDER by  V.DESDPTO_34, OT.MATRIC_20");
		return strsql;
	}

	/**
	 * Devuelve la SQL de las ordenes aplicndo los filtros de fecha de entrada,
	 * salida y tipo taller
	 * 
	 * @param fechaEntrada1
	 * @param fechaEntrada2
	 * @param fechaSalida1
	 * @param fechaSalida2
	 * @param tipoTaller
	 * @return
	 */
	private StringBuffer getOrdenesSql(String fechaEntrada1,
			String fechaEntrada2, String fechaSalida1, String fechaSalida2,
			int tipoTaller,String idioma) {
		StringBuffer strsql = new StringBuffer();
		strsql.append(" SELECT ID_ORDEN,      ");
		strsql.append("   MATRICULA,");
		strsql.append("   FECHA_SALIDA, ");
		strsql.append("   FECHA_ENTRADA,");
		strsql.append("   DEPARTAMENTO, ");
		strsql.append("   IMPORTE_FACT_EUROS, ");
		strsql.append("   TALLER");
		strsql.append(" FROM M0520V00");
		strsql.append(" WHERE 1=1 ");// Truco sucio igual que en UDA

		if (fechaEntrada1.length() != 0 || fechaEntrada2.length() != 0) {
			strsql.append(" AND ");
			strsql.append(getFechasSQL(fechaEntrada1, fechaEntrada2,
					"fecha_entrada",idioma));
		}

		if (fechaSalida1.length() != 0 || fechaSalida2.length() != 0) {
			strsql.append(" AND ");
			strsql.append(getFechasSQL(fechaSalida1, fechaSalida2,
					"fecha_salida",idioma));
		}

		if (tipoTaller == m05bOrdenesTrabajoDao.TALLERINTERNO) {
			strsql.append(" AND TALLER='TALLER PARQUE MOVIL'");
		} else if (tipoTaller == m05bOrdenesTrabajoDao.TALLEREXTERNO) {
			strsql.append(" AND TALLER!='TALLER PARQUE MOVIL'");
		}
		strsql.append(" ORDER BY fecha_entrada desc, fecha_salida desc");

		return strsql;
	}

	/**
	 * Devuelve la SQL de las ordenes aplicndo los filtros de fecha de entrada,
	 * salida y tipo taller
	 * 
	 * @param fechaEntrada1
	 * @param fechaEntrada2
	 * @param fechaSalida1
	 * @param fechaSalida2
	 * @param tipoTaller
	 * @return
	 */
	private StringBuffer getOrdenesAgrupSql(String fechaEntrada1,
			String fechaEntrada2, String fechaSalida1, String fechaSalida2,
			int tipoTaller,String idioma) {
		StringBuffer strsql = new StringBuffer();
		strsql.append(" SELECT ");
		strsql.append("   MATRICULA,");
		strsql.append("   DEPARTAMENTO, ");
		strsql.append("   Count(*) AS cuenta ");
		strsql.append(" FROM M0520V00");
		strsql.append(" WHERE 1=1 ");// Truco sucio igual que en UDA

		if (fechaEntrada1.length() != 0 || fechaEntrada2.length() != 0) {
			strsql.append(" AND ");
			strsql.append(getFechasSQL(fechaEntrada1, fechaEntrada2,
					"fecha_entrada",idioma));
		}

		if (fechaSalida1.length() != 0 || fechaSalida2.length() != 0) {
			strsql.append(" AND ");
			strsql.append(getFechasSQL(fechaSalida1, fechaSalida2,
					"fecha_salida",idioma));
		}

		if (tipoTaller == m05bOrdenesTrabajoDao.TALLERINTERNO) {
			strsql.append(" AND TALLER='TALLER PARQUE MOVIL'");
		} else if (tipoTaller == m05bOrdenesTrabajoDao.TALLEREXTERNO) {
			strsql.append(" AND TALLER!='TALLER PARQUE MOVIL'");
		}
		strsql.append(" GROUP BY DEPARTAMENTO, MATRICULA");
		strsql.append(" ORDER BY MATRICULA");

		return strsql;
	}

	/**
	 * Devuelve la SQL de las ordenes aplicndo los filtros de fecha de entrada,
	 * salida y tipo taller
	 * 
	 * @param fechaEntrada1
	 * @param fechaEntrada2
	 * @param fechaSalida1
	 * @param fechaSalida2
	 * @param tipoTaller
	 * @return
	 */
	private StringBuffer getOrdenesAgrupRangoSql(String fechaEntrada1,
			String fechaEntrada2, String fechaSalida1, String fechaSalida2,
			int tipoTaller,String idioma) {
		StringBuffer strsql = new StringBuffer();
		strsql.append(" SELECT ");
		strsql.append("   M0520V00.MATRICULA,");
		strsql.append("   M0520V00.DEPARTAMENTO, ");
		strsql.append("   RANGOVEHICULO, ");
		strsql.append("   Count(*) AS cuenta ");
		strsql.append(" FROM M0520V00 INNER JOIN M0534V00 on M0520V00.MATRICULA = M0534V00.MATRICULA");
		strsql.append(" WHERE 1=1 ");// Truco sucio igual que en UDA

		if (fechaEntrada1.length() != 0 || fechaEntrada2.length() != 0) {
			strsql.append(" AND ");
			strsql.append(getFechasSQL(fechaEntrada1, fechaEntrada2,
					"fecha_entrada", idioma));
		}

		if (fechaSalida1.length() != 0 || fechaSalida2.length() != 0) {
			strsql.append(" AND ");
			strsql.append(getFechasSQL(fechaSalida1, fechaSalida2,
					"fecha_salida", idioma));
		}

		if (tipoTaller == m05bOrdenesTrabajoDao.TALLERINTERNO) {
			strsql.append(" AND TALLER='TALLER PARQUE MOVIL'");
		} else if (tipoTaller == m05bOrdenesTrabajoDao.TALLEREXTERNO) {
			strsql.append(" AND TALLER!='TALLER PARQUE MOVIL'");
		}
		strsql.append(" GROUP BY M0520V00.DEPARTAMENTO, M0520V00.MATRICULA,RANGOVEHICULO");
		strsql.append(" ORDER BY MATRICULA");

		return strsql;
	}

	/**
	 * 
	 * @param fecha1
	 * @param fecha2
	 * @param campo
	 * @return
	 */
	private StringBuffer getFechasSQL(String fecha1, String fecha2, String campo,String idioma) {
		StringBuffer strsql = new StringBuffer();
		String formatoFecha="dd/MM/yyyy";

		if(!idioma.equals(m05bConstantesInformes.CASTELLANO)){
			formatoFecha="yyyy/MM/dd";
		
		}
		if ((fecha1 == null || fecha1.length() == 0)
				&& (fecha2 != null || fecha2.length() != 0)) {
			strsql.append(" ");
			strsql.append(campo);
			strsql.append("  <=to_date('");
			strsql.append(fecha2);
			strsql.append("','");
			strsql.append(formatoFecha);
			strsql.append("')");
		} else if ((fecha1 != null || fecha1.length() != 0)
				&& (fecha2 == null || fecha2.length() == 0)) {
			strsql.append(" ");
			strsql.append(campo);
			strsql.append("  >=to_date('");
			strsql.append(fecha1);
			strsql.append("','");
			strsql.append(formatoFecha);
			strsql.append("')");
		} else if ((fecha1 != null || fecha1.length() != 0)
				&& (fecha2 != null || fecha2.length() != 0)) {
			strsql.append(" (");
			strsql.append(campo);
			strsql.append(" between to_date('");
			strsql.append(fecha1);
			strsql.append("','");
			strsql.append(formatoFecha);
			strsql.append("') and");
			strsql.append(" to_date('");
			strsql.append(fecha2);
			strsql.append("','");
			strsql.append(formatoFecha);
			strsql.append("'))");
		}

		return strsql;

	}

	/**
	 * Devuelve un array con las ordenes de trabajo entre las fechas dadas, y el
	 * tipo de taller seleccionado
	 * 
	 * @param fechaEntrada1
	 * @param fechaEntrada2
	 * @param fechaSalida1
	 * @param fechaSalida2
	 * @param tipoTaller
	 * @return
	 */
	public ArrayList<m05bOrdenTrabajo> ordenes(String fechaEntrada1,
			String fechaEntrada2, String fechaSalida1, String fechaSalida2,
			int tipoTaller, String idioma, int numPagina) {

		ArrayList<m05bOrdenTrabajo> resultado = null;
		PreparedStatement stmt = null;
		ResultSet rs = null;
		StringBuffer strsql;
		Connection m_Connection = null;
		try {
			strsql = getOrdenesSql(fechaEntrada1, fechaEntrada2, fechaSalida1,
					fechaSalida2, tipoTaller,idioma);
			m05bOrdenTrabajo current;

			resultado = new ArrayList<m05bOrdenTrabajo>();
			// strsql=paginar(getAmortizacionBaseSQL(fechaInicio,fechaFin),1,60);
			if(numPagina==m05bPaginator.INITPAGE){
				int cuenta=0;			 
				cuenta=contarRegistros(strsql); 
				current= new m05bOrdenTrabajo();
				current.setNumeroPaginas((int)Math.ceil((double)cuenta/m05bPaginator.PAGESIZE));
				current.setNumeroRegistros(cuenta);
				resultado.add(current);
				numPagina=1;
			}
			if(numPagina!=m05bPaginator.NO){
		
				strsql=paginar(strsql,numPagina);
			}
			// //System.out.println(strsql.toString());
			m05bConexion miConex = new m05bConexion();
			m_Connection = miConex.getConnection();
			stmt = m_Connection.prepareStatement(strsql.toString());

			logger.info("Ejecutando sql" + strsql.toString());
			logger.info("Ejecutando sql"+strsql.toString());rs = stmt.executeQuery();
		

			while (rs.next()) {
				current = new m05bOrdenTrabajo();
				current.setIdOrden(rs.getInt("ID_ORDEN"));
				current.setDepartamento(rs.getString("DEPARTAMENTO"));
				current.setMatricula(rs.getString("MATRICULA"));
				current.setFechaEntrada(rs.getDate("FECHA_ENTRADA"));
				current.setFechaSalida(rs.getDate("FECHA_SALIDA"));
				current.setImporte(rs.getDouble("IMPORTE_FACT_EUROS"));
				current.setTaller(rs.getString("TALLER"));
				resultado.add(current);
			}

			stmt.close();
		} catch (Exception e) {
			imprimirError(e);
			logger.info("Cerrando conexin");
		} finally {
			try {
				logger.info("Cerrando conexin");
				m_Connection.close();
				logger.info("Conexin cerrada");
			} catch (Exception e) {
				imprimirError(e);

			}
		}
		return resultado;
	}

	/**
	 * Devuelve un array con las ordenes de trabajo detalladas para la fecha de
	 * entrada y la matrcula dada
	 * 
	 * @param fechaEntrada
	 * @param matricula
	 * @return
	 */
	public ArrayList<m05bOrdenTrabajo> ordenesDetalle(String fechaEntrada,
			String matricula, String idioma, int numPagina) {

		ArrayList<m05bOrdenTrabajo> resultado = null;
		PreparedStatement stmt = null;
		ResultSet rs = null;
		StringBuffer strsql;
		Connection m_Connection = null;
		try {
			strsql = getOrdenesDetalleSql(fechaEntrada, matricula,idioma);
			m05bOrdenTrabajo current;

			resultado = new ArrayList<m05bOrdenTrabajo>();
			// strsql=paginar(getAmortizacionBaseSQL(fechaInicio,fechaFin),1,60);
			if(numPagina==m05bPaginator.INITPAGE){
				int cuenta=0;			 
				cuenta=contarRegistros(strsql); 
				current= new m05bOrdenTrabajo();
				current.setNumeroPaginas((int)Math.ceil((double)cuenta/m05bPaginator.PAGESIZE));
				current.setNumeroRegistros(cuenta);
				resultado.add(current);
				numPagina=1;
			}
			if(numPagina!=m05bPaginator.NO){
		
				strsql=paginar(strsql,numPagina);
			}
			// System.out.println(strsql.toString());
			m05bConexion miConex = new m05bConexion();
			m_Connection = miConex.getConnection();
			stmt = m_Connection.prepareStatement(strsql.toString());

			logger.info("Ejecutando sql" + strsql.toString());
			logger.info("Ejecutando sql"+strsql.toString());rs = stmt.executeQuery();
		

			while (rs.next()) {
				current = new m05bOrdenTrabajo();
				current.setMatricula(rs.getString("MATRICULA"));
				current.setFechaEntrada(rs.getDate("FECHA_ENTRADA"));
				current.setFechaSalida(rs.getDate("FECHA_SALIDA"));
				current.setEmpleado(rs.getString("EMPLEADO"));
				current.setConcepto(rs.getString(5));
				current.setDescripcion(rs.getString("DESCRIPCION"));
				resultado.add(current);
			}

			stmt.close();
		} catch (Exception e) {
			imprimirError(e);
			logger.info("Cerrando conexin");
		} finally {
			try {
				logger.info("Cerrando conexin");
				m_Connection.close();
				logger.info("Conexin cerrada");
			} catch (Exception e) {
				imprimirError(e);

			}
		}
		return resultado;
	}

	/**
	 * Devuelve las ordendes de trabajo por fecha y tipotaller agrupadas por
	 * matricula y departamento
	 * 
	 * @param fechaEntrada
	 * @param matricula
	 * @param tipoTaller
	 * @return
	 */
	public ArrayList<m05bOrdenTrabajo> ordenesporFecha(String fechaEntrada,
			String fechaEntrada2, int tipoTaller, String idioma, int numPagina) {

		ArrayList<m05bOrdenTrabajo> resultado = null;
		PreparedStatement stmt = null;
		ResultSet rs = null;
		StringBuffer strsql;
		Connection m_Connection = null;
		try {
			strsql = getOrdenesPorFechasSql(fechaEntrada, fechaEntrada2,
					tipoTaller,idioma);
			m05bOrdenTrabajo current;

			resultado = new ArrayList<m05bOrdenTrabajo>();
			// strsql=paginar(getAmortizacionBaseSQL(fechaInicio,fechaFin),1,60);
			if(numPagina==m05bPaginator.INITPAGE){
				int cuenta=0;			 
				cuenta=contarRegistros(strsql); 
				current= new m05bOrdenTrabajo();
				current.setNumeroPaginas((int)Math.ceil((double)cuenta/m05bPaginator.PAGESIZE));
				current.setNumeroRegistros(cuenta);
				resultado.add(current);
				numPagina=1;
			}
			if(numPagina!=m05bPaginator.NO){
		
				strsql=paginar(strsql,numPagina);
			}
			m05bConexion miConex = new m05bConexion();
			m_Connection = miConex.getConnection();
			stmt = m_Connection.prepareStatement(strsql.toString());

			logger.info("Ejecutando sql" + strsql.toString());
			logger.info("Ejecutando sql"+strsql.toString());rs = stmt.executeQuery();
			

			while (rs.next()) {
				current = new m05bOrdenTrabajo();
				current.setMatricula(rs.getString("MATRICULA"));
				current.setFechaEntrada(rs.getDate("FECHA_ENTRADA"));
				current.setFechaSalida(rs.getDate("FECHA_SALIDA"));
				current.setTaller(rs.getString("TALLER"));
				current.setRango(rs.getString("RANGOVEHICULO"));
				current.setIdOrden(rs.getInt("ID_ORDEN"));
				current.setDepartamento(rs.getString("DEPARTAMENTO"));
				current.setImporte(rs.getDouble("IMPORTE_FACT_EUROS"));
				resultado.add(current);
			}

			stmt.close();
		} catch (Exception e) {
			
			imprimirError(e);
			logger.info("Cerrando conexin");
		} finally {
			try {
				logger.info("Cerrando conexin");
				m_Connection.close();
				logger.info("Conexin cerrada");
			} catch (Exception e) {
				imprimirError(e);

			}
		}
		return resultado;
	}

	/**
	 * Devuelve las ordendes de trabajo por fecha y tipotaller
	 * 
	 * @param fechaEntrada
	 * @param matricula
	 * @param tipoTaller
	 * @return
	 */
	public ArrayList<m05bOrdenTrabajo> ordenesporFechaAgrup(
			String fechaEntrada, String fechaEntrada2, int tipoTaller, String idioma, int numPagina) {

		StringBuffer strsql = getOrdenesPorFechasAgrupSql(fechaEntrada,
				fechaEntrada2, tipoTaller,idioma);
		return ordenesAgrup(strsql, false,idioma,numPagina);
	}

	/**
	 * Devuelve las ordendes de trabajo por fecha y tipotaller aprupados por
	 * departamento y matricula
	 * 
	 * @param fechaEntrada
	 * @param matricula
	 * @param tipoTaller
	 * @return
	 */
	public ArrayList<m05bOrdenTrabajo> ordenesAgrup(String fechaEntrada1,
			String fechaEntrada2, String fechaSalida1, String fechaSalida2,
			int tipoTaller, String idioma, int numPagina) {

		StringBuffer strsql = getOrdenesAgrupSql(fechaEntrada1, fechaEntrada2,
				fechaSalida1, fechaSalida2, tipoTaller, idioma);
		return ordenesAgrup(strsql, false,idioma,numPagina);
	}

	/**
	 * Devuelve las ordendes de trabajo por fecha y tipotaller aprupados por
	 * departamento , matricula y rango
	 * 
	 * @param fechaEntrada
	 * @param matricula
	 * @param tipoTaller
	 * @return
	 */
	public ArrayList<m05bOrdenTrabajo> ordenesAgrupRango(String fechaEntrada1,
			String fechaEntrada2, String fechaSalida1, String fechaSalida2,
			int tipoTaller, String idioma, int numPagina) {

		StringBuffer strsql = getOrdenesAgrupRangoSql(fechaEntrada1,
				fechaEntrada2, fechaSalida1, fechaSalida2, tipoTaller, idioma);
		return ordenesAgrup(strsql, true,idioma,numPagina);
	}

	/**
	 * Devuelve las ordendes de trabajo por fecha y tipotaller
	 * 
	 * @param fechaEntrada
	 * @param matricula
	 * @param tipoTaller
	 * @return
	 */
	private ArrayList<m05bOrdenTrabajo> ordenesAgrup(StringBuffer strsql,
			boolean rangosi, String idioma, int numPagina) {

		ArrayList<m05bOrdenTrabajo> resultado = null;
		PreparedStatement stmt = null;
		ResultSet rs = null;

		Connection m_Connection = null;
		try {
			m05bOrdenTrabajo current;

			resultado = new ArrayList<m05bOrdenTrabajo>();
			// strsql=paginar(getAmortizacionBaseSQL(fechaInicio,fechaFin),1,60);
			if(numPagina==m05bPaginator.INITPAGE){
				int cuenta=0;			 
				cuenta=contarRegistros(strsql); 
				current= new m05bOrdenTrabajo();
				current.setNumeroPaginas((int)Math.ceil((double)cuenta/m05bPaginator.PAGESIZE));
				current.setNumeroRegistros(cuenta);
				resultado.add(current);
				numPagina=1;
			}
			if(numPagina!=m05bPaginator.NO){
		
				strsql=paginar(strsql,numPagina);
			}
			m05bConexion miConex = new m05bConexion();
			m_Connection = miConex.getConnection();
			stmt = m_Connection.prepareStatement(strsql.toString());
			// System.out.println(strsql);
			logger.info("Ejecutando sql" + strsql.toString());
			
			rs = stmt.executeQuery();
		

			while (rs.next()) {
				current = new m05bOrdenTrabajo();
				current.setMatricula(rs.getString("MATRICULA"));
				current.setDepartamento(rs.getString("DEPARTAMENTO"));
				current.setCuenta(rs.getInt("CUENTA"));
				if (rangosi)
					current.setRango(rs.getString("RANGOVEHICULO"));
				resultado.add(current);
			}

			stmt.close();
		} catch (Exception e) {
			imprimirError(e);
			logger.info("Cerrando conexin");
		} finally {
			try {
				logger.info("Cerrando conexin");
				m_Connection.close();
				logger.info("Conexin cerrada");
			} catch (Exception e) {
				imprimirError(e);

			}
		}
		return resultado;
	}
}
