package m05bDaos;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import m05bClasses.m05bConexion;
import m05bClasses.m05bConstantesInformes;
import n05bModelosVistas.m05bOption;
import n05bModelosVistas.m05bTasasMunicipio;
import org.apache.log4j.Logger;

public class m05bMunicipiosDao extends m05bPaginator {
	private static m05bMunicipiosDao instance = null;

	private static Logger logger;

	public static m05bMunicipiosDao getInstance() {
		if (instance == null) {
			synchronized (m05bMunicipiosDao.class) {
				if (instance == null) {
					instance = new m05bMunicipiosDao();
					logger = Logger.getLogger(instance.getClass());
					// PropertyConfigurator.configure(
					// t64bGlobalContainer.LOGGERCONF);
				}
			}
		}

		return instance;
	}

	/**
	 * Devuleve las tasas que paga el municipio. Si municipio=-1 devuleve todas
	 * las tasas de todos los municipios
	 * 
	 * @param municipio
	 * @param idioma
	 * @param numPagina
	 * @return
	 */
	public ArrayList<m05bTasasMunicipio> getTasas(String municipio, String[] situaciones, String idioma, int numPagina) {
		String campoTexto = "";
		if(!idioma.equals(m05bConstantesInformes.CASTELLANO)) {
			campoTexto = "E";
		}
		StringBuffer sql = new StringBuffer();
		sql.append(" SELECT Matric_32,NVL(");
		sql.append(campoTexto);
		sql.append("DESCRIP_99,DESCRIP_99)");
		sql.append(" as  DESCRIP_99,");
		sql.append("  DESCRIP_24");
		sql.append(" FROM M0532T00");
		sql.append(" INNER JOIN m0599t00");
		sql.append(" ON m0532t00.concepto_32=m0599t00.cod_desc_99");
		sql.append(" AND m0599t00.COD_TAB_99=3");
		sql.append(" INNER JOIN M0524T00");
		sql.append(" ON m0532t00.municipio_32=m0524t00.cod_pob_24");
		sql.append(" INNER JOIN M0534T00");
		sql.append(" ON m0534t00.matric_34=M0532T00.matric_32");
		sql.append(" WHERE 1=1");
		if (!municipio.equals("-1")) {
			sql.append(" AND  m0532t00.municipio_32=?");
		}
		sql.append(stringArrayToSqlIn("SITUACION_34", " AND", situaciones));

		sql.append(" ORDER BY ");
		sql.append(" cod_pob_24, matric_32");
		m05bTasasMunicipio current;
		PreparedStatement stmt = null;
		ResultSet rs = null;

		Connection m_Connection = null;
		ArrayList<m05bTasasMunicipio> resultado = null;
		try {
			resultado = new ArrayList<m05bTasasMunicipio>();
			if (numPagina == m05bPaginator.INITPAGE) {
				int cuenta = 0;
				if (!municipio.equals("-1"))
					cuenta = contarRegistros(sql,municipio);
				else
					cuenta = contarRegistros(sql);
				current = new m05bTasasMunicipio();
				current.setNumeroPaginas((int) Math.ceil((double) cuenta / m05bPaginator.PAGESIZE));
				current.setNumeroRegistros(cuenta);
				resultado.add(current);
				numPagina = 1;
			}
			if (numPagina != m05bPaginator.NO) {
				sql = paginar(sql, numPagina);
			}

			m05bConexion miConex = new m05bConexion();
			m_Connection = miConex.getConnection();
			stmt = m_Connection.prepareStatement(sql.toString());
			if (!municipio.equals("-1"))
				stmt.setString(1, municipio);
			rs = stmt.executeQuery();

			while (rs.next()) {
				current = new m05bTasasMunicipio();
				current.setMatricula(rs.getString("Matric_32"));
				current.setTasa(rs.getString("DESCRIP_99"));
				current.setMunicipio(rs.getString("DESCRIP_24"));
				resultado.add(current);
			}

		} catch (Exception e) {
			imprimirError(e);
			logger.info("Cerrando conexin");
		} finally {
			try {
				logger.info("Cerrando conexin");
				m_Connection.close();
				logger.info("Conexin cerrada");
			} catch (Exception e) {
				imprimirError(e);
			}
		}
		return resultado;
	}

	/**
	 * Devuelve una lista de municipios
	 */
	public ArrayList<m05bOption> getMunicipio() {
		//return getOptions("select cod_pob_24 as val, DESCRIP_24 as text from m0524t00 order by DESCRIP_24");
		return getOptions("SELECT distinct cod_pob_24 AS val, DESCRIP_24 AS text FROM m0524t00 INNER JOIN m0532t00 ON m0532t00.municipio_32=m0524t00.cod_pob_24 ORDER BY DESCRIP_24");
		}
	
	/**
	 * Crea parte de la where para filtrar el cambio nombre si est en array
	 * 
	 * @param nombre
	 * @param bool
	 * @param array
	 * @return
	 */
	private StringBuffer stringArrayToSqlIn(String nombre, String bool, String[] array) {
		StringBuffer strsql = new StringBuffer();
		if (array != null) {
			strsql.append(bool);
			strsql.append(" ");
			strsql.append(nombre);
			strsql.append(" in('");
			boolean first = true;
			for (String element : array) {
				if (!first)
					strsql.append(",'");

				strsql.append(element + "'");
				first = false;
			}
			strsql.append(")");
		}
		return strsql;
	}

	/**
	 * Ejecuta una una select sobre la vista vehiculos (M0534V00) y devuelve una
	 * lista con todos los distintos aos
	 *
	 */
	private ArrayList<m05bOption> getOptions(String sql) {
		ArrayList<m05bOption> resultado = null;
		PreparedStatement stmt = null;
		ResultSet rs = null;
		StringBuffer strsql = new StringBuffer();
		Connection m_Connection = null;
		try {
			strsql.append(sql);

			m05bConexion miConex = new m05bConexion();
			m_Connection = miConex.getConnection();
			stmt = m_Connection.prepareStatement(strsql.toString());

			logger.info("Ejecutando sql" + strsql.toString());
			rs = stmt.executeQuery();

			resultado = new ArrayList<m05bOption>();
			m05bOption current;
			while (rs.next()) {
				current = new m05bOption();
				current.setText(rs.getString("text"));
				current.setValue(rs.getString("val"));
				resultado.add(current);
			}

			stmt.close();
		} catch (Exception e) {
			imprimirError(e);
			logger.info("Cerrando conexin");
		} finally {
			try {
				logger.info("Cerrando conexin");
				m_Connection.close();
				logger.info("Conexin cerrada");
			} catch (Exception e) {
				imprimirError(e);
			}
		}
		return resultado;
	}

	private void imprimirError(Exception e) {
		StackTraceElement[] stackTraceElements = Thread.currentThread()
				.getStackTrace();
		for (StackTraceElement stackTrace : stackTraceElements) {
			logger.error(stackTrace.getClassName() + "  "
					+ stackTrace.getMethodName() + " "
					+ stackTrace.getLineNumber());
		}
	}
}