package m05bDaos;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;

import m05bClasses.m05bConexion;
import m05bClasses.m05bConstantesInformes;
import n05bModelosVistas.m05bOption;

import org.apache.log4j.Logger;

public class m05bGastosDao extends m05bPaginator{
	private static m05bGastosDao instance = null;

	private static Logger logger;

	public static m05bGastosDao getInstance() {
		if (instance == null) {
			synchronized (m05bCTKDao.class) {
				if (instance == null) {
					instance = new m05bGastosDao();
					logger = Logger.getLogger(instance.getClass());
	
				}
			}
		}

		return instance;
	}
	private void imprimirError(Exception e) {
		StackTraceElement[] stackTraceElements = Thread.currentThread()
				.getStackTrace();
		for (StackTraceElement stackTrace : stackTraceElements) {
			logger.error(stackTrace.getClassName() + "  "
					+ stackTrace.getMethodName() + " "
					+ stackTrace.getLineNumber());
		}
	}

	/**
	 * Devuelve una lista de matrculas que tengan el gasto indicado en el importe, en la fecha indicada (idioma para la fecha de entrada)
	 * @param fecha
	 * @param importe
	 * @param idioma
	 * @return
	 */
	public ArrayList<String> getMatriculas(String fecha, double importe, String idioma){
		ArrayList<String> resultado = null;
		PreparedStatement stmt = null;
		ResultSet rs = null;
		StringBuffer strsql = new StringBuffer();
		Connection m_Connection = null;
		try {

		/*	strsql.append("SELECT MATRIC_18, to_char(FOPERAC_18,'");
			if(idioma.equals(m05bConstantesInformes.IDIOMA_E))
				strsql.append("yyyy/mm/dd");
			else
				strsql.append("dd/mm/yyyy");
			strsql.append("') as fecha, IMPORTE_18,CONCEPTO_18");*/
			strsql.append("SELECT distinct(MATRIC_18)");
			
			strsql.append(" FROM m0518t00");
			strsql.append(" WHERE TRUNC(FOPERAC_18)=to_date(?,'");
			if(!idioma.toUpperCase().equals(m05bConstantesInformes.CASTELLANO))
				strsql.append("yyyy/mm/dd");
			else
				strsql.append("dd/mm/yyyy");
			strsql.append("') AND (IMPORTE_18=?)");
			logger.info("Ejecutando sql" + strsql.toString());

			m05bConexion miConex = new m05bConexion();
			m_Connection = miConex.getConnection();
			stmt = m_Connection.prepareStatement(strsql.toString());
			stmt.setString(1, fecha);
			stmt.setDouble(2, importe);
		
			rs = stmt.executeQuery();
			resultado = new ArrayList<String>();
			String current;
			while (rs.next()) {
				current = rs.getString("MATRIC_18");
				resultado.add(current);
			}

			stmt.close();
		} catch (Exception e) {
			imprimirError(e);
			logger.info("Cerrando conexin");
		} finally {
			try {
				logger.info("Cerrando conexin");
				m_Connection.close();
				logger.info("Conexin cerrada");
			} catch (Exception e) {
				imprimirError(e);

			}
		}
		return resultado;
	}
}
