package m05bDaos;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;

import m05bClasses.m05bConexion;
import m05bClasses.m05bConstantesInformes;
import n05bModelosVistas.m05bAmortizacion;
import n05bModelosVistas.m05bAmortizacionBase;
import n05bModelosVistas.m05bAsignacion;
import n05bModelosVistas.m05bCombustible;
import n05bModelosVistas.m05bKilometrajes;

import org.apache.log4j.Logger;

public class m05bCTKDao extends m05bPaginator{
	private static m05bCTKDao instance = null;

	private static Logger logger;

	public static m05bCTKDao getInstance() {
		if (instance == null) {
			synchronized (m05bCTKDao.class) {
				if (instance == null) {
					instance = new m05bCTKDao();
					logger = Logger.getLogger(instance.getClass());
					// PropertyConfigurator.configure(
					// t64bGlobalContainer.LOGGERCONF);
				}
			}
		}

		return instance;
	}

	/**
	 * devuelve la strsql para obtener la CTK amortizacin
	 * 
	 * @param fechainicio
	 * @param fechafin
	 * @return
	 */
	private StringBuffer getAmortizacionSQL(String fechainicio, String fechafin,String idioma) {
		String formatoFecha="dd/MM/yyyy";
	
		if(!idioma.equals(m05bConstantesInformes.CASTELLANO)){
			formatoFecha="yyyy/MM/dd";
	
		}
		StringBuffer strsql = new StringBuffer();
		strsql.append("SELECT RangoDelVehiculo,  Sum((trunc( FechaFinAmortizacion-FechaInicioAmortizacion)+1)*EUROSDIA ) AS AmortizacionDelPeriodo ");
		strsql.append(" FROM (");
		strsql.append(" SELECT ");
		strsql.append("	case when FINIRGA3 is null ");
		strsql.append("	then M05A4T00.ORDENA4		");
		strsql.append("	else RANGOA3 end as RangoDelVehiculo,");
		strsql.append("	CASE when FINIRGA3 is null ");
		strsql.append("  then(");
		strsql.append("		case when Fecha_Matricula < to_date('");
		strsql.append(fechainicio);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("') ");
		strsql.append("    then ");
		strsql.append("				to_date('");
		strsql.append(fechainicio);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("') ");
		strsql.append("			else");
		strsql.append("      	Fecha_Matricula");
		strsql.append("		end)    ");
		strsql.append("	else ");
		strsql.append("		case when FINIRGA3 < to_date('");
		strsql.append(fechainicio);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("') ");
		strsql.append("			then ");
		strsql.append("    		to_date('");
		strsql.append(fechainicio);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("')");
		strsql.append("			else");
		strsql.append("      	FINIRGA3");
		strsql.append("		end ");
		strsql.append("	end AS FechaInicioAmortizacion,");
		strsql.append("  CASE when FINIRGA3 is null then");
		strsql.append("		case  when add_months(Fecha_Matricula,120)  < to_date('");
		strsql.append(fechafin);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("') ");
		strsql.append("			then ");
		strsql.append("				add_months(Fecha_Matricula,120)");
		strsql.append("			else");
		strsql.append("				to_date('");
		strsql.append(fechafin);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("')");
		strsql.append("		end");
		strsql.append("	else");
		strsql.append("		case  when FFINRGA3 < to_date('");
		strsql.append(fechafin);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("') ");
		strsql.append("			then ");
		strsql.append("			FFINRGA3 ");
		strsql.append("			else");
		strsql.append("			to_date('");
		strsql.append(fechafin);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("')");
		strsql.append("		end ");
		strsql.append("	end");
		strsql.append("		AS FechaFinAmortizacion,");
		strsql.append("	Precio_Euros/3650 AS EUROSDIA");
		strsql.append(" FROM ");
		strsql.append("	M05A4T00 INNER JOIN(M0534V00 LEFT JOIN M05A3T00 ON M0534V00.MATRICULA = M05A3T00.MATA3 	) ON M05A4T00.DESCA4  = M0534V00.RANGOVEHICULO ");
		strsql.append(" WHERE ");
		strsql.append(" (	CASE when FINIRGA3 is null then");
		strsql.append("		add_months(Fecha_Matricula,120)");
		strsql.append("		else");
		strsql.append("			case when FFINRGA3 > add_months(Fecha_Matricula,120)");
		strsql.append("				then add_months(Fecha_Matricula,120)");
		strsql.append("				else FFINRGA3");
		strsql.append("			end");
		strsql.append("	end		");
		strsql.append("	Between ");
		strsql.append("		to_date('");
		strsql.append(fechainicio);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("')");
		strsql.append("		And ");
		strsql.append("		to_date('");
		strsql.append(fechafin);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("')");
		strsql.append(")");
		strsql.append(" OR ");
		strsql.append(" ( 	CASE WHEN FINIRGA3  is null");
		strsql.append("	then Fecha_Matricula");
		strsql.append("	else");
		strsql.append("		FINIRGA3");
		strsql.append("	end");
		strsql.append("	Between ");
		strsql.append("		to_date('");
		strsql.append(fechainicio);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("')");
		strsql.append("		And ");
		strsql.append("		to_date('");
		strsql.append(fechafin);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("')		");
		strsql.append("	)");
		strsql.append(" OR ");
		strsql.append(" ((CASE WHEN 	FINIRGA3 is null");
		strsql.append("	then Fecha_Matricula");
		strsql.append("	else");
		strsql.append("		FINIRGA3");
		strsql.append("	end ");
		strsql.append("	<");
		strsql.append("	to_date('");
		strsql.append(fechainicio);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("'))");
		strsql.append("   AND");
		strsql.append("	(CASE WHEN 	FINIRGA3 is null");
		strsql.append("	then ");
		strsql.append("		add_months(Fecha_Matricula,120)");
		strsql.append("	else");
		strsql.append("		case when FFINRGA3>	add_months(Fecha_Matricula,120)");
		strsql.append("			then ");
		strsql.append("				add_months(Fecha_Matricula,120)");
		strsql.append("			else FFINRGA3");
		strsql.append("		end");
		strsql.append("	end	");
		strsql.append("	>");
		strsql.append("	to_date('");
		strsql.append(fechafin);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("')		");
		strsql.append("	))");
		strsql.append("  )");
		strsql.append("  where RangoDelVehiculo!='KA'");
		strsql.append("  GROUP BY RangoDelVehiculo");
		strsql.append("  order by rangoDelvehiculo");
		return strsql;

	}

	public StringBuffer getAmortizacionBaseSQL(String fechainicio,
			String fechafin,String idioma) {
		StringBuffer strsql = new StringBuffer();
		String formatoFecha="dd/MM/yyyy";

		if(!idioma.equals(m05bConstantesInformes.CASTELLANO)){
			formatoFecha="yyyy/MM/dd";
	
		}
		strsql.append(" SELECT ");
		strsql.append(" 	case when FINIRGA3 is null ");
		strsql.append(" 	then");
		strsql.append(" 	");
		strsql.append(" 		M05A4T00.ORDENA4		");
		strsql.append(" 	");
		strsql.append(" 	else RANGOA3 end as RangoDelVehiculo,");
		strsql.append(" 	to_date('19/03/2002','dd/mm/yyyy') AS Expr1, ");
		strsql.append(" 	M0534V00.MATRICULA, ");
		strsql.append(" 	M0534V00.PRECIO_EUROS,");
		strsql.append(" 	CASE when FINIRGA3 is null then");
		strsql.append(" 		case when Fecha_Matricula < to_date('19/03/2002','dd/mm/yyyy') ");
		strsql.append(" 			then ");
		strsql.append(" 				to_date('");
		strsql.append(fechainicio);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("')");
		strsql.append(" 			else");
		strsql.append(" 			Fecha_Matricula");
		strsql.append(" 		end");
		strsql.append(" 	else");
		strsql.append(" 		case when FINIRGA3 < to_date('");
		strsql.append(fechainicio);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("') ");
		strsql.append(" 			then ");
		strsql.append(" 			to_date('");
		strsql.append(fechainicio);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("')");
		strsql.append(" 			else");
		strsql.append(" 			FINIRGA3");
		strsql.append(" 		end ");
		strsql.append(" 	end AS FechaInicioAmortizacion,	");
		strsql.append(" 	CASE when FINIRGA3 is null then");
		strsql.append(" 		case  when add_months(Fecha_Matricula,120)  < to_date('");
		strsql.append(fechafin);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("') ");
		strsql.append(" 			then ");
		strsql.append(" 				add_months(Fecha_Matricula,120)");
		strsql.append(" 			else");
		strsql.append(" 				to_date('");
		strsql.append(fechafin);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("')");
		strsql.append(" 		end");
		strsql.append(" 	else");
		strsql.append(" 		case  when FFINRGA3 < to_date('");
		strsql.append(fechafin);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("') ");
		strsql.append(" 			then ");
		strsql.append(" 			FFINRGA3 ");
		strsql.append(" 			else");
		strsql.append(" 			to_date('");
		strsql.append(fechafin);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("')");
		strsql.append(" 		end ");
		strsql.append(" 	end");
		strsql.append(" 		AS FechaFinAmortizacion,");
		strsql.append(" 	case when FINIRGA3 is null then Fecha_Matricula else FINIRGA3 end AS FechaInicioDelRango,");
		strsql.append(" 	case ");
		strsql.append(" 		when FINIRGA3 is null ");
		strsql.append(" 			then add_months(Fecha_Matricula,120)");
		strsql.append(" 		else");
		strsql.append(" 			case ");
		strsql.append(" 				when FFINRGA3>add_months(Fecha_Matricula,120) then");
		strsql.append(" 					add_months(Fecha_Matricula,120)");
		strsql.append(" 				else FFINRGA3 ");
		strsql.append(" 			end");
		strsql.append(" 		end				");
		strsql.append(" 	AS FechaFinDelRango,");
		strsql.append(" 	trunc(");
		strsql.append("   	CASE when FINIRGA3 is null then");
		strsql.append(" 		case  when add_months(Fecha_Matricula,120)  < to_date('");
		strsql.append(fechafin);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("') ");
		strsql.append(" 			then ");
		strsql.append(" 				add_months(Fecha_Matricula,120)");
		strsql.append(" 			else");
		strsql.append(" 				to_date('");
		strsql.append(fechafin);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("')");
		strsql.append(" 		end");
		strsql.append(" 	else");
		strsql.append(" 		case  when FFINRGA3 < to_date('");
		strsql.append(fechafin);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("') ");
		strsql.append(" 			then ");
		strsql.append(" 			FFINRGA3 ");
		strsql.append(" 			else");
		strsql.append(" 			to_date('");
		strsql.append(fechafin);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("')");
		strsql.append(" 		end ");
		strsql.append(" 	end");
		strsql.append(" 	-");
		strsql.append(" CASE when FINIRGA3 is null then");
		strsql.append(" 		case when Fecha_Matricula < to_date('");
		strsql.append(fechainicio);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("') ");
		strsql.append(" 			then ");
		strsql.append(" 				to_date('");
		strsql.append(fechainicio);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("')");
		strsql.append(" 			else");
		strsql.append(" 			Fecha_Matricula");
		strsql.append(" 		end");
		strsql.append(" 	else");
		strsql.append(" 		case when FINIRGA3 < to_date('");
		strsql.append(fechainicio);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("') ");
		strsql.append(" 			then ");
		strsql.append(" 			to_date('");
		strsql.append(fechainicio);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("')");
		strsql.append(" 			else");
		strsql.append(" 			FINIRGA3");
		strsql.append(" 		end ");
		strsql.append(" 	end ");
		strsql.append(" 	");
		strsql.append("   )+1 	AS DiasAmortizacion,");
		strsql.append(" 	Precio_Euros/3650 AS ValorAmortDiaria,");
		strsql.append(" 	-1   *");
		strsql.append("   case ");
		strsql.append(" 		when FINIRGA3 is null then");
		strsql.append(" 			trunc(Fecha_Matricula - to_date('");
		strsql.append(fechainicio);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("'))*Precio_Euros/3650");
		strsql.append(" 		else");
		strsql.append(" 			Precio_Euros-VPDTEAMORA3");
		strsql.append(" 		end	AS AmortAcumTransf, ");
		strsql.append(" 	(trunc(");
		strsql.append("   ");
		strsql.append("   CASE when FINIRGA3 is null then");
		strsql.append(" 		case  when add_months(Fecha_Matricula,120)  < to_date('");
		strsql.append(fechafin);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("') ");
		strsql.append(" 			then ");
		strsql.append(" 				add_months(Fecha_Matricula,120)");
		strsql.append(" 			else");
		strsql.append(" 				to_date('");
		strsql.append(fechafin);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("')");
		strsql.append(" 		end");
		strsql.append(" 	else");
		strsql.append(" 		case  when FFINRGA3 < to_date('");
		strsql.append(fechafin);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("') ");
		strsql.append(" 			then ");
		strsql.append(" 			FINIRGA3 ");
		strsql.append(" 			else");
		strsql.append(" 			to_date('");
		strsql.append(fechafin);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("')");
		strsql.append(" 		end ");
		strsql.append(" 	end");
		strsql.append(" 		-");
		strsql.append("   CASE when FINIRGA3 is null then");
		strsql.append(" 		case when Fecha_Matricula < to_date('");
		strsql.append(fechainicio);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("') ");
		strsql.append(" 			then ");
		strsql.append(" 				to_date('");
		strsql.append(fechainicio);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("')");
		strsql.append(" 			else");
		strsql.append(" 			Fecha_Matricula");
		strsql.append(" 		end");
		strsql.append(" 	else");
		strsql.append(" 		case when FINIRGA3 < to_date('");
		strsql.append(fechainicio);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("') ");
		strsql.append(" 			then ");
		strsql.append(" 			to_date('");
		strsql.append(fechainicio);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("')");
		strsql.append(" 			else");
		strsql.append(" 			FINIRGA3");
		strsql.append(" 		end ");
		strsql.append(" 	end");
		strsql.append(" 	");
		strsql.append("   ");
		strsql.append("   ");
		strsql.append("   )+1)*Precio_Euros/3650 AS AmortizacionPeriodo");
		strsql.append(" FROM ");
		strsql.append(" M05A4T00 INNER JOIN(M0534V00 LEFT JOIN M05A3T00 ON M0534V00.MATRICULA = M05A3T00.MATA3	) ON M05A4T00.DESCA4  = M0534V00.RANGOVEHICULO ");
		strsql.append(" WHERE ");
		strsql.append(" (	CASE when FINIRGA3 is null then");
		strsql.append(" 		add_months(Fecha_Matricula,120)");
		strsql.append(" 		else");
		strsql.append(" 			case when FFINRGA3 > add_months(Fecha_Matricula,120)");
		strsql.append(" 				then add_months(Fecha_Matricula,120)");
		strsql.append(" 				else FFINRGA3");
		strsql.append(" 			end");
		strsql.append(" 	end		");
		strsql.append(" 	Between ");
		strsql.append(" 		to_date('");
		strsql.append(fechainicio);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("')");
		strsql.append(" 		And ");
		strsql.append(" 		to_date('");
		strsql.append(fechafin);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("')");
		strsql.append(" )");
		strsql.append("  OR ");
		strsql.append("  ( 	CASE WHEN FINIRGA3  is null");
		strsql.append(" 	then Fecha_Matricula");
		strsql.append(" 	else");
		strsql.append(" 		FINIRGA3");
		strsql.append(" 	end");
		strsql.append(" 	Between ");
		strsql.append(" 		to_date('");
		strsql.append(fechainicio);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("')");
		strsql.append(" 		And ");
		strsql.append(" 		to_date('");
		strsql.append(fechafin);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("')		");
		strsql.append(" 	)");
		strsql.append(" OR ");
		strsql.append(" ((CASE WHEN 	FINIRGA3 is null");
		strsql.append(" 	then Fecha_Matricula");
		strsql.append(" 	else");
		strsql.append(" 		FINIRGA3");
		strsql.append(" 	end ");
		strsql.append(" 	<");
		strsql.append(" 	to_date('");
		strsql.append(fechainicio);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("'))");
		strsql.append(" 	");
		strsql.append("    AND");
		strsql.append(" 	(CASE WHEN 	FINIRGA3 is null");
		strsql.append(" 	then ");
		strsql.append(" 		add_months(Fecha_Matricula,120)");
		strsql.append(" 	else");
		strsql.append(" 		case when FFINRGA3>	add_months(Fecha_Matricula,120)");
		strsql.append(" 			then ");
		strsql.append(" 				add_months(Fecha_Matricula,120)");
		strsql.append(" 			else FFINRGA3");
		strsql.append(" 		end");
		strsql.append(" 	end	");
		strsql.append(" 	>");
		strsql.append(" 	to_date('");
		strsql.append(fechafin);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("')		");
		strsql.append(" 	)) ORDER BY MATRICULA, RANGOA3");
		return strsql;
	}

	

	/**
	 * Devuelve la sql de combustible banco
	 * 
	 * @param fechainicio
	 * @param fechafin
	 * @return
	 */
	public StringBuffer srtCombustibleBanco(String fechainicio,
			String fechafin, boolean order,String idioma) {
		String formatoFecha="dd/MM/yyyy";
		
		if(!idioma.equals(m05bConstantesInformes.CASTELLANO)){
			formatoFecha="yyyy/MM/dd";
		
		}
		StringBuffer strsql = new StringBuffer();
		strsql.append(" SELECT ");
		strsql.append("   M0518V00.MATRICULA,");
		strsql.append("   CASE WHEN FINIRGA3 IS NULL ");
		strsql.append("     THEN SUBSTR(ORDENA4,1,1)");
		strsql.append("     ELSE SUBSTR(RANGOA3,1,1)");
		strsql.append("   END AS RangoDelVehiculo,");
		strsql.append("   TO_DATE('");
		strsql.append(fechainicio);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("') AS Expr1,");
		strsql.append("   M0518V00.FECHA,");
		strsql.append("   M05A3T00.FINIRGA3 as FECHAINICIODELRANGO,");
		strsql.append("   CASE WHEN FFINRGA3 IS NULL");
		strsql.append("   	THEN TO_DATE('");
		strsql.append(fechafin);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("')");
		strsql.append("   	ELSE FFINRGA3 ");
		strsql.append("   END AS FechaFinDelRango, ");
		strsql.append("   CASE WHEN FINIRGA3 IS NULL");
		strsql.append("     THEN");
		strsql.append("       CASE WHEN Cargo_Abono='A'");
		strsql.append("         THEN -Abs(Importe_Euros)");
		strsql.append("         ELSE Importe_Euros");
		strsql.append("       END");
		strsql.append("     ELSE");
		strsql.append("       CASE 	WHEN ");
		strsql.append("           (Fecha Between ");
		strsql.append("             FINIRGA3 ");
		strsql.append("             And ");
		strsql.append("             (");
		strsql.append("               CASE WHEN FFINRGA3 IS NULL");
		strsql.append("                 THEN TO_DATE('");
		strsql.append(fechainicio);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("')");
		strsql.append("                 ELSE FFINRGA3 ");
		strsql.append("               END");
		strsql.append("             ))");
		strsql.append("       THEN");
		strsql.append("         CASE WHEN Cargo_Abono='A'");
		strsql.append("         THEN ");
		strsql.append("           -Abs(Importe_Euros)");
		strsql.append("         ELSE");
		strsql.append("           Importe_Euros");
		strsql.append("         END");
		strsql.append("       ELSE");
		strsql.append("         0 ");
		strsql.append("       END ");
		strsql.append("     END AS ImporteCombustible");
		strsql.append(" FROM ");
		strsql.append(" 	M05A4T00");
		strsql.append(" 	INNER JOIN ");
		strsql.append(" 	(( ");
		strsql.append(" (Select * from M0518V00 WHERE ");
		strsql.append(" 	(M0518V00.FECHA Between TO_DATE('");
		strsql.append(fechainicio);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("') And TO_DATE('");
		strsql.append(fechafin);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("'))");
		strsql.append(" AND ");
		strsql.append(" 	M0518V00.TIPO='C') M0518V00");
		strsql.append(" 		INNER JOIN ");
		strsql.append(" 			M0534V00 ON M0518V00.MATRICULA = M0534V00.MATRICULA)");
		strsql.append(" 		LEFT JOIN M05A3T00 ON M0518V00.MATRICULA = M05A3T00.MATA3) ");
		strsql.append(" 	ON M05A4T00.DESCA4 = M0534V00.RANGOVEHICULO");
		// strsql.append(" WHERE ");
		// strsql.append(" 	(M0518V00.FECHA Between TO_DATE('");
		// strsql.append(fechainicio);
		// strsql.append("','dd/mm/yyyy') And add_months(TO_DATE('");
		// strsql.append(fechafin);
		// strsql.append("','dd/mm/yyyy'),12))");
		// strsql.append(" AND ");
		// strsql.append(" 	M0518V00.TIPO='C'");
		if (order)
			strsql.append(" ORDER BY M0518V00.FECHA, M05A3T00.FINIRGA3");

		return strsql;

	}

	/**
	 * Devuelve la sql de CombustibleGastos entre las fechas de inicio y fin
	 * 
	 * @param fechainicio
	 * @param fechafin
	 * @return
	 */
	public StringBuffer strCombustibleGastos(String fechainicio,
			String fechafin, boolean order,String idioma) {
		String formatoFecha="dd/MM/yyyy";
		String campoTexto="";
		if(!idioma.equals(m05bConstantesInformes.CASTELLANO)){
			formatoFecha="yyyy/MM/dd";
			campoTexto="E";
		}
		StringBuffer strsql = new StringBuffer();
		strsql.append(" SELECT M0509V00.MATRICULA,");
		strsql.append("  	CASE WHEN FFINRGA3 is null");
		strsql.append("  		then substr(ORDENA4  ,1,1)");
		strsql.append("  		else substr(RANGOA3 ,1,1)");
		strsql.append("  	end	AS RangoDelVehiculo,");
		strsql.append("  	to_date('");
		strsql.append(fechainicio);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("') AS Expr1,");
		strsql.append("  	M0509V00.FECHA_GASTO as FECHA,");
		strsql.append("  	M05A3T00.FINIRGA3      as FechaInicioDelRango,");
		strsql.append("  	case when FFINRGA3 is null");
		strsql.append("  		then to_date('");
		strsql.append(fechafin);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("') ");
		strsql.append("  		else	FFINRGA3");
		strsql.append("  	end	AS FechaFinDelRango,");
		strsql.append("  	case when FINIRGA3 is null");
		strsql.append("  		then ");
		strsql.append("  			case when Cargo_Abono='A'");
		strsql.append("     		then -Abs(ImporteEuros)");
		strsql.append("       	else ImporteEuros");
		strsql.append("  			end");
		strsql.append("  		else");
		strsql.append("  			case when (Fecha_Gasto Between FINIRGA3 And ");
		strsql.append("             (");
		strsql.append("               case when FFINRGA3 is null");
		strsql.append("                 then to_date('");
		strsql.append(fechafin);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("') ");
		strsql.append("                 else	FFINRGA3");
		strsql.append("               end");
		strsql.append("             ))");
		strsql.append("  			then");
		strsql.append("  				case when Cargo_Abono='A'");
		strsql.append("           then -Abs(ImporteEuros)");
		strsql.append("           else ImporteEuros");
		strsql.append("  				end");
		strsql.append("  			else 0");
		strsql.append("       end");
		strsql.append("  	end AS ImporteCombustible  ");
		strsql.append("  FROM ");
		strsql.append("  M05A4T00");
		strsql.append("  	INNER JOIN ");
		strsql.append("  		((");
		strsql.append("     (select * from   M0509V00 ");
		strsql.append("     WHERE ");
		strsql.append("  	(M0509V00.FECHA_GASTO Between to_date('");
		strsql.append(fechainicio);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("')  And to_date('");
		strsql.append(fechafin);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("') ) ");
		strsql.append("  	AND ");
		strsql.append("  	(M0509V00.CONCEPTO='COMBUSTIBLE')");
		strsql.append("     ) M0509V00");
		strsql.append("     INNER JOIN M0534V00 ON M0509V00.MATRICULA = M0534V00.MATRICULA)");
		strsql.append("  			LEFT JOIN M05A3T00 ON M0509V00.MATRICULA = M05A3T00.MATA3)");
		strsql.append("  	ON M05A4T00.DESCA4  = M0534V00.RANGOVEHICULO");
		strsql.append("  WHERE ");
		strsql.append("  	(M0509V00.FECHA_GASTO Between to_date('");
		strsql.append(fechainicio);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("')  And to_date('");
		strsql.append(fechafin);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("') ) ");
		strsql.append("  	AND ");
		strsql.append("  	(M0509V00.CONCEPTO='COMBUSTIBLE')");
		if (order)
			strsql.append("  ORDER BY M0509V00.FECHA_GASTO, M05A3T00.FINIRGA3");
		return strsql;
	}
	/**
	 * Devuelve la SQL de la consulta vehiculos de altas entre fechas
	 * @param fecha1
	 * @param fecha2
	 * @return
	 */
	public StringBuffer vehiculosdeAltasEntreFechas(String fecha1, String fecha2, boolean order,String idioma) {
		String formatoFecha="dd/MM/yyyy";
		String campoTexto="";
		if(!idioma.equals(m05bConstantesInformes.CASTELLANO)){
			formatoFecha="yyyy/MM/dd";
			campoTexto="E";
		}
		StringBuffer strsql = new StringBuffer();
		strsql.append(" WITH");
		strsql.append("  table1 as  (SELECT M0534V00.MATRICULA,");
		strsql.append("       CASE");
		strsql.append("         WHEN FINIRGA3 IS NULL");
		strsql.append("         THEN");
		strsql.append("           CASE");
		strsql.append("             WHEN Fecha_Matricula<to_date('");
		strsql.append(fecha1);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("')");
		strsql.append("             THEN to_date('");
		strsql.append(fecha1);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("')");
		strsql.append("             ELSE Fecha_Matricula");
		strsql.append("           END");
		strsql.append("         ELSE");
		strsql.append("           CASE");
		strsql.append("             WHEN FINIRGA3<to_date('");
		strsql.append(fecha1);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("')");
		strsql.append("             THEN to_date('");
		strsql.append(fecha1);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("')");
		strsql.append("             ELSE FINIRGA3");
		strsql.append("           END");
		strsql.append("       END AS FechaInicioDelRango,");
		strsql.append("       CASE");
		strsql.append("         WHEN FINIRGA3 IS NULL");
		strsql.append("         THEN");
		strsql.append("           CASE");
		strsql.append("             WHEN Fecha_Baja IS NULL");
		strsql.append("             THEN to_date('");
		strsql.append(fecha2);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("')");
		strsql.append("             ELSE");
		strsql.append("               CASE");
		strsql.append("                 WHEN Fecha_Baja<to_date('");
		strsql.append(fecha2);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("')");
		strsql.append("                 THEN Fecha_Baja");
		strsql.append("                 ELSE to_date('");
		strsql.append(fecha2);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("')");
		strsql.append("               END");
		strsql.append("           END");
		strsql.append("         ELSE");
		strsql.append("           CASE");
		strsql.append("             WHEN FFINRGA3 IS NULL");
		strsql.append("             THEN to_date('");
		strsql.append(fecha2);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("')");
		strsql.append("             ELSE");
		strsql.append("               CASE");
		strsql.append("                 WHEN FFINRGA3<to_date('");
		strsql.append(fecha2);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("')");
		strsql.append("                 THEN FFINRGA3");
		strsql.append("                 ELSE to_date('");
		strsql.append(fecha2);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("')");
		strsql.append("               END");
		strsql.append("           END");
		strsql.append("       END AS FechaFinDelRango,");
		strsql.append("       CASE");
		strsql.append("         WHEN RANGOA3 IS NULL");
		strsql.append("         THEN SUBSTR(ORDENA4,1,1)");
		strsql.append("         ELSE SUBSTR(RANGOA3,1,1)");
		strsql.append("       END AS RangoDelVehiculo,");
		strsql.append("       NVL(M0534V00.");
		strsql.append(campoTexto);
		strsql.append("SITUACION,M0534V00.SITUACION) ");
		strsql.append(" as SITUACION");
		strsql.append("     FROM M05A4T00");
		strsql.append("     INNER JOIN (M0534V00");
		strsql.append("     LEFT JOIN M05A3T00");
		strsql.append("     ON M0534V00.MATRICULA = M05A3T00.MATA3)");
		strsql.append("     ON M05A4T00.DESCA4    = M0534V00.RANGOVEHICULO");
		strsql.append("     WHERE ((");
		strsql.append("       CASE");
		strsql.append("         WHEN FINIRGA3 IS NULL");
		strsql.append("         THEN");
		strsql.append("           CASE");
		strsql.append("             WHEN Fecha_Matricula<to_date('");
		strsql.append(fecha1);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("')");
		strsql.append("             THEN to_date('");
		strsql.append(fecha1);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("')");
		strsql.append("             ELSE Fecha_Matricula");
		strsql.append("           END");
		strsql.append("         ELSE");
		strsql.append("           CASE");
		strsql.append("             WHEN FINIRGA3<to_date('");
		strsql.append(fecha1);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("')");
		strsql.append("             THEN to_date('");
		strsql.append(fecha1);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("')");
		strsql.append("             ELSE FINIRGA3");
		strsql.append("           END");
		strsql.append("       END) BETWEEN to_date('");
		strsql.append(fecha1);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("') AND to_date('");
		strsql.append(fecha2);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("'))");
		strsql.append("     AND ( ((");
		strsql.append("       CASE");
		strsql.append("         WHEN FINIRGA3 IS NULL");
		strsql.append("         THEN");
		strsql.append("           CASE");
		strsql.append("             WHEN Fecha_Baja IS NULL");
		strsql.append("             THEN to_date('");
		strsql.append(fecha2);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("')");
		strsql.append("             ELSE");
		strsql.append("               CASE");
		strsql.append("                 WHEN Fecha_Baja<to_date('");
		strsql.append(fecha2);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("')");
		strsql.append("                 THEN Fecha_Baja");
		strsql.append("                 ELSE to_date('");
		strsql.append(fecha2);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("')");
		strsql.append("               END");
		strsql.append("           END");
		strsql.append("         ELSE");
		strsql.append("           CASE");
		strsql.append("             WHEN FFINRGA3 IS NULL");
		strsql.append("             THEN to_date('");
		strsql.append(fecha2);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("')");
		strsql.append("             ELSE");
		strsql.append("               CASE");
		strsql.append("                 WHEN FFINRGA3<to_date('");
		strsql.append(fecha2);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("')");
		strsql.append("                 THEN FFINRGA3");
		strsql.append("                 ELSE to_date('");
		strsql.append(fecha2);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("')");
		strsql.append("               END");
		strsql.append("           END");
		strsql.append("       END)) BETWEEN to_date('");
		strsql.append(fecha1);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("') AND to_date('");
		strsql.append(fecha2);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("'))");
		strsql.append("   ) ");
		strsql.append(" SELECT Matricula,");
		strsql.append("   FechaInicioDelRango,");
		strsql.append("   FechaFinDelRango,");
		strsql.append("   RangoDelVehiculo,");
		strsql.append("   SITUACION,");
		strsql.append("   (FechaFinDelRango-FechaInicioDelRango +1) AS DIASDEALTA,");
		strsql.append("   CASE");
		strsql.append("     WHEN (FechaFinDelRango-FechaInicioDelRango +1)/(to_date('");
		strsql.append(fecha2);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("') -to_date('");
		strsql.append(fecha1);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("'))>1");
		strsql.append("     THEN 1");
		strsql.append("     ELSE (FechaFinDelRango-FechaInicioDelRango +1)/(to_date('");
		strsql.append(fecha2);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("') -to_date('");
		strsql.append(fecha1);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("'))");
		strsql.append("   END AS Porcentaje");
		strsql.append(" FROM table1 ");
		if (order)			
			strsql.append(" order by matricula,fechainiciodelrango");
		return strsql;
	}
	public StringBuffer numeroMedioVehiculos(String fecha1, String fecha2,String idioma){
		StringBuffer strsql= new StringBuffer();
		strsql.append("select RangoDelVehiculo, sum (porcentaje) as PORCENTAJE from( ");
		strsql.append(vehiculosdeAltasEntreFechas(fecha1,fecha2,false,idioma));
		strsql.append(") group by RangoDelVehiculo order by RangoDelVehiculo");
		return strsql;
	}

	/**
	 * Devuelve la sql de combustible total (unin de combustible gasto y
	 * combustible banco)
	 * 
	 * @param fechainicio
	 * @param fechafin
	 * @return
	 */
	public StringBuffer strCombustibleTotal(String fechainicio, String fechafin,String idioma) {
		StringBuffer strsql = srtCombustibleBanco(fechainicio, fechafin, false,idioma);
		strsql.append(" UNION ");
		strsql.append(strCombustibleGastos(fechainicio, fechafin, false,idioma));
		return strsql;
	}

	/**
	 * Devuelve la sql de combustible (agrupada por rango de combustible total)
	 * 
	 * @param fechainicio
	 * @param fechafin
	 * @return
	 */
	public StringBuffer strCombustible(String fechainicio, String fechafin,String idioma) {
		StringBuffer strsql = new StringBuffer();
		strsql.append(" SELECT RangoDelVehiculo, Sum(ImporteCombustible) AS IMPORTECOMBUSTIBLE ");
		strsql.append(" FROM (");
		strsql.append(strCombustibleTotal(fechainicio, fechafin,idioma));
		strsql.append(" ) GROUP BY RangoDelVehiculo order by RangoDelVehiculo");
		return strsql;
	}

	/**
	 * devuelve un array con los rangos de los vehculos y las amortizaciones
	 * 
	 * @param fechaInicio
	 * @param fechaFin
	 * @return
	 */
	public ArrayList<m05bAmortizacion> amortizacion(String fechaInicio,
			String fechaFin,String idioma, int numPAgina) {

		ArrayList<m05bAmortizacion> resultado = null;
		PreparedStatement stmt = null;
		ResultSet rs = null;
		StringBuffer strsql = new StringBuffer();
		Connection m_Connection = null;
		try {

			strsql.append(getAmortizacionSQL(fechaInicio, fechaFin,idioma));
			// System.out.println(strsql.toString());
			m05bConexion miConex = new m05bConexion();
			m_Connection = miConex.getConnection();
			stmt = m_Connection.prepareStatement(strsql.toString());
			logger.info("Ejecutando sql" + strsql.toString());
			rs = stmt.executeQuery();
			m05bAmortizacion current;
			resultado = new ArrayList<m05bAmortizacion>();
			while (rs.next()) {
				current = new m05bAmortizacion();
				current.setRango(rs.getString("RangoDelVehiculo"));
				current.setValorAmortizacion(rs
						.getDouble("AmortizacionDelPeriodo"));
				resultado.add(current);
			}

			stmt.close();
		} catch (Exception e) {
			imprimirError(e);
			logger.info("Cerrando conexin");
		} finally {
			try {
				logger.info("Cerrando conexin");
				m_Connection.close();
				logger.info("Conexin cerrada");
			} catch (Exception e) {
				imprimirError(e);

			}
		}
		return resultado;
	}

	/**
	 * devuelve un array de amortizaciones base
	 * 
	 * @param fechaInicio
	 * @param fechaFin
	 * @return
	 */
	public ArrayList<m05bAmortizacionBase> amortizacionBase(String fechaInicio,
			String fechaFin,String idioma, int numPagina) {

		ArrayList<m05bAmortizacionBase> resultado = null;
		PreparedStatement stmt = null;
		ResultSet rs = null;
		StringBuffer strsql = new StringBuffer();
		Connection m_Connection = null;
		try {

			// strsql=paginar(getAmortizacionBaseSQL(fechaInicio,fechaFin),1,60);
			strsql = getAmortizacionBaseSQL(fechaInicio, fechaFin,idioma);
			m05bAmortizacionBase current;
			resultado = new ArrayList<m05bAmortizacionBase>();
			
			if(numPagina==m05bPaginator.INITPAGE){
				int cuenta=0;			 
				cuenta=contarRegistros(strsql); 
				current= new m05bAmortizacionBase();
				current.setNumeroPaginas((int)Math.ceil((double)cuenta/m05bPaginator.PAGESIZE));
				current.setNumeroRegistros(cuenta);
				resultado.add(current);
				numPagina=1;
			}
			if(numPagina!=m05bPaginator.NO){
		
				strsql=paginar(strsql,numPagina);
			}
			
			m05bConexion miConex = new m05bConexion();
			m_Connection = miConex.getConnection();
			// System.out.println(strsql.toString());
			stmt = m_Connection.prepareStatement(strsql.toString());
			logger.info("Ejecutando sql" + strsql.toString());
			rs = stmt.executeQuery();
	
			while (rs.next()) {
				current = new m05bAmortizacionBase();
				current.setRango(rs.getString("RangoDelVehiculo"));
				current.setExpr1(rs.getDate("Expr1"));
				current.setMatricula(rs.getString("Matricula"));
				current.setPrecio(rs.getDouble("precio_euros"));
				current.setFechaInicioAmortizacion(rs
						.getDate("FechaInicioAmortizacion"));
				current.setFechaFinAmortizacion(rs
						.getDate("FechaFinAmortizacion"));
				current.setFechaInicioDelRango(rs
						.getDate("FECHAINICIODELRANGO"));
				current.setFechaFinDelRango(rs.getDate("FECHAFINDELRANGO"));
				current.setDiasAmortizacion(rs.getInt("DiasAmortizacion"));
				current.setValorAmortizacionDiaria(rs
						.getDouble("ValorAmortDiaria"));
				current.setAmortAcumTransf(rs.getDouble("AmortAcumTransf"));
				current.setAmortizacionPeriodo(rs
						.getDouble("AmortizacionPeriodo"));
				resultado.add(current);
			}

			stmt.close();
		} catch (Exception e) {
			imprimirError(e);
			logger.info("Cerrando conexin");
		} finally {
			try {
				logger.info("Cerrando conexin");
				m_Connection.close();
				logger.info("Conexin cerrada");
			} catch (Exception e) {
				imprimirError(e);

			}
		}
		return resultado;
	}

	private void imprimirError(Exception e) {
		StackTraceElement[] stackTraceElements = Thread.currentThread()
				.getStackTrace();
		for (StackTraceElement stackTrace : stackTraceElements) {
			logger.error(stackTrace.getClassName() + "  "
					+ stackTrace.getMethodName() + " "
					+ stackTrace.getLineNumber());
		}
	}

	/**
	 * Devuelve una lista de m05Combustible, representando al gasto
	 * 
	 * @param fechainicio
	 * @param fechafin
	 * @return
	 */
	public ArrayList<m05bCombustible> combustibleGastos(String fechainicio,
			String fechafin,String idioma, int numPagina) {
		StringBuffer strsql = new StringBuffer();
		strsql = strCombustibleGastos(fechainicio, fechafin, true,idioma);
		return combustible(strsql, true,idioma,numPagina);

	}

	/**
	 * Devuelve una lista de m05Combustible, representando al combustible de
	 * bancos
	 * 
	 * @param fechainicio
	 * @param fechafin
	 * @return
	 */
	public ArrayList<m05bCombustible> combustibleBanco(String fechainicio,
			String fechafin,String idioma, int numPagina) {
		StringBuffer strsql = new StringBuffer();
		strsql = srtCombustibleBanco(fechainicio, fechafin, true,idioma);
		
		return combustible(strsql, true,idioma,numPagina);

	}

	/**
	 * Devuelve una lista de m05Combustible, con la lista de combustible total
	 * 
	 * @param fechainicio
	 * @param fechafin
	 * @return
	 */
	public ArrayList<m05bCombustible> combustibleTotal(String fechainicio,
			String fechafin,String idioma, int numPagina) {
		StringBuffer strsql = new StringBuffer();
		strsql = strCombustibleTotal(fechainicio, fechafin,idioma);
		return combustible(strsql, true,idioma,numPagina);

	}

	/**
	 * Devuelve una lista de m05Combustible, para obtener el resumen
	 * 
	 * @param fechainicio
	 * @param fechafin
	 * @return
	 */
	public ArrayList<m05bCombustible> combustible(String fechainicio,
			String fechafin,String idioma, int numPagina) {
		StringBuffer strsql = new StringBuffer();
		strsql = strCombustible(fechainicio, fechafin,idioma);
		return combustible(strsql, false,idioma,numPagina);

	}

	/**
	 * devuelve un array de amortizaciones base
	 * 
	 * @param fechaInicio
	 * @param fechaFin
	 * @return
	 */
	private ArrayList<m05bCombustible> combustible(StringBuffer strsql,
			boolean completo,String idioma, int numPagina) {

		ArrayList<m05bCombustible> resultado = null;
		PreparedStatement stmt = null;
		ResultSet rs = null;

		Connection m_Connection = null;
		try {
			m05bCombustible current;
			resultado = new ArrayList<m05bCombustible>();
			// strsql=paginar(getAmortizacionBaseSQL(fechaInicio,fechaFin),1,60);
			if(numPagina==m05bPaginator.INITPAGE){
				int cuenta=0;			 
				cuenta=contarRegistros(strsql); 
				current= new m05bCombustible();
				current.setNumeroPaginas((int)Math.ceil((double)cuenta/m05bPaginator.PAGESIZE));
				current.setNumeroRegistros(cuenta);
				resultado.add(current);
				numPagina=1;
			}
			if(numPagina!=m05bPaginator.NO){
		
				strsql=paginar(strsql,numPagina);
			}
			
			m05bConexion miConex = new m05bConexion();
			m_Connection = miConex.getConnection();
			// System.out.println(strsql.toString());
			stmt = m_Connection.prepareStatement(strsql.toString());
			logger.info("Ejecutando sql" + strsql.toString());
			rs = stmt.executeQuery();

			while (rs.next()) {
				current = new m05bCombustible();
				if (completo) {
					current.setMatricula(rs.getString("Matricula"));
					current.setExpr11(rs.getDate("Expr1"));
					current.setFechaGasto(rs.getDate("FECHA"));
					current.setFechaInicioRango(rs
							.getDate("FECHAINICIODELRANGO"));
					current.setFechaFinRango(rs.getDate("FECHAFINDELRANGO"));
				}
				current.setRangoVehiculo(rs.getString("RangoDelVehiculo"));
				current.setImporte(rs.getDouble("IMPORTECOMBUSTIBLE"));
				resultado.add(current);
			}

			stmt.close();
		} catch (Exception e) {

			imprimirError(e);
			logger.info("Cerrando conexin");
		} finally {
			try {
				logger.info("Cerrando conexin");
				m_Connection.close();
				logger.info("Conexin cerrada");
			} catch (Exception e) {
				imprimirError(e);

			}
		}
		return resultado;
	}

	/**
	 * Devuelve una lista de kilometrajes
	 * 
	 * @param fechainit
	 * @param fechafin
	 * @return
	 */
	public ArrayList<m05bKilometrajes> kilometrajesBase(String fechainit,
			String fechafin,String idioma, int numPagina) {
		String formatoFecha="dd/MM/yyyy";
		
		if(!idioma.equals(m05bConstantesInformes.CASTELLANO)){
			formatoFecha="yyyy/MM/dd";
			
		}
		StringBuffer strsql = new StringBuffer("select * from m0549v00 ");
		strsql.append(" where fecha between to_date('");
		strsql.append(fechainit);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("') and to_date('");
		strsql.append(fechafin);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("')");
		return kilometrajes(strsql, true,idioma,numPagina);
	}

	/**
	 * Devuelve una lista de kilometrajes resumen * @param usuario
	 * 
	 * @return
	 */
	public ArrayList<m05bKilometrajes> kilometrosRecorrido(String usuario,String idioma, int numPagina) {

		StringBuffer strsql = new StringBuffer(
				"SELECT m05a5t00.OrdenA5 as RANGODELVEHICULO, Sum(m05a5t00.DifKmsA5) AS kilometros ");
		strsql.append(" FROM m05a5t00 where usua5 = '");
		strsql.append(usuario);
		strsql.append("' group by m05a5t00.OrdenA5 Order by m05a5t00.OrdenA5");

		return kilometrajes(strsql, false,idioma,numPagina);
	}

	
	/**
	 * devuelve un array de kilometrajes base
	 * 
	 * @param fechaInicio
	 * @param fechaFin
	 * @return
	 */
	private ArrayList<m05bKilometrajes> kilometrajes(StringBuffer strsql,
			boolean completo,String idioma, int numPagina) {

		ArrayList<m05bKilometrajes> resultado = null;
		PreparedStatement stmt = null;
		ResultSet rs = null;

		Connection m_Connection = null;
		try {
			m05bKilometrajes current;
			resultado = new ArrayList<m05bKilometrajes>();
			// strsql=paginar(getAmortizacionBaseSQL(fechaInicio,fechaFin),1,60);
			if(numPagina==m05bPaginator.INITPAGE){
				int cuenta=0;			 
				cuenta=contarRegistros(strsql); 
				current= new m05bKilometrajes();
				current.setNumeroPaginas((int)Math.ceil((double)cuenta/m05bPaginator.PAGESIZE));
				current.setNumeroRegistros(cuenta);
				resultado.add(current);
				numPagina=1;
			}
			if(numPagina!=m05bPaginator.NO){
		
				strsql=paginar(strsql,numPagina);
			}
			m05bConexion miConex = new m05bConexion();
			m_Connection = miConex.getConnection();
			// System.out.println(strsql.toString());
			stmt = m_Connection.prepareStatement(strsql.toString());
			logger.info("Ejecutando sql" + strsql.toString());
			rs = stmt.executeQuery();

			while (rs.next()) {
				current = new m05bKilometrajes();
				if (completo) {
					current.setMatricula(rs.getString("Matricula"));
					current.setFecha(rs.getDate("FECHA"));
					current.setFechainiciorango(rs
							.getDate("FECHADEINICIODELRANGO"));
					current.setFechafinrango(rs.getDate("FECHADEFINDELRANGO"));

				}
				current.setRango(rs.getString("RangoDelVehiculo"));
				current.setKilometros(rs.getInt("Kilometros"));
				resultado.add(current);
			}

			stmt.close();
		} catch (Exception e) {
			
			imprimirError(e);
			logger.info("Cerrando conexin");
		} finally {
			try {
				logger.info("Cerrando conexin");
				m_Connection.close();
				logger.info("Conexin cerrada");
			} catch (Exception e) {
				imprimirError(e);

			}
		}
		return resultado;
	}
	/**
	 * Devuleve el resultado de CTk vehiculos
	 * @param fecha1
	 * @return
	 */
	public ArrayList<m05bKilometrajes> numeroVehiculos(String fecha1,String idioma, int numPagina){
		logger.info("CTK numero vehiculos "+fecha1);
		String formatoFecha="dd/MM/yyyy";		
		if(!idioma.equals(m05bConstantesInformes.CASTELLANO)){
			formatoFecha="yyyy/MM/dd";
			
		}
		StringBuffer strsql = new StringBuffer();
		strsql.append(" SELECT ");
		strsql.append("   substr(ORDENA4,1,1) AS RangoDelVehiculo,");
		strsql.append("   Count(M0534V00.MATRICULA) AS porcentaje");
		strsql.append(" FROM M0534V00 INNER JOIN M05A4T00 ");
		strsql.append(" ON M0534V00.RANGOVEHICULO = M05A4T00.DESCA4");
		strsql.append(" WHERE (M0534V00.SITUACION='ALTA' ");
		strsql.append(" 	AND M0534V00.FECHA_MATRICULA<to_date('");
		strsql.append(fecha1);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("')) ");
		strsql.append(" 	OR (");
		strsql.append(" 	M0534V00.SITUACION='BAJA' ");
		strsql.append(" 	AND M0534V00.FECHA_MATRICULA <to_date('");
		strsql.append(fecha1);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("')");
		strsql.append(" 	AND M0534V00.FECHA_BAJA>to_date('");
		strsql.append(fecha1);
		strsql.append("','");
		strsql.append(formatoFecha);
		strsql.append("'))");
		strsql.append("   GROUP BY substr(ORDENA4,1,1) ");
		strsql.append("   order by RangoDelVehiculo");
		return vehiculos(strsql,false,idioma,numPagina);
		
		
	}
	/**
	 * @param fechaInicio
	 * @param fechaFin
	 * @return
	 */
	public  ArrayList<m05bKilometrajes>  getVehiculosAltaEntreFechas(String fechaInicio, String fechaFin,String idioma, int numPagina){
		logger.info("CTK- Vehiculos alta entre fechas");
		StringBuffer sql=vehiculosdeAltasEntreFechas(fechaInicio,fechaFin,true,idioma);
		return vehiculos(sql,true,idioma,numPagina);
	}
	/**
	 * @param fechaInicio
	 * @param fechaFin
	 * @return
	 */
	public  ArrayList<m05bKilometrajes>  getMediaVehiculos(String fechaInicio, String fechaFin,String idioma, int numPagina){
		logger.info("CTK- Numero medio de vehiculos");
		StringBuffer sql=numeroMedioVehiculos(fechaInicio,fechaFin,idioma);
		return vehiculos(sql,false,idioma,numPagina);
	}
	/**
	 * devuelve un array de kilometrajes 
	 * 
	 * @param fechaInicio
	 * @param fechaFin
	 * @return
	 */
	private ArrayList<m05bKilometrajes> vehiculos(StringBuffer strsql,
			boolean completo, String idioma, int numPagina) {

		ArrayList<m05bKilometrajes> resultado = null;
		PreparedStatement stmt = null;
		ResultSet rs = null;

		Connection m_Connection = null;
		try {
			m05bKilometrajes current;
			resultado = new ArrayList<m05bKilometrajes>();
			// strsql=paginar(getAmortizacionBaseSQL(fechaInicio,fechaFin),1,60);
			if(numPagina==m05bPaginator.INITPAGE){
				int cuenta=0;			 
				cuenta=contarRegistros(strsql); 
				current= new m05bKilometrajes();
				current.setNumeroPaginas((int)Math.ceil((double)cuenta/m05bPaginator.PAGESIZE));
				current.setNumeroRegistros(cuenta);
				resultado.add(current);
				numPagina=1;
			}
			if(numPagina!=m05bPaginator.NO){
		
				strsql=paginar(strsql,numPagina);
			}
			m05bConexion miConex = new m05bConexion();
			m_Connection = miConex.getConnection();
			// System.out.println(strsql.toString());
			stmt = m_Connection.prepareStatement(strsql.toString());
			logger.info("Ejecutando sql" + strsql.toString());
			rs = stmt.executeQuery();
		
			while (rs.next()) {
				current = new m05bKilometrajes();
				if (completo) {
					current.setMatricula(rs.getString("Matricula"));
					current.setFechainiciorango(rs
							.getDate("FECHAINICIODELRANGO"));
					current.setFechafinrango(rs.getDate("FECHAFINDELRANGO"));
					current.setSituacion(rs.getString("SITUACION"));
					current.setDiasDeAlta(rs.getInt("DIASDEALTA"));
					
				}
				current.setRango(rs.getString("RangoDelVehiculo"));
				current.setPorcentaje(rs.getDouble("PORCENTAJE"));
				resultado.add(current);
			}

			stmt.close();
		} catch (Exception e) {
			
			imprimirError(e);
			logger.info("Cerrando conexin");
		} finally {
			try {
				logger.info("Cerrando conexin");
				m_Connection.close();
				logger.info("Conexin cerrada");
			} catch (Exception e) {
				imprimirError(e);

			}
		}
		return resultado;
	}
	/**
	 * Rellena la tabla temporal de transferencias
	 */
	public void callRellenar() {
		String strsql = "";
		Connection m_Connection = null;
		CallableStatement stmt;
		try {
			m05bConexion miConex = new m05bConexion();
			m_Connection = miConex.getConnection();
			logger.info("Actualizando tabla temporal de transferencias");
			strsql = "{call PROC_ACTUALIZAR_TRANSFERENCIAS ()}";

			// //System.out.println(strsql);
			stmt = m_Connection.prepareCall(strsql);
			stmt.executeUpdate();
			stmt.close();

		} catch (Exception e) {
			imprimirError(e);
			logger.info("Cerrando conexin");
		} finally {
			try {
				logger.info("Cerrando conexin");
				m_Connection.close();
				logger.info("Conexin cerrada");
			} catch (Exception e) {
				imprimirError(e);

			}
		}
	}

	/**
	 * Rellena la tabla temporal de kilometrajes para el usuario username entre
	 * los valores fechainit,fechafin
	 * 
	 * @param username
	 * @param fechainit
	 * @param fechafin
	 */
	public void callRellenarKilometrajes(String username, String fechainit,
			String fechafin) {
		String strsql = "";
		Connection m_Connection = null;
		CallableStatement stmt;
		try {
			m05bConexion miConex = new m05bConexion();
			m_Connection = miConex.getConnection();
			logger.info("Actualizando tabla temporal de kilometrajes para el usuario "
					+ username);
			strsql = "{call PROC_ACTUALIZAR_KILOMETRAJES (?,?,?)}";

			// //System.out.println(strsql);

			stmt = m_Connection.prepareCall(strsql);
			stmt.setString(1, username);
			stmt.setString(2, fechainit);
			stmt.setString(3, fechafin);
			stmt.executeUpdate();
			stmt.close();

		} catch (Exception e) {
			imprimirError(e);
			logger.info("Cerrando conexin");
		} finally {
			try {
				logger.info("Cerrando conexin");
				m_Connection.close();
				logger.info("Conexin cerrada");
			} catch (Exception e) {
				imprimirError(e);

			}
		}
	}

}
