package m05bDaos;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;

import org.apache.log4j.Logger;

import m05bClasses.m05bConexion;
import m05bClasses.m05bConstantesInformes;
import n05bModelosVistas.m05bAsignacion;
import n05bModelosVistas.m05bOption;
import n05bModelosVistas.m05bPersonaEstadisticas;
import n05bModelosVistas.m05bVehiculoV;

public class m05bAsignacionesDao extends m05bPaginator {
	private static m05bAsignacionesDao instance = null;
	private static Logger logger;

	// private static Logger log;
	public static m05bAsignacionesDao getInstance() {
		if (instance == null) {
			synchronized (m05bAsignacionesDao.class) {
				if (instance == null) {
					instance = new m05bAsignacionesDao();
					logger = Logger.getLogger(instance.getClass());
					// PropertyConfigurator.configure(
					// t64bGlobalContainer.LOGGERCONF);
				}
			}
		}

		return instance;
	}

	/**
	 * Crea la select bsica para asignaciones
	 * 
	 * @return
	 */
	private StringBuffer getMainSQL() {
		StringBuffer strsql = new StringBuffer();
		strsql.append("SELECT M0501V00.ASIGPERMANENTE, M0501V00.DEPARTAMENTO, M0521V00.DESC_CARGO, ");
		strsql.append(" M0521V00.NOMBRE, M0534V00.MARCA, M0534V00.MODELO, M0534V00.MATRICULA, M0534V00.FECHA_MATRICULA, M0534V00.KM_ACTUALES, M0501V00.FECHA_DECRETO, FECHA_DEVOLUCION");
		strsql.append(" FROM (M0501V00 INNER JOIN M0534V00 ON M0501V00.MATRICULA = M0534V00.MATRICULA)");
		strsql.append(" INNER JOIN M0521V00 ON M0501V00.DNI_PERSONA = M0521V00.DNI");
		return strsql;
	}

	public StringBuffer getWhere(String[] tipos, String fechaDevolucionDesde,
			String fechaDevolucionHasta, String fechaDecretoDesde,
			String fechaDecretoHasta, String[] cargos) {
		StringBuffer strsql = new StringBuffer(" WHERE ");
		if (tipos.length > 0) {
			strsql.append("(");
			boolean primero = true;
			for (String s : tipos) {
				if (!primero)
					strsql.append(" OR ");
				if (s.equals("B2"))
					strsql.append(" M0534V00.RANGOVEHICULO ='DIRECTORES' ");
				else if (s.equals("B1"))
					strsql.append(" (M0534V00.RANGOVEHICULO)='VICECONSEJEROS'");
				else if (s.equals("A1")) {
					strsql.append(" ((M0534V00.SITUACION='ALTA'   AND M0534V00.RANGOVEHICULO='REPRESENTACIN-MIEMBROS DEL GOBIERNO')");
					strsql.append(" OR ");
					strsql.append(" M0534V00.RANGOVEHICULO='EX-LEHENDAKARI'");
					strsql.append(" OR");
					strsql.append(" M0534V00.RANGOVEHICULO='VEH. RENTING OPCION COMPRA-CONSEJEROS')");
				} else if (s.equals("VR")) {
					strsql.append(" M0534V00.RANGOVEHICULO='VEH. RENTING OPCION COMPRA/VICECONSEJEROS'");

				}
				primero = false;
			}
			strsql.append(")");
		}
		if (fechaDevolucionDesde.length() == 0
				&& fechaDecretoDesde.length() == 0) {
			strsql.append(" AND (M0501V00.FECHA_DEVOLUCION Is Null)");
		} else if (fechaDevolucionDesde.length() == 0
				&& fechaDecretoDesde.length() != 0) {
			strsql.append(" AND (M0501V00.FECHA_DECRETO Between to_date('");
			strsql.append(fechaDecretoDesde);
			strsql.append("','dd/MM/yyyy') And to_date('");
			strsql.append(fechaDecretoHasta);
			strsql.append("','dd/MM/yyyy') )");
			strsql.append(" AND (M0501V00.FECHA_DEVOLUCION Is Null)");
		} else if (fechaDevolucionDesde.length() != 0
				&& fechaDecretoDesde.length() == 0) {
			strsql.append(" AND (M0501V00.FECHA_DEVOLUCION Between to_date('");
			strsql.append(fechaDevolucionDesde);
			strsql.append("','dd/MM/yyyy') And to_date('");
			strsql.append(fechaDevolucionHasta);
			strsql.append("','dd/MM/yyyy') )");

		} else {
			strsql.append(" AND (M0501V00.FECHA_DECRETO Between to_date('");
			strsql.append(fechaDecretoDesde);
			strsql.append("','dd/MM/yyyy') And to_date('");
			strsql.append(fechaDecretoHasta);
			strsql.append("','dd/MM/yyyy'))");
			strsql.append(" AND (M0501kV00.FECHA_DEVOLUCION Between to_date('");
			strsql.append(fechaDevolucionDesde);
			strsql.append("','dd/MM/yyyy') And to_date('");
			strsql.append(fechaDevolucionHasta);
			strsql.append("','dd/MM/yyyy'))");
		}
		strsql.append(stringArrayToSqlIn("COD_CARGO", "AND", cargos));
		return strsql;

	}
	public StringBuffer getWhere(String[] tipos, String fechaDesde,String fechaHasta,String fechaDevolucionDesde,
			String fechaDevolucionHasta, String fechaDecretoDesde,
			String fechaDecretoHasta, String[] cargos,String[] departamentos,String idioma) {
			StringBuffer strsql =getWhere(fechaDesde,fechaHasta,tipos,idioma) ;
			strsql.append(rangoFechasToSql("M0501V00.FECHA_DECRETO",fechaDecretoDesde,fechaDecretoHasta,idioma));
			strsql.append(rangoFechasToSql("M0501V00.FECHA_DEVOLUCION",fechaDevolucionDesde,fechaDevolucionHasta,idioma));
		
		strsql.append(stringArrayToSqlIn("COD_CARGO", "AND", cargos));
		strsql.append(stringArrayToSqlIn(" M0501V00.cod_departamento", "AND", departamentos));
		return strsql;

	}
	/**
	 * SQL de asignaciones por fechas
	 * 
	 * @return
	 */
	private StringBuffer getMainByDateSQL(String idioma) {
		StringBuffer strsql = new StringBuffer();
		
		String campoTexto="";
		
		if(!idioma.equals(m05bConstantesInformes.CASTELLANO)){
			
			campoTexto="E";
			
		}
		strsql.append("SELECT NVL(M0501V00.");
		strsql.append(campoTexto);
		strsql.append("DEPARTAMENTO,M0501V00.DEPARTAMENTO)");
		strsql.append(" as DEPARTAMENTO,        M0501V00.FECHA_DECRETO, M0521V00.NOMBRE,  NVL(M0521V00.");
		strsql.append(campoTexto);
		strsql.append("DESC_CARGO,M0521V00.DESC_CARGO) ");
		strsql.append("as DESC_CARGO,  M0501V00.MATRICULA, M0501V00.FECHA_DESDE, M0501V00.FECHA_DEVOLUCION, M0501V00.KM_RECORRIDOS, M0501V00.ASIGPERMANENTE, NVL(M0521V00.");
		strsql.append(campoTexto);
		strsql.append("RANGO,M0521V00.RANGO) ");
		strsql.append("as RANGO, M0501V00.CODRANGOVEHICULO ");
		strsql.append(" FROM M0501V00 INNER JOIN M0521V00 ON M0501V00.DNI_PERSONA = M0521V00.DNI ");
		return strsql;
	}

	/**
	 * Crea la SQL de asignaciones vivas
	 * 
	 * @return
	 */
	private StringBuffer getMainVivas(String [] departamentos,String idioma) {
		StringBuffer strsql = new StringBuffer();
	String campoTexto="";
		
		if(!idioma.equals(m05bConstantesInformes.CASTELLANO)){
			
			campoTexto="E";
			
		}
		strsql.append("SELECT M0501V00.ID_ASIGNACIONES, M0501V00.MATRICULA, M0521V00.NOMBRE, NVL(M0521V00.");
		strsql.append(campoTexto);
		strsql.append("DESC_CARGO,M0521V00.DESC_CARGO) ");
		strsql.append("as DESC_CARGO, M0501V00.FECHA_DESDE, M0501V00.FECHA_DEVOLUCION, NVL(M0501V00.");
		strsql.append(campoTexto);
		strsql.append("DEPARTAMENTO ,M0501V00.DEPARTAMENTO)");
		strsql.append(" as DEPARTAMENTO");
		strsql.append(" FROM M0501V00 INNER JOIN M0521V00 ON M0501V00.DNI_PERSONA = M0521V00.DNI");
		strsql.append(" WHERE (((M0501V00.FECHA_DEVOLUCION) Is Null)) ");
		strsql.append(stringArrayToSqlIn(" M0501V00.cod_departamento", "AND", departamentos));
		strsql.append(" ORDER BY M0501V00.ID_ASIGNACIONES");
		return strsql;

	}

	/**
	 * Where de asignaciones por fechas
	 * 
	 * @param fechaDesde
	 * @param fechaHasta
	 * @param rangos
	 * @return
	 */
	public StringBuffer getWhere(String fechaDesde, String fechaHasta,
			String[] rangos,String idioma) {
		StringBuffer strsql = new StringBuffer(" WHERE 1=1");
//		if (fechaDesde.length() != 0) {
//			strsql.append(" AND (M0501V00.FECHA_DESDE Between to_date('");
//			strsql.append(fechaDesde);
//			strsql.append("','dd/MM/yyyy') And to_date('");
//			strsql.append(fechaHasta);
//			strsql.append("','dd/MM/yyyy') )");
//		}
		strsql.append(rangoFechasToSql("M0501V00.FECHA_DESDE",fechaDesde,fechaHasta,idioma));
		strsql.append(stringArrayToSqlIn(" CODRANGOVEHICULO", "AND", rangos));
		return strsql;
	}

	/**
	 * Devuelve la sql de asignaciones por persona agrupada (numero de
	 * kilometros, coches y dias que una persona ha utilizado algun vehiculo por
	 * departamento
	 * 
	 * @return
	 */
	public StringBuffer getSelectAsignacionesPersona( String idioma) {
//		String formatoFecha="dd/MM/yyyy";
		String campoTexto="";
		if(!idioma.equals(m05bConstantesInformes.CASTELLANO)){
	//		formatoFecha="yyyy/MM/dd";
			campoTexto="E_";
		}
		StringBuffer strsql = new StringBuffer();
//		strsql.append("SELECT M0521V00.NOMBRE, NVL(");
//		strsql.append(campoTexto);
//		strsql.append("DEPARTAMENTO,DEPARTAMENTO) ");
//		strsql.append("as DEPARTAMENTO, sum(M0501V00.KM_RECORRIDOS) as totalkilometros,count (MATRICULA) as nummatriculas,");
//		strsql.append("		sum(");
//		strsql.append(" case");
//		strsql.append(" when fecha_devolucion is null  then");
//		strsql.append(" floor(SYSDATE -");
//		strsql.append(" case");
//		strsql.append(" when fecha_desde <to_date('1/1/2008','dd/MM/YYYY') 	then	to_date('1/1/2008','dd/MM/YYYY')");
//		strsql.append(" else 		fecha_desde");
//		strsql.append(" end 	+1)");
//		strsql.append(" else");
//		strsql.append(" fecha_devolucion -");
//		strsql.append(" case ");
//		strsql.append(" when fecha_desde <to_date('1/1/2008','dd/MM/YYYY') 		then			to_date('1/1/2008','dd/MM/YYYY')");
//		strsql.append(" else 		fecha_desde");
//		strsql.append(" end +1");
//		strsql.append(" end ) AS ndias");
//		strsql.append(" FROM M0501V00 INNER JOIN M0521V00 ON M0501V00.DNI_PERSONA = M0521V00.DNI");
//		strsql.append(" where ");
//		strsql.append("  fecha_desde>to_date('1/1/2008','dd/MM/YYYY')");
//		strsql.append(" and  (M0501V00.FECHA_HASTA>to_date(?,'dd/MM/YYYY'))");
//		strsql.append(" and (M0501V00.FECHA_HASTA<to_date(?,'dd/MM/YYYY'))");
//		strsql.append(" AND ((M0501V00.CODCARGOPERSONA in ('01','02','14','15'))");
//		strsql.append(" AND ((M0501V00.ASIGPERMANENTE)='N'))");
//		strsql.append(" GROUP BY M0521V00.NOMBRE, NVL(");
//		strsql.append(campoTexto);
//		strsql.append("DEPARTAMENTO,DEPARTAMENTO)");
//		strsql.append(" order by ndias desc");
		

		strsql.append(" SELECT nombre,");
		strsql.append("   departamento,");
		strsql.append("   floor(ndias) AS ndias,");
		strsql.append("   totalkilometros,");
		strsql.append("   nummatriculas,");
		strsql.append("   gasolina,");
		strsql.append("   peaje");
		strsql.append(" FROM");
		strsql.append("   (SELECT m0521t00.dni_21,");
		strsql.append("     M0521t00.NOMBRE_21         AS nombre,");
		strsql.append("     NVL(");
				strsql.append(campoTexto);
				strsql.append("DESCRIP_06,DESCRIP_06) AS DEPARTAMENTO,");
		strsql.append("     SUM(m0501t00.KM_RECOR_01)  AS totalkilometros,");
		strsql.append("     COUNT (m0501t00.MATRIC_01) AS nummatriculas,");
		strsql.append("     SUM(");
		strsql.append("     CASE");
		strsql.append("     WHEN FINALIZ_01  ='N'");
		strsql.append("     THEN floor(SYSDATE -");
		strsql.append("       CASE");
		strsql.append("         WHEN m0501t00.FDESDE_01 <to_date('1/1/2008','dd/MM/YYYY')");
		strsql.append("         THEN to_date('1/1/2008','dd/MM/YYYY')");
		strsql.append("         ELSE m0501t00.FDESDE_01");
		strsql.append("       END          +1)");
		strsql.append("     ELSE FDEVOL_01 -");
		strsql.append("       CASE");
		strsql.append("         WHEN m0501t00.FDESDE_01 <to_date('1/1/2008','dd/MM/YYYY')");
		strsql.append("         THEN to_date('1/1/2008','dd/MM/YYYY')");
		strsql.append("         ELSE m0501t00.FDESDE_01");
		strsql.append("       END +1");
		strsql.append("   END ) AS ndias");
		strsql.append("   FROM m0501t00");
		strsql.append("   LEFT JOIN M0506T00");
		strsql.append("   ON COD_DPTO_06=CODDPTO_01");
		strsql.append("   INNER JOIN M0521t00");
		strsql.append("   ON m0501t00.DNI_01         = M0521t00.DNI_21");
		strsql.append("   WHERE ((FINALIZ_01     ='S'");
		strsql.append("   AND FDEVOL_01              >to_date(?,'dd/MM/YYYY')");
		strsql.append("   AND FDEVOL_01              <to_date(?,'dd/MM/YYYY'))");
		strsql.append("   OR (FINALIZ_01  ='N'");
		strsql.append("   AND m0501t00.FHASTA_01     >to_date(?,'dd/MM/YYYY')");
		strsql.append("   AND m0501t00.FHASTA_01     <to_date(?,'dd/MM/YYYY')))");
		strsql.append("   AND (m0501t00.CODCARGO_01 IN ('01','02','14','15'))");
		strsql.append("   AND (m0501t00.ASIGPERM_01) ='N'");
		strsql.append("   GROUP BY dni_21,");
		strsql.append("     M0521t00.NOMBRE_21,");
		strsql.append("     NVL(");
				strsql.append(campoTexto);
				strsql.append("DESCRIP_06,DESCRIP_06)");
		strsql.append("   ) T1");
		strsql.append(" LEFT JOIN");
		strsql.append("   (SELECT m0501t00.dni_01,");
		strsql.append("     SUM(");
		strsql.append("     CASE");
		strsql.append("       WHEN m0518t00.TIPO_18='C'");
		strsql.append("       THEN m0518t00.importe_18");
		strsql.append("       ELSE 0");
		strsql.append("     END)AS gasolina,");
		strsql.append("     SUM(");
		strsql.append("     CASE");
		strsql.append("       WHEN m0518t00.TIPO_18='P'");
		strsql.append("       THEN m0518t00.importe_18");
		strsql.append("       ELSE 0");
		strsql.append("     END)AS peaje");
		strsql.append("   FROM m0501t00");
		strsql.append("   LEFT JOIN m0518t00");
		strsql.append("   ON m0518t00.matric_18      =m0501t00.matric_01");
		strsql.append("   WHERE ((FINALIZ_01     ='S'");
		strsql.append("   AND FDEVOL_01              >to_date(?,'dd/MM/YYYY')");
		strsql.append("   AND FDEVOL_01              <to_date(?,'dd/MM/YYYY'))");
		strsql.append("   OR (FINALIZ_01     ='N'");
		strsql.append("   AND m0501t00.FHASTA_01     >to_date(?,'dd/MM/YYYY')");
		strsql.append("   AND m0501t00.FHASTA_01     <to_date(?,'dd/MM/YYYY')))");
		strsql.append("   AND (m0501t00.CODCARGO_01 IN ('01','02','14','15'))");
		strsql.append("   AND (m0501t00.ASIGPERM_01) ='N'");
		strsql.append("   AND verific_18             ='S'");
		strsql.append("   AND m0518t00.FOPERAC_18   >=m0501t00.FDESDE_01");
		strsql.append("   AND ((m0501t00.FINALIZ_01  ='S'");
		strsql.append("   AND m0518t00.FOPERAC_18   <=m0501t00.FDEVOL_01)");
		strsql.append("   OR(m0501t00.FINALIZ_01     ='N'");
		strsql.append("   AND m0518t00.FOPERAC_18   <=to_date(?,'dd/MM/yyyy')))");
		strsql.append("   GROUP BY dni_01");
		strsql.append("   ) T2 ON T2.dni_01=T1.dni_21");
		strsql.append(" ORDER BY ndias DESC ");

		
		return strsql;

	}

	/**
	 * Devuelve la sql de conductores
	 * 
	 * @return
	 */
	public StringBuffer getConductoresMain(String idioma) {
		StringBuffer strsql = new StringBuffer("");
		String campoTexto="";
		if(!idioma.equals(m05bConstantesInformes.CASTELLANO)){
	//		formatoFecha="yyyy/MM/dd";
			campoTexto="E";
		}
		strsql.append(" SELECT M0534V00.MATRICULA, M0534V00.MARCA, M0534V00.MODELO,");
		strsql.append(" M0534V00.FECHA_MATRICULA, M0534V00.KM_ACTUALES,");
		strsql.append(" NVL(M0534V00.");
		strsql.append(campoTexto);
		strsql.append("DEPARTAMENTO,M0534V00.DEPARTAMENTO) ");
		strsql.append(" AS DEPARTAMENTO, NVL(M0521V00.");
		strsql.append(campoTexto);
		strsql.append("DESC_CARGO ,M0521V00.DESC_CARGO)");
		strsql.append(" AS DESC_CARGO, NVL(M0534V00.");
		strsql.append(campoTexto);
		strsql.append("RANGOVEHICULO,M0534V00.RANGOVEHICULO) ");
		strsql.append(" AS RANGOVEHICULO,FECHA_DEVOLUCION,NVL(");
		strsql.append(campoTexto);
		strsql.append("SITUACION,SITUACION) ");
		strsql.append(" AS SITUACION");
		strsql.append(" FROM (M0534V00 INNER JOIN M0501V00 ON M0534V00.MATRICULA = M0501V00.MATRICULA) INNER JOIN M0521V00 ON M0501V00.DNI_PERSONA = M0521V00.DNI");
		return strsql;
	}
	private void imprimirError(Exception e) {
		StackTraceElement[] stackTraceElements = Thread.currentThread()
				.getStackTrace();
		for (StackTraceElement stackTrace : stackTraceElements) {
			logger.error(stackTrace.getClassName() + "  "
					+ stackTrace.getMethodName() + " "
					+ stackTrace.getLineNumber());
		}
	}
	/**
	 * Crea la where de los conductores
	 * 
	 * @param marcas
	 * @param modelos
	 * @param rangos
	 * @param situaciones
	 * @param fechaDevolucion
	 * @return
	 */
	public StringBuffer getWhereConductores(String[] marcas, String[] modelos,
			String[] rangos, String[] situaciones, int fechaDevolucion) {
		StringBuffer strsql = new StringBuffer(
				" WHERE  (DESC_CARGO Like 'COND%') ");
		strsql.append(stringArrayToSqlIn(" MARCA", "AND", marcas));
		strsql.append(stringArrayToSqlIn(" MODELO", "AND", modelos));
		strsql.append(stringArrayToSqlIn(" SITUACION", "AND", situaciones));
		strsql.append(stringArrayToSqlIn(" CODRANGOVEHICULO", "AND", rangos));
		if (fechaDevolucion == 1)
			strsql.append(" AND FECHA_DEVOLUCION Is Null");
		return strsql;
	}

	/**
	 * Ejecuta una una select sobre la vista vehiculos (M0534V00) y devuelve una
	 * lista de vehiculos dados de alta a partir del ao de entrada y con las
	 * situaciones de entrada
	 * 
	 * @param anio
	 * @param situaciones
	 */
	public ArrayList<m05bAsignacion> asignacionesPorTipo(String[] tipos,
			String fechaAsigDesde, String fechaAsigHasta,
			String fechaDevolucionDesde, String fechaDevolucionHasta,
			String fechaDecretoDesde, String fechaDecretoHasta, String[] cargos,String[] departamentos,String idioma, int numPagina) {

		ArrayList<m05bAsignacion> resultado = null;
		PreparedStatement stmt = null;
		ResultSet rs = null;
		StringBuffer strsql = new StringBuffer();
		Connection m_Connection = null;
		try {

			strsql.append(getMainByDateSQL(idioma));
			strsql.append(getWhere(tipos,fechaAsigDesde,fechaAsigHasta, fechaDevolucionDesde,
					fechaDevolucionHasta, fechaDecretoDesde, fechaDecretoHasta,
					cargos,departamentos,idioma));
			strsql.append(" ORDER BY DEPARTAMENTO, FECHA_DESDE");
			
			m05bAsignacion current;
			resultado = new ArrayList<m05bAsignacion>();
			//Prueba de paginacin
			if(numPagina==m05bPaginator.INITPAGE){
				int cuenta=0;
				
			 
				cuenta=contarRegistros(strsql,-1);
				current= new m05bAsignacion();
				current.setNumeroPaginas((int)Math.ceil((double)cuenta/m05bPaginator.PAGESIZE));
				current.setNumeroRegistros(cuenta);
				resultado.add(current);
				numPagina=1;
			}
			if(numPagina!=m05bPaginator.NO){
		
				strsql=paginar(strsql,numPagina);
			}
			m05bConexion miConex = new m05bConexion();
			m_Connection = miConex.getConnection();
			stmt = m_Connection.prepareStatement(strsql.toString());
			logger.info("Ejecutando sql"+strsql.toString());rs = stmt.executeQuery();

	
			while (rs.next()) {
				current = new m05bAsignacion(idioma);
				current.setDepartamento(rs.getString("DEPARTAMENTO"));
				current.setMatricula(rs.getString("MATRICULA"));
				current.setCargo(rs.getString("DESC_CARGO"));
				current.setNombre(rs.getString("NOMBRE"));
				current.setFechaDecreto(rs.getDate("FECHA_DECRETO"));
				current.setFechaDevolucion(rs.getDate("FECHA_DEVOLUCION"));
				current.setFechaAlta(rs.getDate("FECHA_DESDE"));
				current.setKilometraje(rs.getInt("KM_recorridos"));
			
				current.setAsigpermanente(rs.getString("ASIGPERMANENTE"));
				current.setRangoVehiculo(rs.getString("RANGO"));
				current.setCodrangovehiculo(rs.getString("codrangovehiculo"));
				resultado.add(current);
			}

			stmt.close();
		} catch (Exception e) {
		
			imprimirError(e);
			logger.info("Cerrando conexin");
		} finally {
			try {
				logger.info("Cerrando conexin");
				m_Connection.close();
				logger.info("Conexin cerrada");
			} catch (Exception e) {
				imprimirError(e);

			}
		}
		return resultado;
	}

	/**
	 * Ejecuta una una select sobre la vista vehiculos (M0534V00) y devuelve una
	 * lista de vehiculos dados de alta a partir del ao de entrada y con las
	 * situaciones de entrada
	 * 
	 * @param anio
	 * @param situaciones
	 */
	public ArrayList<m05bAsignacion> asignacionesPorFecha(String fechaDesde,
			String fechaHasta, String[] rangos,String idioma, int numPagina) {

		ArrayList<m05bAsignacion> resultado = null;
		PreparedStatement stmt = null;
		ResultSet rs = null;
		StringBuffer strsql = new StringBuffer();
		Connection m_Connection = null;
		try {
			m05bAsignacion current;
			resultado = new ArrayList<m05bAsignacion>();
			strsql.append(getMainByDateSQL(idioma));
			strsql.append(getWhere(fechaDesde, fechaHasta, rangos,idioma));
			strsql.append(" ORDER BY M0501V00.ASIGPERMANENTE, M0521V00.RANGO,DEPARTAMENTO,NOMBRE");
			
			
			//Prueba de paginacin
			if(numPagina==m05bPaginator.INITPAGE){
				int cuenta=0;
				
			 
				cuenta=contarRegistros(strsql,-1);
				current= new m05bAsignacion();
				current.setNumeroPaginas((int)Math.ceil((double)cuenta/m05bPaginator.PAGESIZE));
				current.setNumeroRegistros(cuenta);
				resultado.add(current);
				numPagina=1;
			}
			if(numPagina!=m05bPaginator.NO){
		
				strsql=paginar(strsql,numPagina);
			}
			// ////System.out.println(strsql.toString());
			m05bConexion miConex = new m05bConexion();
			m_Connection = miConex.getConnection();
			stmt = m_Connection.prepareStatement(strsql.toString());
			logger.info("Ejecutando sql"+strsql.toString());rs = stmt.executeQuery();
		
			while (rs.next()) {
				current = new m05bAsignacion();
				current.setDepartamento(rs.getString("DEPARTAMENTO"));
				current.setNombre(rs.getString("NOMBRE"));
				current.setMatricula(rs.getString("MATRICULA"));
				current.setFechaDecreto(rs.getDate("FECHA_DESDE"));
				current.setFechaDevolucion(rs.getDate("FECHA_DEVOLUCION"));
				current.setKilometraje(rs.getInt("KM_recorridos"));
				current.setAsigpermanente(rs.getString("ASIGPERMANENTE"));
				current.setRangoVehiculo(rs.getString("RANGO"));
				current.setCodrangovehiculo(rs.getString("codrangovehiculo"));
				// falta codrangovehiculo

				resultado.add(current);
			}

			stmt.close();
		} catch (Exception e) {
			imprimirError(e);
			logger.info("Cerrando conexin");
		} finally {
			try {
				logger.info("Cerrando conexin");
				m_Connection.close();
				logger.info("Conexin cerrada");
			} catch (Exception e) {
				imprimirError(e);

			}
		}
		return resultado;
	}

	/**
	 * Ejecuta una una select sobre las vista personas y asignaciones y devuelve
	 * una lista de personas estadisticas (numero de kilometros, coches y das
	 * 
	 * @param anio
	 * @param situaciones
	 */
	public ArrayList<m05bPersonaEstadisticas> asignacionesPorPersonas(
			String anio,String idioma, int numPagina) {

		ArrayList<m05bPersonaEstadisticas> resultado = null;
		PreparedStatement stmt = null;
		ResultSet rs = null;
		StringBuffer strsql = new StringBuffer();
		Connection m_Connection = null;
		try {
			String fecha = "1/1/" + anio;
			
			String fecha2 = "1/1/" + (Integer.parseInt(anio)+1);
			strsql.append(getSelectAsignacionesPersona(idioma));
			m05bPersonaEstadisticas current;
			resultado = new ArrayList<m05bPersonaEstadisticas>();
			//Prueba de paginacin
			if(numPagina==m05bPaginator.INITPAGE){
				int cuenta=0;
				
			 
				cuenta=contarRegistros(strsql,fecha,fecha2); 
				current= new m05bPersonaEstadisticas();
				current.setNumeroPaginas((int)Math.ceil((double)cuenta/m05bPaginator.PAGESIZE));
				current.setNumeroRegistros(cuenta);
				resultado.add(current);
				numPagina=1;
			}
			if(numPagina!=m05bPaginator.NO){
		
				strsql=paginar(strsql,numPagina);
			}
			
			
			m05bConexion miConex = new m05bConexion();
			m_Connection = miConex.getConnection();
			// //System.out.println(strsql.toString());
			stmt = m_Connection.prepareStatement(strsql.toString());
			stmt.setString(1, fecha);
			stmt.setString(2, fecha2);
			stmt.setString(3, fecha);
			stmt.setString(4, fecha2);
			stmt.setString(5, fecha);
			stmt.setString(6, fecha2);
			stmt.setString(7, fecha);
			stmt.setString(8, fecha2);
			stmt.setString(9, fecha2);
			
			logger.info("Ejecutando sql"+strsql.toString());
			rs = stmt.executeQuery();

			while (rs.next()) {
				current = new m05bPersonaEstadisticas();
				current.setDepartamento(rs.getString("DEPARTAMENTO"));
				current.setNombre(rs.getString("NOMBRE"));
				current.setNumeroKilometros(rs.getInt("TOTALKILOMETROS"));
				current.setNumeroMatriculas(rs.getInt("NUMMATRICULAS"));
				current.setTotalDias(rs.getInt("NDIAS"));
				current.setGasolina(rs.getDouble("GASOLINA"));
				current.setPeaje(rs.getDouble("PEAJE"));
				resultado.add(current);
			}

			stmt.close();
		} catch (Exception e) {
			e.printStackTrace();
			imprimirError(e);
			logger.info("Cerrando conexin");
		} finally {
			try {
				logger.info("Cerrando conexin");
				m_Connection.close();
				logger.info("Conexin cerrada");
			} catch (Exception e) {
				imprimirError(e);

			}
		}
		return resultado;
	}

	/**
	 * Ejecuta una una select sobre las vistas personal y asignaciones y
	 * devuelve las asignaciones sin finalizar
	 * 
	 */
	public ArrayList<m05bAsignacion> asignacionesVivas(String [] departamentos,String idioma, int numPagina) {

		ArrayList<m05bAsignacion> resultado = null;
		PreparedStatement stmt = null;
		ResultSet rs = null;
		StringBuffer strsql = new StringBuffer();
		Connection m_Connection = null;
		try {
			m05bAsignacion current;
			resultado = new ArrayList<m05bAsignacion>();
			strsql.append(getMainVivas(departamentos,idioma));
			if(numPagina==m05bPaginator.INITPAGE){
				int cuenta=0;			 
				cuenta=contarRegistros(strsql); 
				current= new m05bAsignacion();
				current.setNumeroPaginas((int)Math.ceil((double)cuenta/m05bPaginator.PAGESIZE));
				current.setNumeroRegistros(cuenta);
				resultado.add(current);
				numPagina=1;
			}
			if(numPagina!=m05bPaginator.NO){
		
				strsql=paginar(strsql,numPagina);
			}
			// //System.out.println(strsql.toString());
			m05bConexion miConex = new m05bConexion();
			m_Connection = miConex.getConnection();
			stmt = m_Connection.prepareStatement(strsql.toString());
			logger.info("Ejecutando sql"+strsql.toString());rs = stmt.executeQuery();
	
			while (rs.next()) {
				current = new m05bAsignacion();
				current.setId(rs.getInt("ID_ASIGNACIONES"));
				current.setNombre(rs.getString("NOMBRE"));
				current.setMatricula(rs.getString("MATRICULA"));
				current.setFechaDecreto(rs.getDate("FECHA_DESDE"));
				current.setCargo(rs.getString("DESC_CARGO"));
				current.setDepartamento(rs.getString("DEPARTAMENTO"));
				resultado.add(current);
			}

			stmt.close();
		} catch (Exception e) {
			imprimirError(e);
			logger.info("Cerrando conexin");
		} finally {
			try {
				logger.info("Cerrando conexin");
				m_Connection.close();
				logger.info("Conexin cerrada");
			} catch (Exception e) {
				imprimirError(e);

			}
		}
		return resultado;
	}

	/**
	 * Ejecuta una selec en las vistas vehiculos, personal y asignaciones segun
	 * los parametros de entrada
	 * 
	 * @param marcas
	 * @param modelos
	 * @param rangos
	 * @param situaciones
	 * @param fechaDevolucion
	 * @return
	 */
	public ArrayList<m05bAsignacion> asignacionesAConductores(String[] marcas,
			String[] modelos, String[] rangos, String[] situaciones,
			int fechaDevolucion,String idioma, int numPagina) {

		ArrayList<m05bAsignacion> resultado = null;
		PreparedStatement stmt = null;
		ResultSet rs = null;
		StringBuffer strsql = new StringBuffer();
		Connection m_Connection = null;
		try {

			strsql.append(getConductoresMain(idioma));
			strsql.append(getWhereConductores(marcas, modelos, rangos,
					situaciones, fechaDevolucion));
			strsql.append(" ORDER BY Matricula,Marca,Modelo");
			m05bAsignacion current;
			resultado = new ArrayList<m05bAsignacion>();
			if(numPagina==m05bPaginator.INITPAGE){
				int cuenta=0;			 
				cuenta=contarRegistros(strsql); 
				current= new m05bAsignacion();
				current.setNumeroPaginas((int)Math.ceil((double)cuenta/m05bPaginator.PAGESIZE));
				current.setNumeroRegistros(cuenta);
				resultado.add(current);
				numPagina=1;
			}
			if(numPagina!=m05bPaginator.NO){
		
				strsql=paginar(strsql,numPagina);
			}
			
			// //System.out.println(strsql.toString());
			m05bConexion miConex = new m05bConexion();
			m_Connection = miConex.getConnection();
			stmt = m_Connection.prepareStatement(strsql.toString());
			logger.info("Ejecutando sql"+strsql.toString());rs = stmt.executeQuery();
		
			while (rs.next()) {
				current = new m05bAsignacion();
				current.setDepartamento(rs.getString("DEPARTAMENTO"));
				current.setMatricula(rs.getString("MATRICULA"));
				current.setMarca(rs.getString("MARCA"));
				current.setModelo(rs.getString("MODELO"));
				current.setFechaMatricula(rs.getDate("FECHA_MATRICULA"));
				current.setKilometraje(rs.getInt("KM_ACTUALES"));
				current.setRangoVehiculo(rs.getString("RANGOVEHICULO"));
				current.setCargo(rs.getString("DESC_CARGO"));
				current.setSituacion(rs.getString("SITUACION"));
				current.setFechaDevolucion(rs.getDate("FECHA_DEVOLUCION"));
				resultado.add(current);
			}

			stmt.close();
		} catch (Exception e) {
			imprimirError(e);
			logger.info("Cerrando conexin");
		} finally {
			try {
				logger.info("Cerrando conexin");
				m_Connection.close();
				logger.info("Conexin cerrada");
			} catch (Exception e) {
				imprimirError(e);
			}
		}
		return resultado;
	}

	/**
	 * Crea parte de la where para filtrar el cambio nombre si est en array
	 * 
	 * @param nombre
	 * @param bool
	 * @param array
	 * @return
	 */
	private StringBuffer stringArrayToSqlIn(String nombre, String bool,
			String[] array) {
		StringBuffer strsql = new StringBuffer();
		if (array != null) {
			strsql.append(" ");
			strsql.append(bool);
			strsql.append(" ");
			strsql.append(nombre);
			strsql.append(" in('");
			boolean first = true;
			for (String element : array) {
				if (!first)
					strsql.append(",'");

				strsql.append(element + "'");
				first = false;

			}
			strsql.append(")");

		}
		return strsql;

	}

	private StringBuffer rangoFechasToSql(String campo,String fechaDesde,String fechaHasta,String idioma){
		String formatoFecha="dd/MM/yyyy";
		if(!idioma.equals(m05bConstantesInformes.CASTELLANO))
			formatoFecha="yyyy/MM/dd";
		StringBuffer strsql=new StringBuffer();
		 if (fechaDesde.length() != 0 && fechaHasta.length() != 0) {
				strsql.append(" AND (");
				strsql.append(campo);
				strsql.append(" Between to_date('");
				strsql.append(fechaDesde);
				strsql.append("','");
				strsql.append(formatoFecha);
				strsql.append("') And to_date('");
				strsql.append(fechaHasta);
				strsql.append("','");
				strsql.append(formatoFecha);
				strsql.append("') )");

		  }
		 else if(fechaDesde.length() != 0 && fechaHasta.length() == 0){
			 strsql.append(" AND (");
				strsql.append(campo);
				strsql.append(">=to_date('");
				strsql.append(fechaDesde);
				strsql.append("','");
				strsql.append(formatoFecha);
				strsql.append("'))");
		 }
		 else if(fechaDesde.length() == 0 && fechaHasta.length() != 0){
			 strsql.append(" AND (");
				strsql.append(campo);
				strsql.append("<=to_date('");
				strsql.append(fechaHasta);
				strsql.append("','");
				strsql.append(formatoFecha);
				strsql.append("'))");
		 }
		  
		 return strsql;
	}
	/**
	 * Devuelve una lista de los Cargos disponibles
	 * 
	 */
	public ArrayList<m05bOption> getCargos(String idioma) {
		StringBuffer strsql = new StringBuffer("");
		
		strsql.append(" SELECT    distinct NVL("); 
		if(!idioma.equals(m05bConstantesInformes.CASTELLANO))
		strsql.append("E");
		strsql.append("DESCRIP_04,DESCRIP_04 )  as text, CODCARGO_21  as val FROM M0504T00,   M0521T00  WHERE    CODCARGO_21   =COD_CARG_04(+) and CODCARGO_21 is not null");
	
		strsql.append(" order by 1");
		//System.out.println(strsql.toString());
		return getOptions(strsql.toString());
	}

	/**
	 * Devuelve una lista de cargos por los cdigos de entrada
	 * @param cargos
	 * @return
	 */
	public ArrayList<m05bOption> getCargos(String [] cargos,String idioma) {
		StringBuffer strsql = new StringBuffer("");
		strsql.append(" SELECT    distinct NVL("); 
		if(!idioma.equals(m05bConstantesInformes.CASTELLANO))
			strsql.append("E");
		strsql.append("DESCRIP_04,DESCRIP_04 )  as text, CODCARGO_21  as val FROM M0504T00,   M0521T00  WHERE    CODCARGO_21   =COD_CARG_04(+) and CODCARGO_21 is not null");
		strsql.append(stringArrayToSqlIn("CODCARGO_21", "AND", cargos));
		strsql.append(" order by 1");
		return getOptions(strsql.toString());
	}
	/**
	 * Devuelve una lista de los rangos disponibles
	 * 
	 */
	public ArrayList<m05bOption> getRangos(String idioma) {
		StringBuffer strsql = new StringBuffer("");
		strsql.append("SELECT   distinct  CODRANGO_01||' - '|| NVL(");
		if(!idioma.equals(m05bConstantesInformes.CASTELLANO))
			strsql.append("E");
		strsql.append("DESCRIP_99,DESCRIP_99) as text,  CODRANGO_01 as val   FROM   M0599T00,   M0501T00  WHERE CODRANGO_01  =COD_DESC_99(+)  AND COD_TAB_99=11  order by CODRANGO_01");
		return getOptions(strsql.toString());
	}
	/**
	 * Devuelve una lista de rangos por lo cdigos de entrada
	 * @param rangos
	 * @return
	 */
	public ArrayList<m05bOption> getRangos(String [] rangos,String idioma) {
		StringBuffer strsql = new StringBuffer("");
		strsql.append("SELECT   distinct  CODRANGO_01||' - '|| NVL(");
		if(!idioma.equals(m05bConstantesInformes.CASTELLANO))
			strsql.append("E");
		strsql.append("DESCRIP_99,DESCRIP_99) as text,  CODRANGO_01 as val   FROM   M0599T00,   M0501T00  WHERE CODRANGO_01  =COD_DESC_99(+)  AND COD_TAB_99=11");
		strsql.append(stringArrayToSqlIn("CODRANGOVEHICULO", "AND", rangos));
		strsql.append(" order by CODRANGO_01");		
		return getOptions(strsql.toString());
	}
	/**
	 * Ejecuta una una select sobre la vista vehiculos (M0534V00) y devuelve una
	 * lista con todos los distintos aos
	 * 
	 */
	private ArrayList<m05bOption> getOptions(String sql) {

		ArrayList<m05bOption> resultado = null;
		PreparedStatement stmt = null;
		ResultSet rs = null;
		StringBuffer strsql = new StringBuffer();
		Connection m_Connection = null;
		try {

			strsql.append(sql);

			m05bConexion miConex = new m05bConexion();
			m_Connection = miConex.getConnection();
			stmt = m_Connection.prepareStatement(strsql.toString());

			logger.info("Ejecutando sql" + strsql.toString());
			rs = stmt.executeQuery();

			resultado = new ArrayList<m05bOption>();
			m05bOption current;
			while (rs.next()) {
				current = new m05bOption();
				current.setText(rs.getString("text"));
				current.setValue(rs.getString("val"));
				resultado.add(current);
			}

			stmt.close();
		} catch (Exception e) {
			imprimirError(e);
			logger.info("Cerrando conexin");
		} finally {
			try {
				logger.info("Cerrando conexin");
				m_Connection.close();
				logger.info("Conexin cerrada");
			} catch (Exception e) {
				imprimirError(e);

			}
		}
		return resultado;
	}
}
