package m05bClasses.m05bFirma;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.methods.MultipartPostMethod;

import m05bClasses.m05bComun;
import m05bClasses.m05bConstantes;
import m05bClasses.m05bFileLog;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;
import weblogic.xml.schema.binding.RuntimeUtils;
import com.izenpe.miscelanea.Miscelanea;

public class m05bPlatea {

	public static final String XML_VAL_NOEXISTE = "NOEXISTE";

    //FUNCIONES DE FIRMA

    /**
     * Crea un XML con la firma simple
     * @param strPfFirma String con la firma
     * @param bolPfXMLTag True si es necesario aadir la primera etiqueta del XML, False si no
     * @return String XML con la firma simple
     * @throws
     */
    public static String fncCrearXMLFirmaSimple(String strPfFirma, boolean bolPfXMLTag) {
    	StringBuffer sbSignedData = new StringBuffer();
    	if (bolPfXMLTag) {
    		sbSignedData.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
    	}
		sbSignedData.append("<ejgvDocument>");
		sbSignedData.append("<header>");
		sbSignedData.append("<type>SIMPLE_SIGNATURE</type>");
		sbSignedData.append("<version>1.0</version>");
		sbSignedData.append("<flags>0</flags>");
		sbSignedData.append("</header>");
		sbSignedData.append("<body>");
		sbSignedData.append("<simpleSignature>");
		sbSignedData.append(strPfFirma);
		sbSignedData.append("</simpleSignature>");
		sbSignedData.append("</body>");
		sbSignedData.append("</ejgvDocument>");
		return sbSignedData.toString();
    }//Fin fncCrearXMLFirmaSimple


    /**
	 * Retorna true si la firma es correcta, y false si no lo es
	 * @param strTokenUsuario String: Token de sesion
	 * @param firma String: Firma simple en base64
	 * @param bytesFichero byte[]: Fichero firmado
	 * @return boolean
	 * @throws Exception
	 */
	public static boolean fncVerificarFirma(String strTokenUsuario,String firma,byte[] bytesFichero)throws Exception {
		m05bFileLog miLog = new m05bFileLog();
		miLog.addTraza("", "m05bPlatea fncVerificarFirma", "Verificando Firma", m05bConstantes.LOG_NIVEL_BAJO);

		String[] arrayStringVacio = new String[0];

		String[] paramNames=new String[4];
		paramNames[0]="sSecurityToken";
		paramNames[1]="simpleSign";
		paramNames[2]="documents";
		paramNames[3]="args";

		//Es lo mismo
//		m05bClsLog.info("firma: "+firma);
//		byte[] byFirma=fncObtenerBytesFirma64(firma);
//		String strFirmaBase64=encode(byFirma);
//		m05bClsLog.info("strFirmaBase64: "+strFirmaBase64);

		String strFicheroBase64=encode(bytesFichero);

		String strVacio=RuntimeUtils.arrayToString(arrayStringVacio);

//		Verificar la firma
		String[] paramValues = new String[4];
		paramValues[0] = strTokenUsuario;
		//paramValues[1] = strFirmaBase64;
		paramValues[1] = firma;
		paramValues[2] = strFicheroBase64;
		paramValues[3] = strVacio;
		Object objResultadoFirma = m05bClsFuncionesWS.fncLlamarWS("verifySimplelSignByteArray", paramNames, paramValues);
		String strValido="false";
		if (objResultadoFirma == null || ((String)objResultadoFirma).trim().equals("")) {
			miLog.addTraza("", "m05bPlatea fncVerificarFirma", "No se ha podido firmar el documento. Error en los servicios de la e-Administraci&oacute;n: m&eacute;todo verifySimplelSignByteArray.", m05bConstantes.LOG_NIVEL_BAJO);
		} else {
			String strResultadoVerificacion=(String)objResultadoFirma;
			strValido=fncParsearXml(strResultadoVerificacion, "ns:valid");
			if (!strValido.equalsIgnoreCase("true")) {
				//Si no es vlido, lanzar una excepcin
				String strCausa=fncParsearXml(strResultadoVerificacion, "ns:description");
				miLog.addTraza("", "m05bPlatea fncVerificarFirma", "La firma no se ha validado. Causa: " + strCausa, m05bConstantes.LOG_NIVEL_BAJO);
			}
		}
		if(strValido.equals("true")) {
			miLog.addTraza("", "m05bPlatea fncVerificarFirma", "FIRMA OK", m05bConstantes.LOG_NIVEL_BAJO);
			return true;
		} else {
			return false;
		}
	}


    /**
	 * Retorna true si la firma es correcta, y false si no lo es
	 * @param strTokenUsuario String: Token de sesion
	 * @param firma String: Firma simple en base64
	 * @param strFicheroBase64 String: Fichero firmado en base64
	 * @return boolean
	 * @throws Exception
	 */
	public static boolean fncVerificarFirmaBase64(String strTokenUsuario, String firma, String strFicheroBase64) throws Exception {
		m05bFileLog miLog = new m05bFileLog();
		miLog.addTraza("", "m05bPlatea fncVerificarFirma", "Verificando Firma", m05bConstantes.LOG_NIVEL_BAJO);

		String[] arrayStringVacio = new String[0];

		String[] paramNames=new String[4];
		paramNames[0]="sSecurityToken";
		paramNames[1]="simpleSign";
		paramNames[2]="documents";
		paramNames[3]="args";

		String strVacio=RuntimeUtils.arrayToString(arrayStringVacio);

		//Verificar la firma
		String[] paramValues = new String[4];
		paramValues[0] = strTokenUsuario;
		paramValues[1] = firma;
		paramValues[2] = strFicheroBase64;
		paramValues[3] = strVacio;
		Object objResultadoFirma = m05bClsFuncionesWS.fncLlamarWS("verifySimplelSignByteArray", paramNames, paramValues);
		String strValido="false";
		if (objResultadoFirma == null || ((String)objResultadoFirma).trim().equals("")) {
			miLog.addTraza("", "m05bPlatea fncVerificarFirma", "No se ha podido firmar el documento. Error en los servicios de la e-Administraci&oacute;n: m&eacute;todo verifySimplelSignByteArray.", m05bConstantes.LOG_NIVEL_BAJO);
		} else {
			String strResultadoVerificacion=(String)objResultadoFirma;
			strValido=fncParsearXml(strResultadoVerificacion, "ns:valid");
			if (!strValido.equalsIgnoreCase("true")) {
				//Si no es vlido, lanzar una excepcin
				String strCausa=fncParsearXml(strResultadoVerificacion, "ns:description");
				miLog.addTraza("", "m05bPlatea fncVerificarFirma", "La firma no se ha validado. Causa: " + strCausa, m05bConstantes.LOG_NIVEL_BAJO);
			}
		}
		if(strValido.equals("true")) {
			miLog.addTraza("", "m05bPlatea fncVerificarFirma", "FIRMA OK", m05bConstantes.LOG_NIVEL_BAJO);
			return true;
		} else {
			return false;
		}
	}


	/**
	 * Retorna la firma completa
	 * @param strTokenUsuario String: Token de sesion
	 * @param firma String:Firma simple
	 * @param bytesFichero byte[]: Fichero firmado
	 * @return String
	 * @throws Exception
	 */
	public static String fncObtenerFirmaCompleta(String strTokenUsuario,String firma)throws Exception {
		m05bFileLog miLog = new m05bFileLog();
		miLog.addTraza("", "m05bPlatea fncObtenerFirmaCompleta", "INICIO", m05bConstantes.LOG_NIVEL_BAJO);

		String[] arrayStringVacio = new String[0];
		String strVacio=RuntimeUtils.arrayToString(arrayStringVacio);

		//Codificar firma base64
		byte[] byFirma=fncObtenerBytesFirma64(firma);
		String strFirmaBase64=encode(byFirma);
		//m05bClsLog.info("strFirmaBase64 xxxx: "+strFirmaBase64);

		String[] paramNames=new String[3];
		paramNames[0]="sSessionToken";
		paramNames[1]="baSimpleSignature";
		paramNames[2]="saCertificatePol";

		String paramValues[] = new String[3];
		paramValues[0] = strTokenUsuario;
		paramValues[1] = strFirmaBase64;
		paramValues[2] = strVacio;
		miLog.addTraza("", "m05bPlatea fncObtenerFirmaCompleta", "LLamar webService: convertToCompleteSignaturePKCS7", m05bConstantes.LOG_NIVEL_BAJO);
		Object objResultado = m05bClsFuncionesWS.fncLlamarWS("convertToCompleteSignaturePKCS7", paramNames,paramValues);

		return (String)objResultado;
	}


	/**
	 * Retorna la firma completa
	 * @param strTokenUsuario String: Token de sesion
	 * @param firma String:Firma simple
	 * @param bytesFichero byte[]: Fichero firmado
	 * @return String
	 * @throws Exception
	 */
	public static String fncObtenerFirmaCompletaBase64(String strTokenUsuario,String strFirmaBase64)throws Exception {
		m05bFileLog miLog = new m05bFileLog();
		miLog.addTraza("", "m05bPlatea fncObtenerFirmaCompleta", "INICIO", m05bConstantes.LOG_NIVEL_BAJO);

		String[] arrayStringVacio = new String[0];
		String strVacio=RuntimeUtils.arrayToString(arrayStringVacio);

		String[] paramNames=new String[3];
		paramNames[0]="sSessionToken";
		paramNames[1]="baSimpleSignature";
		paramNames[2]="saCertificatePol";

		String paramValues[] = new String[3];
		paramValues[0] = strTokenUsuario;
		paramValues[1] = strFirmaBase64;
		paramValues[2] = strVacio;
		miLog.addTraza("", "m05bPlatea fncObtenerFirmaCompleta", "LLamar webService: convertToCompleteSignaturePKCS7", m05bConstantes.LOG_NIVEL_BAJO);
		Object objResultado = m05bClsFuncionesWS.fncLlamarWS("convertToCompleteSignaturePKCS7", paramNames,paramValues);
		//miLog.addTraza("", "m05bPlatea fncObtenerFirmaCompleta", "LLamar webService: convertToCompleteSignaturePKCS7 objResultado-->" + objResultado, m05bConstantes.LOG_NIVEL_BAJO);

		return (String)objResultado;
	}


	/**
	 *
	 * @param strTokenUsuario String. Token de sesion
	 * @param firma String. Firma simple
	 * @throws Exception
	 */
	public static String fncObtenerDatosFirmaSencilla(String strTokenUsuario,String firma)throws Exception {
		m05bFileLog miLog = new m05bFileLog();
		miLog.addTraza("", "m05bPlatea fncObtenerDatosFirmaSencilla", "INICIO", m05bConstantes.LOG_NIVEL_BAJO);

		byte[] byFirma=fncObtenerBytesFirma64(firma);
		String strFirmaBase64=encode(byFirma);

		String[] paramNames=new String[2];
		paramNames[0]="sSessionToken";
		paramNames[1]="baSimpleSign";

		String paramValues[] = new String[2];
		paramValues[0] = strTokenUsuario;
		paramValues[1] = strFirmaBase64;
		/*m05bClsLog.info("LLamar webService: getSignatureCertificateInfo");
		Object objResultado = m05bClsFuncionesWS.fncLlamarWS("getSignatureCertificateInfo", paramNames,paramValues);*/
		miLog.addTraza("", "m05bPlatea fncObtenerDatosFirmaSencilla", "LLamar webService: getSignatureCertificateInfoGeneric", m05bConstantes.LOG_NIVEL_BAJO);
		Object objResultado = m05bClsFuncionesWS.fncLlamarWS("getSignatureCertificateInfoGeneric", paramNames,paramValues);
		return (String)objResultado;
	}

	/**
	 * Llama al webservice de SHF para obtener los datos de una firma completa, y retorna la cadena
	 * devuelta por dicho webservice.
	 *
	 * NOTA:
	 * En lugar de llamar a esta funcin directamente, llamar a m05bFunciones.obtenerFirmaCompleta que
	 * devuelve un bean con los datos de la firma extraidos.
	 *
	 * @param strTokenUsuario Token de seguridad que hay que pasar al SHF
	 * @param bytesDocum Bytes del documento firmado
	 * @param firmaCompleta Cadena con el xml de firma completa
	 * @return Cadena devuelta por el webservice.
	 * @throws Exception
	 */
	public static String fncObtenerDatosFirmaCompleta(String strTokenUsuario, byte [] bytesDocum, String firmaCompleta)throws Exception {
		m05bFileLog miLog = new m05bFileLog();
		miLog.addTraza("", "m05bPlatea fncObtenerDatosFirmaCompleta", "INICIO", m05bConstantes.LOG_NIVEL_BAJO);

		String strDocumBase64=encode(bytesDocum);
		String[] paramNames=new String[4];
		paramNames[0]="sSecurityToken";
		paramNames[1]="verDocums";
		paramNames[2]="sComplSign";
		paramNames[3]="sArgs";

		String paramValues[] = new String[4];
		paramValues[0] = strTokenUsuario;
		paramValues[1] = strDocumBase64;
		paramValues[2] = firmaCompleta;
		paramValues[3] = "";
		miLog.addTraza("", "m05bPlatea fncObtenerDatosFirmaCompleta", "LLamar webService: verifyComplSignByteArray", m05bConstantes.LOG_NIVEL_BAJO);
		Object objResultado = m05bClsFuncionesWS.fncLlamarWS("verifyComplSignByteArray", paramNames, paramValues);
		//m05bClsLog.debug("Retorno fncObtenerDatosFirmaCompleta: "+(String)objResultado);
		return (String)objResultado;
	}


	/**
	 * Retorna la firma en b64
	 * @param firma String. Firma digital
	 * @return byte[]: Array de bytes con la firma en base 64
	 * @throws Exception
	 */
	public static byte[] fncObtenerBytesFirma64(String firma)throws Exception {
		Miscelanea m = new Miscelanea();

		ByteArrayOutputStream firmaBos = new ByteArrayOutputStream();
		m.base64Bin(firma, firmaBos);
		byte[] byteFirma=firmaBos.toByteArray();
		byteFirma.toString();

		return byteFirma;
	}


	/**
	 * Funcion que calcula el hash del array de bytes pasado en el argumento "bytesDatos", llamando
	 * al SHF. Comprueba el tamao del array frente al tamao lmite especificado en el fichero de
	 * propiedades (entrada TAM_LIM_FICHERO).
	 * Si s se supera el lmite, llama a "fncObtenerHashLargo".
	 * Si no se supera el lmite, llama a "fncObtenerHashCorto".
	 * @param strTokenUsuario Token de sesion
	 * @param bytesDatos Array de bytes cuyo hash se quiere calcular.
	 * @return String en base64 del hash calculado
	 * @throws Exception
	 */
	public static String fncObtenerHash (String strTokenUsuario, byte[] bytesDatos) throws Exception {
		m05bFileLog miLog = new m05bFileLog();
		miLog.addTraza("", "m05bPlatea fncObtenerHash", "INICIO", m05bConstantes.LOG_NIVEL_BAJO);
		int tam = bytesDatos.length;
		miLog.addTraza("", "m05bPlatea fncObtenerHash", "bytesDatos.length -> "+tam, m05bConstantes.LOG_NIVEL_BAJO);

		//Lee limite de fichero propiedades
		m05bComun miComun = new m05bComun();
		String strLimite = miComun.leerPropiedad("firma.fichero.tamanyolimite");
		int limite = Integer.parseInt(strLimite);
		miLog.addTraza("", "m05bPlatea fncObtenerHash", "Limite tamao -> "+limite, m05bConstantes.LOG_NIVEL_BAJO);

		if (tam > limite) {
			return fncObtenerHashLargo(strTokenUsuario, bytesDatos);
		} else {
			return fncObtenerHashCorto(strTokenUsuario, bytesDatos);
		}
	}

	/**
	 * Funcin que llama al webservice "hashByteArray" del SHF, para calcular el hash de una cantidad
	 * pequea de bytes.
	 * @param strTokenUsuario Token de sesion
	 * @param bytesDatos Array de bytes cuyo hash se quiere calcular.
	 * @return String en base64 del hash calculado
	 * @throws Exception
	 */
	public static String fncObtenerHashCorto (String strTokenUsuario, byte[] bytesDatos) throws Exception {
		m05bFileLog miLog = new m05bFileLog();
		miLog.addTraza("", "m05bPlatea fncObtenerHashCorto", "INICIO", m05bConstantes.LOG_NIVEL_BAJO);
		//int tam = bytesDatos.length;
		//m05bClsLog.info("bytesDatos.length -> "+tam);
		String strHashBase64=encode(bytesDatos);

		String[] paramNames=new String[2];
		paramNames[0]="sSecurityToken";
		paramNames[1]="documents";

		String paramValues[] = new String[2];
		paramValues[0] = strTokenUsuario;
		paramValues[1] = strHashBase64;
		miLog.addTraza("", "m05bPlatea fncObtenerHashCorto", "LLamar webService: hashByteArray", m05bConstantes.LOG_NIVEL_BAJO);
		Object objResultado = m05bClsFuncionesWS.fncLlamarWS("hashByteArray", paramNames, paramValues);
		return (String)objResultado;
	}

	/**
	 * Funcin que llama al webservice "hashFileString" del SHF, para calcular el hash de una cantidad
	 * grande de bytes.
	 * @param strTokenUsuario Token de sesion
	 * @param bytesDatos Array de bytes cuyo hash se quiere calcular.
	 * @return String en base64 del hash calculado
	 * @throws Exception
	 */
	public static String fncObtenerHashLargo (String strTokenUsuario, byte[] bytesDatos) throws Exception {
		m05bFileLog miLog = new m05bFileLog();
		miLog.addTraza("", "m05bPlatea fncObtenerHashLargo", "INICIO", m05bConstantes.LOG_NIVEL_BAJO);

		//PASO 1 Subimos el fichero al servidor
		 String nombreTmpHash = "";
		 nombreTmpHash = "h" + System.currentTimeMillis() + ".txt";
		 String rutaTmpHash = subirFichero(bytesDatos, nombreTmpHash);
		 rutaTmpHash = rutaTmpHash.replaceAll("%2F", "/");
		//int tam = bytesDatos.length;
		//m05bClsLog.info("bytesDatos.length -> "+tam);
		//String strHashBase64=encode(bytesDatos);

		//PASO 2 Obtener el hash de ese fichero grande, a partir de su ruta temporal.
		String[] paramNames=new String[2];
		paramNames[0]="sSecurityToken";
		paramNames[1]="documents";

		String paramValues[] = new String[2];
		paramValues[0] = strTokenUsuario;
		//paramValues[1] = strHashBase64;
		paramValues[1] = rutaTmpHash;
		miLog.addTraza("", "m05bPlatea fncObtenerHashLargo", "LLamar webService: hashFileString", m05bConstantes.LOG_NIVEL_BAJO);
		Object objResultado = m05bClsFuncionesWS.fncLlamarWS("hashFileString", paramNames, paramValues);
		return (String)objResultado;
	}


	/**
	 * Comprueba si una firma sencilla fue realizada por un firmante concreto, identificado
	 * por su DNI.
	 * @param strTokenUsuario Token de sesion
	 * @param strFirmaSimple Cadena con la firma simple en base 64
	 * @param strDniSolicitado DNI del firmante a comprobar, el firmante que debera haber
	 * realizado la firma.
	 * @return True si la firma corresponde con el firmante solicitado
	 * @throws Exception
	 */
	public static boolean fncCompruebaDniFirma (String strTokenUsuario, String strFirmaSimple, String strDniSolicitado) throws Exception {
		m05bFileLog miLog = new m05bFileLog();
		miLog.addTraza("", "m05bPlatea fncCompruebaDniFirma", "Entra en fncCompruebaDniFirma", m05bConstantes.LOG_NIVEL_BAJO);
		miLog.addTraza("", "m05bPlatea fncCompruebaDniFirma", "dniSolicitado: "+strDniSolicitado, m05bConstantes.LOG_NIVEL_BAJO);

		//Alinea a 8, por si tuviera menos
		StringBuffer sb = new StringBuffer(strDniSolicitado);
		while (sb.length()<8) {
			sb.insert(0, "0");
		}
		strDniSolicitado = sb.toString();
		miLog.addTraza("", "m05bPlatea fncCompruebaDniFirma", "dni alineado: "+strDniSolicitado, m05bConstantes.LOG_NIVEL_BAJO);

		String datosFirma=fncObtenerDatosFirmaSencilla(strTokenUsuario, strFirmaSimple);
		miLog.addTraza("", "m05bPlatea fncCompruebaDniFirma", "datosFirma: "+datosFirma, m05bConstantes.LOG_NIVEL_BAJO);

		String dniFirma=fncParsearXml(datosFirma, "idPersona");
		miLog.addTraza("", "m05bPlatea fncCompruebaDniFirma", "Dni extraido de firma: "+dniFirma, m05bConstantes.LOG_NIVEL_BAJO);
		//Compara los 8 digitos (sin letra)
		if (strDniSolicitado.equalsIgnoreCase(dniFirma.substring(0,8))) {
			return true;
		} else {
			miLog.addTraza("", "m05bPlatea fncCompruebaDniFirma", "ERROR. El firmante no es el que deberia", m05bConstantes.LOG_NIVEL_BAJO);
			return false;
		}
	}


	/**
	* Codifica en Base64 un array de bytes
	* @param decData Datos a codificar
	* @return String con los datos codificados en Base64
	* @throws
	*/
	public static String encode(byte[] decData) {
	String encData;
	BASE64Encoder encoder;
	encoder = new BASE64Encoder();
	encData = encoder.encode(decData);
	return encData;
	}//Fin encode

	/**
	* Codifica en Base64 una cadena de caracteres
	* @param decData Datos a codificar
	* @return String con los datos codificados en Base64
	* @throws
	*/
	public static String encodeString(String decData) {
		return encode(decData.getBytes());
	}//Fin encodeString

	/**
	* Decodifica una cadena de caracteres que se encuentra codificada en formato Base64
	* @param encData Datos a decodificar
	* @return Bytes con los datos decodificados
	* @throws Exception
	*/
	public static byte[] decode(String encData) throws Exception {
		byte[] decData;
		BASE64Decoder decoder;
		decoder = new BASE64Decoder();
		decData = decoder.decodeBuffer(encData);
		return decData;
	}//Fin decode

	/**
	* Decodifica una cadena de caracteres que se encuentra codificada en formato Base64
	* @param encData Datos a decodificar
	* @return String con los datos decodificados
	* @throws Exception
	*/
	public static String decodeToString(String encData) throws Exception {
		String decoded = null;
		decoded = new String(decode(encData));
		return decoded;
	}//Fin decodeToString


	//FIN FUNCIONES DE FIRMA



	 /**
     * Parsea un documento XML
     * @param xml String que contiene el XML
     * @param s String
     * @return String Documento XML parseado
     * @throws Exception
     */
	public static String fncParsearXml(String xml, String s)throws Exception {
    	int i=xml.indexOf("<"+s+">");
    	if (i==-1)
    		return XML_VAL_NOEXISTE;
        String salida=xml.substring(i+s.length()+2,xml.indexOf("</"+s+">"));
        return salida;
    }//Fin fncParsearXml

    //Metodo encargado de subir el fichero pasado como parametro a la ruta temporal
    public static String subirFichero(byte[] fichero, String nombreFichero) throws Exception {
    	m05bFileLog miLog = new m05bFileLog();
		miLog.addTraza("", "m05bPlatea subirFichero", "nombreFichero="+nombreFichero, m05bConstantes.LOG_NIVEL_BAJO);

        String rutaFichero = "";
        File f1 = null;
        MultipartPostMethod mPost = null;
        try {
        	/*
        	 * 	private static String strUrlFileTransfer;
				private static String strRutaTemporal;
        	 */
        	m05bComun miComun = new m05bComun();
            String url = miComun.leerPropiedad("firma.urlfiletransfer");
            HttpClient client = new HttpClient();
            mPost = new MultipartPostMethod(url);
            client.setConnectionTimeout(8000);
            //Guardar el fichero sacado de base de datos en la ruta temporal, con un nombre unico
            f1 = new File(miComun.leerPropiedad("firma.rutatemporal"), nombreFichero);
            DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(f1)));
            dos.write(fichero);
            dos.flush();
            dos.close();    //Cerramos el dataoutputstream, para que no haya referencias al file que impidan hacer luego el delete
            //Aadimos como parametro para la llamada a la url
            mPost.addParameter(f1.getName(), f1);

            client.executeMethod(mPost);
            //Llamamos al servlet
            byte[] responseBody = mPost.getResponseBody();
            //Pintamos la respuesta
            if (responseBody!=null) {
            	miLog.addTraza("", "m05bPlatea subirFichero", "responseBody no es null y vale: " + new String(responseBody), m05bConstantes.LOG_NIVEL_BAJO);
            } else {
            	miLog.addTraza("", "m05bPlatea subirFichero", "responseBody es null", m05bConstantes.LOG_NIVEL_BAJO);
            }
            rutaFichero = new String(responseBody);
        } catch (Exception e) {
        	miLog.addTraza("", "m05bPlatea subirFichero", "Error exception="+e.getMessage(), m05bConstantes.LOG_NIVEL_BAJO);
            throw e;
        } finally {
            //Liberamos la conexion
            if (mPost != null) {
                mPost.releaseConnection();
            }
        }
        return (rutaFichero);
    }
}