package m05bClasses;

import java.util.Properties;
import java.io.InputStream;

/**
 * Clase de acceso al fichero de propiedades "/m05b/m05b.properties", segn patrn Singleton
 *
 */
public final class m05bFicheroProperties {

	/* Variables privadas */
	private	static	final	String			PROPERTIES_FILENAME	= m05bConstantesPaginas.PATH_PROPERTIES;
	private static		Properties			configurationParameters;

	/* Instancia privada segn patrn Singleton */
	private static m05bFicheroProperties iSingleton;

	/* Constructor privado */
	private m05bFicheroProperties() {

		try {
			InputStream inputStream = getClass().getResourceAsStream(PROPERTIES_FILENAME);
			configurationParameters = new Properties();
			configurationParameters.load(inputStream);
			inputStream.close();
		} catch (Exception e) {
			System.err.println("C12wVariableConfigurationParameters: No se ha podido cargar el fichero de propiedades = " + PROPERTIES_FILENAME);
			m05bFileLog miLog = new m05bFileLog();
			miLog.addTraza(e);		
		}
	}

	/* Retorna la instancia segn Singleton */
	public static m05bFicheroProperties getInstance() { 
		if (iSingleton == null) {
			iSingleton = new m05bFicheroProperties();
		}
		return iSingleton;
	}

	/**
	 * Retorna el valor de una propiedad especificada en el fichero
	 * <i>properties</i> de configuracion.
	 * @param name String, Nombre de la propriedad.
	 */
	public static String getParameter(String name) {
		return configurationParameters.getProperty(name);
	}
}