package m05bClasses.m05bDokusi.ws;

import java.text.SimpleDateFormat;
import java.util.Date;
import m05bClasses.m05bComun;
import m05bClasses.m05bConstantes;

public class M05BCreateParameters {

	public static String crearAtributosAlmacenarPDF(String titulo, String firmante) throws Exception {
		m05bComun miComun = new m05bComun();

		StringBuffer strXML = new StringBuffer();
		strXML.append("<?xml version=\"1.0\" encoding=\"utf-16\" ?>");
		strXML.append("<attributeList xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">");

		strXML.append("<attribute>");
		strXML.append("<key>acl_name</key>");
		strXML.append("<value>" + miComun.leerPropiedad("DOKUSI_ACL") + "</value>"); 
		strXML.append("</attribute>");

		strXML.append("<attribute>");
		strXML.append("<key>ejgv_serie</key>");
		strXML.append("<value>" + miComun.leerPropiedad("DOKUSI_SERIE") + "</value>");
		strXML.append("</attribute>");

		strXML.append("<attribute>");
		strXML.append("<key>ejgv_origen</key>");
		strXML.append("<value>ADMINISTRACION</value>"); 
		strXML.append("</attribute>");

		strXML.append("<attribute>");
		strXML.append("<key>title</key>");
		strXML.append("<value>" + titulo + "</value>"); 
		strXML.append("</attribute>");

		strXML.append("<attribute>");
		strXML.append("<key>object_name</key>");
		strXML.append("<value>" + titulo + new SimpleDateFormat("yyyymmdd_HHmmss").format(new Date()) + "</value>"); 
		strXML.append("</attribute>");

		strXML.append("<attribute>");
		strXML.append("<key>ejgv_procedimiento</key>");
		strXML.append("<value>" + miComun.leerPropiedad("DOKUSI_PROCEDIMIENTO") + "</value>"); 
		strXML.append("</attribute>");

		strXML.append("<attribute>");
		strXML.append("<key>ejgv_nom_firmantes</key>");
		strXML.append("<value>" + firmante + "</value>"); 
		strXML.append("</attribute>");

		strXML.append("<attribute>");
		strXML.append("<key>authors</key>");
		strXML.append("<value>" + m05bConstantes.CODIGO_APLICACION + "</value>"); 
		strXML.append("</attribute>");

		strXML.append("<attribute>");
		strXML.append("<key>ejgv_fecha_documento</key>");
		strXML.append("<value>" + new SimpleDateFormat("dd/MM/yyyy HH:mm:ss").format(new Date()) + "</value>"); 
		strXML.append("</attribute>");

		strXML.append("</attributeList>");

		return strXML.toString();
	}

	public static String crearContenidoPDF(String documentoBase64) throws Exception {
		StringBuffer strXML = new StringBuffer();

		strXML.append("<?xml version=\"1.0\" encoding=\"utf-16\" ?>");
		strXML.append("<content xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">");

		strXML.append("<content>");
		strXML.append(documentoBase64);
		strXML.append("</content>");

		strXML.append("<format>");
		strXML.append("<name>" + "pdf" + "</name>"); 
		strXML.append("<extension>" + "pdf" + "</extension>");
		strXML.append("<mimeType>" + "application/pdf" + "</mimeType>");
		strXML.append("</format>");

		strXML.append("</content>");

		return strXML.toString();
	}

	public static String crearFirmasPDF(String firma, String oid_documento, String versionDocumento, String dniFirmante, String nombreFirmante) throws Exception {

		StringBuffer strXML = new StringBuffer();

		strXML.append("<?xml version=\"1.0\" encoding=\"utf-16\" ?>");

		strXML.append("<signatureList>");
		strXML.append("<signature>");

		strXML.append("<signedDocumentID><documentID><id>" + oid_documento + "</id><version>" + versionDocumento + "</version></documentID></signedDocumentID>");

		strXML.append("<signature>" + "<![CDATA[" + firma + "]]>" + "</signature>");

		strXML.append("<signatureInfoList>");
			strXML.append("<signatureInfo>");
				strXML.append("<department>" + nombreFirmante + "</department>");
				strXML.append("<entity/>");
				strXML.append("<signerID>" + dniFirmante + "</signerID>");
				strXML.append("<signerName>" + nombreFirmante + "</signerName>");
				strXML.append("<responsability/>");
            strXML.append("</signatureInfo>");
		strXML.append("</signatureInfoList>");

		strXML.append("<date>" + new SimpleDateFormat("dd/MM/yyyy HH:mm:ss").format(new Date()) + "</date>");
		strXML.append("<type>digital</type>");
		strXML.append("<format>");
			strXML.append("<name>pdf</name>");
			strXML.append("<extension>pdf</extension>");
			strXML.append("<mimeType>application/pdf</mimeType>");
		strXML.append("</format>");

		strXML.append("</signature>");
		strXML.append("</signatureList>");

		return strXML.toString();
	}
	
	public static String crearDocumentID(String oid_documento, String versionDocumento) throws Exception {

		StringBuffer strXML = new StringBuffer();

		strXML.append("<?xml version=\"1.0\" encoding=\"utf-16\" ?>");
		strXML.append("<documentID xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">");
		strXML.append("<id>" + oid_documento + "</id>");
		strXML.append("<version>" + versionDocumento + "</version>");
		strXML.append("</documentID>");

		return strXML.toString();
	}

	public static String crearListaKeys() throws Exception {

		StringBuffer strXML = new StringBuffer();

		strXML.append("<object_name></object_name>");
		strXML.append("<r_object_type></r_object_type>");
		strXML.append("<authors></authors>");
		strXML.append("<r_version_label></r_version_label>");
		strXML.append("<ejgv_fecha_digitalizacion></ejgv_fecha_digitalizacion>");

		return strXML.toString();
	}

	public static String crearContenidoRetPrimario() throws Exception {

		StringBuffer strXML = new StringBuffer();

		strXML.append("<?xml version=\"1.0\" encoding=\"utf-16\" ?>");
		strXML.append("<content xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">");
		strXML.append("<format>");

		strXML.append("<name>pdf</name>");
		strXML.append("<extension>pdf</extension>");
		strXML.append("<mimeType>application/pdf</mimeType>");

		strXML.append("</format>");
		strXML.append("</content>");

		return strXML.toString();
	}
}