package m05bClasses.m05bDokusi.parsers;

import noNamespace.DocumentDocument;
import noNamespace.DocumentIDDocument;
import noNamespace.T65BAttributeListType;
import noNamespace.T65BAttributeType;
import noNamespace.T65BContentType;
import noNamespace.T65BDocumentIDType;
import noNamespace.T65BDocumentType;
import noNamespace.T65BFormatType;
import noNamespace.T65BSignatureInfoListType;
import noNamespace.T65BSignatureInfoType;
import noNamespace.T65BSignatureType;
import noNamespace.FormatDocument;
import noNamespace.SignatureDocument;
import noNamespace.SignatureListDocument;

import m05bClasses.m05bFileLog;
import m05bClasses.m05bDokusi.models.T65BAttribute;
import m05bClasses.m05bDokusi.models.T65BContent;
import m05bClasses.m05bDokusi.models.T65BDocument;
import m05bClasses.m05bDokusi.models.T65BDocumentID;
import m05bClasses.m05bDokusi.models.T65BFormat;
import m05bClasses.m05bDokusi.models.T65BSignature;
import m05bClasses.m05bDokusi.models.T65BSignatureInfo;

public class T65BHDCustomParser {
	public static T65BDocumentID parseToT65BDocumentID(String pStrXMLBean)
			throws Exception {

		DocumentIDDocument documentIDDocument = null;

		T65BDocumentID documentID = null;

		if (!(pStrXMLBean == null || pStrXMLBean.equals(""))) {

			try {
				documentIDDocument = DocumentIDDocument.Factory
						.parse(pStrXMLBean);

				documentID = parseToT65BDocumentID(documentIDDocument
						.getDocumentID());

			} catch (Exception xme) {
				
				  m05bFileLog log= new m05bFileLog(); log.addTraza(xme);
				throw new Exception("Error al parsear el documento - ERROR: " + xme.getMessage());
			}
		}

		return documentID;

	}

	private static T65BDocumentID parseToT65BDocumentID(
			T65BDocumentIDType documentIDType) {

		T65BDocumentID documentID = null;

		if (documentIDType != null) {
			documentID = new T65BDocumentID();
			documentID.setId(documentIDType.getId());
			documentID.setVersion(documentIDType.getVersion());
		}
		return documentID;
	}
	
	private static T65BFormat parseToT65BFormat(T65BFormatType pFormatType){
		T65BFormat format=null;
		if (pFormatType!=null) {
			format=new T65BFormat();
			format.setExtension(pFormatType.getExtension());
			format.setMimeType(pFormatType.getMimeType());
			format.setDescription(pFormatType.getDescription());
			format.setName(pFormatType.getName());
		}
		return format;
	}
	
	public static T65BFormat parseToT65BFormat(String pStrXMLBean) throws Exception {
		FormatDocument formatDocument = null;
		
		T65BFormat format= null;
		if (!(pStrXMLBean == null || pStrXMLBean.equals(""))) {
			try {
				
				formatDocument = FormatDocument.Factory.parse(pStrXMLBean);
				format = parseToT65BFormat(formatDocument.getFormat());
			} catch (Exception xme) {
				  m05bFileLog log= new m05bFileLog(); log.addTraza(xme);
				throw new Exception("Error al parsear el documento - ERROR: " + xme.getMessage());
			}	
		}
		return format;
	}

	private static T65BSignature parseToT65BSignature(T65BSignatureType signatureType) {
		T65BSignature signature = null;
		if (signatureType != null) {
			signature = new T65BSignature();
			signature.setSignedDocumentId(parseToT65BDocumentID(signatureType.getSignedDocumentId()));
			signature.setDate(signatureType.getDate());
			//signature.setSignature_format(signatureType.getSignatureFormat()); //
			//signature.setSignature_profile(signatureType.getSignatureProfile());//
			//signature.setSignature_type(signatureType.getSignatureType()); //
			//signature.setTimestamp_serial_number(signatureType.getTimestampSerialNumber());//
			signature.setFormat(parseToT65BFormat(signatureType.getFormat()));
			//signature.setIsConservable(signatureType.getIsConservable());//
			//signature.setIsDocumentRequiered(signatureType.getDocumentIsRequiered());//
			signature.setSignatureInfoList(parseToT65BSignatureInfoList(signatureType.getSignatureInfoList()));
			signature.setType(signatureType.getType());
			signature.setSignature(signatureType.getSignature());
			
		}
		return signature;
	}

	private static T65BSignatureInfo[] parseToT65BSignatureInfoList(T65BSignatureInfoListType signatureInfoTypeList){
		T65BSignatureInfo [] signatureInfoList =null;
		if (signatureInfoTypeList!=null){
			signatureInfoList = new T65BSignatureInfo [signatureInfoTypeList.sizeOfSignatureInfoArray()];
			for (int i=0;i<signatureInfoTypeList.sizeOfSignatureInfoArray();i++){
				signatureInfoList[i]=parseToT65BSignatureInfo(signatureInfoTypeList.getSignatureInfoArray(i));
			}
		}
		return signatureInfoList;
	}

	private static T65BSignatureInfo parseToT65BSignatureInfo(T65BSignatureInfoType signatureInfoType){
		T65BSignatureInfo signatureInfo=null;
		if (signatureInfoType!=null){
			signatureInfo = new T65BSignatureInfo();
			signatureInfo.setDepartment(signatureInfoType.getDepartment());
			signatureInfo.setEntity(signatureInfoType.getEntity());
			signatureInfo.setResponsability(signatureInfoType.getResponsability());
			signatureInfo.setSignerID(signatureInfoType.getSignerID());
			signatureInfo.setSignerName(signatureInfoType.getSignerName());
		}
		return signatureInfo;
	}

	public static T65BSignature parseToT65BSignature(String pStrXMLBean) throws Exception {
		SignatureDocument signatureDocument = null;
		T65BSignature signature = null;
		if (!(pStrXMLBean == null || pStrXMLBean.equals(""))) {
			try {
				signatureDocument = SignatureDocument.Factory.parse(pStrXMLBean);
				signature = parseToT65BSignature(signatureDocument.getSignature());
			} catch (Exception xme) {
				  m05bFileLog log= new m05bFileLog(); log.addTraza(xme);
				throw new Exception("Error al parsear el documento - ERROR: " + xme.getMessage());
			}
		}
		return signature;
	}

	public static T65BSignature[] parseToT65BSignaturesArray(String pStrXMLBean) throws Exception {
		SignatureListDocument signatureListDocument = null;
		T65BSignatureType[] signatureTypes = null;
		T65BSignature[] signatures = null;
		if (!(pStrXMLBean == null || pStrXMLBean.equals(""))) {
			try {
				signatureListDocument = SignatureListDocument.Factory.parse(pStrXMLBean);
				signatureTypes = signatureListDocument.getSignatureList().getSignatureArray();
				signatures = new T65BSignature[signatureTypes.length];
				for (int i = 0; i < signatureTypes.length; i++) {
					signatures[i] = parseToT65BSignature(signatureTypes[i]);
				}
			} catch (Exception xme) {
				  m05bFileLog log= new m05bFileLog(); log.addTraza(xme);
				throw new Exception("Error al parsear el documento - ERROR: " + xme.getMessage());
			}
		}
		return signatures;
	}
	
	
	private static T65BDocument parseToT65BDocument(T65BDocumentType documentType) {
		T65BDocument document = null;
		if (documentType != null) {
			document = new T65BDocument();
			document.setDocumentID(parseToT65BDocumentID(documentType.getDocumentID()));
			document.setContent(parseToT65BContent(documentType.getContent()));
			document.setAttributes(parseToT65BAttributes(documentType.getAttributeList()));
		}
		return document;
	}

	public static T65BDocument parseToT65BDocument(String pStrXMLBean) throws Exception {
		DocumentDocument documentDocument = null;
		T65BDocument document = null;
		if (!(pStrXMLBean == null || pStrXMLBean.equals(""))) {
			try {
				documentDocument = DocumentDocument.Factory.parse(pStrXMLBean);
				document = parseToT65BDocument(documentDocument.getDocument());
			} catch (Exception xme) {
				  m05bFileLog log= new m05bFileLog(); log.addTraza(xme);
				throw new Exception("Error al parsear el documento - ERROR: " + xme.getMessage());
			}
		}
		return document;
	}

	/*
	 * Parseo de T65BContent
	 */
	private static T65BContent parseToT65BContent(T65BContentType pContentType) {
		T65BContent content = null;
		if (pContentType != null) {
			content = new T65BContent();
			content.setContent(pContentType.getContent());
			content.setDocLocation(pContentType.getDocLocation());
			content.setLenght(pContentType.getLenght());
			content.setFormat(parseToT65BFormat(pContentType.getFormat()));
		}
		return content;
	}
	
	private static T65BAttribute[] parseToT65BAttributes(T65BAttributeListType pAtributeListTypes) {
		T65BAttribute[] attributeList = null;
		if (pAtributeListTypes != null) {
			attributeList = new T65BAttribute[pAtributeListTypes.sizeOfAttributeArray()];
			for (int i = 0; i < pAtributeListTypes.sizeOfAttributeArray(); i++) {
				attributeList[i] = T65BHDCustomParser.parseToT65BAttribute(pAtributeListTypes.getAttributeArray(i));
			}
		}
		return attributeList;
	}
	
	private static T65BAttribute parseToT65BAttribute(T65BAttributeType pAtributeType) {
		T65BAttribute attribute = null;
		if (pAtributeType != null) {
			attribute = new T65BAttribute();
			attribute.setKey(pAtributeType.getKey());
			attribute.setValue(pAtributeType.getValue());
		}
		return attribute;
	}
}