package m05bClasses.m05bDokusi;

import m05bClasses.m05bConstantes;
import m05bClasses.m05bFileLog;
import m05bClasses.m05bDokusi.exceptions.m05bDokusiServiceException;
import m05bClasses.m05bDokusi.parsers.T65BHDCustomParser;
import m05bClasses.m05bDokusi.ws.M05BCreateParameters;
import m05bClasses.m05bDokusi.ws.M05BFSDWSInvoker;
import m05bClasses.m05bDokusi.models.T65BDocument;
import m05bClasses.m05bDokusi.models.T65BSignature;
import m05bClasses.m05bDokusi.models.T65BSignatureInfo;
import m05bLdap.SecurityHelpperXLNets;


public class m05bDokusiService {

	private m05bDokusiService() { }
	
	/**
	 *
	 * Obtiene una instancia de m05bDokusiService
	 * @return el m05bDokusiService
	 *
	 */
	static public m05bDokusiService getm05bDokusiService() {
		return new m05bDokusiService();
    }

	/**
	 * Metodo que almacena un documento en dokusi
	 * @throws m05bDokusiServiceException excepcion
	 */
	public String almacenarDocumento(String documentoBase64, String titulo, String dniFirmante, String nombreFirmante) throws m05bDokusiServiceException {

		try {
			String strResultID = null;

			String token = SecurityHelpperXLNets.getTokenXLNets(m05bConstantes.CODIGO_APLICACION);

			strResultID = M05BFSDWSInvoker.almacenarDocumento(
							token,
							this.obtenerAuditUser(dniFirmante, nombreFirmante),
							"ejgv_d_archivo",
							M05BCreateParameters.crearAtributosAlmacenarPDF(titulo, nombreFirmante),
							M05BCreateParameters.crearContenidoPDF(documentoBase64));

			if (strResultID.indexOf("ERROR") >= 0) {
				m05bFileLog miLog = new m05bFileLog();
		    	miLog.addTraza("", "m05bDokusiService->almacenarDocumento", "ERROR Soap return: " + strResultID, m05bConstantes.LOG_NIVEL_BAJO);
		    	return "-1";
			} else {
				//m05bFileLog miLog = new m05bFileLog();
		    	//miLog.addTraza("", "m05bDokusiService->almacenarDocumento", "Resultado almacenarDocumento: " + strResultID, m05bConstantes.LOG_NIVEL_BAJO);
		    	return strResultID;
			}
		} catch (Exception ex) {
			m05bFileLog miLog = new m05bFileLog();
	    	miLog.addTraza("", "m05bDokusiService->almacenarDocumento", "ERROR AL ALMACENAR EL DOCUMENTO EN DOKUSI: " + ex, m05bConstantes.LOG_NIVEL_BAJO);
			return "-1";
		}
	}

	public String adjuntarFirma(String firma, String idDocumento, String versionDocumento, String dniFirmante, String nombreFirmante) throws m05bDokusiServiceException {

		try {
			String strResultStr = null;

			String token = SecurityHelpperXLNets.getTokenXLNets(m05bConstantes.CODIGO_APLICACION);

			//m05bFileLog miLog1 = new m05bFileLog();
			//miLog1.addTraza("", "m05bDokusiService->adjuntarFirma M05BCreateParameters.crearFirmasPDF(firma, idDocumento, versionDocumento, dniFirmante, nombreFirmante)", M05BCreateParameters.crearFirmasPDF(firma, idDocumento, versionDocumento, dniFirmante, nombreFirmante), m05bConstantes.LOG_NIVEL_BAJO);
			
			strResultStr = M05BFSDWSInvoker.adjuntarFirmasAlDocumento(
											token,
											this.obtenerAuditUser(dniFirmante, nombreFirmante),
											idDocumento,
											M05BCreateParameters.crearFirmasPDF(firma, idDocumento, versionDocumento, dniFirmante, nombreFirmante));

			if (strResultStr.indexOf("ERROR") >= 0) {
				m05bFileLog miLog = new m05bFileLog();
		    	miLog.addTraza("", "m05bDokusiService->adjuntarFirma", "ERROR Soap return: " + strResultStr, m05bConstantes.LOG_NIVEL_BAJO);
		    	return "-1";
			} else {
				//m05bFileLog miLog = new m05bFileLog();
		    	//miLog.addTraza("", "m05bDokusiService->adjuntarFirma", "Resultado adjuntar firmas: " + strResultStr, m05bConstantes.LOG_NIVEL_BAJO);
		    	return strResultStr;
			}
		} catch (Exception ex) {
			m05bFileLog miLog = new m05bFileLog();
	    	miLog.addTraza("", "m05bDokusiService->adjuntarFirma", "ERROR AL ADJUNTAR LA FIRMA AL DOCUMENTO EN DOKUSI: " + ex, m05bConstantes.LOG_NIVEL_BAJO);
			return "-1";
		}
	}
	
	/**
	 * Metodo que recupera un documento de dokusi
	 * @throws m05bDokusiServiceException excepcion
	 */
	public T65BDocument recuperarDocumento(String idDocumento, String versionDocumento, String dniUsuario, String nombreUsuario) throws m05bDokusiServiceException {

		try {
			String strResultStr = null;

			String token = SecurityHelpperXLNets.getTokenXLNets(m05bConstantes.CODIGO_APLICACION);

			strResultStr = M05BFSDWSInvoker.recuperarDocumento(
											token,
											this.obtenerAuditUser(dniUsuario, nombreUsuario),
											M05BCreateParameters.crearDocumentID(idDocumento, versionDocumento),
											null,
											M05BCreateParameters.crearContenidoRetPrimario());

			if (strResultStr.indexOf("ERROR") >= 0) {
				m05bFileLog miLog = new m05bFileLog();
		    	miLog.addTraza("", "m05bDokusiService->recuperarDocumento", "ERROR Soap return: " + strResultStr, m05bConstantes.LOG_NIVEL_BAJO);
		    	return null;
			} else {
				T65BDocument document = T65BHDCustomParser.parseToT65BDocument(strResultStr);
				/*T65BDocumentID documentID = document.getDocumentID();
				T65BContent content = document.getContent();
				T65BAttribute[] attributes = document.getAttributes();
				if (documentID != null) {
					miLog.addTraza("", "m05bDokusiService->recuperarDocumento", "ID recuperado: " + documentID.getId(), m05bConstantes.LOG_NIVEL_BAJO);
					miLog.addTraza("", "m05bDokusiService->recuperarDocumento", "Version recuperada: " + documentID.getVersion(), m05bConstantes.LOG_NIVEL_BAJO);
				}
				if (content != null) {
					if (content.getContent() != null) {
						logger.info("Path local: " + T65BCreateParametersMix.createFileFromByteArray(content.getContent(), content.getFormat().getExtension()));
					} else if (content.getDocLocation() != null) {
						logger.info("Path remoto: " + content.getDocLocation());
					}
				}
				if (attributes != null && attributes.length > 0){
					for (int j = 0; j < attributes.length; j++) {
						logger.info("Attributes[" + j + "]: " + attributes[j].getKey() + " --> " + attributes[j].getValue());
						miLog.addTraza("", "m05bDokusiService->recuperarDocumento", "Version recuperada: " + documentID.getVersion(), m05bConstantes.LOG_NIVEL_BAJO);
					}
				}
				*/
				return document;
			}
		} catch (Exception ex) {
			m05bFileLog miLog = new m05bFileLog();
	    	miLog.addTraza("", "m05bDokusiService->recuperarDocumento", "ERROR AL ADJUNTAR LA FIRMA AL DOCUMENTO EN DOKUSI: " + ex, m05bConstantes.LOG_NIVEL_BAJO);
			return null;
		}
	}
	
	public T65BSignature[] recuperarFirmas(String idDocumento, String versionDocumento, String dniUsuario, String nombreUsuario) throws m05bDokusiServiceException {

		try {
			String strResultStr = null;

			String token = SecurityHelpperXLNets.getTokenXLNets(m05bConstantes.CODIGO_APLICACION);

			strResultStr = M05BFSDWSInvoker.recuperarFirmas(
											token,
											this.obtenerAuditUser(dniUsuario, nombreUsuario),
											M05BCreateParameters.crearDocumentID(idDocumento, versionDocumento),
											null);

			if (strResultStr.indexOf("ERROR") >= 0) {
				m05bFileLog miLog = new m05bFileLog();
		    	miLog.addTraza("", "m05bDokusiService->recuperarFirma", "ERROR Soap return: " + strResultStr, m05bConstantes.LOG_NIVEL_BAJO);
		    	return null;
			} else {
				//m05bFileLog miLog = new m05bFileLog();
		    	//miLog.addTraza("", "m05bDokusiService->recuperarFirma", "Resultado recuperar firmas: " + strResultStr, m05bConstantes.LOG_NIVEL_BAJO);
				T65BSignature[] signatures = T65BHDCustomParser.parseToT65BSignaturesArray(strResultStr);
				if (signatures != null && signatures.length > 0) {
					/*
					miLog.addTraza("", "m05bDokusiService->recuperarFirma", "Resultado recuperar firmas", m05bConstantes.LOG_NIVEL_BAJO);
					for (int j = 0; j < signatures.length; j ++) {
						miLog.addTraza("", "m05bDokusiService->recuperarFirma", "--> FIRMA '" + j + "' <--", m05bConstantes.LOG_NIVEL_BAJO);
						T65BSignature signature = signatures[j];
						miLog.addTraza("", "m05bDokusiService->recuperarFirma", "Fecha firma: " + signature.getDate(), m05bConstantes.LOG_NIVEL_BAJO);
						miLog.addTraza("", "m05bDokusiService->recuperarFirma", "Formato firmado: " + signature.getFormat().getName(), m05bConstantes.LOG_NIVEL_BAJO);
						miLog.addTraza("", "m05bDokusiService->recuperarFirma", "Tipo de firma: " + signature.getType(), m05bConstantes.LOG_NIVEL_BAJO);
						miLog.addTraza("", "m05bDokusiService->recuperarFirma", "Contenido: " + j + "': OMITO...\n", m05bConstantes.LOG_NIVEL_BAJO);

						T65BSignatureInfo[] signatureInfos = signature.getSignatureInfoList();
						if (signatureInfos != null && signatureInfos.length > 0){
							for (int m = 0; m < signatureInfos.length; m ++) {
								miLog.addTraza("", "m05bDokusiService->recuperarFirma", "Informacin de firma '" + m + "':", m05bConstantes.LOG_NIVEL_BAJO);
								miLog.addTraza("", "m05bDokusiService->recuperarFirma", "Nombre firmante: " + m + "': " + signatureInfos[m].getSignerName(), m05bConstantes.LOG_NIVEL_BAJO);
								miLog.addTraza("", "m05bDokusiService->recuperarFirma", "ID firmante: " + m + "': " + signatureInfos[m].getSignerID(), m05bConstantes.LOG_NIVEL_BAJO);
								miLog.addTraza("", "m05bDokusiService->recuperarFirma", "Departamento: " + m + "': " + signatureInfos[m].getDepartment(), m05bConstantes.LOG_NIVEL_BAJO);
								miLog.addTraza("", "m05bDokusiService->recuperarFirma", "Fecha firma: " + m + "': " + signatureInfos[m].getEntity(), m05bConstantes.LOG_NIVEL_BAJO);
							}
						}	
						if (signature.getSignature() != null) {
							miLog.addTraza("", "m05bDokusiService->recuperarFirma", "Siganture="+signature.getSignature(), m05bConstantes.LOG_NIVEL_BAJO);
						}
					}
					*/
					//miLog.addTraza("", "m05bDokusiService->recuperarFirma", "strResultStr="+strResultStr, m05bConstantes.LOG_NIVEL_BAJO);
					
					return signatures;
				} else {
					m05bFileLog miLog = new m05bFileLog();
					miLog.addTraza("", "m05bDokusiService->recuperarFirma", "No se ha recuperado ninguna firma para el documento.", m05bConstantes.LOG_NIVEL_BAJO);
					return null;
				}
			}
		} catch (Exception ex) {
			m05bFileLog miLog = new m05bFileLog();
	    	miLog.addTraza("", "m05bDokusiService->recuperarFirma", "ERROR AL ADJUNTAR LA FIRMA AL DOCUMENTO EN DOKUSI: " + ex, m05bConstantes.LOG_NIVEL_BAJO);
			return null;
		}
	}

	/**
	 * @return String String con el usuario auditado en formato DNI#NOMBRE COMPLETO#PUESTO#COD APLIC
	 * @throws m05bDokusiServiceException excepction
	 */
	private String obtenerAuditUser(String dniFirmante, String nombreFirmante) throws m05bDokusiServiceException {

		//DNI#Nombre#[Usuario]#[aplicacion]
		return dniFirmante + "#" + nombreFirmante + "#00000000#" + m05bConstantes.CODIGO_APLICACION;
	}
}