package m05bClasses;

import java.util.*;
import java.sql.*;
import java.io.FileInputStream;
import java.text.NumberFormat;
import java.text.DecimalFormatSymbols;
import java.text.DecimalFormat;
import java.math.BigDecimal;

public class m05bComun {

	m05bFileLog miLog = new m05bFileLog();
	m05bConexion miConex = new m05bConexion();

	public static void main(String[] arg) {
		m05bComun m = new m05bComun();
		System.out.println(m.Mes("2013-04-29 00:00:00.0"));
		System.out.println(m.Mes("2013-04-29 00:00:00.0", "E"));
		System.out.println(m.Mes("2013-04-29 00:00:00.0", "C"));
		
		System.out.println(m.FechaBD("14/03/1979", "00:00"));
		System.out.println(m.FechaBD("1979/03/14", "00:00","E"));
		System.out.println(m.FechaBD("14/03/1979", "00:00","C"));
	}

	/*
	 * Devuelve como string la fecha actual con formato dd/mm/yyyy
	 */
	public String getFechaActual() {

		return getFechaActual(m05bConstantesInformes.IDIOMA_C);
	}

	public String getFechaActual(String idioma) {
		String fecha = "";
		try {
			Calendar miCalendario = new GregorianCalendar();
			java.util.Date actualTime = new java.util.Date(
					System.currentTimeMillis());
			miCalendario.setTime(actualTime);
			Integer intEjercicio = new Integer(miCalendario.get(Calendar.YEAR));
			int intMes = miCalendario.get(Calendar.MONTH);
			intMes = intMes + 1;
			Integer mes = new Integer(intMes);
			Integer intDia = new Integer(miCalendario.get(Calendar.DATE));
			if (idioma.equals(m05bConstantesInformes.IDIOMA_C))
				fecha = "" + intDia.toString() + "/" + mes.toString() + "/"
						+ intEjercicio.toString();
			else if (idioma.equals(m05bConstantesInformes.IDIOMA_E))
				fecha = "" + intEjercicio.toString() + "/" + mes.toString()
						+ "/" + intDia.toString();
		} catch (Exception e) {
			miLog.addTraza(e);
		}
		return fecha;
	}

	/*
	 * Devuelve como string la fecha actual con formato 'dd Mes ao'
	 */
	public String getDetFechaActual(String idioma) {
		String fecha = "";
		try {
			Calendar miCalendario = new GregorianCalendar();
			java.util.Date actualTime = new java.util.Date(
					System.currentTimeMillis());
			miCalendario.setTime(actualTime);
			Integer intEjercicio = new Integer(miCalendario.get(Calendar.YEAR));
			int intMes = miCalendario.get(Calendar.MONTH);
			intMes = intMes + 1;
			String mes = transformaDescMes(intMes, idioma);
			Integer intDia = new Integer(miCalendario.get(Calendar.DATE));
			if (idioma.equals(m05bConstantesInformes.IDIOMA_C)) {
				fecha = "" + intDia.toString() + " " + mes + " "
						+ intEjercicio.toString();
			} else if (idioma.equals(m05bConstantesInformes.IDIOMA_E)) {
				fecha = intEjercicio.toString() + " (e)ko " + mes + "ren "
						+ intDia.toString() + " (e)an";
			}
		} catch (Exception ex) {
			miLog.addTraza(ex);
		}
		return fecha;
	} // Fin funcion getDetFechaActual

	/*
	 * Devuelve como string la fecha actual con formato 'dd Mes ao'
	 */
	public String getDetFecha(String sFecha, String idioma) {
		String fecha = "";
		try {
			if ((sFecha == null) || (sFecha.equals(""))) {
				fecha = "";
			} else {
				String AnoHasta = sFecha.split("/")[2];
				String MesHasta = sFecha.split("/")[1];
				String DiaHasta = sFecha.split("/")[0];
				int intMes = Integer.valueOf(MesHasta).intValue();
				String mes = transformaDescMes(intMes, idioma);
				if (idioma.equals(m05bConstantesInformes.IDIOMA_C)) {
					fecha = "" + DiaHasta + " " + mes + " " + AnoHasta;
				} else if (idioma.equals(m05bConstantesInformes.IDIOMA_E)) {
					fecha = AnoHasta + " (e)ko " + mes + "ren " + DiaHasta
							+ " (e)ko";
				}
			}
		} catch (Exception ex) {
			miLog.addTraza(ex);
		}
		return fecha;
	} // Fin funcion getDetFechaActual

	/*
	 * Devuelve como string la descripcion del mes en el idioma indicado
	 */

	public String transformaDescMes(int mes, String idioma) {
		String descMes = "";
		if (idioma.equals(m05bConstantesInformes.IDIOMA_C)) {
			if (mes == 1)
				descMes = "Enero";
			else if (mes == 2)
				descMes = "Febrero";
			else if (mes == 3)
				descMes = "Marzo";
			else if (mes == 4)
				descMes = "Abril";
			else if (mes == 5)
				descMes = "Mayo";
			else if (mes == 6)
				descMes = "Junio";
			else if (mes == 7)
				descMes = "Julio";
			else if (mes == 8)
				descMes = "Agosto";
			else if (mes == 9)
				descMes = "Setiembre";
			else if (mes == 10)
				descMes = "Octubre";
			else if (mes == 11)
				descMes = "Noviembre";
			else
				descMes = "Diciembre";
		} else if (idioma.equals(m05bConstantesInformes.IDIOMA_E)) {
			if (mes == 1)
				descMes = "Urtarrila";
			else if (mes == 2)
				descMes = "Otsaila";
			else if (mes == 3)
				descMes = "Martxoa";
			else if (mes == 4)
				descMes = "Apirila";
			else if (mes == 5)
				descMes = "Maiatza";
			else if (mes == 6)
				descMes = "Ekaina";
			else if (mes == 7)
				descMes = "Uztaila";
			else if (mes == 8)
				descMes = "Abuztua";
			else if (mes == 9)
				descMes = "Iraila";
			else if (mes == 10)
				descMes = "Urria";
			else if (mes == 11)
				descMes = "Azaroa";
			else
				descMes = "Abendua";
		}
		return descMes;
	} // Fin funcion transformaDescMes

	/*
	 * Devuelve como string el ejercicio de la fecha actual
	 */

	public String getEjerActual() {
		String ejercicio = "";
		try {
			Calendar miCalendario = new GregorianCalendar();
			java.util.Date actualTime = new java.util.Date(
					System.currentTimeMillis());
			miCalendario.setTime(actualTime);
			Integer intEjercicio = new Integer(miCalendario.get(Calendar.YEAR));
			ejercicio = intEjercicio.toString();
		} catch (Exception SQLException) {
			
			miLog.addTraza(SQLException);
		}
		return ejercicio;
	}

	/*
	 * Dar formato al mes y al dia
	 */
	public String formateoFecha(Calendar calendario) {
		return formateoFecha(calendario, m05bConstantesInformes.IDIOMA_C);
	}

	public String formateoFecha(Calendar calendario, String idioma) {
		NumberFormat formatoEjer = NumberFormat.getNumberInstance();
		formatoEjer.setMaximumIntegerDigits(4);
		formatoEjer.setMinimumIntegerDigits(4);
		formatoEjer.setGroupingUsed(false);
		NumberFormat formatoMesYDia = NumberFormat.getNumberInstance();
		formatoMesYDia.setMaximumIntegerDigits(2);
		formatoMesYDia.setMinimumIntegerDigits(2);
		formatoMesYDia.setGroupingUsed(false);
		int mes = calendario.get(Calendar.MONTH);
		++mes;
		if (idioma.equals(m05bConstantesInformes.IDIOMA_C))
			return formatoMesYDia.format(calendario.get(Calendar.DAY_OF_MONTH))
					+ "/" + formatoMesYDia.format(mes) + "/"
					+ formatoEjer.format(calendario.get(Calendar.YEAR));
		else
			return formatoEjer.format(calendario.get(Calendar.YEAR))
					+ "/"
					+ formatoMesYDia.format(mes)
					+ "/"
					+ formatoMesYDia.format(calendario
							.get(Calendar.DAY_OF_MONTH));
	}

	/*
	 * Suma 'n' meses a la fecha que se pasa como parametro
	 */
	public String addMesFechaCorta(String strFecha, int numMeses) {
		return addMesFechaCorta(strFecha,numMeses,m05bConstantesInformes.IDIOMA_C);
	}
	public String addMesFechaCorta(String strFecha, int numMeses, String idioma) {
		int nDia = new Integer(strFecha.substring(6, 8)).intValue();
		int nMes = new Integer(strFecha.substring(4, 6)).intValue();
		int nEjer = new Integer(strFecha.substring(0, 4)).intValue();
		Calendar miCalendario = Calendar.getInstance();
		miCalendario.set(nEjer, nMes - 1, nDia);
		miCalendario.add(Calendar.MONTH, numMeses);
		return formateoFecha(miCalendario,idioma);
	}

	public String formatearFecha(String strFecha, String idioma) {
		if ((strFecha == null) || (strFecha.equals(""))) {
			strFecha = "";
			return strFecha;
		} else {
			if (idioma.equals(m05bConstantesInformes.IDIOMA_C)) {
				int nDia = new Integer(strFecha.substring(8, 10)).intValue();
				int nMes = new Integer(strFecha.substring(5, 7)).intValue();
				int nEjer = new Integer(strFecha.substring(0, 4)).intValue();
				Calendar miCalendario = Calendar.getInstance();
				miCalendario.set(nEjer, nMes, nDia);
				return nDia + "/" + nMes + "/" + nEjer;
			} else {
				int nDia = new Integer(strFecha.substring(8, 10)).intValue();
				int nMes = new Integer(strFecha.substring(5, 7)).intValue();
				int nEjer = new Integer(strFecha.substring(0, 4)).intValue();
				Calendar miCalendario = Calendar.getInstance();
				miCalendario.set(nEjer, nMes, nDia);
				return nEjer + "/" + nMes + "/" + nDia;
			}
		}

	}

	public String formatearFecha(String strFecha) {
		return formatearFecha(strFecha, m05bConstantesInformes.IDIOMA_C);
	} // Fin funcion formatearFecha
	public String formatearFecha2(String strFecha) {
		return formatearFecha2(strFecha, m05bConstantesInformes.IDIOMA_C);
	}
	public String formatearFecha2(String strFecha, String idioma) {
		
		if ((strFecha == null) || (strFecha.equals(""))) {
			strFecha = "";
			return strFecha;
		} else {
			if(idioma.equals(m05bConstantesInformes.IDIOMA_C)){
			String AnoHasta = strFecha.split("/")[2];
			String MesHasta = strFecha.split("/")[1];
			String DiaHasta = strFecha.split("/")[0];
			return AnoHasta + "/" + MesHasta + "/" + DiaHasta;
			}else{
				String AnoHasta = strFecha.split("/")[0];
				String MesHasta = strFecha.split("/")[1];
				String DiaHasta = strFecha.split("/")[2];
				return AnoHasta + "/" + MesHasta + "/" + DiaHasta;
			}
		}
	} // Fin funcion formatearFecha

	public String formatearFechaHora(String strFecha) {
		return formatearFechaHora(strFecha, m05bConstantesInformes.IDIOMA_C);
	}

	public String formatearFechaHora(String strFecha, String idioma) {
		if ((strFecha == null) || (strFecha.equals(""))) {
			strFecha = "";
			return strFecha;
		} else {
			int nDia = new Integer(strFecha.substring(8, 10)).intValue();
			int nMes = new Integer(strFecha.substring(5, 7)).intValue();
			int nEjer = new Integer(strFecha.substring(0, 4)).intValue();
			int nHora = new Integer(strFecha.substring(11, 13)).intValue();
			int nMinuto = new Integer(strFecha.substring(14, 16)).intValue();
			Calendar miCalendario = Calendar.getInstance();
			miCalendario.set(nEjer, nMes, nDia, nHora, nMinuto);
			if (idioma.equals(m05bConstantesInformes.IDIOMA_C)) {
				if (nMinuto < 10) {
					return nDia + "/" + nMes + "/" + nEjer + " " + nHora + ":0"
							+ nMinuto;
				} else {
					return nDia + "/" + nMes + "/" + nEjer + " " + nHora + ":"
							+ nMinuto;
				}
			} else {
				if (nMinuto < 10) {
					return nEjer + "/" + nMes + "/" + nDia + " " + nHora + ":0"
							+ nMinuto;
				} else {
					return nEjer + "/" + nMes + "/" + nDia + " " + nHora + ":"
							+ nMinuto;
				}
			}
		}
	} // Fin funcion formatearFechaHora

	public String formatearFechaHora2(String strFecha) {
		return formatearFechaHora2(strFecha, m05bConstantesInformes.IDIOMA_C);
	} // Fin funcion formatearFechaHora

	public String formatearFechaHora2(String strFecha, String idioma) {
		if ((strFecha == null) || (strFecha.equals(""))) {
			strFecha = "";
			return strFecha;
		} else {
			String nDiaStr = strFecha.substring(8, 10);
			String nMesStr = strFecha.substring(5, 7);
			int nDia = new Integer(strFecha.substring(8, 10)).intValue();
			int nMes = new Integer(strFecha.substring(5, 7)).intValue();
			int nEjer = new Integer(strFecha.substring(0, 4)).intValue();
			int nHora = new Integer(strFecha.substring(11, 13)).intValue();
			int nMinuto = new Integer(strFecha.substring(14, 16)).intValue();
			Calendar miCalendario = Calendar.getInstance();
			miCalendario.set(nEjer, nMes, nDia, nHora, nMinuto);
			if (idioma.equals(m05bConstantesInformes.IDIOMA_C)) {
				if (nMinuto < 10) {
					return nDiaStr + "/" + nMesStr + "/" + nEjer + " " + nHora
							+ ":0" + nMinuto;
				} else {
					return nDiaStr + "/" + nMesStr + "/" + nEjer + " " + nHora
							+ ":" + nMinuto;
				}
			} else {
				if (nMinuto < 10) {
					return nEjer + "/" + nMesStr + "/" + nDiaStr + " " + nHora
							+ ":0" + nMinuto;
				} else {
					return nEjer + "/" + nMesStr + "/" + nDiaStr + " " + nHora
							+ ":" + nMinuto;
				}
			}
		}
	} // Fin funcion formatearFechaHora

	/*
	 * Funcion que recibe 2 fechas en formato yyyymmdd y devuelve el nmero de
	 * dias que hay entre ellas
	 */
	public long getDiasEntreFechas(String finirang, String ffinrang) {
		Calendar calFInicioRango, calFFinRango;
		java.util.Date fInicio, fFin;
		long diasRango = 0, lDias = 0, lUNO = 1;

		int REDONDEO = BigDecimal.ROUND_HALF_UP;
		int DECIMALES = 0;
		BigDecimal bdDivisor = new BigDecimal(24 * 60 * 60 * 1000);
		calFInicioRango = new GregorianCalendar(Integer.parseInt(finirang
				.substring(0, 4)),
				Integer.parseInt(finirang.substring(4, 6)) - 1,
				Integer.parseInt(finirang.substring(6, 8)));
		calFFinRango = new GregorianCalendar(Integer.parseInt(ffinrang
				.substring(0, 4)),
				Integer.parseInt(ffinrang.substring(4, 6)) - 1,
				Integer.parseInt(ffinrang.substring(6, 8)));
		lDias = calFFinRango.getTimeInMillis()
				- calFInicioRango.getTimeInMillis();
		/*
		 * diasRango= (lDias/(24l * 60l * 60l * 1000l))+lUNO; diasRango=
		 * (lDias/(24l * 60l * 60l * 1000l))+lUNO;
		 */
		BigDecimal bdDividendo = new BigDecimal((double) lDias);
		BigDecimal resultado = bdDividendo.divide(bdDivisor, REDONDEO);
		BigDecimal misDias = resultado.setScale(DECIMALES, REDONDEO);
		diasRango = misDias.longValue();
		return diasRango;
		/*
		 * calFInicioRango = new
		 * GregorianCalendar(Integer.parseInt(finirang.substring(0,4)),
		 * Integer.parseInt(finirang.substring(4,6))-1,
		 * Integer.parseInt(finirang.substring(6,8))); fInicio =
		 * calFInicioRango.getTime(); calFFinRango = new
		 * GregorianCalendar(Integer.parseInt(ffinrang.substring(0,4)),
		 * Integer.parseInt(ffinrang.substring(4,6))-1,
		 * Integer.parseInt(ffinrang.substring(6, 8))); fFin =
		 * calFFinRango.getTime(); lDias = fFin.getTime() - fInicio.getTime();
		 * 
		 * diasRango= lDias/(24l * 60l * 60l * 1000l); return diasRango;
		 */

		/*
		 * long dias=0; java.sql.Connection conn = null; PreparedStatement pstmt
		 * = null; ResultSet rs = null; String sql="";
		 * 
		 * try{ conn = miConex.getConnection();
		 * 
		 * sql="select to_number(to_date('"+ffinrang+"','yyyymmdd') - to_date('"+
		 * finirang+"','yyyymmdd')) from dual"; pstmt =
		 * conn.prepareStatement(sql); rs = pstmt.executeQuery(); if (rs.next()
		 * == true){ dias = rs.getLong(1); } } catch (Exception ex1) {
		 * miLog.addTraza(ex1); } finally { try{ if (rs != null) rs.close();
		 * if (pstmt != null) pstmt.close(); if (conn != null) conn.close(); }
		 * catch (Exception ex2) { miLog.addTraza(ex2); } } return dias;
		 */
	} // Fin funcion getDiasEntreFechas

	/*
	 * Funcion que recibe 2 fechas en formato dd/mm/yyyy y devuelve el nmero de
	 * dias que hay entre ellas
	 */
	public long getDiasEntreFechas2(String finirang, String ffinrang) {
		/*
		 * Calendar calFInicioRango, calFFinRango; java.util.Date fInicio, fFin;
		 * long diasRango = 0, lDias=0;
		 * 
		 * calFInicioRango = new
		 * GregorianCalendar(Integer.parseInt(finirang.substring(6,10)),
		 * Integer.parseInt(finirang.substring(3,5))-1,
		 * Integer.parseInt(finirang.substring(0,2))); fInicio =
		 * calFInicioRango.getTime(); calFFinRango = new
		 * GregorianCalendar(Integer.parseInt(ffinrang.substring(6,10)),
		 * Integer.parseInt(ffinrang.substring(3,5))-1,
		 * Integer.parseInt(ffinrang.substring(0, 2))); fFin =
		 * calFFinRango.getTime(); lDias = fFin.getTime() - fInicio.getTime();
		 * 
		 * diasRango= lDias/(24l * 60l * 60l * 1000l); return diasRango;
		 */
		long dias = 0;
		java.sql.Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "";
		try {
			conn = miConex.getConnection();
			sql = "select to_number(to_date('" + ffinrang
					+ "','yyyymmdd') - to_date('" + finirang
					+ "','yyyymmdd')+1) from dual";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			if (rs.next() == true) {
				dias = rs.getLong(1);
			}
			if (rs != null)
				rs.close();
			if (pstmt != null)
				pstmt.close();
		} catch (Exception ex1) {
			
			miLog.addTraza(ex1);
		} finally {
			try {
				if (rs != null)
					rs.close();
				if (pstmt != null)
					pstmt.close();
				if (conn != null)
					conn.close();
			} catch (Exception ex2) {
				miLog.addTraza(ex2);
			}
		}
		return dias;

	} // Fin funcion getDiasEntreFechas

	public long getDiasEntreFechas3(String finirang, String ffinrang) {
		/*
		 * Calendar calFInicioRango, calFFinRango; java.util.Date fInicio, fFin;
		 * long diasRango = 0, lDias=0;
		 * 
		 * calFInicioRango = new
		 * GregorianCalendar(Integer.parseInt(finirang.substring(6,10)),
		 * Integer.parseInt(finirang.substring(3,5))-1,
		 * Integer.parseInt(finirang.substring(0,2))); fInicio =
		 * calFInicioRango.getTime(); calFFinRango = new
		 * GregorianCalendar(Integer.parseInt(ffinrang.substring(6,10)),
		 * Integer.parseInt(ffinrang.substring(3,5))-1,
		 * Integer.parseInt(ffinrang.substring(0, 2))); fFin =
		 * calFFinRango.getTime(); lDias = fFin.getTime() - fInicio.getTime();
		 * 
		 * diasRango= lDias/(24l * 60l * 60l * 1000l); return diasRango;
		 */
		long dias = 0;
		java.sql.Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "";

		try {
			conn = miConex.getConnection();

			sql = "select to_number(to_date('" + ffinrang
					+ "','dd/mm/yyyy') - to_date('" + finirang
					+ "','dd/mm/yyyy')+1) from dual";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			if (rs.next() == true) {
				dias = rs.getLong(1);
			}
			if (rs != null)
				rs.close();
			if (pstmt != null)
				pstmt.close();
		} catch (Exception ex1) {
			miLog.addTraza(ex1);
		} finally {
			try {
				if (rs != null)
					rs.close();
				if (pstmt != null)
					pstmt.close();
				if (conn != null)
					conn.close();
			} catch (Exception ex2) {
				miLog.addTraza(ex2);
			}
		}
		return dias;

	} // Fin funcion getDiasEntreFechas

	/*
	 * public static long getDiasEntreFechas(String finirang, String ffinrang) {
	 * GregorianCalendar g1 = new
	 * GregorianCalendar(Integer.parseInt(finirang.substring(0,4)),
	 * Integer.parseInt(finirang.substring(4,6)),
	 * Integer.parseInt(finirang.substring(6,8))); //g1.setTime(d1);
	 * GregorianCalendar g2 = new
	 * GregorianCalendar(Integer.parseInt(ffinrang.substring(0,4)),
	 * Integer.parseInt(ffinrang.substring(4,6)),
	 * Integer.parseInt(ffinrang.substring(6, 8))); //g2.setTime(d2);
	 * 
	 * long elapsed = 0; GregorianCalendar gc1, gc2;
	 * 
	 * if (g2.after(g1)) { gc2 = (GregorianCalendar) g2.clone(); gc1 =
	 * (GregorianCalendar) g1.clone(); } else { gc2 = (GregorianCalendar)
	 * g1.clone(); gc1 = (GregorianCalendar) g2.clone(); }
	 * 
	 * gc1.clear(Calendar.MILLISECOND); gc1.clear(Calendar.SECOND);
	 * gc1.clear(Calendar.MINUTE); gc1.clear(Calendar.HOUR_OF_DAY);
	 * 
	 * gc2.clear(Calendar.MILLISECOND); gc2.clear(Calendar.SECOND);
	 * gc2.clear(Calendar.MINUTE); gc2.clear(Calendar.HOUR_OF_DAY);
	 * 
	 * while ( gc1.before(gc2) ) { gc1.add(Calendar.DATE, 1); elapsed++; }
	 * return elapsed; }
	 */

	/*
	 * Funcion que recibe 2 fechas en formato yyyymmdd y devuelve el nmero de
	 * dias que hay entre ellas ambas incluidas
	 */
	public long getDiasEntreFechasInclude(String finirang, String ffinrang) {
		Calendar calFInicioRango, calFFinRango;
		java.util.Date fInicio, fFin;
		long diasRango = 0, lDias = 0, lUNO = 1;

		int REDONDEO = BigDecimal.ROUND_HALF_UP;
		int DECIMALES = 0;
		BigDecimal bdDivisor = new BigDecimal(24 * 60 * 60 * 1000);

		calFInicioRango = new GregorianCalendar(Integer.parseInt(finirang
				.substring(0, 4)),
				Integer.parseInt(finirang.substring(4, 6)) - 1,
				Integer.parseInt(finirang.substring(6, 8)));

		calFFinRango = new GregorianCalendar(Integer.parseInt(ffinrang
				.substring(0, 4)),
				Integer.parseInt(ffinrang.substring(4, 6)) - 1,
				Integer.parseInt(ffinrang.substring(6, 8)));

		lDias = calFFinRango.getTimeInMillis()
				- calFInicioRango.getTimeInMillis();
		/*
		 * diasRango= (lDias/(24l * 60l * 60l * 1000l))+lUNO; diasRango=
		 * (lDias/(24l * 60l * 60l * 1000l))+lUNO;
		 */

		BigDecimal bdDividendo = new BigDecimal((double) lDias);
		BigDecimal resultado = bdDividendo.divide(bdDivisor, REDONDEO);
		BigDecimal bdUNO = new BigDecimal(1);
		resultado = resultado.add(bdUNO);
		BigDecimal misDias = resultado.setScale(DECIMALES, REDONDEO);
		diasRango = misDias.longValue();
		if (misDias.signum() == -1.0) {
			diasRango = diasRango - 1;
		}
		return diasRango;
		/*
		 * calFInicioRango = new
		 * GregorianCalendar(Integer.parseInt(finirang.substring(0,4)),
		 * Integer.parseInt(finirang.substring(4,6))-1,
		 * Integer.parseInt(finirang.substring(6,8))); fInicio =
		 * calFInicioRango.getTime();
		 * 
		 * calFFinRango = new
		 * GregorianCalendar(Integer.parseInt(ffinrang.substring(0,4)),
		 * Integer.parseInt(ffinrang.substring(4,6))-1,
		 * Integer.parseInt(ffinrang.substring(6, 8))); fFin =
		 * calFFinRango.getTime();
		 * 
		 * lDias = fFin.getTime() - fInicio.getTime(); diasRango= (lDias/(24l *
		 * 60l * 60l * 1000l))+lUNO;
		 * 
		 * return diasRango;
		 */
		/*
		 * long dias=0; java.sql.Connection conn = null; PreparedStatement pstmt
		 * = null; ResultSet rs = null; String sql="";
		 * 
		 * try{ conn = miConex.getConnection();
		 * 
		 * sql="select to_number(to_date('"+ffinrang+"','yyyymmdd') - to_date('"+
		 * finirang+"','yyyymmdd')+1) from dual"; pstmt =
		 * conn.prepareStatement(sql); rs = pstmt.executeQuery(); if (rs.next()
		 * == true){ dias = rs.getLong(1); } } catch (Exception ex1) {
		 * miLog.addTraza(ex1); } finally { try{ if (rs != null) rs.close();
		 * if (pstmt != null) pstmt.close(); if (conn != null) conn.close(); }
		 * catch (Exception ex2) { miLog.addTraza(ex2); } } return dias;
		 */
	} // Fin funcion getDiasEntreFechasInclude

	public String formatearFechaBD(String strFecha) {
		if (strFecha != null) {
			strFecha = strFecha.substring(0, 4) + strFecha.substring(5, 7)
					+ strFecha.substring(8, 10);
		}
		return strFecha;
	} // Fin funcion formatearFecha

	public String convertirFecha(String strFecha) {
		return convertirFecha(strFecha, m05bConstantesInformes.IDIOMA_C);
	}

	public String convertirFecha(String strFecha, String idioma) {

		String mes = transformaMes(strFecha.substring(4, 7));
		int nDia = new Integer(strFecha.substring(8, 10)).intValue();
		strFecha = strFecha.substring(strFecha.length() - 4, strFecha.length())
				.trim();
		int nEjer = new Integer(strFecha).intValue();
		int nMes = new Integer(mes).intValue();
		Calendar Calendario = Calendar.getInstance();
		Calendario.set(nEjer, nMes, nDia);
		return formateoFecha(Calendario, idioma);

	}// Fin funcion convertirFecha

	public String transformaMes(String mes) {
		if (mes.equals("Jan"))
			mes = "01";
		else if (mes.equals("Feb"))
			mes = "02";
		else if (mes.equals("Mar"))
			mes = "03";
		else if (mes.equals("Apr"))
			mes = "04";
		else if (mes.equals("May"))
			mes = "05";
		else if (mes.equals("Jun"))
			mes = "06";
		else if (mes.equals("Jul"))
			mes = "07";
		else if (mes.equals("Aug"))
			mes = "08";
		else if (mes.equals("Sep"))
			mes = "09";
		else if (mes.equals("Oct"))
			mes = "10";
		else if (mes.equals("Nov"))
			mes = "11";
		else
			mes = "12";
		return mes;
	}

	public String Hora(String FechaHora) {

		String hora = "";

		FechaHora = FechaHora.trim();
		if (FechaHora.indexOf(" ") != -1) {
			hora = FechaHora.substring(FechaHora.indexOf(" "),
					FechaHora.length()).trim();
		} else {
			hora = "";
		}
		return hora;

	}

	public String Fecha2(String FechaHora) {

		String fecha = "";

		FechaHora = FechaHora.trim();
		if (FechaHora.indexOf(" ") != -1) {
			fecha = FechaHora.substring(0, FechaHora.indexOf(" ")).trim();
		} else {
			fecha = FechaHora;
		}
		return fecha;

	}

	public String Mes(String FechaHora) {
		return Mes(FechaHora, m05bConstantesInformes.IDIOMA_C);
	}

	public String Mes(String FechaHora, String idioma) {

		String mes;
		String aux;
		FechaHora = FechaHora.trim();

		if (FechaHora.indexOf(":") != -1) {
			aux = FechaHora.substring(0, FechaHora.indexOf(":") - 3);
		} else {
			aux = FechaHora;
		}
		// miLog.addTraza(m05bConstantes.LOG_NO_USER , m05bConstantes.LOG_NO_SRC
		// , "aux" + aux,m05bConstantes.LOG_NIVEL_BAJO);
		if (idioma.equals(m05bConstantesInformes.IDIOMA_C)) {
			mes = "/" + aux.substring(0, aux.indexOf("-"));
			// miLog.addTraza(m05bConstantes.LOG_NO_USER ,
			// m05bConstantes.LOG_NO_SRC
			// , "mes" + mes,m05bConstantes.LOG_NIVEL_BAJO);

			aux = aux.substring(aux.indexOf("-") + 1, aux.length());
			mes = "/" + aux.substring(0, aux.indexOf("-")) + mes;
			mes = aux.substring(aux.lastIndexOf("-") + 1, aux.length()) + mes;
			// miLog.addTraza(m05bConstantes.LOG_NO_USER ,
			// m05bConstantes.LOG_NO_SRC
			// , "mes" + mes,m05bConstantes.LOG_NIVEL_BAJO);
		} else {
			mes = aux.replaceAll("-", "/");

		}
		return mes;
	} // Fin funcin Mes

	public String Fecha(String fecha) {
		return Fecha(fecha, m05bConstantesInformes.IDIOMA_C);
	}

	public String Fecha(String fecha, String idioma) {

		
		String Fec = "";
		if (idioma.equals(m05bConstantesInformes.IDIOMA_C)) {

			Fec = fecha.substring(fecha.lastIndexOf("/") + 1, fecha.length());
			if (fecha.indexOf("/") + 2 == fecha.lastIndexOf("/"))
				Fec = Fec
						+ "0"
						+ fecha.substring(fecha.indexOf("/") + 1,
								fecha.lastIndexOf("/"));
			else
				Fec = Fec
						+ fecha.substring(fecha.indexOf("/") + 1,
								fecha.lastIndexOf("/"));
			if (fecha.indexOf("/") == 1)
				Fec = Fec + "0" + fecha.substring(0, fecha.indexOf("/"));
			else
				Fec = Fec + fecha.substring(0, fecha.indexOf("/"));
		} else {

			Fec = fecha.substring(fecha.lastIndexOf("/") + 1, fecha.length());
			if (fecha.indexOf("/") + 2 == fecha.lastIndexOf("/"))
				Fec = Fec
						+ "0"
						+ fecha.substring(fecha.indexOf("/") + 1,
								fecha.lastIndexOf("/"));
			else
				Fec = Fec
						+ fecha.substring(fecha.indexOf("/") + 1,
								fecha.lastIndexOf("/"));
			if (fecha.indexOf("/") == 1)
				Fec = Fec + "0" + fecha.substring(0, fecha.indexOf("/"));
			else
				Fec = Fec + fecha.substring(0, fecha.indexOf("/"));
		}
		return Fec;
	}

	public String formatearHora(String horas) {
		String Hor = "";
		if (horas == null || horas.equals(""))
			Hor = "";
		else
			Hor = horas.substring(0, horas.lastIndexOf(":"));

		return Hor;
	} // Fin funcion formatearHora

	/*
	 * Da formato a un String para insertarlo en un campo de fecha de la Base de
	 * Datos
	 */
	public String FechaBD(String fecha, String Hora) {

		String fec = "";
		String auxfec = "";
		String auxhor = "";
		if (fecha == null || fecha.equals("")) {
			fec = "";
		} else {
			auxfec = fecha.substring(fecha.indexOf("/") + 1,
					fecha.lastIndexOf("/"));
			if (auxfec.length() == 1)
				auxfec = "0" + auxfec;
			fec = fecha.substring(fecha.lastIndexOf("/") + 1, fecha.length())
					+ auxfec;
			auxfec = fecha.substring(0, fecha.indexOf("/"));
			if (auxfec.length() == 1)
				auxfec = "0" + auxfec;
			fec = fec + auxfec;
			if ((Hora != null) && (!(Hora.equals("")))) {
				auxhor = Hora.substring(0, Hora.indexOf(":"));
				if (auxhor.length() == 1)
					auxhor = "0" + auxhor;
				fec = fec + auxhor
						+ Hora.substring(Hora.indexOf(":") + 1, Hora.length())
						+ 00;
			} else {
				fec = fec + "000000";
			}
		}
		return fec;
	}

	public String FechaBD(String fecha, String Hora, String idioma) {
		String fec = "";
		String auxfec = "";
		String auxhor = "";
		if (fecha == null || fecha.equals("")) {
			fec = "";
		} else {
			if (idioma.equals(m05bConstantesInformes.IDIOMA_C)) {
				auxfec = fecha.substring(fecha.indexOf("/") + 1,
						fecha.lastIndexOf("/"));
				if (auxfec.length() == 1)
					auxfec = "0" + auxfec;
				fec = fecha.substring(fecha.lastIndexOf("/") + 1,
						fecha.length())
						+ auxfec;
				auxfec = fecha.substring(0, fecha.indexOf("/"));
				if (auxfec.length() == 1)
					auxfec = "0" + auxfec;
				fec = fec + auxfec;
				
			} else {
				fec = fecha.replaceAll("/", "");
			}
			if ((Hora != null) && (!(Hora.equals("")))) {
				auxhor = Hora.substring(0, Hora.indexOf(":"));
				if (auxhor.length() == 1)
					auxhor = "0" + auxhor;
				fec = fec
						+ auxhor
						+ Hora.substring(Hora.indexOf(":") + 1,
								Hora.length()) + 00;
			} else {
				fec = fec + "000000";
			}
		}
		return fec;
	}

	// Lio Sanciones
	public String FechaObj(String fecha, String Hora) {

		String fec = "";
		String auxfec = "";
		String auxhor = "";
		if (fecha == null || fecha.equals("")) {
			fec = "";
		} else {
			// miLog.addTraza(m05bConstantes.LOG_NO_USER ,
			// m05bConstantes.LOG_NO_SRC , "fecha" +
			// fecha,m05bConstantes.LOG_NIVEL_BAJO);
			// miLog.addTraza(m05bConstantes.LOG_NO_USER ,
			// m05bConstantes.LOG_NO_SRC , "Hora" +
			// Hora,m05bConstantes.LOG_NIVEL_BAJO);
			fec = fecha.substring(6, 10) + "-" + fecha.substring(3, 5) + "-"
					+ fecha.substring(0, 2);
			// miLog.addTraza(m05bConstantes.LOG_NO_USER ,
			// m05bConstantes.LOG_NO_SRC , "fec1" +
			// fec,m05bConstantes.LOG_NIVEL_BAJO);
			if (!(Hora.equals(""))) {
				fec = fec + " " + Hora.substring(0, 2) + ":"
						+ Hora.substring(3, 5) + ":00";
			}
			// miLog.addTraza(m05bConstantes.LOG_NO_USER ,
			// m05bConstantes.LOG_NO_SRC , "fec2" +
			// fec,m05bConstantes.LOG_NIVEL_BAJO);

		}
		// miLog.addTraza(m05bConstantes.LOG_NO_USER , m05bConstantes.LOG_NO_SRC
		// , "fec3" + fec,m05bConstantes.LOG_NIVEL_BAJO);

		return fec;
	}

	public String ListaCaracteres(String Lista) {
		String aux = "";
		if (Lista == null)
			Lista = "";
		else {
			Lista = Lista.trim();
			while (Lista.indexOf(",") != -1) {
				aux = aux + "'" + Lista.substring(0, Lista.indexOf(",")) + "',";
				Lista = Lista.substring(Lista.indexOf(",") + 1, Lista.length());
			}
			aux = aux + "'" + Lista + "'";
			Lista = aux;
		}
		return Lista;

	} // Fin funcion ListaCaracteres

	/*
	 * Funcin que formatea campo con 2 decimales
	 */
	public String formatearDblDecimales(double campo) {
		DecimalFormatSymbols unusualSymbols = new DecimalFormatSymbols();
		unusualSymbols.setGroupingSeparator('.'); // Para separar los decimales
		String patron = "###.##";
		DecimalFormat formato = new DecimalFormat(patron, unusualSymbols);
		String result = formato.format(campo);
		return result;
	} // Fin funcion formatearDblDecimales

	/*
	 * Funcin que formatea campo con 2 decimales
	 */
	public String formatearDouble(double campo) {
		campo = Math.rint(campo * 100) / 100;
		return campo + "";
	} // Fin funcion formatearDblDecimales

	/*
	 * Funcin que formatea campo string con separador de miles sin decimales
	 */

	public String formatearStrMiles(String campo) {
		String result = campo;
		if (campo.length() > 3) {
			result = campo.substring(0, campo.length() - 3) + "."
					+ campo.substring(campo.length() - 3, campo.length());
			if (campo.length() > 6)
				result = result.substring(0, result.length() - 7)
						+ "."
						+ result.substring(result.length() - 7, result.length());
			if (campo.length() > 9)
				result = result.substring(0, result.length() - 11)
						+ "."
						+ result.substring(result.length() - 11,
								result.length());

		}
		return result;

	} // Fin funcion formatearStrMiles

	/*
	 * Funcin que formatea campo double con separador de miles sin decimales
	 */

	public String formatearDblMiles(double campo) {
		DecimalFormatSymbols unusualSymbols = new DecimalFormatSymbols();
		unusualSymbols.setDecimalSeparator(','); // Para separar los miles
		String patron = "###,###";
		DecimalFormat formato = new DecimalFormat(patron, unusualSymbols);
		formato.setGroupingSize(3); // Para que agrupar los miles de 3 en 3
		String result = formato.format(campo);
		return result;

	} // Fin funcion formatearDblMiles

	/*
	 * Funcin que formatea campo double con separador de miles y dos decimales
	 */

	public String formatearDblMilesDec(double campo) {
		DecimalFormatSymbols unusualSymbols = new DecimalFormatSymbols();
		unusualSymbols.setDecimalSeparator(','); // Para separar los miles
		unusualSymbols.setGroupingSeparator('.'); // Para separar los decimales
		String patron = "###,###.##"; // ESTO ES LO MAS IMPORTANTE, si no
										// quieres separar los miles, pon ###.##
		DecimalFormat formato = new DecimalFormat(patron, unusualSymbols);
		formato.setGroupingSize(3); // Para que te agrupe los miles de 3 en 3
		String result = formato.format(campo);
		if (result.indexOf(",") < 0)
			// Es que no hay decimales -> pongo los 2 decimales
			result += ",00";
		return result;

	} // Fin funcion formatearDblMiles

	public String formatearDblMilesDec4(double campo) {
		DecimalFormatSymbols unusualSymbols = new DecimalFormatSymbols();
		unusualSymbols.setDecimalSeparator(','); // Para separar los miles
		unusualSymbols.setGroupingSeparator('.'); // Para separar los decimales
		String patron = "###,###.####"; // ESTO ES LO MAS IMPORTANTE, si no
										// quieres separar los miles, pon ###.##
		DecimalFormat formato = new DecimalFormat(patron, unusualSymbols);
		formato.setGroupingSize(3); // Para que te agrupe los miles de 3 en 3
		String result = formato.format(campo);
		if (result.indexOf(",") < 0)
			// Es que no hay decimales -> pongo los 2 decimales
			result += ",0000";
		return result;

	} // Fin funcion formatearDblMiles

	public String ImportesABasedatos(String Importe) {
		String aux = "";
		if (Importe == null)
			Importe = "";
		else {
			Importe = Importe.trim();
			while (Importe.indexOf(".") != -1) {
				aux = aux + Importe.substring(0, Importe.indexOf("."));
				Importe = Importe.substring(Importe.indexOf(".") + 1,
						Importe.length());
			}
			aux = aux + Importe;
			Importe = aux;
			if (Importe.indexOf(",") != -1) {
				aux = Importe.substring(0, Importe.indexOf(",")) + ".";
				Importe = Importe.substring(Importe.indexOf(",") + 1,
						Importe.length());
				aux = aux + Importe;
				Importe = aux;

			}
		}
		return Importe;

	}

	public String ImporteBasedatosAPagina(String Importe) {
		String aux = "0";
		String decimales = "";
		if (Importe == null)
			Importe = "";
		else {
			if (Importe.indexOf(".") != -1) {
				Importe = Importe.trim();
				aux = Importe.substring(0, Importe.indexOf("."));
				if (aux.equals("")) {
					aux = "0";
				}
				aux = formatearStrMiles(aux);
				decimales = Importe.substring(Importe.indexOf(".") + 1,
						Importe.length());
				Importe = aux + "," + decimales;
			} else {
				Importe = Importe.trim();
				aux = formatearStrMiles(Importe);
				Importe = aux;
			}
		}
		return Importe;

	}

	public String ImporteFicheroABasedatos(String Importe) {
		String PEntera = "";
		String Decimales = "";
		PEntera = Importe.substring(0, Importe.length() - 2).trim();
		Decimales = Importe.substring(Importe.length() - 2, Importe.length())
				.trim();
		Importe = PEntera + "." + Decimales;
		return Importe;

	}// Fin funcion convertirFecha

	/*
	 * Funcin que devuelve una entrada del fichero de configuracion
	 */

	public String leerPropiedad(String propiedad) {
		String txtPropiedad = "";
		try {
			// Carga del fichero properties
			/*
			 * String ficheroProperties = m05bConstantesPaginas.PATH_PROPERTIES;
			 * FileInputStream inProperties = new
			 * FileInputStream(ficheroProperties); Properties aProperties = new
			 * Properties(); aProperties.load(inProperties);
			 * txtPropiedad=aProperties.getProperty(propiedad);
			 * inProperties.close();
			 */
			txtPropiedad = m05bFicheroProperties.getInstance().getParameter(
					propiedad);
		} catch (Exception ex1) {
			miLog.addTraza(ex1);
		}
		return txtPropiedad;
	} // Fin funcion leerPropiedad

	public String fncReplaceAcentos(String valor) {
		if (valor != null) {
			// reemplazo los acentos
			valor = valor.replaceAll("", "A");
			valor = valor.replaceAll("", "E");
			valor = valor.replaceAll("", "I");
			valor = valor.replaceAll("", "O");
			valor = valor.replaceAll("", "U");
		}
		return valor;
	}

	public String fncReplaceAsterisco(String valor) {
		String Asterisco = "[*]";

		if (valor != null) {
			// reemplazo los acentos
			valor = valor.replaceAll(Asterisco, "%");
		}
		return valor;
	}

	public String fncBisiesto(String strFecha) {
		if ((strFecha == null) || (strFecha.equals(""))) {
			strFecha = "";
			return strFecha;
		} else {
			String AnoHasta = strFecha.split("/")[2];
			int nAno = new Integer(AnoHasta).intValue();
			String MesHasta = strFecha.split("/")[1];
			int nMes = new Integer(MesHasta).intValue();
			String DiaHasta = strFecha.split("/")[0];
			int nDia = new Integer(DiaHasta).intValue();
			if ((nMes == 2) && (nDia == 29) && (fncCheckYear(nAno).equals("0"))) {
				DiaHasta = "01";
				MesHasta = "03";
			}
			return DiaHasta + "/" + MesHasta + "/" + AnoHasta;
		}
	} // Fin funcion formatearFecha

	public String fncCheckYear(int year) {
		return (((year % 4 == 0) && (year % 100 != 0)) || (year % 400 == 0)) ? "1"
				: "0";
	}

	public String mostrarTexto(String texto) {
		return texto == null ? "" : texto;
	}

}