package m05bClasses;

import java.util.*;
import java.math.BigDecimal;
import java.sql.*;

import m05bClasses.m05bConstantes;
import m05bClasses.m05bConexion;
import m05bClasses.m05bComun;
import m05bClasses.m05bFileLog;
import m05bObjects.m05bKmCTK;
import m05bObjects.m05bGrupos;

public class m05bCalcularCTK {
	
	private static final int REDONDEO  = 	BigDecimal.ROUND_HALF_UP;
	private static final int DECIMALES = 	2;

	java.sql.Connection conn = null;
	m05bConexion miConex = new m05bConexion();
    m05bFileLog miLog = new m05bFileLog();
    m05bComun miComun = new m05bComun();
	ArrayList miArrayKm = new ArrayList();
	ArrayList miArrayGrupo = new ArrayList();
    m05bKmCTK miObjKM;
    m05bGrupos misGrupos;
    
	String matricula="", finiciorang="", finiciorang2="", finiciorang3="", ffinrang="", ffinrang2="", finicioAnt="", rango="", rangoAnt="", total="", taller="";
	double porcent=0.0, gastosTP=0.0, gastosTE=0.0, valorAmort=0.0, amortizacion=0.0, combustible=0.0;
	long diasRango=0;
	long diasRango2=0;
	int intervTP=0, intervTE=0;
	String matriculaAntOrd="";
	String ffinrangAntOrd="";
	
	private boolean obtenerImporteAmortizacionFecha(String rango, String fecha, boolean fechaMasUno, boolean marcarTotal) throws java.lang.Exception
	{
		try
		{
			boolean retorno = false;
			String sqlAmortiz = "";
			PreparedStatement pstmtA = null;
			ResultSet rsA = null;
			 
			sqlAmortiz = " select " + m05bConstantes.COL_39_IMPORTE + "," + m05bConstantes.COL_39_FECHA;
			sqlAmortiz += " from " + m05bConstantes.TAB_AMORTIZACION;
			sqlAmortiz += " where ";
			sqlAmortiz += m05bConstantes.COL_39_FECHA + " = ";
			if (fecha.length() > 0)
			{
				sqlAmortiz += " (to_date(" + fecha + ", 'yyyymmdd')";
				if (fechaMasUno)
					sqlAmortiz += "+1";
				sqlAmortiz += ")";
			}
			
			sqlAmortiz += " and " + m05bConstantes.COL_39_MATRICULA + "= '" + matricula + "' AND RANG_39 = '" + rango + "')";
			
			//miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "obtenerImporteAmortizacionFecha " + sqlAmortiz, m05bConstantes.LOG_NIVEL_MEDIO);
															
			pstmtA = conn.prepareStatement(sqlAmortiz);
			rsA = pstmtA.executeQuery();
			if (rsA.next())
			{
				retorno = true;
				amortizacion = rsA.getDouble(1);
				if (marcarTotal)
					total = "S";
			}
			else
			{
				amortizacion = 0;
			}

			if (rsA != null)
				rsA.close();
			if (pstmtA != null)
				pstmtA.close();
			
			return retorno;
		}
		catch (Exception ex1)
		{
			miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "EXCEPTION: obtenerImporteAmortizacionFecha " + ex1, m05bConstantes.LOG_NIVEL_BAJO);
			miLog.addTraza(ex1);
			throw new Exception(ex1);
		}
	}
    
	private boolean obtenerImporteAmortizacion(String rango, String desde, String hasta, boolean desdeMasUno, boolean hastaMasUno, boolean marcarTotal, boolean tabla40) throws java.lang.Exception
	{
		try
		{
			boolean retorno = false;
			String sqlAmortiz = "";
			PreparedStatement pstmtA = null;
			ResultSet rsA = null;
			 
			if (tabla40)
			{
				sqlAmortiz = " select " + m05bConstantes.COL_40_IMPORTE;
				sqlAmortiz += " from " + m05bConstantes.TAB_TRANSFERENCIAS;
				sqlAmortiz += " where "+ m05bConstantes.COL_40_MATRICULA + "= '" + matricula + "' and ";
				sqlAmortiz += m05bConstantes.COL_40_FHASTA + " <= to_date('" + hasta + "','yyyymmdd') and ";
				sqlAmortiz += m05bConstantes.COL_40_FDESDE + " in (select max(" + m05bConstantes.COL_40_FDESDE + ") from ";
				sqlAmortiz += m05bConstantes.TAB_TRANSFERENCIAS + " where ";
				sqlAmortiz += m05bConstantes.COL_40_MATRICULA + "= '" + matricula + "' and ";
				sqlAmortiz += m05bConstantes.COL_40_FHASTA + " <= to_date('" + hasta + "','yyyymmdd') )";
			}
			else
			{
				sqlAmortiz = " select " + m05bConstantes.COL_39_IMPORTE + "," + m05bConstantes.COL_39_FECHA;
				sqlAmortiz += " from " + m05bConstantes.TAB_AMORTIZACION;
				sqlAmortiz += " where ";
				sqlAmortiz += m05bConstantes.COL_39_FECHA + " IN (SELECT max(" + m05bConstantes.COL_39_FECHA;
				sqlAmortiz += ") FROM " + m05bConstantes.TAB_AMORTIZACION + " WHERE 1 = 1";
				if (desde.length() > 0)
				{
					sqlAmortiz += " and " + m05bConstantes.COL_39_FECHA + " >= (to_date(" + desde + ", 'yyyymmdd')";
					if (desdeMasUno)
						sqlAmortiz += "+1";
					sqlAmortiz += ")";
				}
				if (hasta.length() > 0)
				{
					sqlAmortiz += " and " + m05bConstantes.COL_39_FECHA + " <= (to_date(" + hasta + ", 'yyyymmdd')";
					if (hastaMasUno)
						sqlAmortiz += "+1";
					sqlAmortiz += ")";
				}
				sqlAmortiz += " and " + m05bConstantes.COL_39_MATRICULA + "= '" + matricula + "' AND RANG_39 = '" + rango + "')";
				sqlAmortiz += " and " + m05bConstantes.COL_39_MATRICULA + "= '" + matricula + "' AND RANG_39 = '" + rango + "'";
			}

			//miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "obtenerImporteAmortizacion" + sqlAmortiz, m05bConstantes.LOG_NIVEL_MEDIO);
															
			pstmtA = conn.prepareStatement(sqlAmortiz);
			rsA = pstmtA.executeQuery();
			if (rsA.next())
			{
				retorno = true;
				amortizacion = rsA.getDouble(1);
				if (marcarTotal)
					total = "S";
			}
			else
			{
				amortizacion = 0;
			}

			if (rsA != null)
				rsA.close();
			if (pstmtA != null)
				pstmtA.close();
			
			return retorno;
		}
		catch (Exception ex1)
		{
			miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "EXCEPTION: obtenerImporteAmortizacion " + ex1, m05bConstantes.LOG_NIVEL_BAJO);
			miLog.addTraza(ex1);
			throw new Exception(ex1);
		}
	}
    
	private double obtenerImporteAmortizacionAcumulada(String hasta) throws java.lang.Exception
	{
		try
		{
			double amortizacionAcumulada = 0;
			String sqlAmortiz = "";
			PreparedStatement pstmtA = null;
			ResultSet rsA = null;
			
			sqlAmortiz = " select " + m05bConstantes.COL_39_AMORTIZA + "," + m05bConstantes.COL_39_FECHA;
			sqlAmortiz += " from " + m05bConstantes.TAB_AMORTIZACION;
			sqlAmortiz += " where ";
			sqlAmortiz += m05bConstantes.COL_39_FECHA + " IN (SELECT max(" + m05bConstantes.COL_39_FECHA;
			sqlAmortiz += ") FROM " + m05bConstantes.TAB_AMORTIZACION + " WHERE 1 = 1";
			if (hasta.length() > 0)
				sqlAmortiz += " and " + m05bConstantes.COL_39_FECHA + " <= (to_date(" + hasta + ", 'yyyymmdd')+1)";
			sqlAmortiz += " and " + m05bConstantes.COL_39_MATRICULA + "= '" + matricula + "')";
			sqlAmortiz += " and " + m05bConstantes.COL_39_MATRICULA + "= '" + matricula + "'";
			
			//miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "obtenerImporteAmortizacionAcumulada" + sqlAmortiz, m05bConstantes.LOG_NIVEL_MEDIO);
															
			pstmtA = conn.prepareStatement(sqlAmortiz);
			rsA = pstmtA.executeQuery();
			if (rsA.next())
				amortizacionAcumulada = rsA.getDouble(1);
			else
				amortizacionAcumulada = 0;

			if (rsA != null)
				rsA.close();
			if (pstmtA != null)
				pstmtA.close();
			
			return amortizacionAcumulada;
			
		}
		catch (Exception ex1)
		{
			miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "EXCEPTION: obtenerImporteAmortizacionAcumulada " + ex1, m05bConstantes.LOG_NIVEL_BAJO);
			miLog.addTraza(ex1);
			throw new Exception(ex1);
		}
	}
	
	private String obtenerFechaBaja44() throws java.lang.Exception
	{
		try
		{
			String retorno = "";
			String sqlFechaBaja44 = "";
			PreparedStatement pstmtA = null;
			ResultSet rsA = null;
			 
			sqlFechaBaja44 = " select TO_CHAR(" + m05bConstantes.COL_44_FBAJA + ", 'yyyymmdd') ";
			sqlFechaBaja44 += " from " + m05bConstantes.TAB_HIST_VEHICULOS;
			sqlFechaBaja44 += " where ";
			sqlFechaBaja44 += m05bConstantes.COL_44_FBAJA + " is not null ";
			sqlFechaBaja44 += " and ";
			sqlFechaBaja44 += m05bConstantes.COL_44_SITUACION + " = 'B' ";
			sqlFechaBaja44 += " and ";
			sqlFechaBaja44 += m05bConstantes.COL_44_MATRICULA + "= '" + matricula + "')";
			
			//miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "obtenerFechaBaja44" + sqlFechaBaja44, m05bConstantes.LOG_NIVEL_MEDIO);
															
			pstmtA = conn.prepareStatement(sqlFechaBaja44);
			rsA = pstmtA.executeQuery();
			if (rsA.next())
			{
				retorno = rsA.getString(1);
			}
			else
			{
				retorno = "";
			}

			if (rsA != null)
				rsA.close();
			if (pstmtA != null)
				pstmtA.close();
			
			return retorno;
		}
		catch (Exception ex1)
		{
			miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "EXCEPTION: obtenerFechaBaja44 " + ex1, m05bConstantes.LOG_NIVEL_BAJO);
			miLog.addTraza(ex1);
			throw new Exception(ex1);
		}
	}
    
	public void cargarTempGral (String persona, String DesdeCTK, String HastaCTK) throws javax.servlet.ServletException, java.lang.Exception
	{
		/* 20101116 igo
		 * Comprobamos si el periodo introducido para el informe comprende desde
		 * el 1 de Enero al 31 de Diciembre de un ao ya pasado.
		 * En este caso el proceso de carga de amortizaciones de dicho ao debe estar pasado
		 * por lo que podremos coger todos los datos relativos a las amortizaciones
		 * de la tabla de amortizaciones (M0539T00)
		 * 
		 *  */

		PreparedStatement pstmtAux = null;
		ResultSet rsAux = null;
		boolean anyoPasado = false;

		try
		{
			conn = miConex.getConnection();
			conn.setAutoCommit(false);

			//miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "cargarTempGral DesdeCTK " + DesdeCTK, m05bConstantes.LOG_NIVEL_MEDIO);
			//miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "cargarTempGral DesdeCTK Ao " + DesdeCTK.substring(0, 4), m05bConstantes.LOG_NIVEL_MEDIO);
			//miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "cargarTempGral DesdeCTK MesDa " + DesdeCTK.substring(4, 8), m05bConstantes.LOG_NIVEL_MEDIO);

			//miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "cargarTempGral HastaCTK " + HastaCTK, m05bConstantes.LOG_NIVEL_MEDIO);
			//miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "cargarTempGral HastaCTK Ao " + HastaCTK.substring(0, 4), m05bConstantes.LOG_NIVEL_MEDIO);
			//miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "cargarTempGral HastaCTK MesDa " + HastaCTK.substring(4, 8), m05bConstantes.LOG_NIVEL_MEDIO);

			if (DesdeCTK.substring(0, 4).equals(HastaCTK.substring(0, 4))) //El ao inicio y el ao fin son iguales
			{
				pstmtAux = conn.prepareStatement("SELECT TO_CHAR(sysdate, 'yyyy') FROM DUAL");
			    rsAux = pstmtAux.executeQuery();
			    String anyoActual = "9999";
			    if (rsAux.next())
			    	anyoActual = rsAux.getString(1);

			    //miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "cargarTempGral anyoActual " + anyoActual, m05bConstantes.LOG_NIVEL_MEDIO);

				if (DesdeCTK.compareTo(anyoActual) < 0) //Es un ao pasado
				{
					if (DesdeCTK.substring(4, 8).compareTo("0101") == 0
						&& HastaCTK.substring(4, 8).compareTo("1231") == 0)
					{
						anyoPasado = true;
					}
				}
			}
			
			if (rsAux != null)
				rsAux.close();
			if (pstmtAux != null)
				pstmtAux.close();
			if (conn != null)
				conn.close();

			if (anyoPasado)
			{
				miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "TENEMOS QUE LANZAR EL PROCESO DE AOS ANTERIORES anyoPasado " + anyoPasado, m05bConstantes.LOG_NIVEL_MEDIO);
				this.cargarTempGralAnyosAnteriores(persona, DesdeCTK, HastaCTK);
			}
			else
			{
				miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "TENEMOS QUE LANZAR EL PROCESO DE AOS POSTERIORES anyoPasado " + anyoPasado, m05bConstantes.LOG_NIVEL_MEDIO);
				this.cargarTempGralAnyosSinCargar(persona, DesdeCTK, HastaCTK);
			}
		}
		catch (Exception ex1)
		{
			if (conn != null)
				conn.rollback();
 			miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "EXCEPTION: cargarTempGral " + ex1, m05bConstantes.LOG_NIVEL_BAJO);
 			miLog.addTraza(ex1);
 			throw new Exception(ex1);
		}
		finally
		{
			try
			{
				if (rsAux != null)
					rsAux.close();
				if (pstmtAux != null)
					pstmtAux.close();
				if (conn != null)
					conn.close();
			}
			catch (Exception ex2)
			{
				miLog.addTraza(ex2);
			}
		}
	}  // Fin funcin cargarTempGral
	
	public void cargarTempGralAnyosSinCargar (String persona, String DesdeCTK, String HastaCTK) throws javax.servlet.ServletException, java.lang.Exception
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "", fdesde, fhasta, fhastaf, fmatric, fbaja, matriculaAnt = "", fHastaMatric = "";
		double precio = 0.0, importe = 0.0;
		long diasPendAmort = 0, diasCTK = 0, diasAmort = 0, diasHastaIniRango = 0;
		int vidautil = 0;
		String matriculaSig = "";
		int cont = 0;
		boolean transferido = false;
		//String situacion = "";
		//double importeBaja = 0.0;
		BigDecimal aux1, aux2;
		
		try
		{
			conn = miConex.getConnection();
			conn.setAutoCommit(false);
			
			// Carga de grupos con sus rangos en un objeto
			cargarGrupos();
			
			// Borrado de la tabla temporal
			borrarTemporal(persona);
			
			// Obtencin de los registros que intervienen en el clculo
			// No se tratan los rangos D2 ni X
			sql = "select " + m05bConstantes.COL_34_MATRICULA + ", " + m05bConstantes.COL_34_RANGO +
				", " + m05bConstantes.COL_34_FMATRIC + ", " + m05bConstantes.COL_34_FBAJA +
				", " + m05bConstantes.COL_34_PRECIO + ", " + m05bConstantes.COL_34_VIDAUTIL +
				", " + m05bConstantes.COL_34_SITUACION +
				", " + m05bConstantes.COL_40_RANGO + ", " + m05bConstantes.COL_40_IMPORTE +
				", " + m05bConstantes.COL_34_IMPBAJA + " " +
				", " + m05bConstantes.COL_40_FDESDE + ", " + m05bConstantes.COL_40_FHASTA +
				" from " + m05bConstantes.TAB_VEHICULOS + ", " + m05bConstantes.TAB_TRANSFERENCIAS +
				" where " + m05bConstantes.COL_40_MATRICULA + " (+) = " + m05bConstantes.COL_34_MATRICULA +
					" and " + m05bConstantes.COL_34_RANGO + " NOT IN ('D2')" +
					" and to_char(" + m05bConstantes.COL_34_FMATRIC + ",'yyyymmdd') <= " + HastaCTK +
					" and (" + m05bConstantes.COL_34_FBAJA + " IS NULL " +
					" or to_char(" + m05bConstantes.COL_34_FBAJA + ",'yyyymmdd') >= " + DesdeCTK + ")" +
					//" and " + m05bConstantes.COL_40_MATRICULA + " = 'BI-1760-CN'" + 
					" order by " + m05bConstantes.COL_34_MATRICULA + ", " + m05bConstantes.COL_40_FDESDE;

			miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "SQL cargarTablaTMP CTK: \n         " + sql, m05bConstantes.LOG_NIVEL_MEDIO);

			pstmt = conn.prepareStatement(sql);
		    int contadorRegistros = 0;
		    int i = 0;
		    rs = pstmt.executeQuery();

		    while (rs.next())
	    		contadorRegistros++;

		    rs = pstmt.executeQuery();
		    
			diasCTK = miComun.getDiasEntreFechasInclude(DesdeCTK, HastaCTK);
			
		    while (i != contadorRegistros)
		    {
				if(i == 0)
					rs.next();
		    	i++;
	    	
		    	//Inicializamos los valores para el siguiente vehculo
		    	intervTP = 0;
		    	gastosTP = 0;
		    	intervTE = 0;
		    	gastosTE = 0;
				amortizacion = 0;
				diasRango = 0;
				
				matricula = rs.getString(m05bConstantes.COL_34_MATRICULA);
				
				fdesde = rs.getString(m05bConstantes.COL_40_FDESDE);
	    		fhasta = rs.getString(m05bConstantes.COL_40_FHASTA);
				fhastaf = miComun.formatearFechaBD(fhasta);
			    fmatric = rs.getString(m05bConstantes.COL_34_FMATRIC);
			    fmatric = miComun.formatearFechaBD(fmatric);
			    fbaja = rs.getString(m05bConstantes.COL_34_FBAJA);
			    fbaja = miComun.formatearFechaBD(fbaja);
				vidautil = rs.getInt(m05bConstantes.COL_34_VIDAUTIL);
				//situacion = rs.getString(m05bConstantes.COL_34_SITUACION);
	    		precio = rs.getDouble(m05bConstantes.COL_34_PRECIO);
	    		fHastaMatric = "" + (Integer.parseInt(fmatric.substring(0,4)) + vidautil)
				    		   	  + fmatric.substring(4,6)
				    		      + fmatric.substring(6,8);
	    		
	    		
	    		//if (matricula.equals("2751 CYN"))
	    		//{
					//miLog.addTraza("iniro", "m05bCalcularCTK", "Matricula: 2751 CYN ", m05bConstantes.LOG_NIVEL_BAJO);
					//miLog.addTraza("iniro", "m05bCalcularCTK", "fdesde: " + fdesde, m05bConstantes.LOG_NIVEL_BAJO);
					//miLog.addTraza("iniro", "m05bCalcularCTK", "fhasta: " + fhasta, m05bConstantes.LOG_NIVEL_BAJO);
					//miLog.addTraza("iniro", "m05bCalcularCTK", "fhastaf: " + fhastaf, m05bConstantes.LOG_NIVEL_BAJO);
					//miLog.addTraza("iniro", "m05bCalcularCTK", "fmatric: " + fmatric, m05bConstantes.LOG_NIVEL_BAJO);
					//miLog.addTraza("iniro", "m05bCalcularCTK", "fbaja: " + fbaja, m05bConstantes.LOG_NIVEL_BAJO);
					//miLog.addTraza("iniro", "m05bCalcularCTK", "vidautil: " + vidautil, m05bConstantes.LOG_NIVEL_BAJO);
					//miLog.addTraza("iniro", "m05bCalcularCTK", "precio: " + precio, m05bConstantes.LOG_NIVEL_BAJO);
					//miLog.addTraza("iniro", "m05bCalcularCTK", "fHastaMatric: " + fHastaMatric, m05bConstantes.LOG_NIVEL_BAJO);
				//}

    			// NO hay transferencias para ese vehculo
	    		if (fdesde == null)
	    		{
	    			//miLog.addTraza("PERSONA", "m05bCalcularCTK", " NO hay transferencias para ese vehculo - matrcula = " + matricula, m05bConstantes.LOG_NIVEL_BAJO);
					
	    			cont = 1;
					
					rango = rs.getString(m05bConstantes.COL_34_RANGO);

					if ((fmatric != null) && (DesdeCTK.compareTo(fmatric) < 0))
						finiciorang = fmatric;
				    else
				    	finiciorang = DesdeCTK;

				    if ((fbaja == null) || (HastaCTK.compareTo(fbaja) < 0))
				    	ffinrang = HastaCTK;
				    else
				    	ffinrang = fbaja;
				    
				    diasRango = miComun.getDiasEntreFechasInclude(finiciorang, ffinrang);
	    			diasAmort = miComun.getDiasEntreFechas(fmatric.substring(0,4) + fmatric.substring(4,6) + fmatric.substring(6,8), fHastaMatric);
	    			
				    if (diasRango > 0)
				    {
						//porcent = ((double) diasRango) / ((double) diasCTK);
						aux1=new BigDecimal(diasRango);
						aux2=new BigDecimal(diasCTK);
						porcent=aux1.divide(aux2, DECIMALES, REDONDEO).doubleValue();

						//valorAmort = precio / diasAmort;
						aux1=new BigDecimal(precio);
						aux2=new BigDecimal(diasAmort);
						valorAmort=aux1.divide(aux2, DECIMALES, REDONDEO).doubleValue();

						diasHastaIniRango = miComun.getDiasEntreFechasInclude(fmatric, finiciorang);

						// No se amortiza nada, ha pasado completamente el periodo de amortizacin
						if (diasAmort < diasHastaIniRango)
						{
							amortizacion = 0;
						}
						else
						{
							// Se amortiza slo una parte de los das en el rango
							if (diasAmort < (diasHastaIniRango + diasRango))
							   	diasRango = diasAmort - diasHastaIniRango;
							amortizacion = valorAmort * (double)diasRango;
						}

					    total = "S";
						
				    	//*************Metido para los cohes de baja --> Se amortiza todo*************//
						if ((fbaja != null) && ((DesdeCTK.compareTo(fbaja) <= 0) && (HastaCTK.compareTo(fbaja) >= 0)))
						{
							//
							//miLog.addTraza("PERSONA", "m05bCalcularCTK", " NO hay transferencias para ese vehculo SE DA DE BAJA - matrcula = " + matricula, m05bConstantes.LOG_NIVEL_BAJO);
							this.obtenerImporteAmortizacion(rango, DesdeCTK, HastaCTK, false, false, true, false);
							//
						}
				    	//*************Metido para los cohes de baja --> Se amortiza todo*************//
						
						if(!matriculaAnt.equals(matricula))
						{
							setGastosTaller(matricula, finiciorang, ffinrang);
							if(rango.equals("AR") || rango.equals("BR") || rango.equals("VR"))
							{
								//miLog.addTraza("PERSONA", "m05bCalcularCTK", " NO hay transferencias para ese vehculo RANGO = " + rango + " - matrcula = " + matricula, m05bConstantes.LOG_NIVEL_BAJO);

								amortizacion = 0;
							}

							////iniro 20100831
							////Si no se amortiza nada inicializamos tambin el valor de Amoritzacin Diaria
							//if (amortizacion == 0)
							//	valorAmort = 0;
							////
							
							insertarTemporal(persona);
						}
				    }  // Fin (diasRango > 0)

				    rs.next();
				    
				}
	    		else
				{
	    			// ***************************************
					// ***************************************
					// SI hay transferencias para ese vehiculo
					// ***************************************
					// ***************************************
		    		
					//if (matricula.equals("4985 BPT"))
	    			//{
	    			//miLog.addTraza("PERSONA", "m05bCalcularCTK", "Matricula: 4985 BPT", m05bConstantes.LOG_NIVEL_BAJO);
					//}
		    			
					cont++;
		    		diasAmort = miComun.getDiasEntreFechasInclude(fhasta.substring(0,4) + fhasta.substring(5,7) + fhasta.substring(8,10), fHastaMatric);
		    		
					finiciorang = rs.getString(m05bConstantes.COL_40_FDESDE);
		    		finiciorang = miComun.formatearFechaBD(finiciorang);
					ffinrang = rs.getString(m05bConstantes.COL_40_FHASTA);
		    		ffinrang = miComun.formatearFechaBD(ffinrang);
					rango = rs.getString(m05bConstantes.COL_40_RANGO);
					
					if(rango.equals("AR") || rango.equals("BR") || rango.equals("VR"))
					{
						fHastaMatric = "" + (Integer.parseInt(fhastaf.substring(0,4)) + vidautil) +
				    					 	fhastaf.substring(4,6) +
			    					 		fhastaf.substring(6,8);
					}
					
					//if (matricula.equals("4985 BPT"))
					//{
					//miLog.addTraza("PERSONA", "m05bCalcularCTK", "Matricula: 4985 BPT -- fHastaMatric==" + fHastaMatric, m05bConstantes.LOG_NIVEL_BAJO);
					//}
					
					//if (matricula.equals("2751 CYN"))
					//{
					//miLog.addTraza("iniro", "m05bCalcularCTK", "Matricula: 2751 CYN ", m05bConstantes.LOG_NIVEL_BAJO);
					//miLog.addTraza("iniro", "m05bCalcularCTK", "diasAmort: " + diasAmort, m05bConstantes.LOG_NIVEL_BAJO);
					//miLog.addTraza("iniro", "m05bCalcularCTK", "finiciorang: " + finiciorang, m05bConstantes.LOG_NIVEL_BAJO);
					//miLog.addTraza("iniro", "m05bCalcularCTK", "ffinrang: " + ffinrang, m05bConstantes.LOG_NIVEL_BAJO);
					//miLog.addTraza("iniro", "m05bCalcularCTK", "rango: " + rango, m05bConstantes.LOG_NIVEL_BAJO);
					//miLog.addTraza("iniro", "m05bCalcularCTK", "fHastaMatric: " + fHastaMatric, m05bConstantes.LOG_NIVEL_BAJO);
					//}
	    			
					
				    // Chequear si las fechas de inicio y fin de rango estn dentro del periodo de clculo
					//miLog.addTraza("iniro", "m05bCalcularCTK", "((DesdeCTK.compareTo(finiciorang) >= 0) && (DesdeCTK.compareTo(ffinrang) <= 0)): " + ((DesdeCTK.compareTo(finiciorang) >= 0) && (DesdeCTK.compareTo(ffinrang) <= 0)), m05bConstantes.LOG_NIVEL_BAJO);
					//miLog.addTraza("iniro", "m05bCalcularCTK", "((HastaCTK.compareTo(finiciorang) >= 0) && (HastaCTK.compareTo(ffinrang) <= 0)): " + ((HastaCTK.compareTo(finiciorang) >= 0) && (HastaCTK.compareTo(ffinrang) <= 0)), m05bConstantes.LOG_NIVEL_BAJO);
					//miLog.addTraza("iniro", "m05bCalcularCTK", "((DesdeCTK.compareTo(finiciorang) >= 0) && (HastaCTK.compareTo(ffinrang) <= 0)): " + ((DesdeCTK.compareTo(finiciorang) >= 0) && (HastaCTK.compareTo(ffinrang) <= 0)), m05bConstantes.LOG_NIVEL_BAJO);
					//miLog.addTraza("iniro", "m05bCalcularCTK", "((DesdeCTK.compareTo(ffinrang) >= 0)): " + ((DesdeCTK.compareTo(ffinrang) >= 0)), m05bConstantes.LOG_NIVEL_BAJO);
					//miLog.addTraza("iniro", "m05bCalcularCTK", "((DesdeCTK.compareTo(finiciorang) <= 0) && (HastaCTK.compareTo(ffinrang) >= 0)): " + ((DesdeCTK.compareTo(finiciorang) <= 0) && (HastaCTK.compareTo(ffinrang) >= 0)), m05bConstantes.LOG_NIVEL_BAJO);
					
					if (((DesdeCTK.compareTo(finiciorang) >= 0) && (DesdeCTK.compareTo(ffinrang) <= 0))
						|| ((HastaCTK.compareTo(finiciorang) >= 0) && (HastaCTK.compareTo(ffinrang) <= 0))
						|| ((DesdeCTK.compareTo(finiciorang) >= 0) && (HastaCTK.compareTo(ffinrang) <= 0))
						|| ((DesdeCTK.compareTo(ffinrang) >= 0))
						|| ((DesdeCTK.compareTo(finiciorang) <= 0) && (HastaCTK.compareTo(ffinrang) >= 0)) )
					{
						//if (matricula.equals("2751 CYN"))
						//{
						//miLog.addTraza("iniro", "m05bCalcularCTK", "Matricula: 2751 CYN ", m05bConstantes.LOG_NIVEL_BAJO);
						//miLog.addTraza("iniro", "m05bCalcularCTK", "FECHAS DENTRO DEL RANGO ", m05bConstantes.LOG_NIVEL_BAJO);
						//}
						
						transferido = true;
						
						//if (matricula.equals("4985 BPT"))
						//{
						//miLog.addTraza("PERSONA", "m05bCalcularCTK", "Matricula: 4985 BPT -- transferido==" + transferido, m05bConstantes.LOG_NIVEL_BAJO);
						//}
							
						//*******************************************************************************************
						//Caso 1: Si la Fecha Inicio Periodo solicitado est entre las fechas Desde y Hasta del rango
						//Clculo los datos para amortizacin
						//*******************************************************************************************
						if(DesdeCTK.compareTo(ffinrang) >= 0)
						{
							diasPendAmort = miComun.getDiasEntreFechasInclude(fhasta.substring(0,4) + fhasta.substring(5,7) + fhasta.substring(8,10), fHastaMatric);
							importe = rs.getDouble(m05bConstantes.COL_40_IMPORTE);
							valorAmort = 0;
							amortizacion = 0;
							diasRango = 0;
						} //FIN IF Caso 1
						
						//*******************************************************************************************************
						//Caso 2 condicion 1: Si la Fecha Inicio Periodo solicitado est entre las fechas Desde y Hasta del rango
						//Clculo de datos para amortizacin
						//Clculo del periodo que est en el rango
						//*******************************************************************************************************
						else if(finiciorang.compareTo(DesdeCTK) <= 0
								&& ffinrang.compareTo(DesdeCTK) >= 0 && ffinrang.compareTo(HastaCTK) <= 0)
						{
							finiciorang = DesdeCTK;
							diasRango = miComun.getDiasEntreFechasInclude(finiciorang, ffinrang);
							
							if (diasRango > 0)
							{
								//porcent = ((double) diasRango) / ((double) diasCTK);
								aux1=new BigDecimal(diasRango);
								aux2=new BigDecimal(diasCTK);
								porcent=aux1.divide(aux2, DECIMALES, REDONDEO).doubleValue();
							}

							diasPendAmort = miComun.getDiasEntreFechasInclude(fhasta.substring(0,4) + fhasta.substring(5,7) + fhasta.substring(8,10), fHastaMatric);

							if (diasPendAmort <= 0)
							{
								valorAmort = 0;
								amortizacion = 0;
							}
							else
							{
								//
								this.obtenerImporteAmortizacion(rango, "", ffinrang, false, true, false, false);
								//
								
								diasPendAmort = diasRango;
							}
							
						} //FIN IF Caso 2
						
						//********************************************************************************************
						//Caso 3: Si la Fecha Fin del Periodo solicitado est entre las fechas Desde y Hasta del rango
						//Clculo de datos para amortizacin
						//Clculo del periodo que est en rango
						//********************************************************************************************
						else if(finiciorang.compareTo(DesdeCTK) >= 0 && finiciorang.compareTo(HastaCTK) <= 0
								&& ffinrang.compareTo(HastaCTK) >= 0)
						{
							diasRango2 = miComun.getDiasEntreFechasInclude(finiciorang, ffinrang);
							ffinrang2 = ffinrang;
							ffinrang = HastaCTK;
							diasRango = miComun.getDiasEntreFechasInclude(finiciorang, ffinrang);
							
							if (diasRango > 0)
							{
								//porcent = ((double) diasRango) / ((double) diasCTK);
								aux1=new BigDecimal(diasRango);
								aux2=new BigDecimal(diasCTK);
								porcent=aux1.divide(aux2, DECIMALES, REDONDEO).doubleValue();
							}
							
							diasPendAmort = miComun.getDiasEntreFechasInclude(finiciorang, fHastaMatric);

							//
							boolean retorno = this.obtenerImporteAmortizacion(rango, "", finiciorang, false, false, false, true);
							if (!retorno)
			                	amortizacion = rs.getDouble(m05bConstantes.COL_34_PRECIO);
							//

							if (diasPendAmort == 0)
							{
								valorAmort = 0;
							}
							else
							{
								//valorAmort = amortizacion / (double)diasPendAmort;
								aux1=new BigDecimal(amortizacion);
								aux2=new BigDecimal(diasPendAmort);
								valorAmort=aux1.divide(aux2, DECIMALES, REDONDEO).doubleValue();
							}

							amortizacion = valorAmort * diasRango;
							
						} //FIN IF Caso 3
						
						//Caso 4: Si el Periodo solicitado esta completamente entre las fechas Desde y Hasta del rango
						//Clculo de datos para amortizacin
						//Clculo del periodo que est en el rango
						else if(DesdeCTK.compareTo(finiciorang) >= 0 && HastaCTK.compareTo(ffinrang) <= 0)
						{
							diasRango2 = miComun.getDiasEntreFechasInclude(finiciorang, ffinrang);
							finiciorang2 = finiciorang;
							ffinrang2 = ffinrang;
							finiciorang = DesdeCTK;
							ffinrang = HastaCTK;
							diasRango = miComun.getDiasEntreFechasInclude(finiciorang, ffinrang);

							if (diasRango > 0)
							{
								//porcent = ((double) diasRango) / ((double) diasCTK);
								aux1=new BigDecimal(diasRango);
								aux2=new BigDecimal(diasCTK);
								porcent=aux1.divide(aux2, DECIMALES, REDONDEO).doubleValue();
							}

							diasPendAmort = miComun.getDiasEntreFechasInclude(finiciorang2, fHastaMatric);
								  
							//
							boolean retorno = this.obtenerImporteAmortizacion(rango, "", finiciorang2, false, false, false, true);
							//
							
							if (!retorno)
						    	amortizacion = rs.getDouble(m05bConstantes.COL_34_PRECIO);

							if (diasPendAmort == 0)
							{
								valorAmort = 0;
							}
							else
							{
								//valorAmort = amortizacion / (double)diasPendAmort;
								aux1=new BigDecimal(amortizacion);
								aux2=new BigDecimal(diasPendAmort);
								valorAmort=aux1.divide(aux2, DECIMALES, REDONDEO).doubleValue();
							}
							
							amortizacion = valorAmort * diasRango;

						} //FIN IF Caso 4

						//*****************************************************************************************
						//Caso 5: Si el Periodo solicitado cubre completamente a las fechas Desde y Hasta del rango
						//Clculo de datos para amortizacin
						//Clculo del periodo que est en el rango
						//*****************************************************************************************
						else if(DesdeCTK.compareTo(finiciorang) <= 0 && HastaCTK.compareTo(ffinrang) >= 0)
						{
							diasRango = miComun.getDiasEntreFechasInclude(finiciorang, ffinrang);
							if (diasRango > 0)
							{
								//porcent = ((double) diasRango) / ((double) diasCTK);
								aux1=new BigDecimal(diasRango);
								aux2=new BigDecimal(diasCTK);
								porcent=aux1.divide(aux2, DECIMALES, REDONDEO).doubleValue();
							}

							diasPendAmort = miComun.getDiasEntreFechasInclude(fhasta.substring(0,4) + fhasta.substring(5,7) + fhasta.substring(8,10), fHastaMatric);
								   
							if (diasPendAmort <= 0)
							{
								valorAmort = 0;
								amortizacion = 0;
							}
							else
							{
								//
								this.obtenerImporteAmortizacion(rango, "", ffinrang, false, true, true, false);
								//

								//iniro
								//Esta lnea no se si es correcta
								//El valor importe no puede tener valor
								//valorAmort = importe / (double)diasAmort;
								aux1=new BigDecimal(importe);
								aux2=new BigDecimal(diasAmort);
								valorAmort=aux1.divide(aux2, DECIMALES, REDONDEO).doubleValue();
								
								//El valor de la amortizacin se obtiene en el mtodo "obtenerImporteAmortizacion"
							}
							
						} //FIN IF Caso 5
							
								
						
						if (diasRango > 0)  {
						
							total = "S";
						    setGastosTaller(matricula, finiciorang, ffinrang);

						    if(rango.equals("AR") || rango.equals("BR") || rango.equals("VR")){
						    	amortizacion = 0;
							}
						    
						    //miLog.addTraza("iniro", "m05bCalcularCTK", "Matricula: insertarTemporal(persona) amortizacion: " + amortizacion, m05bConstantes.LOG_NIVEL_BAJO);
							insertarTemporal(persona);
						}
					} // FIN IF Chequear si las fechas de inicio y fin de rango estan dentro del periodo de calculo
					else
					{
						//if (matricula.equals("2751 CYN"))
						//{
						//miLog.addTraza("iniro", "m05bCalcularCTK", "Matricula: 2751 CYN ", m05bConstantes.LOG_NIVEL_BAJO);
						//miLog.addTraza("iniro", "m05bCalcularCTK", "FECHAS FUERA DEL RANGO ", m05bConstantes.LOG_NIVEL_BAJO);
						//}
					}

					
					//**************************************************************************************
					//Datos por si la ltima transferencia es anterior a la fecha fin del periodo solicitado
					//**************************************************************************************
					intervTP = 0; gastosTP = 0; intervTE = 0; gastosTE = 0;
					rango = rs.getString(m05bConstantes.COL_34_RANGO);
					matricula = rs.getString(m05bConstantes.COL_34_MATRICULA);
					finiciorang2 = finiciorang;
						
					diasRango2 = miComun.getDiasEntreFechasInclude(finiciorang2, DesdeCTK);
					if(ffinrang.compareTo(DesdeCTK) < 0)
						finiciorang = DesdeCTK;
					else
						finiciorang = ffinrang;
						
					fbaja = rs.getString(m05bConstantes.COL_34_FBAJA);
				    fbaja = miComun.formatearFechaBD(fbaja);

				    /* ------------------------- */
				    /* 20101122 igo: PENDIENTE */
				    //SI SE DA DE BAJA DENTRO DEL PERIODO
				    //O SU VIDA TIL CONCLUYE DENTRO DEL PERIODO
				    /* ------------------------- */
				    /* */
				    if((fbaja != null && fbaja.compareTo(DesdeCTK) >= 0 && fbaja.compareTo(HastaCTK) <= 0))
				    	//|| (fHastaMatric != null && fHastaMatric.compareTo(DesdeCTK) >= 0 && fHastaMatric.compareTo(HastaCTK) <= 0))
					{
						if (fbaja != null)
							ffinrang = fbaja;
						else
							ffinrang = fHastaMatric;
						
						diasRango = miComun.getDiasEntreFechasInclude(finiciorang, ffinrang);
						if (diasRango > 0)
						{
							//porcent = ((double) diasRango) / ((double) diasCTK);
							aux1=new BigDecimal(diasRango);
							aux2=new BigDecimal(diasCTK);
							porcent=aux1.divide(aux2, DECIMALES, REDONDEO).doubleValue();
						}
						
						//importeBaja = rs.getDouble(m05bConstantes.COL_34_IMPBAJA);
						if (diasPendAmort <= 0)
						{
							valorAmort = 0;
						}
						else
						{
							//valorAmort= importe / (double)diasPendAmort;
							aux1=new BigDecimal(importe);
							aux2=new BigDecimal(diasPendAmort);
							valorAmort=aux1.divide(aux2, DECIMALES, REDONDEO).doubleValue();
						//}
						//
						this.obtenerImporteAmortizacion(rango, DesdeCTK, HastaCTK, false, false, true, false);
						//
						}
					}
					else
					{ 
						//SI NO SE DA DE BAJA
						ffinrang = HastaCTK;
						
						diasRango = miComun.getDiasEntreFechasInclude(finiciorang, ffinrang);

						if(finiciorang.compareTo(ffinrang) == 0)
							diasRango = 0;
						
						//INIRO 20100719
						if (diasRango > 0)
						{
							//porcent = ((double) diasRango) / ((double) diasCTK);
							aux1=new BigDecimal(diasRango);
							aux2=new BigDecimal(diasCTK);
							porcent=aux1.divide(aux2, DECIMALES, REDONDEO).doubleValue();
						}
						//
						
						diasPendAmort = miComun.getDiasEntreFechasInclude(fhasta.substring(0,4) + fhasta.substring(5,7) + fhasta.substring(8,10), fHastaMatric);
						//diasPendAmort = miComun.getDiasEntreFechasInclude(finiciorang, fHastaMatric);
						
						total = "S";
						
						/*******************************************************/
						importe = rs.getDouble(m05bConstantes.COL_40_IMPORTE);
						
						if (diasPendAmort <= 0)
						{
							valorAmort = 0;
							amortizacion = 0;
						}
						else
						{
							//valorAmort = importe / (double)diasPendAmort;
							aux1=new BigDecimal(importe);
							aux2=new BigDecimal(diasPendAmort);
							valorAmort=aux1.divide(aux2, DECIMALES, REDONDEO).doubleValue();
						//}

						amortizacion = valorAmort * diasRango;
						if (amortizacion > importe)
							amortizacion = importe;
						
						//importe = rs.getDouble(m05bConstantes.COL_40_IMPORTE);
						//importe = rs.getDouble(m05bConstantes.COL_34_PRECIO);
						double importePendAmort = precio - obtenerImporteAmortizacionAcumulada(finiciorang);
						//importe = importePendAmort;
						
						double valorAmortAux = 0;
						if (diasPendAmort == 0)
						{
							valorAmortAux = 0;
						}
						else
						{
							//valorAmort = importe / (double)diasPendAmort;
							aux1=new BigDecimal(importe);
							//aux1=new BigDecimal(importePendAmort);
							aux2=new BigDecimal(diasPendAmort);
							valorAmortAux=aux1.divide(aux2, DECIMALES, REDONDEO).doubleValue();
						}

						double amortizacionAux = valorAmortAux * diasRango;
						if (amortizacionAux > importePendAmort)
							amortizacionAux = importePendAmort;
						
						if (amortizacion > amortizacionAux)
						{
							amortizacion = amortizacionAux;
						}
						/*******************************************************/
						
						}
					}	
					
					if(rs.next())
					{
						matriculaAnt = matricula;
						matriculaSig = rs.getString(m05bConstantes.COL_34_MATRICULA);
						
						if(!matriculaSig.equals(matriculaAnt))
						{
							if(transferido)
							{
								if(diasRango > 0)
								{
									setGastosTaller(matricula, finiciorang, ffinrang);
									if(rango.equals("AR") || rango.equals("BR") || rango.equals("VR"))
									{
										amortizacion = 0;
									}
									
									insertarTemporal(persona);
									matriculaAnt = matricula;
								}
								transferido = false;
							}
						}
					}
					else
					{
						if(transferido)
						{
							if(diasRango > 0)
							{
								setGastosTaller(matricula, finiciorang, ffinrang);
								if(rango.equals("AR") || rango.equals("BR") || rango.equals("VR"))
								{
									amortizacion = 0;
								}
								
								insertarTemporal(persona);
							}
							
							//20101109 igo
							transferido = false;
						}
					}

				} // FIN else fecha desde nula //else de if (fdesde == null)
	    		
			}  // FIN while
			    
			// Obtener kilometrajes
			//miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "ANTES TRATAMIENTO KM", m05bConstantes.LOG_NIVEL_BAJO);
			setKm(persona, DesdeCTK, HastaCTK);
			
			// Obtener consumo de combustible
			//miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "ANTES COMBUSTIBLE", m05bConstantes.LOG_NIVEL_BAJO);
			setCombustible(persona);
			//miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "Fin Carga Temporal", m05bConstantes.LOG_NIVEL_BAJO);

 		}
		catch (Exception ex1)
		{
 			conn.rollback();
 			miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "EXCEPTION: cargarTempGral " + ex1, m05bConstantes.LOG_NIVEL_BAJO);
 			miLog.addTraza(ex1);
 			throw new Exception(ex1);
		}
		finally
		{
			conn.commit();
			try
			{
				if (rs != null)
					rs.close();
				if (pstmt != null)
					pstmt.close();
				if (conn != null)
					conn.close();
			}
			catch (Exception ex2)
			{
				miLog.addTraza(ex2);
			}
		}
	}  // Fin funcin cargarTempGralAnyosSinCargar
	
	public void cargarTempGralAnyosAnteriores (String persona, String DesdeCTK, String HastaCTK) throws javax.servlet.ServletException, java.lang.Exception
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "";
		String fdesde;
		String fhasta;
		String fmatric;
		String fbaja;
		String matriculaAnt = "";
		String fhastaAnt = "";
		String rango34 = "";
		long diasCTK = 0;
		BigDecimal aux1;
		BigDecimal aux2;
		
		try
		{
			conn = miConex.getConnection();
			conn.setAutoCommit(false);
			
			// Carga de grupos con sus rangos en un objeto
			cargarGrupos();
			
			// Borrado de la tabla temporal
			borrarTemporal(persona);
			
			
			/**/
			// Obtencin de los registros que intervienen en el clculo
			// No se tratan los rangos D2 ni X
			sql = "" + "\n";
			sql += "SELECT * FROM " + "\n";
			sql += "( " + "\n";
			sql += "   SELECT MATRIC_34, RANGO_34, TO_CHAR(FMATRIC_34,'yyyymmdd') AS FMATRIC_34, TO_CHAR(FBAJA_34,'yyyymmdd') AS FBAJA_34, PRECIO_34, VIDAUTIL_34, SITUACION_34, RANG_40, IMPORTE_40, IMP_BAJA_34, TO_CHAR(FDESDE_40,'yyyymmdd') AS FDESDE_40, TO_CHAR(FHASTA_40,'yyyymmdd') AS FHASTA_40, IMPORTE_39, TO_CHAR(FECHA_39, 'yyyymmdd') AS FECHA_39 " + "\n";
			sql += "    FROM M0534T00, M0540T00, M0539T00 " + "\n";
			sql += "    WHERE MATRIC_34 = MATRIC_39 AND MATRIC_40 = MATRIC_34 " + "\n";
			sql += "    AND (RANG_39 = RANG_40 AND FECHA_39 = FHASTA_40 + 1) " + "\n";
			sql += "    and (TO_CHAR(FECHA_39, 'yyyymmdd') >= " + DesdeCTK + " AND TO_CHAR(FECHA_39, 'yyyymmdd') <= " + HastaCTK + ") " + "\n";
			sql += "    UNION " + "\n";
			sql += "   SELECT MATRIC_34, RANGO_34, TO_CHAR(FMATRIC_34,'yyyymmdd') AS FMATRIC_34, TO_CHAR(FBAJA_34,'yyyymmdd') AS FBAJA_34, PRECIO_34, VIDAUTIL_34, SITUACION_34, RANG_40, IMPORTE_40, IMP_BAJA_34, TO_CHAR(FDESDE_40,'yyyymmdd') AS FDESDE_40, TO_CHAR(FHASTA_40,'yyyymmdd') AS FHASTA_40, IMPORTE_39, TO_CHAR(FECHA_39, 'yyyymmdd') AS FECHA_39 " + "\n";
			sql += "    FROM M0534T00, M0540T00, M0539T00 " + "\n";
			sql += "    WHERE MATRIC_34 = MATRIC_39 AND MATRIC_40 = MATRIC_34 " + "\n";
			sql += "    AND (FECHA_39 = (SELECT FBAJA_44 FROM M0544T00 WHERE MATRIC_44 = MATRIC_34 AND FBAJA_44 is not null AND SITUACION_44 = 'B') " + "\n";
			sql += "         OR FECHA_39 = FBAJATEMP_34 AND SITUACION_34 = 'T' " + "\n";
			sql += "         OR FECHA_39 = FCEDIDO_34 AND SITUACION_34 = 'C' " + "\n";
			sql += "         OR FECHA_39 = ADD_MONTHS(FMATRIC_34, 12*VIDAUTIL_34) " + "\n";
			sql += "         OR TO_CHAR(FECHA_39, 'yyyymmdd') = " + HastaCTK + ") " + "\n";
			sql += "    AND FECHA_39 >= FDESDE_40 AND FECHA_39 <= FHASTA_40 " + "\n";
		    sql += "    AND (TO_CHAR(FECHA_39, 'yyyymmdd') >= " + DesdeCTK + " AND TO_CHAR(FECHA_39, 'yyyymmdd') <= " + HastaCTK + ") " + "\n"; 
	    	sql += "    UNION " + "\n";
    		sql += "   SELECT MATRIC_34, RANGO_34, TO_CHAR(FMATRIC_34,'yyyymmdd') AS FMATRIC_34, TO_CHAR(FBAJA_34,'yyyymmdd') AS FBAJA_34, PRECIO_34, VIDAUTIL_34, SITUACION_34, '' AS RANG_40, 0 AS IMPORTE_40, IMP_BAJA_34, null AS FDESDE_40, null AS FHASTA_40, IMPORTE_39, TO_CHAR(FECHA_39, 'yyyymmdd') AS FECHA_39 " + "\n";
			sql += "    FROM M0534T00, M0539T00 " + "\n";
			sql += "    WHERE MATRIC_34 = MATRIC_39 " + "\n";
			sql += "    AND (FECHA_39 = (SELECT FBAJA_44 FROM M0544T00 WHERE MATRIC_44 = MATRIC_34 AND FBAJA_44 is not null AND SITUACION_44 = 'B') " + "\n";
			sql += "         OR FECHA_39 = FBAJATEMP_34 AND SITUACION_34 = 'T' " + "\n";
			sql += "         OR FECHA_39 = FCEDIDO_34 AND SITUACION_34 = 'C' " + "\n";
			sql += "         OR FECHA_39 = ADD_MONTHS(FMATRIC_34, 12*VIDAUTIL_34) " + "\n";
			sql += "         OR TO_CHAR(FECHA_39, 'yyyymmdd') = " + HastaCTK + ") " + "\n";
			sql += "    AND (TO_CHAR(FECHA_39, 'yyyymmdd') >= " + DesdeCTK + " AND TO_CHAR(FECHA_39, 'yyyymmdd') <= " + HastaCTK + ") " + "\n";
			sql += "    AND MATRIC_34 NOT IN (SELECT MATRIC_40 FROM M0540T00 WHERE FECHA_39 >= FDESDE_40 AND FECHA_39 <= FHASTA_40) " + "\n";
			sql += "    AND RANG_39 = RANGO_34 " + "\n";
			sql += "    UNION " + "\n";
			
			sql += "   SELECT MATRIC_34, RANGO_34, TO_CHAR(FMATRIC_34,'yyyymmdd') AS FMATRIC_34, TO_CHAR(FBAJA_34,'yyyymmdd') AS FBAJA_34, PRECIO_34, VIDAUTIL_34, SITUACION_34, RANG_40, IMPORTE_40, IMP_BAJA_34 , TO_CHAR(FDESDE_40,'yyyymmdd') AS FDESDE_40, TO_CHAR(FHASTA_40,'yyyymmdd') AS FHASTA_40, 0 as IMPORTE_39, null as FECHA_39 " + "\n"; 
			sql += "    FROM M0534T00, M0540T00 " + "\n";
			sql += "    WHERE MATRIC_40 (+) = MATRIC_34 " + "\n";
			sql += "    AND MATRIC_34 " + "\n";
			sql += "   	NOT IN " + "\n";
			sql += "    ( " + "\n";
			sql += "     SELECT MATRIC_39 from M0539T00 " + "\n";
			sql += "     WHERE (TO_CHAR(FECHA_39,'yyyymmdd') >= " + DesdeCTK + " AND TO_CHAR(FECHA_39,'yyyymmdd') <= " + HastaCTK + ") " + "\n"; 
			sql += "    ) " + "\n";
			sql += "    AND NOT (TO_CHAR(FHASTA_40, 'yyyymmdd') < " + DesdeCTK + ") " + "\n";
			sql += "   UNION " + "\n";
			sql += "   SELECT MATRIC_34, RANGO_34, TO_CHAR(FMATRIC_34,'yyyymmdd') AS FMATRIC_34, TO_CHAR(FBAJA_34,'yyyymmdd') AS FBAJA_34, PRECIO_34, VIDAUTIL_34, SITUACION_34, '' AS RANGO_40, 0 AS IMPORTE_40, IMP_BAJA_34 , '' AS FDESDE_40, '' FHASTA_40, 0 as IMPORTE_39, null as FECHA_39 " + "\n"; 
			sql += "    FROM M0534T00, M0540T00 " + "\n";
			sql += "    WHERE MATRIC_40 (+) = MATRIC_34 " + "\n";
			sql += "    AND MATRIC_34 " + "\n";
			sql += "    NOT IN " + "\n";
			sql += "    ( " + "\n";
			sql += "     SELECT MATRIC_39 from M0539T00 " + "\n";
			sql += "     WHERE (TO_CHAR(FECHA_39,'yyyymmdd') >= " + DesdeCTK + " AND TO_CHAR(FECHA_39,'yyyymmdd') <= " + HastaCTK + ") " + "\n"; 
			sql += "    ) " + "\n";
			
			sql += "    AND " + "\n";
			sql += "    (TO_CHAR(FHASTA_40, 'yyyymmdd') >= " + DesdeCTK + " AND TO_CHAR(FHASTA_40, 'yyyymmdd') <= " + HastaCTK + " " + "\n";
			sql += "    OR FHASTA_40 IS NULL " + "\n";
			sql += "    OR FHASTA_40 = (SELECT MAX(FHASTA_40) FROM M0540T00 WHERE MATRIC_34 = MATRIC_40 AND TO_CHAR(FHASTA_40, 'yyyymmdd') < " + DesdeCTK + ") " + "\n";
			sql += "    AND NOT EXISTS(SELECT FHASTA_40 FROM M0540T00 WHERE MATRIC_34 = MATRIC_40 AND TO_CHAR(FHASTA_40, 'yyyymmdd') > " + HastaCTK + ") ) " + "\n";
		    
			sql += "   UNION " + "\n";
			
			sql += "   SELECT MATRIC_34, RANGO_34, TO_CHAR(FMATRIC_34,'yyyymmdd') AS FMATRIC_34, TO_CHAR(FBAJA_34,'yyyymmdd') AS FBAJA_34, PRECIO_34, VIDAUTIL_34, SITUACION_34, RANG_40, IMPORTE_40, IMP_BAJA_34 , TO_CHAR(FDESDE_40,'yyyymmdd') AS FDESDE_40, TO_CHAR(FHASTA_40,'yyyymmdd'), 0 AS IMPORTE_39, null AS FECHA_39 " + "\n";
			sql += "   FROM M0534T00, M0540T00 " + "\n";
			sql += "   WHERE MATRIC_40 = MATRIC_34 " + "\n";
			sql += "   AND MATRIC_34 NOT IN (SELECT MATRIC_39 FROM M0539T00 WHERE (FECHA_39 = FHASTA_40 + interval '1' day " + "\n"; 
			sql += "   															   OR FECHA_39 = TO_DATE(" + HastaCTK + ",'yyyymmdd') " + "\n";
			sql += "   															   OR FECHA_39 = ADD_MONTHS(FMATRIC_34, 12*VIDAUTIL_34))" + "\n";
			sql += "															   AND (RANG_39 = RANG_40 OR (RANG_39 = RANGO_34 AND RANG_40 is null))) " + "\n";
					   
			sql += "   AND TO_CHAR(FHASTA_40, 'yyyymmdd') >= " + DesdeCTK + " AND TO_CHAR(FDESDE_40, 'yyyymmdd') <= " + HastaCTK + " " + "\n";
			
			sql += ") " + "\n";
			sql += "WHERE RANGO_34 NOT IN ('D2') and FMATRIC_34 <= " + HastaCTK + " " + "\n"; 
			sql += "AND (FBAJA_34 IS NULL OR FBAJA_34 >= " + DesdeCTK + ") " + "\n";
			sql += "ORDER BY MATRIC_34, FDESDE_40, FECHA_39 ";
			/**/
			
			miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "SQL cargarTempGralAnyosAnteriores CTK: \n         " + sql, m05bConstantes.LOG_NIVEL_MEDIO);

			pstmt = conn.prepareStatement(sql);
		    int contadorRegistros = 0;
		    int i = 0;
		    rs = pstmt.executeQuery();

		    while (rs.next())
	    		contadorRegistros++;
		    
		    rs = pstmt.executeQuery();

			diasCTK = miComun.getDiasEntreFechasInclude(DesdeCTK, HastaCTK);
			
		    while (i != contadorRegistros)
		    {
				if(i == 0)
					rs.next();
		    	i++;
	    	
		    	//Inicializamos los valores para el siguiente vehculo
		    	intervTP = 0;
		    	gastosTP = 0;
		    	intervTE = 0;
		    	gastosTE = 0;
				amortizacion = 0;
				diasRango = 0;
				
				matricula = rs.getString(m05bConstantes.COL_34_MATRICULA);
				rango34 = rs.getString(m05bConstantes.COL_34_RANGO);
				fdesde = rs.getString(m05bConstantes.COL_40_FDESDE);
	    		fhasta = rs.getString(m05bConstantes.COL_40_FHASTA);
			    fmatric = rs.getString(m05bConstantes.COL_34_FMATRIC);
			    fbaja = rs.getString(m05bConstantes.COL_34_FBAJA);

			    
				// NO hay transferencias para ese vehculo
	    		if (fdesde == null || fhasta.compareTo(DesdeCTK) < 0)
	    		{	    			
	    			rango = rs.getString(m05bConstantes.COL_34_RANGO);
	    			fmatric = rs.getString(m05bConstantes.COL_34_FMATRIC);
	    			finiciorang = DesdeCTK;
	    			if ((finiciorang + "").compareTo(fmatric+"") < 0)
	    				finiciorang = fmatric;
		    		ffinrang = rs.getString(m05bConstantes.COL_39_FECHA);
		    		if (ffinrang == null || ffinrang.equals(""))
		    			ffinrang = HastaCTK;
		    		if ((fbaja+"").compareTo(ffinrang) < 0)
						ffinrang = fbaja;
		    		
		    		if (matriculaAnt.equals(matricula)
		    			&& fhastaAnt != null
		    			&& !fhastaAnt.equals(""))
	    			{
		    			finiciorang = fhastaAnt;
		    			fhastaAnt = null;
	    			}
	    		}
	    		else
	    		{
	    			rango = rs.getString(m05bConstantes.COL_40_RANGO);
	    			finiciorang = rs.getString(m05bConstantes.COL_40_FDESDE);
	    			if ((finiciorang + "").compareTo(DesdeCTK+"") < 0)
	    				finiciorang = DesdeCTK;
	    			if ((finiciorang + "").compareTo(fmatric+"") < 0)
	    				finiciorang = fmatric;
		    		ffinrang = rs.getString(m05bConstantes.COL_40_FHASTA);
		    		if ((ffinrang + "").compareTo(HastaCTK+"") > 0)
		    			ffinrang = HastaCTK;
		    		if ((fbaja+"").compareTo(ffinrang) < 0)
						ffinrang = fbaja;
	    		}
	    		
	    		total = "S";
	    		
				diasRango = miComun.getDiasEntreFechasInclude(finiciorang, ffinrang);
				amortizacion = rs.getDouble(m05bConstantes.COL_39_IMPORTE);
				
				aux1=new BigDecimal(amortizacion);
				aux2=new BigDecimal(diasRango);
				valorAmort=aux1.divide(aux2, DECIMALES, REDONDEO).doubleValue();
				
				aux1=new BigDecimal(diasRango);
				aux2=new BigDecimal(diasCTK);
				porcent=aux1.divide(aux2, DECIMALES, REDONDEO).doubleValue();
				
				this.setGastosTaller(matricula, finiciorang, ffinrang);
				
				if(rango.equals("AR") || rango.equals("BR") || rango.equals("VR"))
				{
					amortizacion = 0;
					valorAmort = 0;					
				}
				
				this.insertarTemporal(persona);
				
				
				/*
				 * 
				 */
				
				if (rs.next())
				{
					//i++;
					
					if (!rs.getString(m05bConstantes.COL_34_MATRICULA).equals(matricula))
					{
						if ((ffinrang+"").compareTo(HastaCTK) < 0)
						{
							//Y no se ha dado de baja
							if ((fbaja+"").compareTo(ffinrang) > 0)
							{
								rango = rango34;
								finiciorang = ffinrang;
								ffinrang = HastaCTK;
								if ((fbaja+"").compareTo(ffinrang) < 0)
									ffinrang = fbaja;
								
								//En este punto tiene que estar totalmente amortizado
								diasRango = miComun.getDiasEntreFechasInclude(finiciorang, ffinrang);
								amortizacion = 0;
								valorAmort = 0;
								
								aux1=new BigDecimal(diasRango);
								aux2=new BigDecimal(diasCTK);
								porcent=aux1.divide(aux2, DECIMALES, REDONDEO).doubleValue();
								
								intervTP = 0;
								gastosTP = 0;
								intervTE = 0;
								gastosTE = 0;
								
								this.setGastosTaller(matricula, finiciorang, ffinrang);
								
								if(rango.equals("AR") || rango.equals("BR") || rango.equals("VR"))
								{
									amortizacion = 0;
									valorAmort = 0;					
								}
								
								this.insertarTemporal(persona);
							}
						}
					}
				}
				
				matriculaAnt = matricula;
				fhastaAnt = fhasta;
				
			    /**/
			}  // FIN while
		    
		    
			// Obtener kilometrajes
			setKm(persona, DesdeCTK, HastaCTK);
			
			// Obtener consumo de combustible
			setCombustible(persona);
 		}
		catch (Exception ex1)
		{
 			conn.rollback();
 			miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "EXCEPTION: cargarTempGral " + ex1, m05bConstantes.LOG_NIVEL_BAJO);
 			miLog.addTraza(ex1);
 			throw new Exception(ex1);
		}
		finally
		{
			conn.commit();
			try
			{
				if (rs != null)
					rs.close();
				if (pstmt != null)
					pstmt.close();
				if (conn != null)
					conn.close();
			}
			catch (Exception ex2)
			{
				miLog.addTraza(ex2);
			}
		}
	}  // Fin funcin cargarTempGralAnyosAnteriores
	
    public void borrarTemporal (String persona) throws javax.servlet.ServletException, java.lang.Exception
    {
    	PreparedStatement pstmt = null;
		String sql = "";

		try
		{			
			// Borrado de la tabla temporal del calculo del CTK
		    sql = "delete from " + m05bConstantes.TAB_CTK +
    			  " where " + m05bConstantes.COL_97_USUARIO + " = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, persona);
			pstmt.executeUpdate();
			conn.commit();
 		}
		catch (Exception ex1)
 		{
		    miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"EXCEPTION: BORRAR TEMPORAL " + ex1, m05bConstantes.LOG_NIVEL_BAJO);
		    miLog.addTraza(ex1);
		}
 		finally
		{
			try
			{
				if (pstmt != null)
					pstmt.close();
	 		}
			catch (Exception ex2)
	 		{
				miLog.addTraza(ex2);
			}
		}
	}  // Fin funcin borrarTemporal

    public void insertarTemporal (String persona) throws javax.servlet.ServletException, java.lang.Exception
    {
		PreparedStatement pstmt = null;
		String sql = "";
		String grupo = "";

		try
		{
			// Insercin en la tabla temporal
			if (valorAmort < 0)
			{
				valorAmort = 0;
				amortizacion = 0;
			}

			grupo = getGrupo(rango);
			
			if(grupo != null && !grupo.equals(""))
			{
			    sql = "insert into " + m05bConstantes.TAB_CTK +
					  " (" + m05bConstantes.COL_97_USUARIO + ", " + m05bConstantes.COL_97_MATRICULA +
					  ", " + m05bConstantes.COL_97_GRUPO + ", " + m05bConstantes.COL_97_RANGO +
					  ", " + m05bConstantes.COL_97_TOTAL + 
					  ", " + m05bConstantes.COL_97_FDESDE + ", " + m05bConstantes.COL_97_FHASTA + 
					  ", " + m05bConstantes.COL_97_PORCENT + ", " + m05bConstantes.COL_97_DIAS + 
					  ", " + m05bConstantes.COL_97_INTERV_TP + ", " + m05bConstantes.COL_97_GASTOS_TP + 
					  ", " + m05bConstantes.COL_97_INTERV_TE + ", " + m05bConstantes.COL_97_GASTOS_TE + 
					  ", " + m05bConstantes.COL_97_AMORTDIARIA + ", " + m05bConstantes.COL_97_AMORTIZACION +  ")" +
					  " values " +
					  "('" + persona + "', '" + matricula + "', '" + grupo + "', '" + rango + "', '" + total + 
					  "', to_date('" + finiciorang + "','YYYYMMDD'), to_date('" + ffinrang + "','YYYYMMDD') " +
					  ", " + porcent + ", " + diasRango + ", " + intervTP + ", " + gastosTP + 
					  ", " + intervTE + ", " + gastosTE + ", " + valorAmort + ", " + amortizacion + " )";

			    //miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "CTK Insert-97: \n         " + sql, m05bConstantes.LOG_NIVEL_BAJO);
			  //  System.out.println(sql);
			    pstmt = conn.prepareStatement(sql);
				pstmt.executeUpdate();
			}
 		}
		catch (Exception ex1)
 		{
		    miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"EXCEPTION: INSERTAR TEMPORAL  " + ex1, m05bConstantes.LOG_NIVEL_BAJO);
		    miLog.addTraza(ex1);
			throw new Exception(ex1);
		}
 		finally
 		{
			try
			{
				if (pstmt != null)
					pstmt.close();
	 		}
			catch (Exception ex2)
	 		{
				miLog.addTraza(ex2);
			}
		}
	}  // Fin funcin insertarTemporal 
    
    public void cargarGrupos () throws javax.servlet.ServletException, java.lang.Exception
    {
    	PreparedStatement m05bPstmt = null;
		ResultSet rs = null;
		String sql = "";
		String grupo = "", tkRangos = "", rango = "";
		String delimReg = ",";
	    StringTokenizer stReg = null;
		
		try
		{
			// Obtener rangos por grupo de BD
			sql = "select " + m05bConstantes.COL_36_CODIGO  + ", " + m05bConstantes.COL_36_RANGOS +
				  " from " + m05bConstantes.TAB_GRUPOS +
				  " where " + m05bConstantes.COL_36_NOMBRE + " like 'CTK-%'";
			m05bPstmt = conn.prepareStatement(sql);
			rs = m05bPstmt.executeQuery();
			
			while (rs.next())
			{   // While 1
				grupo = rs.getString(1);
				tkRangos = rs.getString(2);
				stReg = new StringTokenizer(tkRangos, delimReg);
			
				while (stReg.hasMoreTokens())
				{   // While 2
					rango = stReg.nextToken();
					misGrupos = new m05bGrupos();
			        // poner valores en objeto
					misGrupos.setGrp_Grupo(grupo);
					misGrupos.setGrp_Rango(rango);
					//aadir en la ultima posicion del array
					miArrayGrupo.add(misGrupos);
				}  // Fin while 2
			} // Fin while 1
 		}
		catch (Exception ex1)
 		{
			miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"EXCEPTION: CARGAR GRUPOS: " + ex1, m05bConstantes.LOG_NIVEL_BAJO);
			miLog.addTraza(ex1);
			throw new Exception(ex1);
		}
		finally
		{
			try
			{
				if (rs != null)
					rs.close();
				if (m05bPstmt != null)
					m05bPstmt.close();
	 		}
			catch (Exception ex2)
	 		{
				miLog.addTraza(ex2);
			}
		}
     }  // Fin funcin cargarGrupos

    public String getGrupo (String rango) throws javax.servlet.ServletException, java.lang.Exception
    {
    	 String grupo = "";
    	 boolean bEncontrado = false;
		
    	 try
    	 {
		 	Iterator iter = miArrayGrupo.iterator();
		 	while ((iter.hasNext()) && !(bEncontrado))
		 	{
		 		//misGrupos=null;
		        misGrupos = (m05bGrupos) iter.next();
		        if (misGrupos.getGrp_Rango().equals(rango))
		        {
		        	grupo = misGrupos.getGrp_Grupo();
					bEncontrado = true;
				}
		    } // Fin de bucle while
    	 }
    	 catch (Exception ex1)
    	 {
    		 miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"EXCEPTION: GET GRUPO  " + ex1, m05bConstantes.LOG_NIVEL_BAJO);
    		 miLog.addTraza(ex1);
			 throw new Exception(ex1);
    	 }
    	 return grupo;
	}  // Fin funcin getGrupo

    public void cargarObjeto (String matricula, String fDesde, String fInicio, String fFin, double kmIni, double kmFin, double recorrido, double dias) throws javax.servlet.ServletException, java.lang.Exception
    {
    	try
    	{
			miObjKM = new m05bKmCTK();
		   
			//poner valores en objeto
		    //miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "Cargar Objeto:  " + matricula + " : " + fInicio + " Km: " + kmIni, m05bConstantes.LOG_NIVEL_BAJO);
		    miObjKM.setKmCTK_matricula(matricula);
		    miObjKM.setKmCTK_fDesde(fDesde);
		    miObjKM.setKmCTK_fIniAct(fInicio);
		    miObjKM.setKmCTK_fFinAct(fFin);
		    miObjKM.setKmCTK_kmIni(kmIni);
		    miObjKM.setKmCTK_kmFin(kmFin);
		    miObjKM.setKmCTK_kmRecorridos(recorrido);
		    
		    //double numDias=(double) miComun.getDiasEntreFechasInclude(fInicio,fFin);
		    //double media = recorrido /numDias; //  19-04-2006 - Cambiado por peticion de P. Durn a A. Garca
		    double media = recorrido; // 19-04-2006 - Cambiado por peticion de P. Durn a A. Garca
		    miObjKM.setKmCTK_kmMedia(media);
		    //aadir en la ltima posicion del array
		    miArrayKm.add(miObjKM);
 		}
    	catch (Exception ex1)
    	{
 			miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"EXCEPTION: CARGAR OBJETO " + ex1, m05bConstantes.LOG_NIVEL_BAJO);
 			miLog.addTraza(ex1);
			throw new Exception(ex1);
		}
	}  // Fin funcin cargarObjeto  
				 
    public void setKm (String persona, String Desde, String Hasta) throws javax.servlet.ServletException, java.lang.Exception
    {
		PreparedStatement pstmt = null, pstmtInsert = null;
		ResultSet rs = null;
		String sql = "", sqlAsigKmSal = "", sqlAsigKmLleg = "", sqlGastos = "";
		String sqlOperBancos = "", sqlOrdEnt = "", sqlOrdSal = "", sqlRevi = "", sqlVehi = "", sqlUnion = "";
		String matricula = "", fIni = "", fFin = "", fUnion = "", rango = "", matriculaAnt = "", rangoAnt = "";
		String fIniAct = "", fFinAct = "", fIniAnt = "";
		long diasDifIniMin = 10000, diasDifFinMin = 10000, difFechaIni = 0, difFechaFin = 0;
		double dias = 0.0, km = 0.0, kmIni = 0.0, kmFin = 0.0, kmRecor = 0.0;
		boolean bHayKM = false;

		try
		{
			// Asignaciones - KM Salida
			sqlAsigKmSal = "select " + m05bConstantes.COL_01_MATRICULA + " AS MATRICULA, " + m05bConstantes.COL_01_FDESDE +
						   " AS FECHA, " + m05bConstantes.COL_01_KMSALIDA + " AS KM " +
						   " from " + m05bConstantes.TAB_ASIGNACION  +
				    	   " where " +  m05bConstantes.COL_01_KMSALIDA + " IS NOT NULL " +
						   " and " + m05bConstantes.COL_01_FDESDE + " IS NOT NULL " +
						   " and " + m05bConstantes.COL_01_KMSALIDA + " <> '0' ";
			// Asignaciones - KM Llegada
			sqlAsigKmLleg = "select " + m05bConstantes.COL_01_MATRICULA + " AS MATRICULA, " + m05bConstantes.COL_01_FDEVOL +
							" AS FECHA, " + m05bConstantes.COL_01_KMLLEGADA + " AS KM " +
							" from " + m05bConstantes.TAB_ASIGNACION  +
				    		" where " +  m05bConstantes.COL_01_KMLLEGADA + " IS NOT NULL " +
							" and " + m05bConstantes.COL_01_FDEVOL + " IS NOT NULL " +
							" and " + m05bConstantes.COL_01_KMLLEGADA + " <> '0' ";
			// Gastos
			sqlGastos = "select " + m05bConstantes.COL_09_MATRICULA + " AS MATRICULA, " + m05bConstantes.COL_09_FECHA +
			    		" AS FECHA, " + m05bConstantes.COL_09_KMGASTO + " AS KM " +
						" from " + m05bConstantes.TAB_GASTOS  +
				    	" where " +  m05bConstantes.COL_09_KMGASTO + " IS NOT NULL " +
				    	" and " + m05bConstantes.COL_09_KMGASTO + " <> 0 " +
						" and " + m05bConstantes.COL_09_FECHA + " IS NOT NULL ";
			// Operacion Bancos
			sqlOperBancos = "select " + m05bConstantes.COL_18_MATRICULA + " AS MATRICULA, " + m05bConstantes.COL_18_FECHA +
			    			" AS FECHA, TO_CHAR(" + m05bConstantes.COL_18_KM + ") AS KM " +
							" from " + m05bConstantes.TAB_OPEBANCOS  +
				    		" where " +  m05bConstantes.COL_18_KM + " IS NOT NULL " +
				    		" and " + m05bConstantes.COL_18_KM + " <> 0 " +
							" and " + m05bConstantes.COL_18_FECHA + " IS NOT NULL ";
			// Ordenes Trabajo - KM Entrada
			sqlOrdEnt = "select " + m05bConstantes.COL_20_MATRICULA + " AS MATRICULA, " + m05bConstantes.COL_20_FENTRADA +
						" AS FECHA, TO_CHAR(" + m05bConstantes.COL_20_KM_ENTRADA + ") AS KM " +
						" from " + m05bConstantes.TAB_ORDENESTRAB  +
			   			" where " +  m05bConstantes.COL_20_KM_ENTRADA + " IS NOT NULL " +
						" and " + m05bConstantes.COL_20_KM_ENTRADA + " <> 0 " +
						" and " + m05bConstantes.COL_20_FENTRADA + " IS NOT NULL ";
			// Ordenes Trabajo - KM Salida
			sqlOrdSal = "select " + m05bConstantes.COL_20_MATRICULA + " AS MATRICULA, " + m05bConstantes.COL_20_FSALIDA +
						" AS FECHA, TO_CHAR(" + m05bConstantes.COL_20_KM_SALIDA + ") AS KM " +
						" from " + m05bConstantes.TAB_ORDENESTRAB  +
				    	" where " +  m05bConstantes.COL_20_KM_SALIDA + " IS NOT NULL " +
				    	" and " + m05bConstantes.COL_20_KM_SALIDA + " <> 0 " +
						" and " + m05bConstantes.COL_20_FSALIDA + " IS NOT NULL ";
			// Revisiones - KM Revision
			sqlRevi = "select " + m05bConstantes.COL_35_MATRICULA + " AS MATRICULA, " + m05bConstantes.COL_35_FECHA +
			    	  " AS FECHA, TO_CHAR(" + m05bConstantes.COL_35_KMRE + ") AS KM " +
					  " from " + m05bConstantes.TAB_REVISIONES  +
				      " where " +  m05bConstantes.COL_35_KMRE + " IS NOT NULL " +
				      " and " + m05bConstantes.COL_35_KMRE + " <> 0 " +
					  " and " + m05bConstantes.COL_35_FECHA + " IS NOT NULL ";
			// Vehiculos - KM Actuales
			sqlVehi = "select " + m05bConstantes.COL_34_MATRICULA + " AS MATRICULA, " + m05bConstantes.COL_34_FKMACT +
			    	  " AS FECHA, TO_CHAR(" + m05bConstantes.COL_34_KMACTUALES + ") AS KM " +
					  " from " + m05bConstantes.TAB_VEHICULOS  +
					  " where " + m05bConstantes.COL_34_FKMACT + " IS NOT NULL ";
			
			// KILOMETRAJES
			sqlUnion = sqlAsigKmSal + " \n UNION \n" + sqlAsigKmLleg + " \n UNION \n" + sqlGastos + 
					   " \n UNION \n" + sqlOperBancos + " \n UNION \n" + sqlOrdEnt + " \n UNION \n" + sqlOrdSal +
					   " \n UNION \n" + sqlRevi + " \n UNION \n" + sqlVehi;

			sql = "select B." + m05bConstantes.COL_97_MATRICULA  + ", B." + m05bConstantes.COL_97_DIAS +
			   	  ", TO_CHAR(A.FECHA,'yyyymmdd')" + ", B." + m05bConstantes.COL_97_RANGO  +
			      ", A.KM, TO_CHAR(B." + m05bConstantes.COL_97_FDESDE + ",'yyyymmdd')" +
				  ", TO_CHAR(B." + m05bConstantes.COL_97_FHASTA + ",'yyyymmdd')" +
				  " from (" + sqlUnion + ") A, " + m05bConstantes.TAB_CTK + " B" +
				  " where B." + m05bConstantes.COL_97_MATRICULA + " = A.MATRICULA " +
				  " and B." + m05bConstantes.COL_97_USUARIO + " = '" + persona + "'" +
				  " order by B." + m05bConstantes.COL_97_MATRICULA +
				  ", TO_CHAR(B." + m05bConstantes.COL_97_FDESDE +
				  ",'yyyymmdd'), B." + m05bConstantes.COL_97_RANGO + // 01-06-06; Pedido por Pedro
				  ",  TO_CHAR(A.FECHA,'yyyymmdd'),A.KM asc";
				
			//miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "SQL Kilometrajes CTK - SQL: \n         " + sql, m05bConstantes.LOG_NIVEL_BAJO);
	
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			
			while (rs.next())
			{
				bHayKM= true;
				// Recoger valores del rs
				matricula = rs.getString(1);
				//if (matricula.equals("6994 FFG"))
					//bHayKM= true;

				try
				{
					dias = (rs.getString(2)==null)?new Double("0.0").doubleValue():rs.getDouble(2);
				}
				catch(Exception e)
				{
					miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "Error para el vehculo "+ matricula + " con dias INCORRECTOS. Mirar en BD (Posiblemente una coma)", m05bConstantes.LOG_NIVEL_BAJO);
					miLog.addTraza(e);
					String diasString = rs.getString(2);
					if(diasString.indexOf(",")!=-1)
					{
						diasString = diasString.replaceAll(",","");
						dias=new Double(diasString).doubleValue();
					}
				}
				
				fUnion = rs.getString(3);
				rango = rs.getString(4);					 
				
				try
				{
					km=(rs.getString(5)==null)?new Double("0.0").doubleValue():rs.getDouble(5);
				}
				catch(Exception e)
				{
					miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"Error para el vehculo "+ matricula + " con km INCORRECTOS. Mirar en BD (Posiblemente una coma)", m05bConstantes.LOG_NIVEL_BAJO);
					miLog.addTraza(e);
					String kmString = rs.getString(5);
					if(kmString.indexOf(",")!=-1)
					{
						kmString = kmString.replaceAll(",","");
						km = new Double(kmString).doubleValue();
					}
				}
				
				fIni = rs.getString(6);
				fFin = rs.getString(7);
				
				// Meter informacion al objeto cuando cambie de matrcula y rango
				// se mete lo del anterior
				
				if ((!(matricula.equals(matriculaAnt)) || !(rango.equals(rangoAnt)))
					&& !(matriculaAnt.equals("")) && !(rangoAnt.equals("")))
				{
					cargarObjeto(matriculaAnt, fIniAnt, fIniAct, fFinAct, kmIni, kmFin, kmRecor, dias);
				}

				// Calcular valores
				if (!(matricula.equals(matriculaAnt)) || !(rango.equals(rangoAnt)))
				{
					// Cambia la matrcula
					diasDifIniMin = 10000;
					diasDifFinMin = 10000;
					kmIni=0; kmFin=0; kmRecor=0;
				}
				
				difFechaIni = miComun.getDiasEntreFechas(fIni, fUnion);

				if (difFechaIni < 0)
					difFechaIni = difFechaIni*(-1);
					
				//miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, " --- FFIN: " + fFin + " - FUNION:  " + fUnion, m05bConstantes.LOG_NIVEL_BAJO);
				difFechaFin = miComun.getDiasEntreFechas(fFin, fUnion);
					   
				if (difFechaFin < 0)
					difFechaFin = difFechaFin*(-1);
				
				if (difFechaIni == diasDifIniMin)
				{
					if (km <= kmIni)
					{
						kmIni=km;
					}
				}
					   
				if (difFechaIni < diasDifIniMin)
				{
					//miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, " ---DIF INI: " + difFechaIni + " - " + diasDifIniMin, m05bConstantes.LOG_NIVEL_BAJO);
					diasDifIniMin=difFechaIni;
					fIniAct=fUnion;
					kmIni=km;
					//miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "    INICIO: " + fIniAct + " - " + kmIni, m05bConstantes.LOG_NIVEL_BAJO);
				}
			 
				if (difFechaFin <= diasDifFinMin)
				{
					//miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "    DIF FIN: " + difFechaFin + " - " + diasDifFinMin, m05bConstantes.LOG_NIVEL_BAJO);
					diasDifFinMin=difFechaFin;
					fFinAct=fUnion;
					kmFin=km;
					//miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "    FIN: " + fFinAct + " - " + kmFin, m05bConstantes.LOG_NIVEL_BAJO);
				}
					   
				kmRecor = kmFin - kmIni;
					 
				// Guardar el valor para ver si cambia
				matriculaAnt = matricula;
				rangoAnt = rango;
				fIniAnt = fIni;

			} // Fin bucle while
				
			if (bHayKM)
			{
				// Meter ltimo elemento al objeto
				cargarObjeto(matriculaAnt, fIni, fIniAct, fFinAct, kmIni, kmFin, kmRecor,dias);
					
				// Recorrer array y grabar en BD
				Iterator iter = miArrayKm.iterator();
				miObjKM = null;
				
		        while(iter.hasNext())
		        {
		        	miObjKM = (m05bKmCTK) iter.next();
				    //miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"---KM-matricula: " + miObjKM.getKmCTK_matricula(), m05bConstantes.LOG_NIVEL_BAJO);
		        	//miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"---KM-fecha: " + miObjKM.getKmCTK_fIniAct(), m05bConstantes.LOG_NIVEL_BAJO);
				    //miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"---KM-km: " + miObjKM.getKmCTK_kmIni(), m05bConstantes.LOG_NIVEL_BAJO);
					dias = (double)miComun.getDiasEntreFechas(miObjKM.getKmCTK_fIniAct(), miObjKM.getKmCTK_fFinAct());
					kmRecor = miObjKM.getKmCTK_kmRecorridos();

							   
					// Actualizar tabla temporal de calculo de CTK con kilometrajes
					sql = "update " + m05bConstantes.TAB_CTK +
						  " set " + m05bConstantes.COL_97_FINIKM + "= to_date(" + miObjKM.getKmCTK_fIniAct() + ",'yyyymmdd')" +
						  " , " + m05bConstantes.COL_97_FFINKM + "= to_date(" + miObjKM.getKmCTK_fFinAct() + ",'yyyymmdd')" +
						  " , " + m05bConstantes.COL_97_INIKM + "= " + miObjKM.getKmCTK_kmIni() +
						  " , " + m05bConstantes.COL_97_FINKM + "= " + miObjKM.getKmCTK_kmFin() +
						  " , " + m05bConstantes.COL_97_KMRECORRIDOS + "= " + kmRecor +
						  " , " + m05bConstantes.COL_97_DIASKM + "= " + dias +
						  " , " + m05bConstantes.COL_97_MEDIAKM + "= " + miObjKM.getKmCTK_kmMedia() +
						  " where " + m05bConstantes.COL_97_MATRICULA + " = '" + miObjKM.getKmCTK_matricula() + "'" +
						  " and " + m05bConstantes.COL_97_USUARIO + " = '" + persona + "'" +
						  " and to_char(" + m05bConstantes.COL_97_FDESDE + ",'yyyymmdd') = '" + miObjKM.getKmCTK_fDesde() + "'";

					pstmtInsert = conn.prepareStatement(sql);

					//if (matricula.equals("BI-1070-CP")){
						//   miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"sql"+ sql, m05bConstantes.LOG_NIVEL_BAJO);					   					   
			            //  miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"fIniAct"+ fIniAct, m05bConstantes.LOG_NIVEL_BAJO);		
					//}										   
					
					//miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"Update-97 KM: " + sql, m05bConstantes.LOG_NIVEL_BAJO);
					pstmtInsert.executeUpdate();
					pstmtInsert.close();
		        } // Fin de bucle while
			}  // Fin if bHayKM
		}
		catch (Exception ex1)
		{
			miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"EXCEPTION: SET KM: " + ex1 + "\n" + matricula + " KM INI: " +  miObjKM.getKmCTK_kmIni() + " KM FIN: " + miObjKM.getKmCTK_kmFin(), m05bConstantes.LOG_NIVEL_BAJO);
			miLog.addTraza(ex1);
			throw new Exception(ex1);
		}
		finally
		{
			try
			{
				if (rs != null)
					rs.close();
				if (pstmt != null)
					pstmt.close();
				if (pstmtInsert != null)
					pstmtInsert.close();
		 	}
			catch (Exception ex2)
		 	{
				miLog.addTraza(ex2);;
			}
		}
	}  // Fin funcin setKm

     public void setCombustible (String persona) throws javax.servlet.ServletException, java.lang.Exception {

		PreparedStatement pstmt = null, pstmtInsert = null;
		ResultSet rs = null;
		String sql="", rango ="", inicioRango="";

		try{
			// Obtener consumo de combustible
			sql = "select b. " + m05bConstantes.COL_97_MATRICULA + ", sum(c.importe), to_char(b. " + m05bConstantes.COL_97_FDESDE + ",'yyyymmdd')" +
				  " from (" + 
							"select " + m05bConstantes.COL_18_MATRICULA + " as matricula, " + 
										m05bConstantes.COL_18_FECHA  + " as fecha, " + 
										m05bConstantes.COL_18_IMPORTE  + " as importe " +
							" from " + m05bConstantes.TAB_OPEBANCOS   + 
							" where " + m05bConstantes.COL_18_TIPO + " = '" + m05bConstantes.CPTO_COMBUSTIBLE + "'" +
							") c, " +
				  //" UNION " +
				  //    " select " + m05bConstantes.COL_09_MATRICULA + " as matricula, " +
				  //				m05bConstantes.COL_09_FECHA + " as fecha, " +
				  //				m05bConstantes.COL_09_IMPORTE + " as importe " +
				  //	   " from " + m05bConstantes.TAB_GASTOS + 
				  //		" where " + m05bConstantes.COL_09_CODCPTO + "= '" + m05bConstantes.CPTO_COMBUSTIBLE + "') c, " + 
				  m05bConstantes.TAB_CTK + " b " +
				  " where b." + m05bConstantes.COL_97_MATRICULA + "= c.matricula " +
				  //" and c.importe >0 " +
				  " and " +  m05bConstantes.COL_97_USUARIO + " = '" + persona + "'" +
				  //" and to_char(c.fecha,'yyyymmdd') between 	'" + DesdeCTK + "' and '" + HastaCTK + "' " + 
				  " and to_date(to_char(c.fecha,'dd/mm/yyyy'),'dd/mm/yyyy') between 	" + m05bConstantes.COL_97_FDESDE + " and " + m05bConstantes.COL_97_FHASTA + // 01-06-06; Pedido por Pedro
				  " group by b."+m05bConstantes.COL_97_MATRICULA+", b."+m05bConstantes.COL_97_FDESDE;
			
			//miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"cargarTablaTMP combustible: \n         " + sql, m05bConstantes.LOG_NIVEL_BAJO);
			
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			
			while ( rs.next() ) {
				matricula = rs.getString(1);
			  	combustible = rs.getDouble(2);
				inicioRango = rs.getString(3);
			    
				//miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"COMBUSTIBLE: " + combustible, m05bConstantes.LOG_NIVEL_BAJO);
				
				// Actualizar tabla temporal de calculo de CTK con combustible
				sql = "update " + m05bConstantes.TAB_CTK +
					    " set " + m05bConstantes.COL_97_COMBUSTIBLE + "= " + combustible +
						" where " + m05bConstantes.COL_97_MATRICULA + " = '" + matricula + "'" +
						" and " + m05bConstantes.COL_97_USUARIO + " = '" + persona + "'" +
						" and to_char(" + m05bConstantes.COL_97_FDESDE + ",'yyyymmdd') = '" + inicioRango + "'";
				pstmtInsert = conn.prepareStatement(sql);
			    //miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"Update-97: " + sql, m05bConstantes.LOG_NIVEL_BAJO);
				pstmtInsert.executeUpdate();
				pstmtInsert.close();
			}  
 		} catch (Exception ex1) {
 			miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"EXCEPTION: SET COMBUSTIBLE:  " + ex1 + "\n" + matricula + " COMBUSTIBLE: " +  combustible + "  KM FIN: " +  miObjKM.getKmCTK_kmFin(), m05bConstantes.LOG_NIVEL_BAJO);
 			miLog.addTraza(ex1);
			throw new Exception(ex1);
		} finally {
			try{
				if (rs != null)
					rs.close();
				if (pstmt != null)
					pstmt.close();
				if (pstmtInsert != null)
					pstmtInsert.close();
	 		} catch (Exception ex2) {
	 			miLog.addTraza(ex2);
			}
		}
	}  // Fin funcin setCombustible  

     private void setGastosTaller (String matricula, String finiciorang, String ffinrang) throws javax.servlet.ServletException, java.lang.Exception {
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql="";

		try{
			//if (matricula.equals("VI-7320-U"))
				//System.out.println("BEGO");
			 
			// Calcular Gastos Taller
			sql = "select " + m05bConstantes.COL_20_IMPORTE + ", " + m05bConstantes.COL_20_CODTALLER +
			      " from " + m05bConstantes.TAB_ORDENESTRAB  +
		      	  " where " + m05bConstantes.COL_20_MATRICULA + "(+) = '" + matricula + "'";
			
			if (!(matricula.equals(matriculaAntOrd))){
				sql = sql + " and to_char(" + m05bConstantes.COL_20_FENTRADA + "(+),'yyyymmdd') >= " + finiciorang;
				ffinrangAntOrd = finiciorang;
			 }else{
				 sql=sql+	" and to_char(" + m05bConstantes.COL_20_FENTRADA + "(+),'yyyymmdd') > " + finiciorang;
			 }
				
			sql = sql + " and to_char(" + m05bConstantes.COL_20_FENTRADA + "(+),'yyyymmdd') <= " + ffinrang +
						" order by " + m05bConstantes.COL_20_MATRICULA + ", " + m05bConstantes.COL_20_FSALIDA;

			//miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "Gastos Taller: \n         " + sql,m05bConstantes.LOG_NIVEL_BAJO);
			
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			
			while ( rs.next() ){
				taller = rs.getString(2);
				if (taller.equals(m05bConstantes.OT_TALLER_PROPIO)) {
					++intervTP;
					gastosTP = gastosTP + rs.getDouble(1);
					//miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "Taller Propio: \n         " + intervTP,m05bConstantes.LOG_NIVEL_BAJO);
				} else {
					++intervTE;
					gastosTE = gastosTE + rs.getDouble(1);
					//miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "Taller Externo: \n         " + intervTE,m05bConstantes.LOG_NIVEL_BAJO);
				} 
			}
			
			matriculaAntOrd = matricula;
			ffinrangAntOrd = ffinrang;
			
 		} catch (Exception ex1) {
 			miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"EXCEPTION: SET GASTOS TALLER  " + ex1, m05bConstantes.LOG_NIVEL_BAJO);
			miLog.addTraza(ex1);
			throw new Exception(ex1);
		} finally {
			try{
				if (rs != null)
					rs.close();
				if (pstmt != null)
					pstmt.close();
	 		} catch (Exception ex2) {
				miLog.addTraza(ex2);
			}
		}
	}  // Fin funcin setGastosTaller 
     
    public boolean existeTransferencia (String matricula, String fdesde, String fhasta, String HastaCTK)
    {
    	 boolean exTransferencia = false;
    	 PreparedStatement pstmt = null;
    	 ResultSet rs = null;
    	 String sql = "";

    	 try
    	 {
			sql = " SELECT 1 FROM " + m05bConstantes.TAB_TRANSFERENCIAS +
				  "          WHERE " + m05bConstantes.COL_40_MATRICULA + " = '" + matricula + "'" +
				  "          AND to_char(" + m05bConstantes.COL_40_FDESDE + ",'yyyy-mm-dd hh:mi:ss') >= '" + fhasta + "'" +
				  "          AND to_char("   + m05bConstantes.COL_40_FDESDE + ",'yyyymmdd') <= '" + HastaCTK + "'" +
				  "          AND to_char("   + m05bConstantes.COL_40_FDESDE + ",'yyyy-mm-dd hh:mi:ss') <> '" + fdesde + "'";
		    //miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"ExisteTransferencia: " + sql,m05bConstantes.LOG_NIVEL_BAJO);
			
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			if (rs.next())
				exTransferencia = true;
			
 		}
    	catch (Exception ex1)
 		{
		    miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"EXCEPTION: EXISTE TRANSFERENCIA  " + ex1 + "\n" + matricula + "   DESDE: " + fdesde, m05bConstantes.LOG_NIVEL_BAJO);
			miLog.addTraza(ex1);
		}
    	finally
		{
			try
			{
				if (rs != null)
					rs.close();
				if (pstmt != null)
					pstmt.close();
	 		}
			catch (Exception ex2)
			{
				miLog.addTraza(ex2);
			}
		}

    	return exTransferencia;
    }  // Fin funcion existeTransferencia

    public int[] getTotalRango (String persona) throws javax.servlet.ServletException, java.lang.Exception
    {
		java.sql.Connection conn2 = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "", grupo = "";
		int[] totalRango = new int[6];

		try
		{
			conn2 = miConex.getConnection();
			
			// No se tratan los rangos D2 ni X
			sql = "select " + m05bConstantes.COL_97_GRUPO + 
				  " from " + m05bConstantes.TAB_CTK +
				  " where " +  m05bConstantes.COL_97_TOTAL + " = 'S'" +
				  " and " +  m05bConstantes.COL_97_USUARIO + " = '" + persona + "'";

			//miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"getTotalRango CTK: \n         " + sql);

			totalRango[0]=0;totalRango[1]=0;totalRango[2]=0;totalRango[3]=0;totalRango[4]=0;totalRango[5]=0;
			
			pstmt = conn2.prepareStatement(sql);
			rs = pstmt.executeQuery();
			
			while (rs.next())
			{
				// N Total de vehculos por rango
				grupo = rs.getString(1);
				if (grupo!=null && grupo.equals(m05bConstantes.GRUPO_CTK_A)) 		// A,AE,CA
					totalRango[0] = ++totalRango[0];
			    else if (grupo!=null && grupo.equals(m05bConstantes.GRUPO_CTK_B))  // B1,B2
					totalRango[1] = ++totalRango[1];
		        else if (grupo!=null && grupo.equals(m05bConstantes.GRUPO_CTK_C))  // C,CB,CV
					totalRango[2] = ++totalRango[2];
		        else if (grupo!=null && grupo.equals(m05bConstantes.GRUPO_CTK_D))  // D1,D2
					totalRango[3] = ++totalRango[3];
				else if (grupo!=null && grupo.equals(m05bConstantes.GRUPO_CTK_RA)) // AR
					totalRango[4] = ++totalRango[4];
				else if (grupo!=null && grupo.equals(m05bConstantes.GRUPO_CTK_RB)) //VR,BR
					totalRango[5] = ++totalRango[5];
			}
 		}
		catch (Exception ex1)
		{
 			miLog.addTraza(ex1);
 			throw new Exception(ex1);
		}
		finally
		{
			try
			{
				if (rs != null)
					rs.close();
				if (pstmt != null)
					pstmt.close();
				if (conn2 != null)
					conn2.close();
	 		}
			catch (Exception ex2)
	 		{
	 			miLog.addTraza(ex2);
			}
		}
		
		return totalRango;
	}  // Fin funcin getTotalRango
    public double[] getMediaRango (String persona) throws javax.servlet.ServletException, java.lang.Exception
    {
		java.sql.Connection conn2 = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "", grupo = "";
		double[] doubleMediaRango = new double[6];

		try{
			conn2 = miConex.getConnection();
			
			// No se tratan los rangos D2 ni X
			sql = "select sum(" + m05bConstantes.COL_97_PORCENT + "), " + m05bConstantes.COL_97_GRUPO +
				  " from " + m05bConstantes.TAB_CTK +
				  " where " +  m05bConstantes.COL_97_USUARIO + " = '" + persona + "'" +
				  " group by " + m05bConstantes.COL_97_GRUPO;
		    //miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"getdoubleMediaRango CTK: \n         " + sql);
			
			doubleMediaRango[0]=0;doubleMediaRango[1]=0;doubleMediaRango[2]=0;doubleMediaRango[3]=0;doubleMediaRango[4]=0;doubleMediaRango[5]=0;
			
			pstmt = conn2.prepareStatement(sql);
			rs = pstmt.executeQuery();
			
			while (rs.next())
			{
				// N Medio de vehculos por rango
				grupo = rs.getString(2);
				if (grupo!=null && grupo.equals(m05bConstantes.GRUPO_CTK_A)) 	   // A,AE,CA
					doubleMediaRango[0] = rs.getDouble(1);
			    else if (grupo!=null && grupo.equals(m05bConstantes.GRUPO_CTK_B))  // B1,B2
					doubleMediaRango[1] = rs.getDouble(1);
				else if (grupo!=null && grupo.equals(m05bConstantes.GRUPO_CTK_C))  // C,CB,CV
					doubleMediaRango[2] = rs.getDouble(1);
				else if (grupo!=null && grupo.equals(m05bConstantes.GRUPO_CTK_D))  // D1,D2
					doubleMediaRango[3] = rs.getDouble(1);
				else if (grupo!=null && grupo.equals(m05bConstantes.GRUPO_CTK_RA)) // AR
					doubleMediaRango[4] = rs.getDouble(1);
				else if (grupo!=null && grupo.equals(m05bConstantes.GRUPO_CTK_RB)) //BR,VR
					doubleMediaRango[5] = rs.getDouble(1);
			}  // Fin while
 		}
		catch (Exception ex1)
		{
		    miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "EXCEPTION: GET MEDIA RANGO:  " + ex1, m05bConstantes.LOG_NIVEL_BAJO);
			miLog.addTraza(ex1);
			throw new Exception(ex1);
		}
		finally
		{
			try
			{
				if (rs != null)
					rs.close();
				if (pstmt != null)
					pstmt.close();
				if (conn2 != null)
					conn2.close();
	 		}
			catch (Exception ex2)
	 		{
				miLog.addTraza(ex2);
			}
		}
		
		return doubleMediaRango;
	}  // Fin funcin getMediaRango
    public int[] getKmRango (String persona)throws javax.servlet.ServletException, java.lang.Exception
    {
    	java.sql.Connection conn2 = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql="", grupo ="";
		int[] kmRango = new int[6];

		try
		{
			conn2 = miConex.getConnection();
			// No se tratan los rangos D2 ni X
			sql = "select sum(" + m05bConstantes.COL_97_KMRECORRIDOS + "), " + m05bConstantes.COL_97_GRUPO +
			      " from " + m05bConstantes.TAB_CTK +
				  " where " +  m05bConstantes.COL_97_USUARIO + " = '" + persona + "'" +
				  " and " + m05bConstantes.COL_97_KMRECORRIDOS + " <> 0 " +
				  " group by " + m05bConstantes.COL_97_GRUPO;
			//miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"getKMRango CTK:          " + sql, m05bConstantes.LOG_NIVEL_BAJO);

			kmRango[0] = 0; kmRango[1] = 0; kmRango[2] = 0; kmRango[3] = 0; kmRango[4] = 0; kmRango[5] = 0;

			pstmt = conn2.prepareStatement(sql);
			rs = pstmt.executeQuery();
			while (rs.next())
			{
				// Kilometraje de vehculos por rango
				grupo = rs.getString(2);

				if (grupo!=null && grupo.equals(m05bConstantes.GRUPO_CTK_A)) 		// A,AE,CA
					kmRango[0] = rs.getInt(1);
			    else if (grupo!=null && grupo.equals(m05bConstantes.GRUPO_CTK_B))   // B1,B2
					kmRango[1] = rs.getInt(1);
		        else if (grupo!=null && grupo.equals(m05bConstantes.GRUPO_CTK_C))   // C,CB,CV
					kmRango[2] = rs.getInt(1);
		        else if (grupo!=null && grupo.equals(m05bConstantes.GRUPO_CTK_D))   // D1,D2
					kmRango[3] = rs.getInt(1);
				else if (grupo!=null && grupo.equals(m05bConstantes.GRUPO_CTK_RA))  // AR
					kmRango[4] = rs.getInt(1);
				else if (grupo!=null && grupo.equals(m05bConstantes.GRUPO_CTK_RB))  //VR.BR
					kmRango[5] = rs.getInt(1);
			}
 		}
		catch (Exception ex1)
 		{
		    miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "EXCEPTION: GET KM RANGO:  " + ex1, m05bConstantes.LOG_NIVEL_BAJO);
			miLog.addTraza(ex1);
			throw new Exception(ex1);
		}
		finally
		{
			try
			{
				if (rs != null)
					rs.close();
				if (pstmt != null)
					pstmt.close();
				if (conn2 != null)
					conn2.close();
	 		}
			catch (Exception ex2)
	 		{
				miLog.addTraza(ex2);
			}
		}
		return kmRango;
	}  // Fin funcin getKmRango
    public double[] getAmortRango (String persona)throws javax.servlet.ServletException, java.lang.Exception
    {
    	java.sql.Connection conn2 = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "", grupo = "";
		double[] dAmortRango = new double[6];

		try
		{
			conn2 = miConex.getConnection();
			
			// No se tratan los rangos D2 ni X
            sql = "select sum(" + m05bConstantes.COL_97_AMORTIZACION + "), " + m05bConstantes.COL_97_GRUPO +
			      " from " + m05bConstantes.TAB_CTK +
				  " where " +  m05bConstantes.COL_97_USUARIO + " = '" + persona + "'" +
				  " group by " + m05bConstantes.COL_97_GRUPO;
			//miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"getAmortRango CTK: \n         " + sql, m05bConstantes.LOG_NIVEL_BAJO);
			dAmortRango[0] = 0; dAmortRango[1] = 0; dAmortRango[2] = 0; dAmortRango[3] = 0; dAmortRango[4] = 0; dAmortRango[5] = 0;
			pstmt = conn2.prepareStatement(sql);
			rs = pstmt.executeQuery();
			while (rs.next())
			{
				// N Medio de vehculos por rango
				grupo = rs.getString(2);
				if (grupo!=null && grupo.equals(m05bConstantes.GRUPO_CTK_A)) 		// A,AE,CA
					dAmortRango[0]=rs.getDouble(1);
			    else if (grupo!=null && grupo.equals(m05bConstantes.GRUPO_CTK_B))	// B1,B2
					dAmortRango[1]=rs.getDouble(1);
		        else if (grupo!=null && grupo.equals(m05bConstantes.GRUPO_CTK_C))	// C,CB,CV
					dAmortRango[2]=rs.getDouble(1);
		        else if (grupo!=null && grupo.equals(m05bConstantes.GRUPO_CTK_D)) 	// D1,D2
					dAmortRango[3]=rs.getDouble(1);
				else if (grupo!=null && grupo.equals(m05bConstantes.GRUPO_CTK_RA))	// AR
					dAmortRango[4]=rs.getDouble(1);
				else if (grupo!=null && grupo.equals(m05bConstantes.GRUPO_CTK_RB))  //VR,BR
					dAmortRango[5]=rs.getDouble(1);
			}  // Fin while
 		}
		catch (Exception ex1)
		{
		    miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "EXCEPTION: GET AMORT RANGO: " + ex1, m05bConstantes.LOG_NIVEL_BAJO);
			miLog.addTraza(ex1);
			throw new Exception(ex1);
		}
		finally
		{
			try
			{
				if (rs != null)
					rs.close();
				if (pstmt != null)
					pstmt.close();
				if (conn2 != null)
					conn2.close();
	 		}
			catch (Exception ex2)
			{
				miLog.addTraza(ex2);
			}
		}
		
		return dAmortRango;
	}  // Fin funcin getAmortRango	
    public double[] getCombusRango (String persona) throws javax.servlet.ServletException, java.lang.Exception
    {
		java.sql.Connection conn2 = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "", grupo = "";
		double[] combustible = new double[6];
		double combus=0;

		try
		{
			conn2 = miConex.getConnection();
			
			// No se tratan los rangos D2 ni X
            sql = "select sum(" + m05bConstantes.COL_97_COMBUSTIBLE + "), " + m05bConstantes.COL_97_GRUPO +
		          " from " + m05bConstantes.TAB_CTK +
				  " where " +  m05bConstantes.COL_97_USUARIO + " = '" + persona + "'" +
				  " group by " + m05bConstantes.COL_97_GRUPO;
            //miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"getCombusRango CTK: \n         " + sql);
				
			combustible[0] = 0; combustible[1] = 0; combustible[2] = 0; combustible[3] = 0; combustible[4] = 0; combustible[5] = 0;
			
			pstmt = conn2.prepareStatement(sql);
			rs = pstmt.executeQuery();
			while (rs.next())
			{
				// N Total de vehculos por rango
				combus = rs.getDouble(1);
				grupo = rs.getString(2);
			    if ( grupo!=null && grupo.equals(m05bConstantes.GRUPO_CTK_A))		// A,AE,CA
					combustible[0] = combus;
			    else if ( grupo!=null && grupo.equals(m05bConstantes.GRUPO_CTK_B))  // B1,B2
					combustible[1] = combus;
		        else if ( grupo!=null && grupo.equals(m05bConstantes.GRUPO_CTK_C))  // C,CB,CV
					combustible[2] = combus;
		        else if ( grupo!=null && grupo.equals(m05bConstantes.GRUPO_CTK_D))  // D1,D2
					combustible[3] = combus;
				else if ( grupo!=null && grupo.equals(m05bConstantes.GRUPO_CTK_RA)) // AR
					combustible[4] = combus;
				else if ( grupo!=null && grupo.equals(m05bConstantes.GRUPO_CTK_RB)) //VR,BR
					combustible[5] = combus;
			}
 		}
		catch (Exception ex1)
		{
		    miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "EXCEPTION: GET COMBUS RANGO: " + ex1, m05bConstantes.LOG_NIVEL_BAJO);
			miLog.addTraza(ex1);
			throw new Exception(ex1);
		}
		finally
		{
			try
			{
				if (rs != null)
					rs.close();
				if (pstmt != null)
					pstmt.close();
				if (conn2 != null)
					conn2.close();
	 		}
			catch (Exception ex2)
	 		{
				miLog.addTraza(ex2);
			}
		}
		
		return combustible;
	}  // Fin funcin getCombusRango
    public int[] getIntervRango (String persona) throws javax.servlet.ServletException, java.lang.Exception
    {
		java.sql.Connection conn2 = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "", grupo = "";
		int[] intervTPRango = new int[6];
		int interv = 0;

		try
		{
			conn2 = miConex.getConnection();
			
			// No se tratan los rangos D2 ni X
			sql = "select sum(" + m05bConstantes.COL_97_INTERV_TP + "), " + m05bConstantes.COL_97_GRUPO + 
				  " from " + m05bConstantes.TAB_CTK +
				  " where " +  m05bConstantes.COL_97_USUARIO + " = '" + persona + "'" +
				  " group by " + m05bConstantes.COL_97_GRUPO;
			//miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"getIntervTPRango CTK: \n         " + sql);
				
			intervTPRango[0]=0;intervTPRango[1]=0;intervTPRango[2]=0;intervTPRango[3]=0;intervTPRango[4]=0;
			
			pstmt = conn2.prepareStatement(sql);
			rs = pstmt.executeQuery();
			
			while (rs.next())
			{
				// N Total de vehculos por rango
				interv = rs.getInt(1);
				grupo = rs.getString(2);
				if (grupo!=null && grupo.equals(m05bConstantes.GRUPO_CTK_A))  	   // A,AE,CA
					intervTPRango[0] = interv;
			    else if (grupo!=null && grupo.equals(m05bConstantes.GRUPO_CTK_B))  // B1,B2
					intervTPRango[1] = interv;
		        else if (grupo!=null && grupo.equals(m05bConstantes.GRUPO_CTK_C))  // C,CB,CV
					intervTPRango[2] = interv;
		        else if (grupo!=null && grupo.equals(m05bConstantes.GRUPO_CTK_D))  // D1,D2
					intervTPRango[3] = interv;
				else if (grupo!=null && grupo.equals(m05bConstantes.GRUPO_CTK_RA)) // AR
					intervTPRango[4] = interv;
				else if (grupo!=null && grupo.equals(m05bConstantes.GRUPO_CTK_RB)) // VR,BR
					intervTPRango[5] = interv;
			}
 		}
		catch (Exception ex1)
		{
		    miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "EXCEPTION: GET INTERV RANGO:  " + ex1, m05bConstantes.LOG_NIVEL_BAJO);
			miLog.addTraza(ex1);
			throw new Exception(ex1);
		}
		finally
		{
			try
			{
				if (rs != null)
					rs.close();
				if (pstmt != null)
					pstmt.close();
				if (conn2 != null)
					conn2.close();
	 		}
			catch (Exception ex2)
	 		{
				miLog.addTraza(ex2);
			}
		}
		return intervTPRango;
	}  // Fin funcin getIntervRango
    public double[] getGastosTP (String persona) throws javax.servlet.ServletException, java.lang.Exception
    {
		java.sql.Connection conn2 = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "", grupo = "";
		double[] gastosTPRango = new double[6];
		double gastos = 0;

		try
		{
			conn2 = miConex.getConnection();
			
			// No se tratan los rangos D2 ni X
			sql = "select sum(" + m05bConstantes.COL_97_GASTOS_TP + "), " + m05bConstantes.COL_97_GRUPO + 
				  " from " + m05bConstantes.TAB_CTK +
				  " where " +  m05bConstantes.COL_97_USUARIO + " = '" + persona + "'" +
				  " group by " + m05bConstantes.COL_97_GRUPO;
			//miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"getGastosTPRango CTK: \n         " + sql);
				
			gastosTPRango[0]=0;gastosTPRango[1]=0;gastosTPRango[2]=0;gastosTPRango[3]=0;gastosTPRango[4]=0;
			
			pstmt = conn2.prepareStatement(sql);
			rs = pstmt.executeQuery();
			
			while (rs.next())
			{
				// N Total de vehculos por rango
				gastos = rs.getDouble(1);
				grupo = rs.getString(2);
				if (grupo!=null && grupo.equals(m05bConstantes.GRUPO_CTK_A)) 	   // A,AE,CA
					gastosTPRango[0] = gastos;
			    else if (grupo!=null && grupo.equals(m05bConstantes.GRUPO_CTK_B))  // B1,B2
					gastosTPRango[1] = gastos;
		        else if (grupo!=null && grupo.equals(m05bConstantes.GRUPO_CTK_C))  // C,CB,CV
					gastosTPRango[2] = gastos;
		        else if (grupo!=null && grupo.equals(m05bConstantes.GRUPO_CTK_D))  // D1,D2
					gastosTPRango[3] = gastos;
				else if (grupo!=null && grupo.equals(m05bConstantes.GRUPO_CTK_RA)) // AR
					gastosTPRango[4] = gastos;
				else if (grupo!=null && grupo.equals(m05bConstantes.GRUPO_CTK_RB)) //VR,BR
					gastosTPRango[5] = gastos;
			}
 		}
		catch (Exception ex1)
		{
		    miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "EXCEPTION: GET GASTOS TP RANGO:  " + ex1, m05bConstantes.LOG_NIVEL_BAJO);
			miLog.addTraza(ex1);
			throw new Exception(ex1);
		}
		finally
		{
			try
			{
				if (rs != null)
					rs.close();
				if (pstmt != null)
					pstmt.close();
				if (conn2 != null)
					conn2.close();
	 		}
			catch (Exception ex2)
	 		{
				miLog.addTraza(ex2);
			}
		}
		
		return gastosTPRango;
	}  // Fin funcin getGastosTP
    public double[] getGastosTE (String persona)throws javax.servlet.ServletException, java.lang.Exception
    {
		java.sql.Connection conn2 = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "", grupo = "";
		double[] gastosTERango = new double[6];
		double gastos = 0;

		try
		{
			conn2 = miConex.getConnection();
			
			// No se tratan los rangos D2 ni X
		    sql = "select sum(" + m05bConstantes.COL_97_GASTOS_TE + "), " + m05bConstantes.COL_97_GRUPO +
			      " from " + m05bConstantes.TAB_CTK +
				  " where " +  m05bConstantes.COL_97_USUARIO + " = '" + persona + "'" +
				  " group by " + m05bConstantes.COL_97_GRUPO;
		    //miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"getGastosTERango CTK: \n         " + sql);
				
			gastosTERango[0] = 0; gastosTERango[1] = 0; gastosTERango[2] = 0; gastosTERango[3] = 0; gastosTERango[4] = 0;
			
			pstmt = conn2.prepareStatement(sql);
			rs = pstmt.executeQuery();
			while (rs.next())
			{
				// N Total de vehculos por rango
				gastos = rs.getDouble(1);
				grupo = rs.getString(2);
				if (grupo!=null && grupo.equals(m05bConstantes.GRUPO_CTK_A))		 // A,AE,CA
					gastosTERango[0] = gastos;
			    else if (grupo!=null && grupo.equals(m05bConstantes.GRUPO_CTK_B))  // B1,B2
					gastosTERango[1] = gastos;
		        else if (grupo!=null && grupo.equals(m05bConstantes.GRUPO_CTK_C))  // C,CB,CV
					gastosTERango[2] = gastos;
		        else if (grupo!=null && grupo.equals(m05bConstantes.GRUPO_CTK_D))  // D1,D2
					gastosTERango[3] = gastos;
				else if (grupo!=null && grupo.equals(m05bConstantes.GRUPO_CTK_RA)) // AR
					gastosTERango[4] = gastos;
				else if (grupo!=null && grupo.equals(m05bConstantes.GRUPO_CTK_RB)) //VR,BR
					gastosTERango[5] = gastos;
			}
 		}
		catch (Exception ex1)
		{
		    miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "EXCEPTION: GET GASTOS TE RANGO: " + ex1, m05bConstantes.LOG_NIVEL_BAJO);
			miLog.addTraza(ex1);
			throw new Exception(ex1);
		}
		finally
		{
			try
			{
				if (rs != null)
					rs.close();
				if (pstmt != null)
					pstmt.close();
				if (conn2 != null)
					conn2.close();
	 		}
			catch (Exception ex2)
	 		{
				miLog.addTraza(ex2);
			}
		}
		
		return gastosTERango;
	}  // Fin funcin getGastosTE

    public double[] getRenting (String persona, String desde, String hasta) throws javax.servlet.ServletException, java.lang.Exception
    {
 		java.sql.Connection conn2 = null;
 		PreparedStatement pstmt = null;
 		ResultSet rs = null;
 		String sql = "", grupo = "";
 		double[] rentingRango = new double[3];
 		double importe = 0;

 		try
 		{
 			conn2 = miConex.getConnection();
 			
			// No se tratan los rangos D2 ni X
			sql = "select sum(" + m05bConstantes.COL_41_IMPORTE + "), " + m05bConstantes.COL_97_GRUPO +
				  " from " + m05bConstantes.TAB_CUOTAS  + "," + m05bConstantes.TAB_CTK +
				  " where to_char(" +  m05bConstantes.COL_41_FECHA + ",'yyyymmdd') BETWEEN " + desde + " AND " + hasta +
				  " and " +  m05bConstantes.COL_41_IMPORTE + " > 0 AND " + m05bConstantes.COL_41_MATRICULA + " = " + m05bConstantes.COL_97_MATRICULA +
				  " and " + m05bConstantes.COL_97_USUARIO + " = '" + persona + "' " +
				  " group by " + m05bConstantes.COL_97_GRUPO;
			//miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"getGastosTERango CTK: \n         " + sql);
 				
 			rentingRango[0] = 0; rentingRango[1] = 0;
 			
 			pstmt = conn2.prepareStatement(sql);
 			rs = pstmt.executeQuery();
 			while (rs.next())
 			{
 				// N Total de vehculos por rango
 				importe = rs.getDouble(1);
 				grupo = rs.getString(2);
 				if (grupo!=null && grupo.equals(m05bConstantes.GRUPO_CTK_RA))        // AR
 					rentingRango[0] = importe;
 				else if (grupo!=null && grupo.equals(m05bConstantes.GRUPO_CTK_RB))   //VR,BR
 					rentingRango[1] = importe;
 			}
  		}
 		catch (Exception ex1)
  		{
		    miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "EXCEPTION: GET RENTING RANGO: " + ex1, m05bConstantes.LOG_NIVEL_BAJO);
			miLog.addTraza(ex1);
			throw new Exception(ex1);
		}
 		finally
 		{
			try
			{
				if (rs != null)
					rs.close();
				if (pstmt != null)
					pstmt.close();
				if (conn2 != null)
					conn2.close();
		 	}
			catch (Exception ex2)
			{
				miLog.addTraza(ex2);
			}
		}
 		
		return rentingRango;
 	} // Fin funcin getRenting
     
}  // Fin clase m05bCalcularCTK