package m05bClasses;

/**
 * Esta clase representa un conjunto de utilidades para el manejo de ficheros XML
 */
public class m05bCFicheroXML {

    public static void anadirCabecera(StringBuffer astrBuffer){
        astrBuffer.append("<cabecera>");
        astrBuffer.append('\n');
    }
    public static void cerrarCabecera(StringBuffer astrBuffer){
        astrBuffer.append("</cabecera>");
        astrBuffer.append('\n');
    }
    public static void anadirLinea(StringBuffer astrBuffer){
        astrBuffer.append("<linea>");
        astrBuffer.append('\n');
    }
    public static void cerrarLinea(StringBuffer astrBuffer){
        astrBuffer.append("</linea>");
        astrBuffer.append('\n');
    }
    public static void anadirLineas(StringBuffer astrBuffer){
        astrBuffer.append("<lineas>");
        astrBuffer.append('\n');
    }
    public static void cerrarLineas(StringBuffer astrBuffer){
        astrBuffer.append("</lineas>");
        astrBuffer.append('\n');
    }    
    public static void anadirGrupos(StringBuffer astrBuffer){
        astrBuffer.append("<grupos>");
        astrBuffer.append('\n');
    }
    public static void cerrarGrupos(StringBuffer astrBuffer){
        astrBuffer.append("</grupos>");
        astrBuffer.append('\n');
    }
    public static void anadirGrupo(StringBuffer astrBuffer){
        astrBuffer.append("<grupo>");
        astrBuffer.append('\n');
    }
    public static void cerrarGrupo(StringBuffer astrBuffer){
        astrBuffer.append("</grupo>");
        astrBuffer.append('\n');
    }

    public static void addColumn(StringBuffer astrBuffer, String astrIdColumna, String astrValor){       
        //astrValor=r76bCFormatoCadena.normalizaXML(astrValor);
        astrBuffer.append("<columna id="+'"'+astrIdColumna+'"'+">"+((astrValor==null||astrValor.equals("null"))?"":astrValor)+"</columna>");        
        astrBuffer.append('\n');
    }
   
    public static void addColumn(StringBuffer astrBuffer, String astrIdColumna, String astrValor, boolean abolGrabarVacia){       
        if (!abolGrabarVacia && (astrValor==null || astrValor.trim().equals("")))
            return;
        addColumn(astrBuffer, astrIdColumna, astrValor);
    }

    public static void anadirDatoCabecera(StringBuffer astrBuffer, String astrIdColumna, String astrEtiqueta, String astrValor){       
        astrBuffer.append("<dato id="+'"'+astrIdColumna+'"'+">");
        astrBuffer.append('\n');
        astrBuffer.append("<etiqueta>"+astrEtiqueta+"</etiqueta>");        
        astrBuffer.append('\n');
        //astrValor=r76bCFormatoCadena.normalizaXML(astrValor);
        astrBuffer.append("<valor>"+((astrValor==null||astrValor.equals("null"))?"":astrValor)+"</valor>");                
        astrBuffer.append('\n');
        astrBuffer.append("</dato>");
    }

    public static void anadirCriterio(StringBuffer astrBuffer, String astrIdCriterio, String astrEtiqueta, String astrValor){       
        astrBuffer.append("<criterio id="+'"'+astrIdCriterio+'"'+">");
        astrBuffer.append('\n');
        astrBuffer.append("<etiqueta>"+astrEtiqueta+"</etiqueta>");        
        astrBuffer.append('\n');
        //astrValor=r76bCFormatoCadena.normalizaXML(astrValor);
        astrBuffer.append("<valor>"+((astrValor==null||astrValor.equals("null"))?"":astrValor)+"</valor>");                
        astrBuffer.append('\n');
        astrBuffer.append("</criterio>");
    }
  
    public static void anadirFiltro(StringBuffer astrBuffer, String astrIdFiltro, String astrEtiqueta, String astrValor){       
        //astrBuffer.append("<filtro id="+'"'+astrIdFiltro+'"'+">");
        astrBuffer.append("<criterio id="+'"'+astrIdFiltro+'"'+">");
        astrBuffer.append('\n');
        astrBuffer.append("<etiqueta>"+astrEtiqueta+"</etiqueta>");        
        astrBuffer.append('\n');
        //astrValor=r76bCFormatoCadena.normalizaXML(astrValor);
        astrBuffer.append("<valor>"+((astrValor==null||astrValor.equals("null"))?"":astrValor)+"</valor>");                
        astrBuffer.append('\n');
        //astrBuffer.append("</filtro>");
        astrBuffer.append("</criterio>");
    }
    public static void anadirTexto(StringBuffer astrBuffer){
        astrBuffer.append("<Texto>");
        astrBuffer.append('\n');
    }
    public static void cerrarTexto(StringBuffer astrBuffer){
        astrBuffer.append("</Texto>");
        astrBuffer.append('\n');
    }    
}