package m05bClasses;

import java.io.PrintStream;

import org.apache.log4j.Logger;
/**
 * Esta clase une la consola al log4j, para que los errores los escriba en la consola
 * @author iaizpurl
 *
 */
public class StdOutErrLog {

	private static final Logger logger = Logger.getLogger(StdOutErrLog.class);

	public static void tieSystemOutAndErrToLog() {
	    System.setOut(createLoggingProxy(System.out));
	    System.setErr(createLoggingProxy(System.err));
	}

	public static PrintStream createLoggingProxy(final PrintStream realPrintStream) {
	    return new PrintStream(realPrintStream) {
	        public void print(final String string) {
	            logger.info(string);
	        }
	        public void println(final String string) {
	            logger.info(string);
	        }
	    };
	}
	}
