package m05bBD;

/**
 * This class holds information about an order, 
 * which is stored in the database table <tt>m0532t00</tt>. 
 * The table <tt>m0532t00_tasas</tt> is defined in the database as follows:
 * <pre>
CREATE TABLE M0532T00 ( 
  COD_TASA_32		NUMBER (6)    NOT NULL, 
  MATRIC_32		VARCHAR2 (20),
  CONCEPTO_32      	VARCHAR2 (4),
  MUNICIPIO_32     	VARCHAR2 (50), 
  OBSERV_32      	VARCHAR2 (200),
  FECHA_32      	DATE,
  IMPORTE_32      	NUMBER (6), 
  PRIMARY KEY ( COD_TASA_32 ));
 * </pre>
 * This class follows the convention of a JavaBean.
 *
 */
public class m05bTasas
    implements java.io.Serializable{

  private String tas_codigo    				= "0";
  private String tas_matricula        			= "";
  private String tas_concepto				= "";
  private String tas_municipio      			= "";
  private String tas_observacion   			= "";
  private String tas_fecha  			= "";
  private String tas_importe   				= "";



  
  public String getTas_codigo(){return tas_codigo;} 
  public void setTas_codigo(String n){tas_codigo = n;}
  
  public String getTas_matricula(){return tas_matricula;}  
  public void setTas_matricula(String n){tas_matricula = n;}
  
  public String getTas_concepto(){return tas_concepto;} 
  public void setTas_concepto(String n){tas_concepto = n;}
  
  public String getTas_municipio(){return tas_municipio;}  
  public void setTas_municipio(String n){tas_municipio = n;}

  public String getTas_observacion(){return tas_observacion;}
  public void setTas_observacion(String n){tas_observacion = n;}
  
  
  public String getTas_fecha(){return tas_fecha;}
  public void setTas_fecha(String n){tas_fecha = n;}

  public String getTas_importe(){return tas_importe;}  
  public void setTas_importe(String n){tas_importe = n;}


  
  public String toString(){
    String s = "";
    s += "[Codigo  = " + tas_codigo + "]";
    s += "[Matricula = " + tas_matricula + "]";
    s += "[Concepto = " + tas_concepto + "]";
    s += "[Municipio = " + tas_municipio + "]";
    s += "[Observacion = " + tas_observacion + "]";
    s += "[Fecha = " + tas_fecha + "]";
    s += "[Importe = " + tas_importe + "]";

    return s;
  }
 }