package m05bBD;

/**
 * This class holds information about an order, 
 * which is stored in the database table <tt>M05102T00</tt>. 
 * The table <tt>M05102T00</tt> is defined in the database as follows:
 * <pre>
CREATE TABLE M05102T00
(
  ID_SOLICITUD_102 		NUMBER(9, 0) NOT NULL,
  COD_VALIDADOR_102		VARCHAR2(12),
  FECHA_VALIDACION_102	DATE,
  ESTADO_102			VARCHAR2(3),
  MOTIVO_102			VARCHAR2(255),
  NOTAS_102				VARCHAR2(255),
  OBSERVACIONES_102		VARCHAR2(255),
  COD_DESTINO_102		VARCHAR2(2),
  DESTINO_OTROS_102		VARCHAR2(100),
  MAIL_ENVIADO_102		VARCHAR2(1),
  DNI_102				VARCHAR2(15),
  NOMBRE_APELLIDOS_102	VARCHAR2(100),
  ORIGEN_102			VARCHAR2(1),
  SITUACION_102			VARCHAR2(1),
  VALIDACION_POSTERIOR_102  VARCHAR2(1)
, CONSTRAINT M05102I01 PRIMARY KEY (ID_SOLICITUD_102, COD_VALIDADOR_102, ESTADO_102, SITUACION_102, FECHA_VALIDACION_102)
, CONSTRAINT fk100_102 FOREIGN KEY (ID_SOLICITUD_102) REFERENCES M05100T00(ID_SOLICITUD_100)
, CONSTRAINT fk104_102 FOREIGN KEY (COD_DESTINO_102) REFERENCES M05104T00(COD_DESTINO_104)
);
 * </pre>
 * This class follows the convention of a JavaBean.
 *
 */
public class m05bSolicitudReserva_Validacion implements java.io.Serializable {

	private Integer idSolicitud = new Integer(-1);
	private String codValidador = "";
	private String fechaValidacion = "";
	private String estado = "";
	private String motivo = "";
	private String notas = "";
	private String observaciones = "";
	private String codDestino = "";
	private String destinoOtros = "";
	private String mail_enviado = "";
	private String dni = "";
	private String nombre_apellidos = "";
	private String origen;
	private String situacion = "";
	private String validacionPosterior = "";


	public String getCodValidador() {
		return codValidador;
	}
	public void setCodValidador(String codValidador) {
		this.codValidador = codValidador;
	}

	public String getDni() {
		return dni;
	}
	public void setDni(String dni) {
		this.dni = dni;
	}

	public String getEstado() {
		return estado;
	}
	public void setEstado(String estado) {
		this.estado = estado;
	}

	public String getFechaValidacion() {
		return fechaValidacion;
	}
	public void setFechaValidacion(String fechaValidacion) {
		this.fechaValidacion = fechaValidacion;
	}

	public Integer getIdSolicitud() {
		return idSolicitud;
	}
	public void setIdSolicitud(Integer idSolicitud) {
		this.idSolicitud = idSolicitud;
	}

	public String getMail_enviado() {
		return mail_enviado;
	}
	public void setMail_enviado(String mail_enviado) {
		this.mail_enviado = mail_enviado;
	}

	public String getMotivo() {
		return motivo;
	}
	public void setMotivo(String motivo) {
		this.motivo = motivo;
	}

	public String getNotas() {
		return notas;
	}
	public void setNotas(String notas) {
		this.notas = notas;
	}

	public String getObservaciones() {
		return observaciones;
	}
	public void setObservaciones(String observaciones) {
		this.observaciones = observaciones;
	}

	public String getCodDestino() {
		return codDestino;
	}
	public void setCodDestino(String codDestino) {
		this.codDestino = codDestino;
	}

	public String getDestinoOtros() {
		return destinoOtros;
	}
	public void setDestinoOtros(String destinoOtros) {
		this.destinoOtros = destinoOtros;
	}

	public String getNombre_apellidos() {
		return nombre_apellidos;
	}
	public void setNombre_apellidos(String nombre_apellidos) {
		this.nombre_apellidos = nombre_apellidos;
	}

	public String getOrigen() {
		return origen;
	}
	public void setOrigen(String origen) {
		this.origen = origen;
	}
	
	public String getSituacion() {
		return situacion;
	}
	public void setSituacion(String situacion) {
		this.situacion = situacion;
	}

	public String getValidacionPosterior() {
		return validacionPosterior;
	}
	public void setValidacionPosterior(String validacionPosterior) {
		this.validacionPosterior = validacionPosterior;
	}
	
	public String toString(){
		String s = "";
		s += "[Id SolicitudReserva = " + idSolicitud + "]";
		s += "[Cdigo validador SolicitudReserva = " + codValidador + "]";
		s += "[Fecha Validacin SolicitudReserva = " + fechaValidacion + "]";
		s += "[Estado SolicitudReserva = " + estado + "]";
		s += "[Motivo SolicitudReserva = " + motivo + "]";
		s += "[Notas SolicitudReserva = " + notas + "]";
		s += "[Observaciones SolicitudReserva = " + observaciones + "]";
		s += "[CodDestino SolicitudReserva = " + codDestino + "]";
		s += "[DestinoOtros SolicitudReserva = " + destinoOtros + "]";
		s += "[Mail enviado SolicitudReserva = " + mail_enviado + "]";
		s += "[DNI SolicitudReserva = " + dni + "]";
		s += "[Nombre y apellidos SolicitudReserva = " + nombre_apellidos + "]";
		s += "[Origen SolicitudReserva = " + origen + "]";
		s += "[Situacion SolicitudReserva = " + situacion + "]";
		s += "[ValidacionPosterior SolicitudReserva = " + validacionPosterior + "]";

		return s;
	}
}