package m05bBD;

/**
 * This class holds information about an order, 
 * which is stored in the database table <tt>M05101T00</tt>. 
 * The table <tt>M05101T00</tt> is defined in the database as follows:
 * <pre>
CREATE TABLE M05101T00
(
  ID_SOLICITUD_101 		NUMBER(9, 0) NOT NULL,
  COD_SOLICITANTE_101	VARCHAR2(12) NOT NULL,
  DNI_101				VARCHAR2(15),
  NOMBRE_APELLIDOS_101	VARCHAR2(100),
  TELEFONO_101			VARCHAR2(30),
  TELEFONO_MOVIL_101	VARCHAR2(30),
  DOMICILIO_101			VARCHAR2(80),
  COD_PROVINCIA_101		VARCHAR2(2),
  COD_MUNICIPIO_101		VARCHAR2(3),
  COD_POSTAL_101		VARCHAR2(5),
  PUESTO_101			VARCHAR2(80),
  COD_DEPTO_101			VARCHAR2(3),
  DESCC_DEPTO_101		VARCHAR2(80),
  DESCE_DEPTO_101		VARCHAR2(80),
  COD_DIRECCION_101		VARCHAR2(3),
  DESCC_DIRECCION_101	VARCHAR2(80),
  DESCE_DIRECCION_101	VARCHAR2(80)
, CONSTRAINT M05101I01 PRIMARY KEY (ID_SOLICITUD_101, COD_SOLICITANTE_101)
, CONSTRAINT fk100_101 FOREIGN KEY (ID_SOLICITUD_101) REFERENCES M05100T00(ID_SOLICITUD_100)
);
 * </pre>
 * This class follows the convention of a JavaBean.
 *
 */
public class m05bSolicitudReserva_Usuario implements java.io.Serializable {

	private Integer idSolicitud = new Integer(-1);
	private String codSolicitante = "";
	private String dni = "";
	private String nombre_apellidos = "";
	private String telefono = "";
	private String telefonoMovil = "";
	private String domicilio = "";
	private m05bProvincia provincia;
	private m05bMunicipio municipio;
	private String codPostal = "";
	private String puesto = "";
	private String codDepartamento = "";
	private String desccDepartamento = "";
	private String desceDepartamento = "";
	private String codDireccion = "";
	private String desccDireccion = "";
	private String desceDireccion = "";
	

	public String getCodDepartamento() {
		return codDepartamento;
	}
	public void setCodDepartamento(String codDepartamento) {
		this.codDepartamento = codDepartamento;
	}

	public String getCodDireccion() {
		return codDireccion;
	}
	public void setCodDireccion(String codDireccion) {
		this.codDireccion = codDireccion;
	}

	public String getCodPostal() {
		return codPostal;
	}
	public void setCodPostal(String codPostal) {
		this.codPostal = codPostal;
	}

	public String getCodSolicitante() {
		return codSolicitante;
	}
	public void setCodSolicitante(String codSolicitante) {
		this.codSolicitante = codSolicitante;
	}

	public String getDesccDepartamento() {
		return desccDepartamento;
	}
	public void setDesccDepartamento(String desccDepartamento) {
		this.desccDepartamento = desccDepartamento;
	}

	public String getDesccDireccion() {
		return desccDireccion;
	}
	public void setDesccDireccion(String desccDireccion) {
		this.desccDireccion = desccDireccion;
	}

	public String getDesceDepartamento() {
		return desceDepartamento;
	}
	public void setDesceDepartamento(String desceDepartamento) {
		this.desceDepartamento = desceDepartamento;
	}

	public String getDesceDireccion() {
		return desceDireccion;
	}
	public void setDesceDireccion(String desceDireccion) {
		this.desceDireccion = desceDireccion;
	}

	public String getDni() {
		return dni;
	}
	public void setDni(String dni) {
		this.dni = dni;
	}

	public String getDomicilio() {
		return domicilio;
	}
	public void setDomicilio(String domicilio) {
		this.domicilio = domicilio;
	}

	public Integer getIdSolicitud() {
		return idSolicitud;
	}
	public void setIdSolicitud(Integer idSolicitud) {
		this.idSolicitud = idSolicitud;
	}

	public m05bMunicipio getMunicipio() {
		return municipio;
	}
	public void setMunicipio(m05bMunicipio municipio) {
		this.municipio = municipio;
	}

	public String getNombre_apellidos() {
		return nombre_apellidos;
	}
	public void setNombre_apellidos(String nombre_apellidos) {
		this.nombre_apellidos = nombre_apellidos;
	}

	public m05bProvincia getProvincia() {
		return provincia;
	}
	public void setProvincia(m05bProvincia provincia) {
		this.provincia = provincia;
	}

	public String getPuesto() {
		return puesto;
	}
	public void setPuesto(String puesto) {
		this.puesto = puesto;
	}

	public String getTelefono() {
		return telefono;
	}
	public void setTelefono(String telefono) {
		this.telefono = telefono;
	}
	
	public String getTelefonoMovil() {
		return telefonoMovil;
	}
	public void setTelefonoMovil(String telefonoMovil) {
		this.telefonoMovil = telefonoMovil;
	}


	public String toString(){
		String s = "";
		s += "[Id SolicitudReserva = " + idSolicitud + "]";
		s += "[Cdigo Solicitante SolicitudReserva = " + codSolicitante + "]";
		s += "[DNI SolicitudReserva = " + dni + "]";
		s += "[Nombre y apellidos SolicitudReserva = " + nombre_apellidos + "]";
		s += "[Telefono SolicitudReserva = " + telefono + "]";
		s += "[TelefonoMovil SolicitudReserva = " + telefonoMovil + "]";
		s += "[Domicilio SolicitudReserva = " + domicilio + "]";
		s += "[Codigo Provincia SolicitudReserva = " + provincia.getCodigo() + "]";
		s += "[Nombre Provincia SolicitudReserva = " + provincia.getNombre() + "]";
		s += "[Codigo Municipio SolicitudReserva = " + municipio.getCodigo() + "]";
		s += "[Nombre Municipio SolicitudReserva = " + municipio.getNombre() + "]";
		s += "[CodigoPostal SolicitudReserva = " + codPostal + "]";
		s += "[Puesto SolicitudReserva = " + puesto + "]";
		s += "[Cod Departamento SolicitudReserva = " + codDepartamento + "]";
		s += "[Descc Departamento SolicitudReserva = " + desccDepartamento + "]";
		s += "[Desce Departamento SolicitudReserva = " + desceDepartamento + "]";
		s += "[Cod Departamento Direccin SolicitudReserva = " + codDireccion + "]";
		s += "[Descc Departamento Direccin SolicitudReserva = " + desccDireccion + "]";
		s += "[Desce Departamento Direccin SolicitudReserva = " + desceDireccion + "]";
		
		return s;
	}
}