package m05bBD;

/**
 * This class holds information about an order, 
 * which is stored in the database table <tt>M05103T00</tt>. 
 * The table <tt>M05103T00</tt> is defined in the database as follows:
 * <pre>
CREATE TABLE M05103T00
(
  COD_ASIGNACION_103	NUMBER(9, 0) NOT NULL,
  TIPO_FIRMA_103		VARCHAR2(1),
  FECHA_FIRMA_103		DATE,
  COD_FIRMANTE_103		VARCHAR2(12),
  DNI_103				VARCHAR2(15),
  NOMBRE_APELLIDOS_103	VARCHAR2(100),
  DOCUMENTO_103			BLOB,
  FIRMA_103				BLOB,
  OID_DOKUSI_103		VARCHAR2(50),
  VERSION_DOKUSI_103    VARCHAR2(50)
, CONSTRAINT M05103I01 PRIMARY KEY (COD_ASIGNACION_103,	TIPO_FIRMA_103)
, CONSTRAINT fk01_103 FOREIGN KEY (COD_ASIGNACION_103) REFERENCES M0501T00(COD_ASIG_01)
);
 * </pre>
 * This class follows the convention of a JavaBean.
 *
 */
public class m05bSolicitudReserva_Firma implements java.io.Serializable {

	private Integer codAsignacion = new Integer(-1);
	private String tipoFirma = "";
	private String fechaFirma = "";
	private String codFirmante = "";
	private String dni = "";
	private String nombre_apellidos = "";
	private byte[] documento = null;
	private byte[] firma = null;
	private String oid_dokusi = "";


	public Integer getCodAsignacion() {
		return codAsignacion;
	}
	public void setCodAsignacion(Integer codAsignacion) {
		this.codAsignacion = codAsignacion;
	}

	public String getCodFirmante() {
		return codFirmante;
	}
	public void setCodFirmante(String codFirmante) {
		this.codFirmante = codFirmante;
	}

	public String getDni() {
		return dni;
	}
	public void setDni(String dni) {
		this.dni = dni;
	}

	public byte[] getDocumento() {
		return documento;
	}
	public void setDocumento(byte[] documento) {
		this.documento = documento;
	}

	public String getFechaFirma() {
		return fechaFirma;
	}
	public void setFechaFirma(String fechaFirma) {
		this.fechaFirma = fechaFirma;
	}

	public byte[] getFirma() {
		return firma;
	}
	public void setFirma(byte[] firma) {
		this.firma = firma;
	}

	public String getNombre_apellidos() {
		return nombre_apellidos;
	}
	public void setNombre_apellidos(String nombre_apellidos) {
		this.nombre_apellidos = nombre_apellidos;
	}

	public String getTipoFirma() {
		return tipoFirma;
	}
	public void setTipoFirma(String tipoFirma) {
		this.tipoFirma = tipoFirma;
	}

	public String getOid_dokusi() {
		return oid_dokusi;
	}
	public void setOid_dokusi(String oid_dokusi) {
		this.oid_dokusi = oid_dokusi;
	}

	public String toString(){
		String s = "";
		s += "[Codigo Asignacion = " + codAsignacion + "]";
		s += "[Tipo firma = " + tipoFirma + "]";
		s += "[Fecha firma = " + fechaFirma + "]";
		s += "[Cdigo firmante = " + codFirmante + "]";
		s += "[Dni = " + dni + "]";
		s += "[Nombre y apellidos = " + nombre_apellidos + "]";
		s += "[Oid Dokusi = " + oid_dokusi + "]";

		return s;
	}
}