package m05bBD;

import m05bClasses.m05bConstantes;

/**
 * This class holds information about an order, 
 * which is stored in the database table <tt>M05100T00</tt>. 
 * The table <tt>M05100T00</tt> is defined in the database as follows:
 * <pre>
CREATE TABLE M05100T00
(
  ID_SOLICITUD_100 		NUMBER(9, 0) NOT NULL,
  FECHA_SOLICITUD_100 	DATE,
  FECHA_INI_100			DATE,
  FECHA_FIN_100			DATE,
  COD_ASIGNACION_100	NUMBER(6, 0),
  BLOQUEO_100			VARCHAR2(1)
, CONSTRAINT M05100I01 PRIMARY KEY (ID_SOLICITUD_100)
, CONSTRAINT fk01_100 FOREIGN KEY (COD_ASIGNACION_100) REFERENCES M0501T00(COD_ASIG_01)
);
 * </pre>
 * This class follows the convention of a JavaBean.
 *
 */
public class m05bSolicitudReserva implements java.io.Serializable {

	private Integer idSolicitud = new Integer(-1);
	private String fechaSolicitud = "";
	private String fechaIni = "";   
	private String fechaFin = "";   
	private Integer codAsignacion = new Integer(-1);
	private String bloqueo = "";
	private m05bSolicitudReserva_Usuario usuario = null;
	private m05bSolicitudReserva_Validacion[] validaciones = null;


	public Integer getCodAsignacion() {
		return codAsignacion;
	}
	public void setCodAsignacion(Integer codAsignacion) {
		this.codAsignacion = codAsignacion;
	}

	public String getFechaFin() {
		return fechaFin;
	}
	public void setFechaFin(String fechaFin) {
		this.fechaFin = fechaFin;
	}

	public String getFechaIni() {
		return fechaIni;
	}
	public void setFechaIni(String fechaIni) {
		this.fechaIni = fechaIni;
	}

	public String getFechaSolicitud() {
		return fechaSolicitud;
	}
	public void setFechaSolicitud(String fechaSolicitud) {
		this.fechaSolicitud = fechaSolicitud;
	}

	public Integer getIdSolicitud() {
		return idSolicitud;
	}
	public void setIdSolicitud(Integer idSolicitud) {
		this.idSolicitud = idSolicitud;
	}

	public String getBloqueo() {
		return bloqueo;
	}
	public void setBloqueo(String bloqueo) {
		this.bloqueo = bloqueo;
	}

	public m05bSolicitudReserva_Usuario getUsuario() {
		return usuario;
	}
	public void setUsuario(m05bSolicitudReserva_Usuario usuario) {
		this.usuario = usuario;
	}
	
	public m05bSolicitudReserva_Validacion[] getValidaciones() {
		return validaciones;
	}
	public void setValidaciones(m05bSolicitudReserva_Validacion[] validaciones) {
		this.validaciones = validaciones;
	}
	
	/*MTODOS INI*/
	public m05bSolicitudReserva_Validacion obtenerValidacionSolicitada()
	{
		if (this.getValidaciones() != null)
		{
			for (int i=this.getValidaciones().length-1; i>=0; i--)
			{
				if (this.getValidaciones()[i].getEstado().equals(m05bConstantes.SOLICITADA))
				{
					return this.getValidaciones()[i];
				}
			}
		}

		return null;
	}
	
	public m05bSolicitudReserva_Validacion obtenerValidacionAceptadaSinAsignar()
	{
		if (this.getValidaciones() != null)
		{
			for (int i=0; i<this.getValidaciones().length; i++)
			{
				if (this.getValidaciones()[i].getEstado().equals(m05bConstantes.ACEPTADASINASIGNAR))
				{
					return this.getValidaciones()[i];
				}
			}
		}

		return null;
	}
	
	public m05bSolicitudReserva_Validacion obtenerValidacionRechazada() {
		if (this.getValidaciones() != null)
		{
			for (int i=0; i<this.getValidaciones().length; i++)
			{
				if (this.getValidaciones()[i].getEstado().equals(m05bConstantes.RECHAZADA))
				{
					return this.getValidaciones()[i];
				}
			}
		}

		return null;
	}
	
	public m05bSolicitudReserva_Validacion obtenerValidacionUltima() {
		if (this.getValidaciones() != null)
		{
			return this.getValidaciones()[0];
		}

		return null;
	}
	/*MTODOS FIN*/

	public String toString(){
		String s = "";
		s += "[Id SolicitudReserva = " + idSolicitud + "]";
		s += "[Fecha SolicitudReserva = " + fechaSolicitud + "]";
		s += "[FechaIni SolicitudReserva = " + fechaIni + "]";
		s += "[FechaFin SolicitudReserva = " + fechaFin + "]";
		s += "[Cdgo Asignacion SolicitudReserva = " + codAsignacion + "]";
		s += "[Bloqueo = " + bloqueo + "]";

		return s;
	}
}