package m05bBD;

/**
 * This class holds information about an order,
 * which is stored in the database table <tt>m0518t00_cargos</tt>.
 * The table <tt>m0518t00_cargos</tt> is defined in the database as follows:
 * <pre>
CREATE TABLE M0518T00 (TARJETA_18		VARCHAR2 (20)				NOT NULL
, MATRIC_18		VARCHAR2 (20)
, FOPERAC_18		DATE
, CTRLDUPL_18	NUMBER(7)                                                          NOT NULL
, TIPO_18		VARCHAR2(1)
, CONCEPTO_18	VARCHAR2(20)
, DPTO_18		VARCHAR2(100)
, SERVICIO_18		VARCHAR2(50)
, CENTRO_18		VARCHAR2(50)
, ESTCIF_18		VARCHAR2(15)
, EST_DESCR_18	VARCHAR2(255)
, KM_18		VARCHAR2(6)
, LITROS_18		VARCHAR2(5)
, IMPORTE_18		NUMBER(10,2)
, CARG_ABON_18	VARCHAR2(1)
, VERIFIC_18		VARCHAR2(200)	DEFAULT N	NOT NULL
, UECONOMIC_18	VARCHAR2(2)
, EST_NCOM_18	VARCHAR2(15),
  PRIMARY KEY (CTRLDUPL_18));
 * </pre>
 * This class follows the convention of a JavaBean.
 *
 */


public class m05bGastosTarjeta implements java.io.Serializable{

  private String gastar_control   = "";
  private String gastar_tarjeta   = "";
  private String gastar_fecha     = "";
  private String gastar_litros    = "";
  private String gastar_importe   = "";
  private String gastar_matricula = "";
  private String gastar_km        = "";
  private String gastar_estcif    = "";
  private String gastar_estdesc   = "";
  private String gastar_dpto      = "";
  private String gastar_cargo     = "";
  private String gastar_verifi    = "";
  private String gastar_centro    = "";
  private String gastar_tipo      = "";
  private String gastar_ueconomic = "";
  private String gastar_concepto  = "";
  private String gastar_servicio   = "";
  private String gastar_ncomercio ="";

  public  String getGastar_control () {return gastar_control;}
  public void setGastar_control (String n) {gastar_control=n;}

  public String getGastar_tarjeta () {return gastar_tarjeta;}
  public void setGastar_tarjeta (String n) {gastar_tarjeta=n;}

  public String getGastar_fecha () {return gastar_fecha;}
  public void setGastar_fecha (String n) {gastar_fecha=n;}

  public String getGastar_litros () {return gastar_litros;}
  public void setGastar_litros (String n) {gastar_litros=n;}

  public String getGastar_importe () {return gastar_importe;}
  public void setGastar_importe (String n) {gastar_importe=n;}

  public String getGastar_matricula () {return gastar_matricula;}
  public void setGastar_matricula (String n) {gastar_matricula=n;}

  public String getGastar_km () {return gastar_km;}
  public void setGastar_km (String n) {gastar_km=n;}

  public String getGastar_dpto () {return gastar_dpto;}
  public void setGastar_dpto (String n) {gastar_dpto=n;}

  public String getGastar_centro () {return gastar_centro;}
  public void setGastar_centro (String n) {gastar_centro=n;}

  public String getGastar_tipo () {return gastar_tipo;}
  public void setGastar_tipo (String n) {gastar_tipo=n;}

  public String getGastar_concepto () {return gastar_concepto;}
  public void setGastar_concepto (String n) {gastar_concepto=n;}

  public String getGastar_servicio () {return gastar_servicio;}
  public void setGastar_servicio (String n) {gastar_servicio=n;}

  public String getGastar_verifi () {return gastar_verifi;}
  public void setGastar_verifi (String n) {gastar_verifi=n;}

  public String getGastar_ueconomic () {return gastar_ueconomic;}
  public void setGastar_ueconomic (String n) {gastar_ueconomic=n;}

  public String getGastar_cargo () {return gastar_cargo;}
  public void setGastar_cargo (String n) {gastar_cargo=n;}

  public String getGastar_estcif () {return gastar_estcif;}
  public void setGastar_estcif (String n) {gastar_estcif=n;}

  public String getGastar_estdesc () {return gastar_estdesc;}
  public void setGastar_estdesc (String n) {gastar_estdesc=n;}
  
  public String getGastar_ncomercio () {return gastar_ncomercio;}
  public void setGastar_ncomercio (String n) {gastar_ncomercio=n;}

  public String toString(){
    String s = "";
    s += "[Codigo = " + gastar_control + "]";
    s += "[Tarjeta = " + gastar_tarjeta + "]";
    s += "[Fecha = " + gastar_fecha + "]";
    s += "[Litros = " + gastar_litros + "]";
    s += "[Concepto = " + gastar_concepto + "]";
    s += "[Establecimiento CIF = " + gastar_estcif + "]";
    s += "[Nombre Establecimineto = " + gastar_estdesc + "]";
    s += "[Cargo= " + gastar_cargo + "]";
    s += "[Importe = " + gastar_importe + "]";
    s += "[Matricula = " + gastar_matricula + "]";
    s += "[Kilometros = " + gastar_km + "]";
    s += "[Ueconomic= " + gastar_ueconomic + "]";
    s += "[Verifi = " + gastar_verifi + "]";
    s += "[Dpto = " + gastar_dpto + "]";
    s += "[Centro = " + gastar_tipo + "]";
    s += "[Num Comercio = " + gastar_ncomercio + "]";

    return s;
  }


}
