/****************************************************************************\
 *          				DETECCION DEL BROWSER             			    *
\****************************************************************************/
// Deteccion del browser
var ns4 = document.layers;								// NS4
var ie4 = document.all;									// IE 4+
var ie5 = document.all;									// IE 5
var ie6 = document.getElementById && document.all;		// IE6

var ns6 = document.getElementById && !document.all;		// NS6


/**
 * Detecta el explorador que se esta utilizando de forma mas precisa,
 * devolviendo un objeto que contiene toda la informacin del browser
 */
function UserAgent() {
	var b = navigator.appName.toUpperCase();

	if (b == "NETSCAPE") this.b = "ns";
	else if (b == "MICROSOFT INTERNET EXPLORER") this.b = "ie";
	else if (b == "OPERA") this.b = "op"; 
	else this.b = b;

	this.version = navigator.appVersion;
	this.v = parseInt(this.version);

	this.ns = (this.b == "ns" && this.v >= 4);
	this.ns4 = (this.b == "ns" && this.v == 4);
	this.ns5 = (this.b == "ns" && this.v == 5);

	this.ie = (this.b == "ie" && this.v >= 4);
	this.ie4 = (this.version.indexOf('MSIE 4') > 0);
	this.ie5 = (this.version.indexOf('MSIE 5') > 0);
	this.ie55 = (this.version.indexOf('MSIE 5.5') > 0);
	this.ie6 = (this.version.indexOf('MSIE 6') > 0);

	this.op = (this.b == "op");
	this.op4 = (this.b == "op" && this.v == 4);
	this.op5 = (this.b == "op" && this.v == 5);
}
var navegador = new UserAgent();	// Objeto que almacena el navegador




//==========================================================================\\
// FUNCIONES AUXILIARES PARA CONOCER LA POSICIN DE UN ANCHOR               \\
//==========================================================================\\
/**
 * getAnchorPositionScreenRelative(anchorname)
 *   Devuelve un objeto que tiene las propiedades .x y .y que son las coordenadas
 *   relativas a la PANTALLA de un elemento anchor <a></a>.
 */
function getAnchorPositionScreenRelative(anchorname) {
	var coordinates = getAnchorPositionWindowRelative(anchorname);
	var x=0;
	var y=0;
	if (ie6 || ns6) {
		if (isNaN(window.screenX)) {
			x = coordinates.x - document.body.scrollLeft + window.screenLeft;
			y = coordinates.y - document.body.scrollTop + window.screenTop;
		} else {
			x = coordinates.x + window.screenX + (window.outerWidth-window.innerWidth) - window.pageXOffset;
			y = coordinates.y + window.screenY + (window.outerHeight-24-window.innerHeight) - window.pageYOffset;
		}
	} else if (ie4) {
		x = coordinates.x - document.body.scrollLeft + window.screenLeft;
		y = coordinates.y - document.body.scrollTop + window.screenTop;
	} else if (ns4) {
		x = coordinates.x + window.screenX + (window.outerWidth-window.innerWidth) - window.pageXOffset;
		y = coordinates.y + window.screenY + (window.outerHeight-24-window.innerHeight) - window.pageYOffset;
	}
	coordinates.x = x;
	coordinates.y = y;
	return coordinates;
}
//___________________________________________________________________________\\
/**
 * getAnchorPositionWindowRelative(anchorname)
 *   Devuelve un objeto que tiene las propiedades .x y .y que son las coordenadas
 *   relativas a la VENTANA DEL NAVEGADOR de un elemento anchor <a></a>.
 */
function getAnchorPositionWindowRelative(anchorname) {
	// This function will return an Object with x and y properties
	var useWindow = false;
	var coordinates = new Object();
	var x=0;
	var y=0;
	// Encontrar el anchor (recorrer todo el documento y buscar aquel cuyo id es el que se pasa
 	if (ie6) {
		x = AnchorPosition_getPageOffsetLeft(document.all[anchorname]);
		y = AnchorPosition_getPageOffsetTop(document.all[anchorname]);
	} else if (ns6) {
		var o = document.getElementById(anchorname);
		x = o.offsetLeft;
		y = o.offsetTop;
	} else if (ie4) {
		x = AnchorPosition_getPageOffsetLeft(document.all[anchorname]);
		y = AnchorPosition_getPageOffsetTop(document.all[anchorname]);
	} else if (ns4) {
		var found=0;
		for (var i=0; i<document.anchors.length; i++) {
			if (document.anchors[i].name == anchorname) {
				found=1;
				break;
			}
		}
		if (found == 0) {
			coordinates.x=0; 
			coordinates.y=0; 
			return coordinates;
		}
		x = document.anchors[i].x;
		y = document.anchors[i].y;
	} else {
		coordinates.x=0; 
		coordinates.y=0; 
		return coordinates;
	}
	coordinates.x = x;
	coordinates.y = y;
	return coordinates;		// Devuelve un objeto con dos miembros x e y
	}
//___________________________________________________________________________\\
// Funciones de IE para obtener la posicion de un elemento
function AnchorPosition_getPageOffsetLeft (el) {
	var ol = el.offsetLeft;
	while ((el = el.offsetParent) != null) { 
		ol += el.offsetLeft; 
	}
	return ol;
}
function AnchorPosition_getPageOffsetTop (el) {
	var ot = el.offsetTop;
	while((el = el.offsetParent) != null) { 
		ot += el.offsetTop; 
	}
	return ot;
}
//___________________________________________________________________________\\





/****************************************************************************\
 *          		FUNCIONES MATEMATICAS AUXILIARES             			*
\****************************************************************************/
/** 
 * Hex to Decimal converter
 * Covert decimal to hex number, return dec num as string
 */
function toDec(dec) {
	dec_val = parseInt(dec.toUpperCase(),16);
	return dec_val
}
//_______________________________________________________________________________________________\\
/**
 * Decimal to Hex converter
 * Covert decimal to hex number, return hex num as string
 */
function toHex(hex) {
	var hex_val = hex.toString(16).toUpperCase();
	if (hex_val.length == 1) {
		var temp = "0" + hex_val
		hex_val = temp;
	}
	return hex_val
}
//_______________________________________________________________________________________________\\
/**
 * Obtiene el valor decimal de un numero
 */
function toDecimals(val,n) {
    if (isNaN(n)) return val;
	   if (n<=0) return Math.round(val);
    for (var m=0; m<n; m++)  val *= 10;
    val = Math.round(val);
    valstr = val.toString();
    len = valstr.length;
    if (len>n)
        valstr = valstr.substring(0,len-n) + "." + valstr.substring(len-n,len);
    else {
        while (valstr.length<n) valstr = "0" + valstr;
        valstr = "0." + valstr;
    }
    return valstr;
}
//_______________________________________________________________________________________________\\







